<?php
/**
 * Provides a simple lookup mechanism to lookup common hotlap flag formats in LFS.
 *
 * @file rules.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */

/**
 * Include base lookup
 */
if(!class_exists('PPFBaseLookup'))
    include dirname(__FILE__).'/baselookup.php';
    
/**
 * Static class for creating lookup arrays between commonly used formats to represent hotlap flags in LFS.
 *
 * @class PPFHotlapFlags
 * @version 1.0.00
 */
class PPFHotlapFlags extends PPFBaseLookup
{
    /**
     * Public function for retrieving a lookup array from one format to another.
     *
     * <pre>
     * LEFTHANDDRIVE		1
     * GEARCHANGECUT		2
     * GEARCHANGEBLIP		4
     * AUTOGEAR				8
     * -					16
     * -					32
     * BRAKEHELP			64
     * THROTTLEHELP			128
     * -					256
     * -					512
     * MOUSESTEER *			1024
     * KN *					2048
     * KS *					4096
     * (*) if not 1024, 2048 or 4096, steering is wheel.
     * </pre>
     * 
     * @public
     * @param from (String) The source format. Valid values are 'zbi', 'bits', 'words'.
     * @param to (String) The target format. Valid values are 'zbi', 'bits', 'words'.
     * @return (Array) An array providing a bridge between the two specified formats.
     **/
    function getLookupArray($from, $to, $ignore=array())
    {
        static $indexes;

        if($indexes == null)
        {
            $indexes =  array(  'zbi'=>array(   0,
                                                1,
                                                2,
                                                3,
                                                4,
                                                5,
                                                6,
                                                7,
                                                8,
                                                9,
                                                10,
                                                11,
                                                12),
                                                
                                'bits'=>array(  1,
                                                2,
                                                4,
                                                8,
                                                16,
                                                32,
                                                64,
                                                128,
                                                256,
                                                512,
                                                1024,
                                                2048,
                                                4096),

                                'words'=>array( 'Left Hand Drive',
                                                'Gear Change Cut',
                                                'Gear Change Blip',
                                                'Automatic Gears',
                                                '',
                                                '',
                                                'Brake Help',
                                                'Throttle Help',
                                                '',
                                                '',
                                                'Mouse',
                                                'Keyboard No Assist',
                                                'Keyboard Stablised'));
        }

        return parent::getBaseLookup($indexes, $from, $to, $ignore);
    }
}
?>
