<?php
/**
 * Provides a simple class for creating lookup arrays between commonly used formats to represent cars in LFS.
 *
 * @file cars.php
 * @author Michael Simons <ixulai@gmail.com> 
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */

/**
 * Include base lookup
 */
if(!class_exists('PPFBaseLookup'))
    include dirname(__FILE__).'/baselookup.php';

/**
 * Static class for creating lookup arrays between commonly used formats to represent cars in LFS.
 *
 * @class PPFCars
 * @version 1.0.00
 */
class PPFCars extends PPFBaseLookup
{
    /**
     * Public function for retrieving a lookup array from one format to another.
     *
     * <pre>
     * TLC		Bit			Words
     * --------------------------------
     * XFG		1			XF GTi
     * XRG		2			XR GT
     * XRT		4			XR GT Turbo
     * RB4		8			RB4
     * FXO		16			FXO
     * LX4		32			LX4
     * LX6		64			LX6
     * MRT		128			MRT
     * UF1		256			UF1000
     * RAC		512			Raceabout
     * FZ5		1024		FZ50
     * FOX		2048		Formula XR
     * XFR		4096		XF GTR
     * UFR		8192		UF GTR
     * FO8		16384		Formula V8
     * FXR		32768		FXO GTR
     * XRR		65536		XR GTR
     * FZR 		131072		FZ50 GTR
     * BF1		262144		BMW Sauber F1.06
     * </pre>
     * 
     * @public
     * @param from (String) The source format. Valid values are 'bits', 'codes', 'words'.
     * @param to (String) The target format. Valid values are 'bits', 'codes', 'words'.
     * @return (Array) An array providing a bridge between the two specified formats.
     **/
    function getLookupArray($from, $to)
    {
        static $indexes;

        if($indexes == null)
        {
            $indexes = array(   'zbi'=>array(   0,
                                                1,
                                                2,
                                                3,
                                                4,
                                                5,
                                                6,
                                                7,
                                                8,
                                                9,
                                                10,
                                                11,
                                                12,
                                                13,
                                                14,
                                                15,
                                                16,
                                                17,
                                                18),
                                                                                                
                                'bits'=>array(  1,
                                                2,
                                                4,
                                                8,
                                                16,
                                                32,
                                                64,
                                                128,
                                                256,
                                                512,
                                                1024,
                                                2048,
                                                4096,
                                                8192,
                                                16384,
                                                32768,
                                                65536,
                                                131072,
                                                262144),

                                'codes'=>array( 'XFG',
                                                'XRG',
                                                'XRT',
                                                'RB4',
                                                'FXO',
                                                'LX4',
                                                'LX6',
                                                'MRT',
                                                'UF1',
                                                'RAC',
                                                'FZ5',
                                                'FOX',
                                                'XFR',
                                                'UFR',
                                                'FO8',
                                                'FXR',
                                                'XRR',
                                                'FZR',
                                                'BF1'),

                                'words'=>array( 'XF GTi',
                                                'XR GT',
                                                'XR GT Turbo',
                                                'RB4',
                                                'FXO',
                                                'LX4',
                                                'LX6',
                                                'MRT',
                                                'UF1000',
                                                'Raceabout',
                                                'FZ50',
                                                'Formula XR',
                                                'XF GTR',
                                                'UF GTR',
                                                'Formula V8',
                                                'FXO GTR',
                                                'XR GTR',
                                                'FZ50 GTR',
                                                'BMW Sauber F1.06'));
        }
        
        return parent::getLookupArray($indexes, $from, $to, array());
    }
}
?>
