<?php
/**
 * Provides a simple lookup mechanism to lookup common formats in LFS.
 *
 * @file baselookup.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */

/**
 * Static class for creating lookup arrays between commonly used formats in LFS.
 *
 * @class PPFBaseLookup
 * @version 1.0.00
 */
class PPFBaseLookup
{
    /**
     * Public function for retrieving a lookup array from one format to another.
     *
     * @public
     * @param from (String) The source format.
     * @param to (String) The target format.
     * @return (Array) An array providing a bridge between the two specified formats.
     **/
    function getLookupArray($indexes, $from, $to, $ignore)
    {
        $from = strtolower($from);
        $to = strtolower($to);
        $ignore = array_flip($ignore);

        if(isset($indexes[$from]) && isset($indexes[$to]))
        {
            $combined = array();

            for($i=0; $i < count($indexes[$from]); $i++)
	    	if(!isset($ignore[$indexes[$from][$i]]))
	                $combined[$indexes[$from][$i]] = $indexes[$to][$i];

            return $combined;
        }

        return false;
    }
}
?>
