<?php
/**
 * @file bitstostring.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */

/**
 * A lookup utility function to convert a bitfield in to a string using a lookup with performance enhancements for repetitive usage.
 *
 * @version 1.1.00
 * @param type (String) A string representing the type of conversion.
 * @param bits (Integer) The bitfield to convert.
 * @param lookup (Array) A lookup array to use as a reference when converting from bits to words.
 * @param joinString (String) A string to insert between each converted bitfield value.
 * @param useAnd (Boolean) A boolean to indicate wether to use an english ' and ' as the joining string for the last entry for gramatical correctness.
 * @return (String) A string representing the bitfield.
 */ 
function bitsToString($type, $bits, $lookup, $joinString=', ', $useAnd=false)
{
    //This is expensive if we are doing it lots of times, so a local per exec cache is appropriate
    static $cache;
    if($cache == null)
        $cache = array();

    //Init the cache array for this type
    if(!isset($cache[$type]))
        $cache[$type][0] = '(None)';

    if(!isset($cache[$type][$bits]))
    {
        $current = 1;
        $words = array();
        $count = 0;
        $last = '';
        
        while($current <= $bits)
        {
            if($current & $bits)
                if(isset($lookup[$current]))
	                $words[] = $lookup[$current];

            $current = pow(2, ++$count);
        }
        
        if($useAnd === true)
        {
            $last = array_pop($words);
            $last = ((count($words) == 0) ? ('') : (' and ')) . $last;                
        }
        
        $result = $cache[$type][$bits] = implode($joinString, $words) . $last;
        
    }
    else
        $result = $cache[$type][$bits];

    return $result;
}
?>
