<?php
/**
 * Provides a class for parsing world record lists from LFSWorld.
 *
 * @file wr.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */

/**
 * Include base provider class. 
 */
require_once(dirname(__FILE__).'/base.php');    
 
/**
 * Class for parsing LFSWorld world record lists.
 * 
 * @class LFSWorldWorldRecords
 * @version 2.0.00
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */
class LFSWorldWorldRecords extends LFSWorldDataProvider
{
    /**
	 * The base url of this data source.
	 * @protected
	 */
	var $m_sURL = 'http://www.lfsworld.net/pubstat/get_stat2.php?action=wr';
	
	/**
	 * An array of meta data possibly useful to other parts of a program. (Such as tarpit duration)
	 * @protected
	 */
    var $m_aSrcMetaData = array('lifeTime' => 60, 'actualTarpit' => 5);

    /**
     * Parses an individual line entry from LFSWorld.
     *
     * Raw entry format
     *
     * <pre>
     * requires:-
     * optional:&control=STEERING
     * returns:TRACK CAR TIME FLAGS_HLAPS RACER_NAME
     * </pre>
	 *
	 * @protected
	 * @see LFSWorldDataProvider::parse()
	 * @param line (String) The raw chunk to be parsed
	 * @return (Array) The parsed entry as an array.
     */
    function _parseLine($line)
    {
        $return =array();
        $line = explode(' ', $line);
        $return['id_wr'] = array_shift($line);
        $return['track'] = array_shift($line);
        $return['car'] = array_shift($line);
        $return['time'] = array_shift($line);
        $return['flags'] = array_shift($line);
        $return['racer'] = implode(' ', $line);
        
        return $return;
    }
    
    /**
     * Checks and adjusts input parameters where required & possible.
	 *
	 * @public
	 * @param params (&Array) An array of the params that are set.
	 * @return (Boolean) True if the parameters are ok, false otherwise.
     */
	function initParams(&$params)
	{
        if(!isset($params['version']) || $params['version'] != 1.2)
            $params['version'] = 1.2;
		return parent::initParams($params);
	}
}

?>
