<?php
/**
 * Provides a class for parsing the hotlap log from LFSWorld.
 *
 * @file hllog.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */

/**
 * Include base provider class. 
 */
require_once(dirname(__FILE__).'/base.php');    
 
/**
 * Class for parsing LFSWorld hotlap log.
 * 
 * @class LFSWorldHotlapLog
 * @version 2.1.00
 */
class LFSWorldHotlapLog extends LFSWorldDataProvider
{
    /**
	 * (String) The base url of this data source.
	 * @protected
	 */
	var $m_sURL = 'http://www.lfsworld.net/pubstat/get_stat2.php?action=hl_log';
	
	/**
	 * (Array) An array of meta data possibly useful to other parts of a program. (Such as tarpit duration)
	 * @protected
	 */
    var $m_aSrcMetaData = array('lifeTime' => 60, 'actualTarpit' => 5);
 
    /**
     * LFSWorldHotlapLog::parse
	 * 
     * Parses the raw data from LFSWorld in to an array.
	 *
	 * @public
	 * @param rawList (String) The raw list retrieved from LFSWorld that needs to be parsed.
	 * @param[out] outputList (Array) A reference to an array that will store the parsed output.
	 * @return (Boolean) True on success, false otherwise.
     */
    function parse($rawList, &$outputList)
    {
        switch($this->m_nFormat)
        {
            case 2:
                $outputList = $rawList;
                break;
            case 3:
                // do actual parsing
                $offset = 0;
                while(true)
                {
                    $chunk = substr($rawList, $offset, 88);
                    $offset += 88;

                    if(strlen($chunk) == 88)
                    {
                        $data = unpack('l1time/a24racer/a32country/c1track/c1config/c1reversed/c1car/l4split/v1pos/v1flags/l1id', $chunk);
                        $data['track'] = $data['track'].$data['config'].$data['reversed'];
                        unset($data['config'], $data['reversed']);
                        //$data['car'] = ord($data['car']);
                        $outputList[] = $data;
                    }
                    else
                    {
                        break;
                    }
                    
                }
                break;
            case 1:
            default:
                if(is_array($outputList))
                {
                    $outputList = array_merge($outputList, explode("\n", $rawList));
                }
                else
                {
                    $outputList = explode("\n", $rawList);
                }
                break;
                
        }
        
        return true;
    }
    
    /**
     * Checks and adjusts input parameters where required & possible.
	 *
	 * @public
	 * @param params (&Array) An array of the params that are set.
	 * @return (Boolean) True if the parameters are ok, false otherwise.
     */
    function initParams(&$params)
    {
        if(!isset($params['version']) || $params['version'] < 1.2)
            $params['version'] = '1.2';
        
        if(isset($params['format']))
            $this->m_nFormat = $params['format'];
        else
            $params['format'] = $this->m_nFormat = 3;

        return parent::initParams($params);
    }
}

?>
