<?php
/**
 * Provides a simple lookup mechanism to lookup common team flag formats in LFS.
 *
 * @file teamflags.php
 * @author Michael Simons <ixulai@gmail.com>
 * @license http://creativecommons.org/licenses/by/2.5/ Creative Commons
 */

/**
 * Static class for creating lookup arrays between commonly used formats to represent team flags in LFS.
 *
 * @class PPFTeamFlags
 * @version 1.0.00
 */
class PPFTeamFlags extends PPFBaseLookup
{
    /**
     * Public function for retrieving a lookup array from one format to another.
     * 
     * <pre>
     * Name			Bit
     * -----------------
     * race			1
	 * drift		2
	 * drag			4
	 * can apply	8
	 * has host		16
	 * Demo			32
	 * S1			64
	 * S2			128
	 * S3			256
     * </pre>
     * 
     * @public
     * @param from (String) The source format. Valid values are 'zbi', 'bits', 'words'.
     * @param to (String) The target format. Valid values are 'zbi', 'bits', 'words'.
     * @return (Array) An array providing a bridge between the two specified formats.
     **/
    function getLookupArray($from, $to, $ignore=array())
    {
        static $indexes;

        if($indexes == null)
        {
            $indexes =  array(  'zbi'=>array(   0,
                                                1,
                                                2,
                                                3,
                                                4,
                                                5,
                                                6,
                                                7,
                                                8),
                                                
                                'bits'=>array(  1,
                                                2,
                                                4,
                                                8,
                                                16,
                                                32,
                                                64,
                                                128,
                                                256),

                                'words'=>array( 'Race',
                                                'Drift',
                                                'Drag',
                                                'Can Apply',
                                                'Has Host',
                                                'Demo',
                                                'S1',
                                                'S2',
                                                'S3'));
        }

        return parent::getLookupArray($indexes, $from, $to, $ignore);
    }
}
?>
