package LFSMonitor;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;


public class Screen extends GameCanvas implements Runnable {
    private LayerManager layerManager;
    private boolean isRunning;
    private LFSMon midlet;
    private int width;
    private int height;

    public Screen(LFSMon midlet) {
        super(false);
        this.midlet = midlet;
        //setFullScreenMode(true);
        width = getWidth();
        height = getHeight();
	start();
    }


    public void init() {
    }


    public void start() {
        if (!isRunning) {
            Thread t = new Thread(this);
            t.start();
	}
    }

    public void run() {
        isRunning = true;
        Graphics g = getGraphics();
	int c = 0;
	splash(g);
    }

    
  private void splash(Graphics g) {
	    g.setColor(0);
	    g.fillRect(0,0,width,height);
  }


    public void stop() {
        isRunning = false;
    }


    public boolean isRunning() {
        return isRunning;
    }

    
    void updateSpeed(String val) {
        Graphics g = getGraphics();

        g.setFont(Font.getFont(Font.FACE_SYSTEM, Font.STYLE_PLAIN,
					Font.SIZE_LARGE));
        g.setColor(0);
        g.fillRect(0, 0, width, 20);
        g.setColor(255,255,255);
        g.drawString(val, 0, 0,  Graphics.TOP |Graphics.LEFT);
        flushGraphics();
    }

    void updateGear(String val) {
        Graphics g = getGraphics();
        g.setColor(0);
        g.fillRect(0,100,width, 20);
        g.setColor(255,255,255);
        g.drawString(val, 0, 100,  Graphics.TOP |Graphics.LEFT);  
        flushGraphics();
    }


}
