package LFSMonitor;
/*
 * LFSMon.java
 *
 * Created on 3. November 2006, 13:49
 */

import java.lang.String;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import javax.microedition.io.*;
import javax.bluetooth.*;
import java.io.*;
/**
 *
 * @author  nilo
 * @version
 */
public class LFSMon extends MIDlet implements Runnable{
    LocalDevice device;
    DiscoveryAgent agent;
    private static Display display;
    private Screen screen;
    public final static UUID uuid = new UUID("94f39d297d6d437d973bfba39e49d4ee", false);
    public boolean done = false;
    public boolean connected = true;
    public StreamConnectionNotifier server;

  public void run_server()
  {
    try
    {
      //
      // initialize the JABWT stack
      device = LocalDevice.getLocalDevice(); // obtain reference to singleton
      device.setDiscoverable(DiscoveryAgent.GIAC); // set Discover mode to LIAC

      // start a thread to serve the server connection.
      // for simplicity of this demo, we only start one server thread
      // see run() for the task of this thread
      Thread t = new Thread( this );
      t.start();
      
      
    } catch ( BluetoothStateException e )
    {
      e.printStackTrace();
    }

  }
  public void run()
  {
    // human friendly name of this service
    String appName = "LFS Outgauge Monitor";


    // connection to remote device
    StreamConnection c = null;
    try
    {
      String url = "btspp://localhost:" + uuid.toString() +";name="+ appName + ";authorize=false;authenticate=false;encrypt=false";
      log("server url: " + url );

      // Create a server connection object, using a
      // Serial Port Profile URL syntax and our specific UUID
      // and set the service name to BlueChatApp
      server =  (StreamConnectionNotifier)Connector.open( url );

      // Retrieve the service record template
      ServiceRecord rec = device.getRecord( server );

      // set ServiceRecrod ServiceAvailability (0x0008) attribute to indicate our service is available
      // 0xFF indicate fully available status
      // This operation is optional
      rec.setAttributeValue( 0x0008, new DataElement( DataElement.U_INT_1, 0xFF ) );

    } catch (Exception e)
    {
      e.printStackTrace();
      log(e.getClass().getName()+" "+e.getMessage());
    }

    while( !done)
    {
      try {
        // start accepting client connection.
        // This method will block until a client
        // connected
        display = Display.getDisplay(this);
	display.setCurrent(screen);
        screen.updateSpeed("0");
        screen.updateGear("N");
        c = server.acceptAndOpen();

        // retrieve the remote device object
        RemoteDevice rdev = RemoteDevice.getRemoteDevice( c );

        // obtain an input stream to the remote service
        InputStream in = c.openInputStream();
        
        int cnt = 0;

        char conv;
        String serg;
        String output = "";
        while (connected) {
            // read in a string from the stream
            int erg = in.read();
            conv = (char) erg;
            serg = String.valueOf(conv);
            if (serg.equals("#")) {
                if (output.startsWith("GEA:")) {
                    screen.updateGear(output.substring(4));
                }
                if (output.startsWith("SPD:")) {
                    screen.updateSpeed(output.substring(4));
                }
                output = "";
            } else {
                output = output + serg;
            }
            
            
            
            //screen.drawValue(""+b);
            
            if (erg == -1) {
                connected = false;
            }            
        }
        //DataOutputStream out = c.openDataOutputStream();
        //out.writeUTF( s );
        //out.flush();


        // close current connection, wait for the next one
        c.close();


      } catch (Exception e)
      {
        e.printStackTrace();
        //SPP_MIDlet.alert(e, SPP_MIDlet.instance.spp_screen );
      }

    } // while

  }

  /**
   * An utility function to display a log message
   * @param s String
   */
  public void log( String s )
  {
    //SPP_MIDlet.log( s );
  }

    public void startApp() {
        screen = new Screen(this);
        run_server();
    }
    
    public void pauseApp() {
    }
    
    public void destroyApp(boolean unconditional) {
    }
}
