/*
 * Decompiled with CFR 0.152.
 */
package LFSMonitor;

import LFSMonitor.Screen;
import java.io.InputStream;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class LFSMon
extends MIDlet
implements Runnable {
    LocalDevice device;
    DiscoveryAgent agent;
    private static Display display;
    private Screen screen;
    public static final UUID uuid;
    public boolean done = false;
    public boolean connected = true;
    public StreamConnectionNotifier server;

    public void run_server() {
        try {
            this.device = LocalDevice.getLocalDevice();
            this.device.setDiscoverable(10390323);
            Thread t = new Thread(this);
            t.start();
        }
        catch (BluetoothStateException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        String appName = "LFS Outgauge Monitor";
        StreamConnection c = null;
        try {
            String url = "btspp://localhost:" + uuid.toString() + ";name=" + appName + ";authorize=false;authenticate=false;encrypt=false";
            this.log("server url: " + url);
            this.server = (StreamConnectionNotifier)Connector.open((String)url);
            ServiceRecord rec = this.device.getRecord((Connection)this.server);
            rec.setAttributeValue(8, new DataElement(8, 255L));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(e.getClass().getName() + " " + e.getMessage());
        }
        while (!this.done) {
            try {
                display = Display.getDisplay((MIDlet)this);
                display.setCurrent((Displayable)this.screen);
                this.screen.updateSpeed("0");
                this.screen.updateGear("N");
                c = this.server.acceptAndOpen();
                RemoteDevice rdev = RemoteDevice.getRemoteDevice((Connection)c);
                InputStream in = c.openInputStream();
                boolean cnt = false;
                String output = "";
                while (this.connected) {
                    int erg = in.read();
                    char conv = (char)erg;
                    String serg = String.valueOf(conv);
                    if (serg.equals("#")) {
                        if (output.startsWith("GEA:")) {
                            this.screen.updateGear(output.substring(4));
                        }
                        if (output.startsWith("SPD:")) {
                            this.screen.updateSpeed(output.substring(4));
                        }
                        output = "";
                    } else {
                        output = output + serg;
                    }
                    if (erg != -1) continue;
                    this.connected = false;
                }
                c.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void log(String s) {
    }

    public void startApp() {
        this.screen = new Screen(this);
        this.run_server();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    static {
        uuid = new UUID("94f39d297d6d437d973bfba39e49d4ee", false);
    }
}

