#bluetooth handshake, return socket ready for writing

from bluetooth import *
import sys


class SimpleRFCOMMClient:
    """Simple connection to a RFCOMM server."""
        
    def connect(self, uuid, service_name):
        found = False
        while not found:
            print "Searching all nearby bluetooth devices for '%s'." % (
                        service_name)
            service_matches = find_service( uuid=uuid, address=None)
        
            if len(service_matches) == 0:
                print "Nothing found."
                print "Press Enter to try again, or type 'quit' to give up."
                inp = raw_input()
                if inp == 'quit':
                    sys.exit(0)
            else:
                found = True

        first_match = service_matches[0]
        port = first_match["port"]
        name = first_match["name"]
        host = first_match["host"]

        print 'Connecting to "%s" on %s...' % (name, host),

        # Create the client socket
        sock=BluetoothSocket( RFCOMM )
        sock.connect((host, port))
        print 'connected!'
        return sock



