from bluetooth import *
import sys
from LFSLib.InSimParser import OutGaugePacket, OUTGAUGE_ATTRIBUTE_NAMES
from LFSLib.Connection import OutGaugeConnection
from RFCOMM import SimpleRFCOMMClient




rfcomm = SimpleRFCOMMClient()
bt_sock = rfcomm.connect("94f39d29-7d6d-437d-973b-fba39e49d4ee", 
                         "LFS Mobile Monitor Server")

og_conn = OutGaugeConnection('localhost', 21567)


sent = dict()

try:
    while 1:
        data = og_conn.getNextPacket()
        outgauge = OutGaugePacket(data, rpm_res=250, pedals_res=5,
                                  speed_res=1, turbo_res=0.05)
        for name, att in [('GEA:', 'gear'), ('SPD:', 'speed')]: 
            val = getattr(outgauge, att, None)
            if sent.get(name, None) != val:
                sent[name] = val
                bt_sock.send('%s%s##' % (name, val))

except:
    print "Exiting..."
    og_conn.close()
    bt_sock.close()