using System;
using System.Collections;
using System.Text;
using System.Net;
using System.IO;


namespace conv
{
    class Program
    {
        static void Main(string[] args)
        {
            string outputFile ="";
            string idk="";
            string userName="";
            string pass="";
            string coef = "";
            string mlcoef = "";


// English US Globalization
            System.Threading.Thread.CurrentThread.CurrentCulture = new System.Globalization.CultureInfo("en-US");


            if (args.Length < 4 )
            {
                usage();
                return;
            }
            for (int i = 0;i < args.Length; i++)
            {
                switch (args[i])
                {
                    case "-o":
                        outputFile = args[i + 1];
                        i++;
                        break;
                    case "-l":
                        userName = args[i + 1];
                        i++;
                        break;
                    case "-p":
                        pass = args[i + 1];
                        i++;
                        break;
                    case "-c":
                        coef = args[i + 1];
                        i++;
                        break;
                    case "-mlc":
                        mlcoef = args[i + 1];
                        i++;
                        break;
                    case "-i":
                        idk = args[i + 1];
                        i++;
                        break;
                }
            }
            if (outputFile == "" || coef == "" || mlcoef == "" )
            {
                usage();
                return;
            }
            if( idk == "" && ( userName == "" || pass == "" ) )
            {
                Console.WriteLine(idk);
                usage();
                return;
            }
            try
            {
                conv(userName, pass, idk, coef, mlcoef, outputFile);
            }
            catch (Exception ex)
            {
                Console.WriteLine("The following error occurred:");
                Console.WriteLine(ex.Message);   // Print the error message.
                Console.WriteLine(ex.Source);    // Name of application or object that caused the error.
                Console.WriteLine(ex.StackTrace); //String that contains the stack trace for this exception.
                Console.WriteLine(ex.TargetSite); //String that contains the stack trace for this exception.
                System.Threading.Thread.Sleep(50000);
            }
            //            System.Threading.Thread.Sleep(50000);
        }
        public static string getShortVersion(int level)
        {
            string[] FullNameSplit = System.Reflection.Assembly.GetExecutingAssembly().FullName.Split(',');
            string[] version = FullNameSplit[1].Trim().Split('=');
            string[] id = version[1].Split('.');
            string retVal = id[0];
            for (int i = 1; i < level; i++)
                retVal += "." + id[i];
            return retVal;
        }
        static void usage()
        {
            Console.WriteLine("Usage:");
            Console.WriteLine("\tConvWr.exe -l licenseName -p pass -c coef -mlc maxLapCoef -o outputFile");
            Console.WriteLine("or");
            Console.WriteLine("\tConvWr.exe -i idk -c coef -mlc maxLapCoef -o outputFile\n");
            Console.WriteLine("licenseName = Your lfs license Name");
            Console.WriteLine("pass = Your pass of lfs license Name");
            Console.WriteLine("idk = it's your idk. to obtain it in lfsworld 'My LFSW Setting'");
            Console.WriteLine("coef = multiple coef possibility separated by ':'");
            Console.WriteLine("\tex\t:100.5");
            Console.WriteLine("\t\t:100.5:101:101.5");
            Console.WriteLine("maxLapCoef = one coef possibility, to generate MaxLapTime");
            Console.WriteLine("\tex\t:150");
            System.Threading.Thread.Sleep(10000);
        }
        class carInfo
        {
            public string CName;
            public string maxLapTime;
            public string lapTime;
            public string[] split = new string[3];

            public carInfo(string CName,string maxLapTime, string split1, string split2,string split3, string lapTime )
            {
                this.CName = CName;
                this.maxLapTime = maxLapTime;
                this.split[0] = split1;
                this.split[1] = split2;
                this.split[2] = split3;
                this.lapTime = lapTime;
            }
        }
        class trackInfo : System.IComparable
        {
            public string track;
            public System.Collections.Hashtable carTable = new System.Collections.Hashtable();
            public trackInfo(string track ) {
                this.track = track;
            }
            public int CompareTo(object x)
            {
                if (string.Compare((x as trackInfo).track, this.track) < 0)
                    return 1;
                else if (string.Compare((x as trackInfo).track, this.track) > 0)
                    return -1;
                else
                    return 0;
            }
        }
        static string lenTrack(string track)
        {
            string cp = track.Substring(0, 3);
            switch (cp)
            {
                case "BL1":
                    return "3.3";
                case "BL2":
                    return "3.3";
                case "BL3":
                    return "1.8";
                case "SO1":
                    return "2.0";
                case "SO2":
                    return "2.0";
                case "SO3":
                    return "1.3";
                case "SO4":
                    return "4.0";
                case "SO5":
                    return "3.1";
                case "SO6":
                    return "2.9";
                case "FE1":
                    return "1.6";
                case "FE2":
                    return "3.1";
                case "FE3":
                    return "3.5";
                case "FE4":
                    return "6.6";
                case "FE5":
                    return "2";
                case "FE6":
                    return "0.7";
                case "KY1":
                    return "3.0";
                case "KY2":
                    return "5.1";
                case "KY3":
                    return "7.4";
                case "WE1":
                    return "4.4";
                case "WE2":
                    return "5.8";
                case "WE4":
                    return "0.5";
                case "AS1":
                    return "1.9";
                case "AS2":
                    return "3.1";
                case "AS3":
                    return "5.6";
                case "AS4":
                    return "8.1";
                case "AS5":
                    return "8.8";
                case "AS6":
                    return "8.0";
                case "AS7":
                    return "5.2";
                case "RO1":
                    return "3.1";
                case "RO2":
                    return "2.7";
                case "RO3":
                    return "2.4";
                case "RO4":
                    return "3.3";
                case "RO5":
                    return "1.0";
                case "RO6":
                    return "1.6";
                case "RO7":
                    return "3.9";
                case "RO8":
                    return "3.6";
                case "RO9":
                    return "2.2";
                case "RO10":
                    return "4.0";
                case "RO11":
                    return "2.7";
                default:
                    return "0.0";
            }
        }
        static string convTrack(string track)
        {
            string retValue = "";
            switch (track[0])
            {
                case '0':
                    retValue = "BL";
                    break;
                case '1':
                    retValue = "SO";
                    break;
                case '2':
                    retValue = "FE";
                    break;
                case '3':
                    retValue = "AU";
                    break;
                case '4':
                    retValue = "KY";
                    break;
                case '5':
                    retValue = "WE";
                    break;
                case '6':
                    retValue = "AS";
                    break;
                case '7':
                    retValue = "RO";
                    break;
            }
            retValue += (int.Parse(track[1].ToString()) + 1).ToString();
            if (track[2] == '1')
                retValue += "R";
            if (track == "7100")
                retValue = "RO11";
            return retValue;
        }
        static void conv(string user, string pass, string idk, string scoef, string smlcoef, string outputFile )
        {
            string readLine;
            System.Collections.Hashtable trackTable = new System.Collections.Hashtable();


            string[] coef = scoef.Split(':');
            string split1="";
            string split2="";
            string split3="";
            string lapTime="";
            string maxLapTime="";


            Console.WriteLine("TrackInfo maker version " + getShortVersion(2) + " by Gai-Luron");
            Console.WriteLine("Small change by FreeScirocco: RO / WE 2.0 / BL 2.0 support");
            Console.WriteLine("Retreiving infos");
            Console.WriteLine(scoef);
            //            Console.ReadKey();
            string url;
            if (idk != null)
                url = "http://www.lfsworld.net/pubstat/get_stat2.php?version=1.3&idk=" + idk + "&action=wr";
            else
                url = "http://www.lfsworld.net/pubstat/get_stat2.php?version=1.3&user=" + user + "&pass=" + pass + "&action=wr";
            WebRequest req  = WebRequest.Create(url);
            WebResponse result = req.GetResponse();
            Stream receiveStream = result.GetResponseStream();
            using( StreamReader sr = new StreamReader(receiveStream))
            {
                while ( !sr.EndOfStream )
                {
                    readLine = sr.ReadLine();
                    Console.WriteLine(readLine);
                    Console.Write(".");
                    if (readLine.IndexOf("Identification") != -1)
                        throw new System.Exception(readLine);
                    if( readLine.IndexOf("can't") != -1 )
                        throw new System.Exception(readLine);
                    string [] mline = readLine.Split(' ');
                    string track = mline[1];
                    string car = mline[2];
                    string sep = "";
                    split1 = "";
                    split2 = "";
                    split3 = "";
                    lapTime = "";

                    double dmlcoef = double.Parse(smlcoef) / 100;

                    for (int i = 0; i < coef.Length; i++)
                    {

                        double dcoef = double.Parse(coef[i])/100;
//                        Console.WriteLine(coef[i]);
//                        Console.WriteLine(dcoef);
//                        Console.ReadKey();

                        split1 = split1 + sep + timeConv.LongToHMS((long)(double.Parse(mline[3]) * dcoef));
                        if (int.Parse(mline[4]) != 0)
                            split2 = split2 + sep + timeConv.LongToHMS((long)(double.Parse(mline[4]) * dcoef));
                        if (int.Parse(mline[5]) != 0)
                            split3 = split3 + sep + timeConv.LongToHMS((long)(double.Parse(mline[5]) * dcoef));
                        lapTime = lapTime + sep + timeConv.LongToHMS((long)(double.Parse(mline[6]) * dcoef));
                        sep = ":";
                    }
//                    Console.ReadKey();

                    maxLapTime = timeConv.LongToHMS((long)(double.Parse(mline[6]) * dmlcoef));
                    if (!trackTable.ContainsKey(track))
                    {
                        trackTable[track] = new trackInfo(track);
                    }
                    trackInfo tt = (trackTable[track] as trackInfo);
                    if (!tt.carTable.ContainsKey(car))
                    {
                        tt.carTable[car] = new carInfo(car,maxLapTime,split1, split2, split3,lapTime);
                    }
                }

            }
            using (System.IO.StreamWriter sw = new System.IO.StreamWriter(outputFile))
            {
                using (System.IO.StreamReader sr = new System.IO.StreamReader("./header.txt"))
                {

                    while ( !sr.EndOfStream )
                    {
                        readLine = sr.ReadLine();
                        sw.WriteLine(readLine);
                    }
                    sw.WriteLine("");
                    sw.WriteLine("#Auto generated file :");
                    sw.WriteLine("#\tSplit & LapTime coefs :" + scoef);
                    sw.WriteLine("#\tMaxLapTime coef :" + smlcoef);
                    sw.WriteLine("");


                }
                System.Collections.ArrayList list = new System.Collections.ArrayList();
                foreach (DictionaryEntry ct in trackTable)
                {
                    list.Add((trackInfo)(ct.Value));
                }
                list.Sort();
                for( int i = 0; i < list.Count;i++){
//                foreach( DictionaryEntry ct in trackTable ){
//                    sw.WriteLine("track = " + convTrack( (string)ct.Key ));
//                    trackInfo tt = (trackInfo)ct.Value;

                    trackInfo tt = ( trackInfo ) list[i];
                    sw.WriteLine("track = " + convTrack(tt.track));
                    sw.WriteLine("\tlen = " + lenTrack(convTrack(tt.track)));

                    foreach (DictionaryEntry cc in tt.carTable)
                    {
                        sw.WriteLine("\tcar = " + cc.Key);
                        carInfo ci = (carInfo)cc.Value;
                        sw.WriteLine("\t\tMaxLapTime = " + ci.maxLapTime);
                        sw.WriteLine("\t\tsplit1 = " + ci.split[0]);
                        if (ci.split[1] != "")
                            sw.WriteLine("\t\tsplit2 = " + ci.split[1]);
                        if (ci.split[2] != "")
                            sw.WriteLine("\t\tsplit3 = " + ci.split[2]);
                        sw.WriteLine("\t\tlapTime = " + ci.lapTime);
                    }
                }

            }
            Console.WriteLine("");
            Console.WriteLine("Done!");

        }
    }
}
