// LFS Vertex Shader : Interface


// Vertex shader input structures

struct VS_INPUT // VERT_PDT1
{
	float4	v0		: POSITION;
	float4	v5		: COLOR0;
	float2	v8		: TEXCOORD0;
};

// Vertex shader output structures

struct VS_OUTPUT
{
    float4	oPos	: POSITION;
	float4	oD0		: COLOR0;
	float2	oT0		: TEXCOORD0;
};


// Global variables

float4x4	lightinfo_mat	: register(c0); // for vertices in world space


// Main functions

VS_OUTPUT vs_i_prelit_world( in VS_INPUT In ) // for prelit vertices in world space - used in 3D view modes
{
    VS_OUTPUT Out;
	Out.oPos = mul(In.v0, lightinfo_mat); // position
	Out.oD0 = In.v5; // colour
	Out.oT0 = In.v8; // texture
    return Out;
}