#==================================================================================#
#Addonname: 	Soccer
#Author: 	 	Bass-Driver
#Version: 	 	0.5
#VersionDate: 	02-04-2018
#Description:
#
#Version 0.4: Minor Bugfixes
#	-Fix: Error while loading stored GoalCoordinates
#	-Fix: Error while start Socceraddon with !socceron
#	-Fix: Error when "The Ball" respawns to the center
#	-Update: Disabled Next/Previous page button in Load GoalCoordinates
#Version 0.5: More Minor Bugfixes
#	-Fix: !socceroff , playerbuttons doesnt disappear
#	-Fix: Error when entering the adminpanel.
#	-Fix: Upper TeamName buttons didnt change after changing Teamname
#	-Fix: Some commands could be executed by non-admins
#	-Fix: SpawnToCenter command could be executed by guests
#	-Fix: Could start a soccergame without a ball.
#	-Fix: Could start a soccergame without any players in the teams.
#	-Fix: Error while stopping the soccergame.
#	-Fix: VoteWindow: Buttons with playernames didnt close. 
#==================================================================================#
 
CatchEvent OnLapperStart()
	GlobalVar $SoccerActivated; $SoccerActivated = "No";
	GlobalVar $Soccerstarted; $Soccerstarted = 0;
	GlobalVar $BallAutoSpawn; $BallAutoSpawn = 0;
	GlobalVar $PlayersInServer; #Players in Server (PlayerList.LPR)
	GlobalVar $SoccerManyBalls; $SoccerManyBalls = 0;
	GlobalVar $MaxGoalLimit; $MaxGoalLimit = 5;
	GlobalVar $TeamBluePoints; $TeamBluePoints = 0;
	GlobalVar $TeamRedPoints; $TeamRedPoints = 0;
	GlobalVar $CantScoreAgain; $CantScoreAgain = 0;
	GlobalVar $PlyInTeam1; #Blueteam
	GlobalVar $PlyInTeam2; #Redteam
	GlobalVar $PlyInTeam3; #The Ball
	GlobalVar $PlyInTeam4; #The Spectators
	GlobalVar $SoccerTeamName1; $SoccerTeamName1 = "^4Team Blue";
	GlobalVar $SoccerTeamName2; $SoccerTeamName2 = "^1Team Red";
	GlobalVar $SoccerTeamName3; $SoccerTeamName3 = "^7The Ball";
	GlobalVar $SoccerTeamName4; $SoccerTeamName4 = "^7The Spectators";
	GlobalVar $UOT1; #UsersOnTrack of BLUE TEAM
	GlobalVar $UOT2; #UsersOnTrack of RED TEAM
	GlobalVar $UOT3; #UsersOnTrack of BALL
	GlobalVar $UOT4; #UsersOnTrack of SPECTATORS
	GlobalVar $PlyInTeam1; #UsersInTeam of BLUE TEAM
	GlobalVar $PlyInTeam2; #UsersInTeam of RED TEAM
	GlobalVar $PlyInTeam3; #UsersInTeam of BALL
	GlobalVar $PlyInTeam4; #UsersInTeam of SPECTATORS
	GlobalVar $WhoHitTheBall; #Who Hit the ball Nickname
	GlobalVar $WhoHitTheBallUserName; #Who Hit the ball UserName	
	GlobalVar $HitBallDetection; $HitBallDetection = 0;#Looking for hitting the ball
	GlobalVar $BallOnCenter; $BallOnCenter = 0;#Check if the ball is on the centerpoint
	
	#Timer
	Globalvar $Seconds; $Seconds = 0;
	Globalvar $Minutes; $Minutes = 0;
	Globalvar $DisplaySeconds; $DisplaySeconds = 0;
	Globalvar $SoccerTimeLimit; $SoccerTimeLimit = 1;
	Globalvar $TimerStarted; $TimerStarted = 0;
	Globalvar $TimeLimitSec; $TimeLimitSec = 300; #5 minutes
	Globalvar $TimeLimitMinutes; $TimeLimitMinutes = 5; #Value for timer in adminpanel
	#Votesystem
	GlobalVar $ManyVotes; $ManyVotes = 0;
	Globalvar $MaxVotes;
	Globalvar $UserVotes;
	Globalvar $WinningUser;

	#SoccerRounds
	Globalvar $SoccerRounds; $SoccerRounds = 0;
	Globalvar $ManySoccerRounds; $ManySoccerRounds = 3;
	Globalvar $SoccerRoundNumber; $SoccerRoundNumber = 0;
	Globalvar $PlayerBallChangeCar; $PlayerBallChangeCar = 0;
	GlobalVar $TeamBlueRoundPoints; $TeamBlueRoundPoints = 0;
	GlobalVar $TeamRedRoundPoints; $TeamRedRoundPoints = 0;
	
	#GoalCoordinates
	Globalvar $LayoutName; $LayoutName = "Unknown"; #Layoutname
	Globalvar $BlueGoal_X; $BlueGoal_X = "-"; #BlueGoal X_axis 
	Globalvar $BlueGoal_Y; $BlueGoal_Y = "-"; #BlueGoal Y_axis
	Globalvar $BlueGoal_W; $BlueGoal_W = "-"; #BlueGoal Width
	
	Globalvar $RedGoal_X; $RedGoal_X = "-"; #RedGoal X_axis
	Globalvar $RedGoal_Y; $RedGoal_Y = "-"; #RedGoal Y_axis
	Globalvar $RedGoal_W; $RedGoal_W = "-"; #RedGoal Width
	
	Globalvar $Center_X; $Center_X = "-"; #Center X_axis
	Globalvar $Center_Y; $Center_Y = "-"; #Center Y_axis
	Globalvar $Center_W; $Center_W = "-"; #Center Witdh
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event

	$idxOfFirtsSpace = indexOf( $text, " ");

	IF( $idxOfFirtsSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirtsSpace );
	  $argv = trim( subStr( $text,$idxOfFirtsSpace ) );
	ENDIF

	SWITCH( $command )
	CASE "!socceron":
		IF ( UserIsAdmin( $userName ) == 1 ) THEN
			$SoccerActivated = "Yes";
			SoccerPlayerList();
			$Players = GetListOfPlayers("U");  				
			FOREACH( $Var IN $Players )
				SoccerUserSelectTeam($Var["value"]);
				setPlayerVar( $Var["value"], "Voted",0);
				setPlayerVar( $Var["value"], "VotedForUser",0);
				setPlayerVar( $Var["value"], "ScoredManyTimes",0);
				setPlayerVar( $Var["value"], "Team",4);
			ENDFOREACH
			globalmsg("^2»^7Type ^3!soccerhelp ^7for instructions!");
		ELSE
			globalmsg("^1»^7Only for admins!");
		ENDIF
	BREAK;
	CASE "!socceroff":
	IF ( UserIsAdmin( $userName ) == 1 ) THEN
		$SoccerActivated = "No";
		closeGlobalButton("Team1BTN11&Team1BTN1&Team1BTN&Team2BTN1&Team2BTN&Team3BTN1&Team3BTN&Team4BTN1&Team4BTN&waitingforplayers&Topbtn&Timer&Timer2");
		#close Playerbuttons
		$RacersInTeams = getListOfPlayers("N");
		FOREACH( $maVar IN $RacersInTeams )
			closeGlobalButton("name_" . $maVar["value"]);
			closeGlobalButton("ontrack_" . $maVar["value"]);					
		ENDFOREACH
	BREAK;
	
	CASE "!switchteam":
	CASE "!switch":
		IF ($SoccerActivated == "Yes") THEN
			IF ($Soccerstarted == "0") THEN
					SoccerUserSelectTeam($userName);
			ELSE
				privMsg("^3›^7Not possible to switch team during a match!");
			ENDIF
		ENDIF
    BREAK;
		
	CASE "!soccerhelp":
	CASE "!sh":
		IF ($SoccerActivated == "Yes")THEN
			   SoccerHelp(0,0);
		ENDIF
    BREAK;	
	
	#Only for admins
	CASE "!setgoals":
	CASE "!sg":
		IF ( UserIsAdmin( $userName ) == 1 ) THEN
			IF ($SoccerActivated == "Yes") THEN
				OpenSetDetectionMenu(0,0); #Open Set goaldetections window
			ENDIF
		ELSE
				globalmsg("^1»^7Only for admins!");
		ENDIF
    BREAK;
	
	CASE "!setteam":
	CASE "!sttm":
		IF ( UserIsAdmin( $userName ) == 1 ) THEN
			IF ($SoccerActivated == "Yes") THEN
				SetCurrentPlayerVar( "Team",$argv); #Force yourself to a another team
				cmdLFS("/msg ".GetCurrentPlayerVar("NickName")."^7: Forced himself to a another team.");
				SoccerPlayerList();
			ENDIF
		ELSE
			globalmsg("^1»^7Only for admins!");
		ENDIF
    BREAK;

	CASE "!adminmenu":
	CASE "!am":
		IF ( UserIsAdmin( $userName ) == 1 ) THEN
			IF ($SoccerActivated == "Yes")THEN
				   SoccerAdminMenu();
			ENDIF
		ELSE
			globalmsg("^1»^7Only for admins!");
		ENDIF
    BREAK;
	
	CASE "!spawntocenter":
	CASE "!soc":
		IF (( UserIsAdmin( $userName ) == 1 )||(GetPlayerVar( $userName, "Team") == 3 )) THEN 
			IF ($SoccerActivated == "Yes")THEN
				SpawnBallToCenter();
			ENDIF
		ELSE
			globalmsg("^1»^7Admin or The Ball are allowed to use this command!");
		ENDIF
    BREAK;
	
	CASE "!startsoccer":
		IF ( UserIsAdmin( $userName ) == 1 ) THEN
			IF ($SoccerActivated == "Yes") THEN
				PreStartSoccerGame();
			ENDIF
		ELSE
			globalmsg("^1»^7Only for admins!");
		ENDIF
	BREAK;
	
	CASE "!stopsoccer":
		IF ( UserIsAdmin( $userName ) == 1 ) THEN
			IF ($SoccerActivated == "Yes") THEN
				StopSoccerGame();
			ENDIF
		ELSE
			globalmsg("^1»^7Only for admins!");
		ENDIF
	BREAK;
	ENDSWITCH
EndCatchEvent

CatchEvent OnConnect( $userName ) # Player connected to the server
	IF (($SoccerActivated == "Yes")&&($userName != "")) THEN
		
		SoccerUserSelectTeam($userName);
		SetCurrentPlayerVar( "Voted",0);
		SetCurrentPlayerVar( "VotedForUser",0);
		SetCurrentPlayerVar( "ScoredManyTimes",0);
		SetCurrentPlayerVar( "Team",4); #Spectators
		SoccerPlayerList();
		
		IF ($Soccerstarted == 1) THEN
			SetCurrentPlayerVar( "CannotJoinGame",1); #user is too late for joining the game
		ENDIF
	privmsg("^2»^7Type ^3!soccerhelp ^7for instructions!");	
	ENDIF
EndCatchEvent

CatchEvent OnNewPlayerJoin( $userName )  # Player joins the track
	IF ($SoccerActivated == "Yes") THEN
		IF (($PlayerBallChangeCar == 1)&&(GetCurrentPlayerVar("Team") == 3)&&(GetCurrentPlayerVar("Car") == "UF1")) THEN #Player Forcedspected to change car to UF1, insim is waiting until player leaves pit with UF1 and will restart the race
			$PlayerBallChangeCar = 0;
			cmdLFS("/restart");
		ENDIF
			IF ($Soccerstarted == 1)THEN #IF Soccergame is started after restarting race
					IF ((GetCurrentPlayerVar("Team") == 3)&&(GetCurrentPlayerVar("Car") != "UF1")) THEN  #When user is in The Ball team and do not drive a UF1
						privMsg ( $userName , "^8YOU MUST TAKE ^3UF1 ^8TO BE THE ^7[BALL]!!!!!");
						cmdLFS("/spec " . $userName);
					ENDIF
					IF ((GetCurrentPlayerVar("Team") == 3)&&(GetCurrentPlayerVar("Car") == "UF1")&&($CantScoreAgain == 0)) THEN
						cmdLFS("/msg ^7BALL >>> DRIVE TO CENTER!, ^1DO NOT HIT THE BALL!!");
						cmdLFS( "/rcm ^7BALL >>> DRIVE TO CENTER!, ^1DO NOT HIT THE BALL!!");
						cmdLFS( "/rcm_all");
						$CantScoreAgain = 1;
					ENDIF
					IF (GetCurrentPlayerVar("Team") == 4) THEN #Spectators 
						privMsg ( $userName , "^1MATCH HAS BEEN STARTED, WAIT FOR THE NEXT ROUND!");
						cmdLFS("/spec " . $userName);
					ENDIF
			ENDIF
	SoccerPlayerList();	
	ENDIF
EndCatchEvent

CatchEvent OnDisConnect( $userName, $reason ) # Player Disconnect from server
		closeGlobalButton("ontrack_" . $userName);
		closeGlobalButton("name_" . $userName);
		SoccerPlayerList();
EndCatchEvent

CatchEvent OnLeaveRace( $userName )  #Player goes to pit or spectates
	SoccerPlayerList();
EndCatchEvent

CatchEvent OnPit($userName)  # Player teleported to pit ( Shift + P )
	SoccerPlayerList();
EndCatchEvent

CatchEvent OnSpbSplit1( $userName ) # Player event
	IF(GetCurrentPlayerVar("Team") == 3)THEN
		
	ENDIF
EndCatchEvent

CatchEvent OnRaceStart( $NumP ) # Lapper event
	IF (($SoccerActivated == "Yes")&&($NumP > 0)) THEN
		PreStartSoccerGame();
	ENDIF
EndCatchEvent

Sub PreStartSoccerGame()
	IF ($SoccerActivated == "Yes") THEN
		IF ($PlyInTeam3 < 1) THEN
			cmdLFS("/msg ^3SELECT A PLAYER FOR ^7THE BALL");
			cmdLFS( "/rcm ^3VOTE FOR THE BALL!");
			cmdLFS( "/rcm_all");
			Voting(); #Open Votescreen
		ELSE
			StartSoccerGame();
		ENDIF
	ENDIF
EndSub

Sub StartSoccerGame() #Start the soccergame
$GameReady = 1; #LocalVar
$RacersInTeam = getListOfPlayers("N");
			FOREACH( $maVar IN $RacersInTeam )
				IF (GetPlayerVar($maVar["value"], "Team") == 4) THEN #Check player is in Team 4 ( Spectators)
					privMsg ( GetPlayerVar($maVar["value"],"UserName") , "^1MATCH HAS BEEN STARTED, WAIT FOR THE NEXT ROUND!");
					cmdLFS("/spec " . GetPlayerVar($maVar["value"],"UserName"));
				ENDIF
				IF ((GetPlayerVar($maVar["value"], "Team") == 1)||(GetPlayerVar($maVar["value"], "Team") == 2)) THEN								
					#Check is there's a ball available and the right car				
					IF (GetPlayerVar($maVar["value"], "Team") == 3) THEN
						IF (GetPlayerVar($maVar["value"], "Car") != "UF1") THEN #Check is a player is in Team 3 ( The Ball)
							privMsg ( GetPlayerVar($maVar["value"],"UserName") , "^8YOU MUST TAKE ^3UF1 ^8TO BE ^7THE BALL!!!!!");
							cmdLFS("/spec " . GetPlayerVar($maVar["value"],"UserName"));
							openGlobalButton( "userchangecar",50,10,100,12,5,10,32, "^1MATCH WILL BE RESTARTED AFTER PLAYER CHANGED CAR TO ^7UF1!!");
							$GameReady = 0;
						ENDIF
					ENDIF
				ENDIF
			ENDFOREACH
			
	#No ball = Votescreen		
	IF ( $BallInGame == 0) THEN
		cmdLFS("/msg ^3»^7Cannot start the game!, No ball available!");
		cmdLFS("/msg ^3»^7Starting votescreen to choose the ball!");
		Voting();
	ENDIF			
	IF($GameReady == 1) THEN
			#clear all racemessages
			cmdLFS("/rcc_all");
			
			closeGlobalButton("waitingforplayers");
			$TeamBluePoints = 0;$TeamRedPoints = 0;
			
				openGlobalButton("Background",70,0,75,6,1,-1,32,"");
				openGlobalButton("BlueTeamName",70,0,25,6,1,-1,16,"^4› ".$SoccerTeamName1);
				openGlobalButton("TeamScoring",95,0,10,6,1,-1,32,"^7".$TeamBluePoints." ^7- ^7" .$TeamRedPoints);
				openGlobalButton("RedTeamName",105,0,25,6,1,-1,16,"".$SoccerTeamName2."^1 ‹");
			
			IF ($SoccerTimeLimit == 1) THEN
				SoccerCalcTime($TimeLimitSec);
			ELSE
				openGlobalButton("timer",130,0,15,6,1,-1,16,"^7GoalLimit: ^6".$MaxGoalLimit );
			ENDIF
			
			$Carreset = "yes"; cmdLFS( "/canreset=" . $Carreset);
			cmdLFS("/msg ^7BALL >>> DRIVE TO CENTER!, ^1DO NOT HIT THE BALL!!"); 
			cmdLFS( "/rcm ^7BALL >>> DRIVE TO CENTER!, ^1DO NOT HIT THE BALL!!";
			cmdLFS( "/rcm_all");
			$Soccerstarted = 1;
			$CantScoreAgain = 1;
			$HitBallDetection = 1;
			#$yellowflagsystem = "off";
			
			#When SoccerRounds are enabled:
			IF($SoccerRounds == 1)THEN
				$SoccerRoundNumber = 0;
			ENDIF
			SoccerPlayerList();
	ELSE
		cmdLFS("/msg ^3»^7No Ball or enough players to start a game!!");
	ENDIF
EndSub

Sub StopSoccerGame() #Stop the soccergame
	$TeamBluePoints = 0;$TeamRedPoints = 0;
	$Soccerstarted = 0;
	$HitBallDetection = 0; #HitBall Detection is disabled (end of game)
	closeGlobalButton("BlueTeamName&RedTeamName&Background&TeamScoring&timer&timer2");
	closeGlobalButton("timer&timer2");
	$RacersInTeams = getListOfPlayers("N");
	FOREACH( $maVar IN $RacersInTeams )
		SetPlayerVar($maVar["value"], "CannotJoinGame",0);
	ENDFOREACH
EndSub


############################################
#TEAM SELECTION MENU
############################################
Sub SoccerUserSelectTeam($userName)
	openPrivButton( "stmbgd",70,50,50,40,5,-1,32,""); #Selectteam menu
	openPrivButton( "stmtitle",70,50,50,6,5,-1,32,"^3Select team"); #Selectteam menu
	openPrivButton( "stmcounter",70,50,50,6,5,60,128,"(%cpt%)",UJoinSpectators); #Selectteam menu
	openPrivButton( "stmtext",71,57,48,5,4,-1,0,"^7Choose your team %nl% ^7You cannot switch teams during a match! ");
	openPrivButton( "stmblueteam",70,70,50,6,5,-1,16,"^4Join: ".$SoccerTeamName1."" ,UJoinBlueTeam);
	openPrivButton( "stmredteam",70,77,50,6,5,-1,16,"^1Join: ".$SoccerTeamName2."", UJoinRedTeam);
	openPrivButton( "stmspectators",70,84,50,6,5,-1,16,"^7Join The Spectators",UJoinSpectators);	
EndSub

Sub UJoinBlueTeam( $KeyFlags,$id  )
        cmdLFS("/msg ".GetCurrentPlayerVar("NickName"). " ^7Joined: ".$SoccerTeamName1."");
		SetCurrentPlayerVar( "Team",1); #BlueTeam
		closePrivButton("stmbgd&stmtitle&stmcounter&stmtext&stmblueteam&stmredteam&stmspectators");
		SoccerPlayerList();
EndSub

Sub UJoinRedTeam( $KeyFlags,$id  )
        cmdLFS("/msg ".GetCurrentPlayerVar("NickName"). " ^7Joined: ".$SoccerTeamName2."");
		SetCurrentPlayerVar( "Team",2); #RedTeam
		closePrivButton("stmbgd&stmtitle&stmcounter&stmtext&stmblueteam&stmredteam&stmspectators");
		SoccerPlayerList();
EndSub

Sub UJoinSpectators( $KeyFlags,$id  )
        cmdLFS("/msg ".GetCurrentPlayerVar("NickName"). " ^7Joined the Spectators!");
		SetCurrentPlayerVar( "Team",4); #Spectators
		closePrivButton("stmbgd&stmtitle&stmcounter&stmtext&stmblueteam&stmredteam&stmspectators");
		SoccerPlayerList(); 
EndSub
############################################
#END TEAM SELECTION MENU
############################################

Sub RedTeamScored( $userName, $id)
IF (($SoccerActivated == "Yes")&&(GetCurrentPlayerVar("Team") == 3)&&(GetCurrentPlayerVar("Car") == "UF1")&&($CantScoreAgain == 0)&&($Soccerstarted == 1)) THEN
	IF(GetPlayerVar($WhoHitTheBallUserName , "Team") == 1)THEN
		cmdLFS("/msg ^3OWN GOAL MADE BY:".$WhoHitTheBall );
		SetPlayerVar($WhoHitTheBallUserName, "ScoredOwnGoals",GetPlayerVar($WhoHitTheBallUserName, "ScoredOwnGoals")+1);
	ENDIF
		cmdLFS("/msg ^7 ".$WhoHitTheBall. " SCORED!!!" );
		cmdLFS("/rcm ^7 ".$WhoHitTheBall. " SCORED!!!" );
		cmdLFS("/rcm_all");
		IF($BallAutoSpawn == 1) THEN
			SpawnBallToCenter();
		ELSE
			cmdLFS("/msg ^7BALL >>> DRIVE TO CENTER!, ^1DO NOT HIT THE BALL!!");
		ENDIF
		
		#Player Score
		SetPlayerVar($WhoHitTheBallUserName, "ScoredManyTimes",GetPlayerVar($WhoHitTheBallUserName, "ScoredManyTimes")+1);
		IF(GetPlayerVar($WhoHitTheBallUserName, "ScoredManyTimes") == 3) THEN #Hattick detection
			openGlobalButton("hattrick",70,55,60,7,1,5,32,"^7Hattick for: ".$WhoHitTheBall);
		ENDIF
		
		$TeamRedPoints=$TeamRedPoints+1;
		openGlobalButton("TeamScoring",95,0,10,6,1,-1,32,"^7".$TeamBluePoints." ^7- ^7" .$TeamRedPoints);
		$CantScoreAgain = 1;
		
		IF (($SoccerTimeLimit == 0)&&($TeamRedPoints == $MaxGoalLimit)) THEN #GoalLimit enabled
			SoccerTimeLimitExpires();
		ENDIF
ENDIF	
EndSub

Sub BlueTeamScored( $userName, $id)
IF (($SoccerActivated == "Yes")&&(GetCurrentPlayerVar("Team") == 3)&&(GetCurrentPlayerVar("Car") == "UF1")&&($CantScoreAgain == 0)&&($Soccerstarted == 1)) THEN
	IF(GetPlayerVar($WhoHitTheBallUserName , "Team") == 2)THEN
		cmdLFS("/msg ^3OWN GOAL MADE BY:".$WhoHitTheBall );
		SetPlayerVar($WhoHitTheBallUserName, "ScoredOwnGoals",GetPlayerVar($WhoHitTheBallUserName, "ScoredOwnGoals")+1);
	ENDIF
		cmdLFS("/msg ^7 ".$WhoHitTheBall. " SCORED!!!" );
		cmdLFS("/rcm ^7 ".$WhoHitTheBall. " SCORED!!!" );
		cmdLFS("/rcm_all");
		IF($BallAutoSpawn == 1) THEN
			SpawnBallToCenter();
		ELSE
			cmdLFS("/msg ^7BALL >>> DRIVE TO CENTER!, ^1DO NOT HIT THE BALL!!");
		ENDIF
		
		#Player Score
		SetPlayerVar($WhoHitTheBallUserName, "ScoredManyTimes",GetPlayerVar($WhoHitTheBallUserName, "ScoredManyTimes")+1);
		IF(GetPlayerVar($WhoHitTheBallUserName, "ScoredManyTimes") == 3) THEN #Hattick detection
			openGlobalButton("hattrick",70,55,60,7,1,5,32,"^7Hattick for: ".$WhoHitTheBall);
		ENDIF
		
		$TeamBluePoints=$TeamBluePoints+1;
		openGlobalButton("TeamScoring",95,0,10,6,1,-1,32,"^7".$TeamBluePoints." ^7- ^7" .$TeamRedPoints);
		$CantScoreAgain = 1;
		
		IF (($SoccerTimeLimit == 0)&&($TeamBluePoints == $MaxGoalLimit)) THEN #GoalLimit enabled
			SoccerTimeLimitExpires();
		ENDIF
ENDIF
EndSub

Sub GotoCenter( $userName, $id)
IF ((GetCurrentPlayerVar("Team") == 3)&&(GetCurrentPlayerVar("Car") == "UF1")&&($CantScoreAgain == 1)&&($Soccerstarted == 1)&&($BallOnCenter == 0)) THEN
	openGlobalButton("timer2",80,7,40,6,1,8,32,"^7MAKE GOALS IN: ^2(^7 %cpt% ^2) ^7Seconds" ,Scoreagain);
	cmdLFS("/msg ^7PREPARE YOURSELF!, ^1DO NOT HIT THE BALL!!");
	cmdLFS("/rcm ^7PREPARE YOURSELF!, ^1DO NOT HIT THE BALL!!" );
	cmdLFS("/rcm_all");
	SetCurrentPlayerVar( "CannotJoinGame",1);
	$BallOnCenter = 1; 
ENDIF
EndSub

Sub SpawnBallToCenter()
	$TheBall = GetListOfPlayers("U");  				
		FOREACH( $Player IN $TheBall )
			IF (GetPlayerVar($Player["value"], "Team") == 3 ) THEN
				$BALLUCID = GetPlayerVar($Player["value"], "UCID");
				$BALLPLID = GetPlayerVar($Player["value"], "PLID");
				IF(($Center_X == "-")||($Center_Y == "-")) THEN
					Globalmsg("^1No centerspot found, set a Centerspot!! ^7(!setgoal)");
				ELSE
					IF ($CantScoreAgain == 0) THEN
						openGlobalButton("timer2",80,7,40,6,1,8,32,"^7MAKE GOALS IN: ^2(^7 %cpt% ^2) ^7Seconds" ,Scoreagain);
						cmdLFS("/msg ^7PREPARE YOURSELF!, ^1DO NOT HIT THE BALL!!");
						cmdLFS("/rcm ^7PREPARE YOURSELF!, ^1DO NOT HIT THE BALL!!" );
						joinrequest($Center_X,$Center_Y,17,128,7,$BALLUCID,$BALLPLID,4); #Send Data to LFS
					ELSE
						joinrequest($Center_X,$Center_Y,17,128,7,$BALLUCID,$BALLPLID,4); #Send Data to LFS
					ENDIF
				ENDIF
		   ENDIF
		ENDFOREACH
EndSub

Sub Scoreagain($KeyFlags,$id)
	closeGlobalButton("timer2");
	$CantScoreAgain = 0;
	$BallOnCenter = 0;
	cmdLFS("/msg ^2GO GO GO GO GO");
	cmdLFS("/rcm ^2GO GO GO GO GO" );
	cmdLFS("/rcm_all");
EndSub

Sub SoccerTimeLimitExpires()
	closeGlobalButton("timer&timer2");
	cmdLFS("/msg ^4› ^7THE GAMETIME IS OVER!!!" );
		#BLUETEAM WINS
		IF($TeamBluePoints > $TeamRedPoints) THEN
			IF($SoccerRounds == 1)THEN
				$TeamBlueRoundPoints=$TeamBlueRoundPoints+1;
			ENDIF
		
			cmdLFS("/msg ^7".$SoccerTeamName1." ^7Wins the game!");
			cmdLFS( "/rcm " . $SoccerTeamName1 . " ^7Wins!!!");
			cmdLFS("/rcm_all");
		ENDIF
		#REDTEAM WINS
		IF($TeamBluePoints < $TeamRedPoints) THEN
			IF($SoccerRounds == 1)THEN
				$TeamRedRoundPoints=$TeamRedRoundPoints+1;
			ENDIF
		
			cmdLFS("/msg ^7".$SoccerTeamName2." ^7Wins the game!");
			cmdLFS( "/rcm " . $SoccerTeamName2 . " ^7Wins!!!");
			cmdLFS("/rcm_all");
		ENDIF
		IF($TeamBluePoints == $TeamRedPoints) THEN
			cmdLFS( "/rcm ^7GAME IS A TIE");
			cmdLFS("/rcm_all");
		ENDIF
		
		#ROUNDS
		IF($SoccerRounds == 1)THEN
			IF( $SoccerRoundNumber == $ManySoccerRounds)THEN
				IF($TeamBluePoints < $TeamRedPoints) THEN
					cmdLFS("/msg ^7".$SoccerTeamName2." Wins with" .$TeamRedRoundPoints. "Points");
					cmdLFS("/msg ^7After ^3".$ManySoccerRounds."^7 rounds.");
				ENDIF
				IF($TeamBluePoints > $TeamRedPoints) THEN
					cmdLFS("/msg ^7".$SoccerTeamName1." Wins with " .$TeamBlueRoundPoints. "Points");
					cmdLFS("/msg ^7After ^3".$ManySoccerRounds."^7 rounds.");
				ENDIF
				#Reset Soccerrounds Option
				$SoccerRoundNumber = 0;
				$SoccerRounds = 0;
			ELSE
			$SoccerRoundNumber=$SoccerRoundNumber+1;
			cmdLFS("/msg ^7GET READY FOR ROUND:^0[^3". $SoccerRoundNumber."^0]");
			openGlobalButton("RoundNR",145,0,15,6,1,-1,16,"^3Round: ^7".$SoccerRoundNumber."/".$SoccerRounds);
			
			ENDIF
		ENDIF
		
		StopSoccerGame();
EndSub
CatchEvent OnCarContact($PlayerA,$PlayerB,$PlayerA_Speed,$PlayerB_Speed,$PlayerA_X,$PlayerB_X,$PlayerA_Y,$PlayerB_Y)  # Player event
IF ($Soccerstarted == 1) THEN
	IF ((GetPlayerVar($PlayerA , "Team") == 1)&&(GetPlayerVar($PlayerB , "Team") == 3)) THEN
		$WhoHitTheBall = GetPlayerVar($PlayerA, "NickName"); #Set Nickname to var $WhoHitTheBall
		$WhoHitTheBallUserName = GetPlayerVar($PlayerA, "UserName"); #Set UserName to var $WhoHitTheBall
	ENDIF
	IF ((GetPlayerVar($PlayerB , "Team") == 1)&&(GetPlayerVar($PlayerA , "Team") == 3)) THEN
		$WhoHitTheBall = GetPlayerVar($PlayerB, "NickName"); #Set Nickname to var $WhoHitTheBall
		$WhoHitTheBallUserName = GetPlayerVar($PlayerB, "UserName"); #Set UserName to var $WhoHitTheBall
	ENDIF
	IF ((GetPlayerVar($PlayerA , "Team") == 2)&&(GetPlayerVar($PlayerB , "Team") == 3)) THEN
		$WhoHitTheBall = GetPlayerVar($PlayerA, "NickName"); #Set Nickname to var $WhoHitTheBall
		$WhoHitTheBallUserName = GetPlayerVar($PlayerA, "UserName"); #Set UserName to var $WhoHitTheBall
	ENDIF
	IF ((GetPlayerVar($PlayerB , "Team") == 2)&&(GetPlayerVar($PlayerA , "Team") == 3)) THEN
		$WhoHitTheBall = GetPlayerVar($PlayerB, "NickName"); #Set Nickname to var $WhoHitTheBall
		$WhoHitTheBallUserName = GetPlayerVar($PlayerB, "UserName"); #Set UserName to var $WhoHitTheBall
	ENDIF
ENDIF
EndCatchEvent

############################################
#Calculating Seconds in Minutes/Seconds
############################################
Sub SoccerCalcTime( $argv )
	IF ($TimerStarted == 0) THEN #Extra check that the timer cant be enabled for the 2nd time
		$TimerStarted = 1;
		$Minutes = round(($argv/60),0);
		$Time = (round(($argv/60),2)-$Minutes);
		$Seconds = round(($Time*60),0);

			IF ( $Seconds < 0 ) THEN # when seconds are negative
			  $Minutes = $Minutes-1;
			  $Seconds = 60 + $Seconds;
			ENDIF

		$DisplaySeconds=$Seconds;
		Timer( $KeyFlags );#Goto Countdowntimer
	ENDIF
EndSub

Sub Timer( $KeyFlags )
IF ($SoccerTimeLimit == 1) THEN
	IF($Minutes < 10)THEN
		openGlobalButton("timer",130,0,15,6,1,-1,16,"^3Time: 0".$Minutes."^7:^3".$DisplaySeconds."","" );
	ELSE
		openGlobalButton("timer",130,0,15,6,1,-1,16,"^3Time: ".$Minutes."^7:^3".$DisplaySeconds."","" );
	ENDIF
	$Seconds = $Seconds-1;

    IF ( $Seconds < 0 ) THEN
      $Minutes = $Minutes-1;
      $Seconds = 59;
    ENDIF
	
    IF( $Seconds < 10 ) THEN
      $DisplaySeconds = "0".$Seconds;
    ELSE
      $DisplaySeconds = $Seconds;
    ENDIF
	
	 IF ( $Minutes >= 0 && $Seconds >=0 ) THEN
		HostDelayedCommand( 1, Timer ); #Go back to Timersub
	 ELSE
		$TimerStarted = 0;
		removehostdelayedcommand(Timer);
		SoccerTimeLimitExpires();
     ENDIF
ELSE
	removehostdelayedcommand(Timer);
ENDIF
EndSub

##############################################
#SIMPLE HELPMENU
##############################################
Sub SoccerHelp( $KeyFlags,$id  )

	openPrivButton( "soccerhelpmenu_bgd",60,40,80,100,5,-1,16, "");
	openPrivButton( "soccerhelpmenu_bgd1",61,41,78,98,5,-1,32, "");
	openPrivButton( "soccerhelpmenu_title",61,41,78,10,5,-1,32, "^7HELPMENU");
	openPrivButton( "soccerhelpmenu_Close",61,133,78,6,5,-1,32, "^3Close",CloseSoccerMenu);
	
	openPrivButton( "soccerhelpmenu_btn1",61,53,26,5,5,-1,32, "^3Instructions",SoccerInstructions);
	openPrivButton( "soccerhelpmenu_btn2",87,53,26,5,5,-1,32, "^7Commands",SoccerCommands);
	openPrivButton( "soccerhelpmenu_btn3",113,53,26,5,5,-1,32, "^7Stats",SoccerStats);
	
	openPrivButton( "soccerhelpmenu_Instructions",61,60,78,73,5,-1,32,"");
	openPrivButton( "soccerhelpmenu_Instructions1",61,60,78,5,4,-1,64, langEngine( "%{SoccerInstructions1}%"));

EndSub

Sub SoccerInstructions( $KeyFlags,$id  )
	openPrivButton( "soccerhelpmenu_btn1",61,53,26,5,5,-1,32, "^3Instructions",SoccerInstructions);
	openPrivButton( "soccerhelpmenu_btn2",87,53,26,5,5,-1,32, "^7Commands",SoccerCommands);
	openPrivButton( "soccerhelpmenu_btn3",113,53,26,5,5,-1,32, "^7Stats",SoccerStats);
	openPrivButton( "soccerhelpmenu_Instructions1",61,60,78,5,4,-1,64, langEngine( "%{SoccerInstructions1}%"));
EndSub

Sub SoccerCommands( $KeyFlags,$id  )
	openPrivButton( "soccerhelpmenu_btn1",61,53,26,5,5,-1,32, "^7Instructions",SoccerInstructions);
	openPrivButton( "soccerhelpmenu_btn2",87,53,26,5,5,-1,32, "^3Commands",SoccerCommands);
	openPrivButton( "soccerhelpmenu_btn3",113,53,26,5,5,-1,32, "^7Stats",SoccerStats);
	openPrivButton( "soccerhelpmenu_Instructions1",61,60,78,5,4,-1,64, langEngine( "%{SoccerCommands1}%"));
EndSub

Sub SoccerStats( $KeyFlags,$id  )
privmsg("Under development");
EndSub

Sub CloseSoccerMenu( $KeyFlags,$id  )
closePrivButton("soccerhelpmenu_bgd&soccerhelpmenu_bgd1&soccerhelpmenu_Close&soccerhelpmenu_title");
closePrivButton("soccerhelpmenu_btn1&soccerhelpmenu_btn2&soccerhelpmenu_btn3&soccerhelpmenu_Instructions&soccerhelpmenu_Instructions1");
EndSub

#Languages
Lang "EN"
SoccerInstructions1 = 
"^3-How to start a game:"
	. "%nl%^7You need 2 players (1 player each team) and 1 ball "
	. "%nl%^7When no game is running , restart the race with (Shift+R)"
	. "%nl%"
	. "%nl%^3-How to get/be a ball:"
	. "%nl%^7When no ball is detected when starting the match, a votewindow will be displayed."
	. "%nl%^7Click on one of the players that want to be the ball."
	. "%nl%^7The player with the most votes, get forced spectated to change theire car into a UF1."
	. "%nl%^7When the user leave the pit with a UF1 , the race will restart automaticlly."
	. "%nl%"
	. "%nl%^1-RULES:"
	. "%nl%^7»The Ball must go to the center after each goal."
	. "%nl%^7»It is allowed to reset your car"
	. "%nl%^7»It is allowed to spec/pit"
	. "%nl%^7»You may not switch teams during the game";
	
	
SoccerCommands1 = 
"^2»^7!soccerhelp ^8(Soccerhelpmenu) !sh"
	. "%nl%^2»^7!switch ^8(Choose a another team before or after the game) "
	. "%nl%^2»^7!spawntocenter^8(Teleport The Ball to centerpoint) !soc ^1ONLY FOR THE BALL!!!!"
	. "%nl%"
	. "%nl%Admincommands:"
	. "%nl%^2»^7!socceron / off ^8(Switch addon on /off )"
	. "%nl%^2»^7!startsoccer ^8(Start game  /restart have the same result)"
	. "%nl%^2»^7!stopsoccer ^8(Stop game)"
	. "%nl%^2»^7!adminmenu ^8(enter adminmenu) !am"
	. "%nl%^2»^7!sttm 1 or 2(Blue or Red) ^8(Force yourself to a another team)"
	. "%nl%^2»^7!setgoals ^8(Set the locations of the Red/Blue goal and Center) !sg";	
EndLang
##############################################
#SIMPLE HELPMENU END
##############################################