#----------------------------------#
#Name: ZoneBuilder
#Author: Bass-Driver
#Lapper Version: 7.0.4.10 and higher.
#Script Version: 1.0
#ChangeLog:
#
#1.0  				Initial Release
#----------------------------------#

CatchEvent OnLapperStart()
 GlobalVar $List_BtnClose;
 GlobalVar $Loop_On; $Loop_On = 1;
 GlobalVar $CreatedFiles; $CreatedFiles = "includes/ZoneBuilder/Files/CreatedFiles.txt";
 GlobalVar $SavedFileDir; $SavedFileDir = "includes/ZoneBuilder/Files/";
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirtsSpace = indexOf( $text, " ");


	IF( $idxOfFirtsSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirtsSpace );
	  $argv = trim( subStr( $text,$idxOfFirtsSpace ) );
	ENDIF
		
	SWITCH( $command )
			CASE "!zb":
			CASE "!zonebuilder":
				privmsg("^1»* ^7= Required field!!");
				DefineAreaMenu($userName);	
			BREAK;
	ENDSWITCH
EndCatchEvent


CatchEvent OnNewPlayerJoin( $userName )  # Player event
	#Set PlayerVars for this script
	PlayerVars($userName);
EndCatchEvent

Sub PlayerVars($userName)
		#Frequently used Playervar for this script.
	SetPlayerVar($userName,"FileName","");
	SetPlayerVar($userName,"ZoneID","");
	SetPlayerVar($userName,"WidthOfZone",0);
	SetPlayerVar($userName,"EnterZone","");
	SetPlayerVar($userName,"LeaveZone","");
	SetPlayerVar($userName,"X_Axis",-1);
	SetPlayerVar($userName,"Y_Axis",-1);
	SetPlayerVar($userName,"Z_Axis",-1);
	SetPlayerVar($userName,"CarHeading",-1);
	
	#ExpandMenu
	SetPlayerVar($userName,"PageFile",1);
		
	#TestingVars
	SetPlayerVar($userName,"IsTesting",0);
	SetPlayerVar($userName,"IsTestingFile",0);
EndSub

Sub StartLoop($userName)
	$hgt = 30;
	openPrivButton( "DAM_YLoc_X_Axis",171,$hgt+15,9,4,1,-1,32,"^7".GetPlayerVar($userName,"X"));
	openPrivButton( "DAM_YLoc_Y_Axis",180,$hgt+15,9,4,1,-1,32,"^7".GetPlayerVar($userName,"Y"));
	openPrivButton( "DAM_YLoc_Z_Axis",189,$hgt+15,10,4,1,-1,32,"^7".GetPlayerVar($userName,"Z"));
	IF ((GetPlayerVar($userName,"CarHeading") == -1)||(GetPlayerVar($userName,"InstantSpeed") > 1)) THEN
		openPrivTextButton( "DAM_Cfg_Heading_01",182,$hgt+56,17,4,1,32,"^7Set The CarHeading Manually","^3".Round(GetPlayerVar($userName,"Heading"),0),3,SetCarHeading);
	ENDIF
	privDelayedCommand("StartLoop", 1, StartLoop); #Go back to StartLoop Sub
EndSub

Sub DefineAreaMenu($userName)
	#Design	
	$hgt = 30;
	openPrivButton( "DAM_Bgddark",170,$hgt,30,82,1,-1,32,"");
	openPrivButton( "DAM_BgdLight",171,$hgt+1,28,81,1,-1,16,"");
	openPrivButton( "DAM_Title",171,$hgt+1,28,5,1,-1,16,"^0Zone Builder");
	
	#PlayersPosition (Players X and Y Coordinate in LoopSub)
	openPrivButton( "DAM_YLoc_Title",171,$hgt+7,28,4,1,-1,16,"^0Your Position:");
	
	openPrivButton( "DAM_YLoc_X_Title",171,$hgt+11,9,4,1,-1,16,"^2X ^0Axis");
	openPrivButton( "DAM_YLoc_Y_Title",180,$hgt+11,9,4,1,-1,16,"^1Y ^0Axis");
	openPrivButton( "DAM_YLoc_Z_Title",189,$hgt+11,10,4,1,-1,16,"^3Z ^0Axis");
	openPrivButton( "DAM_YLoc_XY",179,$hgt+15,2,4,1,-1,16,"^0:");
	openPrivButton( "DAM_YLoc_YZ",188,$hgt+15,2,4,1,-1,16,"^0:");
	
	#Save/Edit Settings
	#Titles
	openPrivButton( "DAM_Cfg_Title",171,$hgt+20,28,4,1,-1,16,"^0Settings:");
	openPrivButton( "DAM_Cfg_FileName",171,$hgt+24,11,4,1,-1,80,"^0Filename^1*^0:",DisplayFolder);
	openPrivButton( "DAM_Cfg_ZoneID",171,$hgt+28,11,4,1,-1,80,"^0ZoneID^1*^0:",NameOfZoneID);
	openPrivButton( "DAM_Cfg_WoA",171,$hgt+32,11,4,1,-1,80,"^0Width Zone^1*^0:");
	openPrivButton( "DAM_Cfg_SubEnter",171,$hgt+36,11,4,1,-1,80,"^0Enter Zone^1*^0:");
	openPrivButton( "DAM_Cfg_SubLeave",171,$hgt+40,11,4,1,-1,80,"^0Leave Zone:");
	openPrivButton( "DAM_Cfg_X-Axis",171,$hgt+44,11,4,1,-1,80,"^0X-Axis:");
	openPrivButton( "DAM_Cfg_Y-Axis",171,$hgt+48,11,4,1,-1,80,"^0Y-Axis:");
	openPrivButton( "DAM_Cfg_Z-Axis",171,$hgt+52,11,4,1,-1,80,"^0Z-Axis:");
	openPrivButton( "DAM_Cfg_Heading",171,$hgt+56,11,4,1,-1,80,"^0Heading:");
	
#Clickable Buttons
	openPrivTextButton( "DAM_Cfg_FileName_01",182,$hgt+24,17,4,1,32,"^7Enter the name of the New/Saved file","^7".GetPlayerVar($userName,"FileName").".txt",15,SetFileName);
	openPrivTextButton( "DAM_Cfg_ZoneID_01",182,$hgt+28,17,4,1,32,"^7Enter the ID of the Zone","^7".GetPlayerVar($userName,"ZoneID"),20,SetZoneID);
	openPrivTextButton( "DAM_Cfg_WoA_01",182,$hgt+32,17,4,1,32,"^7Width of the Zone","^7".GetPlayerVar($userName,"WidthOfZone"),3,SetWidthOfZone);
	openPrivTextButton( "DAM_Cfg_SubEnter_01",182,$hgt+36,17,4,1,32,"^7Name of Sub when ^3ENTER the Zone","^7".GetPlayerVar($userName,"EnterZone"),20,SetSubEnterZone);
	openPrivTextButton( "DAM_Cfg_SubLeave_01",182,$hgt+40,17,4,1,32,"^7Name of Sub when ^3LEAVING the Zone","^7".GetPlayerVar($userName,"LeaveZone"),20,SetSubLeaveZone);
	openPrivTextButton( "DAM_Cfg_X-Axis_01",182,$hgt+44,17,4,1,32,"^7Set The X-Axis Manually","^7".GetPlayerVar($userName,"X_Axis"),5,SetXAxis);
	openPrivTextButton( "DAM_Cfg_Y-Axis_01",182,$hgt+48,17,4,1,32,"^7Set The Y-Axis Manually","^7".GetPlayerVar($userName,"Y_Axis"),5,SetYAxis);
	openPrivTextButton( "DAM_Cfg_Z-Axis_01",182,$hgt+52,17,4,1,32,"^7Set The Z-Axis Manually","^7".GetPlayerVar($userName,"Z_Axis"),3,SetZAxis);
	openPrivTextButton( "DAM_Cfg_Heading_01",182,$hgt+56,17,4,1,32,"^7Set The CarHeading Manually","^7".Round(GetPlayerVar($userName,"CarHeading"),0),4,SetCarHeading);
	
#Buttons when Testing is activated
	IF (Getcurrentplayervar("IsTesting") != 1) THEN
		IF ((Getcurrentplayervar("WidthOfZone") != 0)&&(Getcurrentplayervar("X_Axis") != "")) THEN
			openPrivButton( "DAM_Test",185,$hgt+61,14,4,1,-1,32,"^2Test Zone%at%^7Test Zone",TestZone);
			openPrivButton( "DAM_GoTo",185,$hgt+65,14,4,1,-1,32,"^3Goto Zone",GoToZone);
		ELSE
			openPrivButton( "DAM_Test",185,$hgt+61,14,4,1,-1,32,"^8Test Zone");
			openPrivButton( "DAM_GoTo",185,$hgt+65,14,4,1,-1,32,"^8Goto Zone");
		ENDIF
	ELSE
		#Test zone function
		TestZone(0,0);
	ENDIF

	IF ((Getcurrentplayervar("FileName") != "")&&(Getcurrentplayervar("IsTesting") != 1)) THEN
		openPrivButton( "DAM_TestFile",171,$hgt+65,14,4,1,-1,32,"^2Test File%at%^7Test File",TestSavedFile);
	ELSE
		openPrivButton( "DAM_TestFile",171,$hgt+65,14,4,1,-1,32,"^8Test File");
	ENDIF

		openPrivButton( "DAM_Edit",171,$hgt+61,14,4,1,-1,32,"");
		openPrivButton( "DAM_Save",171,$hgt+69,28,4,1,-1,32,"^2Save Zone",SaveArea);
		openPrivButton( "DAM_Close",171,$hgt+74,28,4,1,-1,32,"^3Close menu",DAM_Close);
	StartLoop($userName);
	ExpandMenu(0,0);
EndSub

#Info about the buttons/functions:
Sub DisplayFolder($keyflags,$id)
	privmsg("^7»File: ".Getcurrentplayervar("FileName").".txt can be found in...."  );
	privmsg("^7»".$SavedFileDir."".Getcurrentplayervar("FileName").".txt" );
EndSub

Sub NameOfZoneID($keyflags,$id)
	privmsg("^7»The name of Zone");
EndSub

#----------------------------------#
#Expand Menu
#----------------------------------#

Sub ExpandMenu($keyflags,$id)
	$Expandhgt = 112; #Reset Height after recalling the sub
	$FileLine = (ToNum(Getcurrentplayervar("PageFile")-1)*12);
	$SelectedZones = 0;
	
	openPrivButton( "DAM_E_Bgddark",150,$Expandhgt,50,65,1,-1,32,"");
	openPrivButton( "DAM_E_BgdLight",151,$Expandhgt+1,48,63,1,-1,16,"");
	
#OPTIONS#
	#Filter Options
	openPrivButton( "DAM_E_Filter",151,$Expandhgt+1,10,4,1,-1,16,"^8Filter options:");
	
	openPrivButton( "DAM_E_Filter_X",161,$Expandhgt+1,4,4,1,-1,16,"^8X");
	openPrivButton( "DAM_E_Filter_Y",165,$Expandhgt+1,4,4,1,-1,16,"^8Y");
	openPrivButton( "DAM_E_Filter_ZoneID",169,$Expandhgt+1,10,4,1,-1,16,"^8AreaID");
	openPrivButton( "DAM_E_Filter_EnterZone",179,$Expandhgt+1,10,4,1,-1,16,"^8EnterZone");
	openPrivButton( "DAM_E_Filter_LeaveZone",189,$Expandhgt+1,10,4,1,-1,16,"^8LeaveZone");
	
	#Display List of Saved Files
	openPrivButton( "DAM_E_ListofFiles",151,$Expandhgt+5,18,4,1,-1,16,"^0List of saved files",GetListOfSavedFiles);
	openPrivButton( "DAM_E_Delete",169,$Expandhgt+5,10,4,1,-1,16,"^8Delete");
	openPrivButton( "DAM_E_?",179,$Expandhgt+5,4,4,1,-1,16,"^3?",Help);
	
#########END OF OPTIONS##########

#TITLE#
	IF (Getcurrentplayervar("FileName") != "") THEN
		#Get File
		UserGroupFromFile( "".Getcurrentplayervar("FileName"), "".$SavedFileDir."".Getcurrentplayervar("FileName").".txt" );
		
		#Create Array of the entire list / Get number of Zones's.
		$ListOfZones = GetListOfUsersGroup("".Getcurrentplayervar("FileName"));
		$MaxZonesinList = arrayCount($ListOfZones);
		
		openPrivButton( "DAM_E_PageCount",151,$Expandhgt+10,48,4,1,-1,128,"^0".Getcurrentplayervar("PageFile"));
		openPrivTextButton( "DAM_E_Delete",169,$Expandhgt+5,10,4,1,16,"^7Are you sure??? (Y/N)","^8Delete File",1,DeleteFile);		
	ELSE
		openPrivButton( "DAM_E_Title",151,$Expandhgt+10,48,4,1,-1,96,"^7Current File: ^8No file saved/selected!");
	ENDIF
#END OF TITLE#

#SCROLLBAR#
	openPrivButton( "DAM_E_Scroll",196,$Expandhgt+14,3,50,1,-1,16,"");
	IF (Getcurrentplayervar("PageFile") > 1) THEN
		openPrivButton( "DAM_E_Scroll_Up",196,$Expandhgt+14,3,4,1,-1,16,"^0^H¡¶",DAM_E_PageUp);
	ELSE
		openPrivButton( "DAM_E_Scroll_Up",196,$Expandhgt+14,3,4,1,-1,16,"^8^H¡¶");
	ENDIF
	openPrivButton( "DAM_E_Scroll_Down",196,$Expandhgt+60,3,4,1,-1,16,"^0^H¡¿",DAM_E_PageDown);
#End of ScrollBar#

#LIST#	
	#Display the list with area's
	IF(Getcurrentplayervar("FileName") != "")THEN
		FOR ($NrOfRows=1;$NrOfRows<13;$NrOfRows=$NrOfRows+1)
			$LineOfZone = SplitToArray($ListOfZones[$FileLine], "|");
			IF((Getcurrentplayervar("X_Axis") == $LineOfZone[0]) && (Getcurrentplayervar("Y_Axis") == $LineOfZone[1])) THEN
				openPrivButton( "DAM_E_Row_".$FileLine,151,$Expandhgt+14,45,4,1,-1,96,"^0› ^0X = ^7".$LineOfZone[0]." | ^0Y = ^7".$LineOfZone[1]." | ^0W = ^7".$LineOfZone[3]." | ^0EZ = ^7".$LineOfZone[5]."",ClickedLine);
				$SelectedZones = $SelectedZones + 1;
			ELSE
				openPrivButton( "DAM_E_Row_".$FileLine,151,$Expandhgt+14,45,4,1,-1,64,"^0X = ^7".$LineOfZone[0]." | ^0Y = ^7".$LineOfZone[1]." | ^0W = ^7".$LineOfZone[3]." | ^0EZ = ^7".$LineOfZone[5]."",ClickedLine);
			ENDIF
			$List_BtnClose = $List_BtnClose . "&DAM_E_Row_".$FileLine;
			$Expandhgt=$Expandhgt+4;
			$FileLine=$FileLine+1;
		ENDFOR
		$Expandhgt = 112; 
		openPrivButton( "DAM_E_Title",151,$Expandhgt+10,48,4,1,-1,96,"^7Current File: ^3".Getcurrentplayervar("FileName")." ^0(^7".$SelectedZones."/".$MaxZonesinList-1."^0) ^7selected Zones's");
	ENDIF
	
#END OF LIST#
EndSub

#Sub when clicked on a AREA
Sub ClickedLine($keyflags,$id)
	$ZoneID = trim( subStr( $id,10 ));
	$FileLine = (ToNum(Getcurrentplayervar("PageFile")-1)*12) + $ZoneID;
	$Expandhgt = 112; #Reset Height after recalling the sub
	
#Get info from UserGroup (File)
	UserGroupFromFile( "".Getcurrentplayervar("FileName"), "".$SavedFileDir."".Getcurrentplayervar("FileName").".txt" );
	$ListOfZones = GetListOfUsersGroup("".Getcurrentplayervar("FileName"));
	$LineOfZone = SplitToArray($ListOfZones[$FileLine], "|");
	
#X-Axis | Y-Axis | Z-Axis | WidthOfZone | ZoneID | EnterZone | LeaveZone | CarDirection
	SetcurrentPlayerVar("FileName",Getcurrentplayervar("FileName"));
	SetcurrentPlayerVar("X_Axis",		$LineOfZone[0] );
	SetcurrentPlayerVar("Y_Axis",		$LineOfZone[1] );
	SetcurrentPlayerVar("Z_Axis",		$LineOfZone[2] );
	SetcurrentPlayerVar("WidthOfZone",	$LineOfZone[3] );
	SetcurrentPlayerVar("ZoneID",		$LineOfZone[4] );
	SetcurrentPlayerVar("EnterZone",	$LineOfZone[5] );
	SetcurrentPlayerVar("LeaveZone",	$LineOfZone[6] );
	SetcurrentPlayerVar("CarHeading",	$LineOfZone[7] );
	DefineAreaMenu(Getcurrentplayervar("UserName"));
	ExpandMenu(0,0);
	
	openPrivTextButton( "DAM_E_Delete",169,$Expandhgt+5,10,4,1,16,"^7Are you sure??? (Y/N)","^1Delete Zone",1,DeleteZone);
EndSub

Sub Help($id,$argv)

	privmsg("^7»X = X-Axis");
	privmsg("^7»Y = X-Axis");
	privmsg("^7»W = Width of the zone");
	privmsg("^7»EZ = Name of Sub Callback for entering a zone");
	privmsg("^7»LZ = Name of Sub Callback for leaving a zone");
EndSub

Sub DeleteZone($id,$argv)
	IF ($argv = "Y") THEN
	
		$String = "".Getcurrentplayervar("X_Axis")."|".Getcurrentplayervar("Y_Axis")."|".Getcurrentplayervar("Z_Axis")."|".Getcurrentplayervar("WidthOfZone")."|".Getcurrentplayervar("ZoneID")."|".Getcurrentplayervar("EnterZone")."|".Getcurrentplayervar("LeaveZone")."|".Round(Getcurrentplayervar("CarHeading"),0)."";
		IF( UserInGroup( "".Getcurrentplayervar("FileName"), $String ) == 1 ) THEN
		
			RemoveUserFromGroup( "".Getcurrentplayervar("FileName"),Getcurrentplayervar("X_Axis")."|".Getcurrentplayervar("Y_Axis")."|".Getcurrentplayervar("Z_Axis")."|".Getcurrentplayervar("WidthOfZone")."|".Getcurrentplayervar("ZoneID")."|".Getcurrentplayervar("EnterZone")."|".Getcurrentplayervar("LeaveZone")."|".Round(Getcurrentplayervar("CarHeading"),0));
			UserGroupToFile( "".Getcurrentplayervar("FileName"), "".$SavedFileDir."".Getcurrentplayervar("FileName").".txt" );
			
			#Reset PlayerVars
			SetPlayerVar(Getcurrentplayervar("UserName"),"ZoneID","");
			SetPlayerVar(Getcurrentplayervar("UserName"),"WidthOfZone",0);
			SetPlayerVar(Getcurrentplayervar("UserName"),"EnterZone","");
			SetPlayerVar(Getcurrentplayervar("UserName"),"LeaveZone","");
			SetPlayerVar(Getcurrentplayervar("UserName"),"X_Axis",-1);
			SetPlayerVar(Getcurrentplayervar("UserName"),"Y_Axis",-1);
			SetPlayerVar(Getcurrentplayervar("UserName"),"Z_Axis",-1);
			SetPlayerVar(Getcurrentplayervar("UserName"),"CarHeading",-1);	
			
			DefineAreaMenu(Getcurrentplayervar("UserName"));
			ExpandMenu(0,0);
			privmsg("^7»Zone deleted!!");
		ELSE
			globalmsg("^7»A problem occurred with deleting Zone!!");
		ENDIF
	ENDIF
EndSub

#Sub to get list of saved files.
Sub GetListOfSavedFiles($keyflags,$id)
	$FileLine = (ToNum(Getcurrentplayervar("PageFile")-1)*12);
	$Expandhgt = 114; #Reset Height after recalling the sub
	
	UserGroupFromFile( "CreatedFiles", $CreatedFiles."" );
	$ListOfFiles = GetListOfUsersGroup("CreatedFiles");
	$MaxAreasinList = arrayCount($ListOfFiles);
	
#Options
	openPrivButton( "DAM_E_Delete",169,$Expandhgt+3,10,4,1,-1,16,"^8Delete");
	
#Title
	openPrivButton( "DAM_E_Title",151,$Expandhgt+8,48,4,1,-1,32,"^7Number of saved Files: ^7(".$MaxAreasinList-1.") files");
#############LIST#############	
	#List from File
		FOR ($NrOfRows=0;$NrOfRows<13;$NrOfRows=$NrOfRows+1)
			$LineOfFile = SplitToArray($ListOfFiles[$FileLine], "|"); #Get List from File
			openPrivButton( "DAM_E_Row_".$FileLine,151,$Expandhgt+12,48,4,1,-1,64,"^0".$LineOfFile[0],ClickedFileLine);

			$List_BtnClose = $List_BtnClose . "&DAM_E_Row_".$FileLine;
			$Expandhgt=$Expandhgt+4;
			$FileLine=$FileLine+1;
		ENDFOR
#########END OF LIST##########	
EndSub

Sub ClickedFileLine($keyflags,$id)
	$ZoneID = trim( subStr( $id,10 ));
	$FileLine = (ToNum(Getcurrentplayervar("PageFile")-1)*12) + $ZoneID;
	$Expandhgt = 30; #Reset Height after recalling the sub
		
	UserGroupFromFile( "CreatedFiles", $CreatedFiles."");
	$ListOfFiles = GetListOfUsersGroup("CreatedFiles");
	$LineOfFile = SplitToArray($ListOfFiles[$FileLine], "|"); #Get List from File
	
	SetcurrentPlayerVar("FileName",$LineOfFile[0]);
	#Refresh Menu+ExpandMenu
	DefineAreaMenu(Getcurrentplayervar("UserName"));
	ExpandMenu(0,0);
EndSub

#Action sub for pressing ScrollButtons
Sub DAM_E_PageUp($keyflags,$id)
	Setcurrentplayervar("PageFile",Getcurrentplayervar("PageFile")-1);
	closeprivbutton($List_BtnClose);
	ExpandMenu(0,0);
EndSub

Sub DAM_E_PageDown($keyflags,$id)
	Setcurrentplayervar("PageFile",Getcurrentplayervar("PageFile")+1);
	closeprivbutton($List_BtnClose);
	ExpandMenu(0,0);
EndSub

#----------------------------------#
#SET BUTTONS
#----------------------------------#

Sub SetFileName($id,$argv)
	SetCurrentPlayerVar("FileName",$argv);
	DefineAreaMenu(GetCurrentPlayerVar("UserName"));
EndSub

Sub SetZoneID($id,$argv)
	IF (Contains($argv," ") == FALSE) THEN
		SetCurrentPlayerVar("ZoneID",$argv);
		DefineAreaMenu(GetCurrentPlayerVar("UserName"));
	ELSE
		privmsg("^1»ERROR: ^7Must not contain spaces");
	ENDIF
EndSub

Sub SetSubEnterZone($id,$argv)
	IF (Contains($argv," ") == FALSE) THEN
		SetCurrentPlayerVar("EnterZone",$argv);
		DefineAreaMenu(GetCurrentPlayerVar("UserName"));
	ELSE
		privmsg("^1»ERROR: ^7Must not contain spaces");
	ENDIF
EndSub

Sub SetSubLeaveZone($id,$argv)
	IF (Contains($argv," ") == FALSE) THEN
		SetCurrentPlayerVar("LeaveZone",$argv);
		DefineAreaMenu(GetCurrentPlayerVar("UserName"));
	ELSE
		privmsg("^1»ERROR: ^7Must not contain spaces");
	ENDIF
EndSub

Sub SetXAxis($id,$argv)
	IF (IsNum($argv) == TRUE) THEN
		SetCurrentPlayerVar("X_Axis",$argv);
		DefineAreaMenu(Getcurrentplayervar("UserName"));
	ELSE
		privmsg("^1»ERROR: ^7Must be numeric value >> -1000 - 1000");
	ENDIF
EndSub

Sub SetYAxis($id,$argv)
	IF (IsNum($argv) == TRUE) THEN
		SetCurrentPlayerVar("Y_Axis",$argv);
		DefineAreaMenu(Getcurrentplayervar("UserName"));
	ELSE
		privmsg("^1»ERROR: ^7Must be numeric value >> -1000 - 1000");
	ENDIF
EndSub

Sub SetZAxis($id,$argv)
	IF (IsNum($argv) == TRUE) THEN
		SetCurrentPlayerVar("Z_Axis",$argv);
		DefineAreaMenu(Getcurrentplayervar("UserName"));
	ELSE
		privmsg("^1»ERROR: ^7Must be numeric value >> 0 - 100");
	ENDIF
EndSub

Sub SetCarHeading($id,$argv)
	IF (IsNum($argv) == TRUE) THEN
		SetCurrentPlayerVar("CarHeading",$argv);
		DefineAreaMenu(Getcurrentplayervar("UserName"));
	ELSE
		privmsg("^1»ERROR: ^7Must be numeric value >> 0 - 360");
	ENDIF
EndSub

Sub SetWidthOfZone($id,$argv)
	IF (IsNum($argv) == TRUE) THEN
		SetCurrentPlayerVar("WidthOfZone",$argv);
		DefineAreaMenu(GetCurrentPlayerVar("UserName"));
	ELSE
		privmsg("^1»ERROR: ^7Must be numeric value >> 0 - 100");
	ENDIF
EndSub

#----------------------------------#
# SAVE AREA SUB-Routine
#----------------------------------#
Sub SaveArea($keyflags,$id)
	IF((Getcurrentplayervar("FileName") != "") && (Getcurrentplayervar("ZoneID") != "") && (Getcurrentplayervar("EnterZone") != "") && (Getcurrentplayervar("WidthOfZone") > 0)) THEN
		MoveUserToGroup( "".Getcurrentplayervar("FileName"),Getcurrentplayervar("X")."|".Getcurrentplayervar("Y")."|".Getcurrentplayervar("Z")."|".Getcurrentplayervar("WidthOfZone")."|".Getcurrentplayervar("ZoneID")."|".Getcurrentplayervar("EnterZone")."|".Getcurrentplayervar("LeaveZone")."|".Round(Getcurrentplayervar("Heading"),0));
		UserGroupToFile( "".Getcurrentplayervar("FileName"), "".$SavedFileDir."".Getcurrentplayervar("FileName").".txt" );
		
		#Save the created filename in 'CreatedFiles.txt' for later purposes
		MoveUserToGroup( "CreatedFiles",Getcurrentplayervar("FileName"));
		UserGroupToFile( "CreatedFiles", $CreatedFiles."" );	
		#Set Player's position
		SetPlayerVar($userName,"X_Axis",Getcurrentplayervar("X"));
		SetPlayerVar($userName,"Y_Axis",Getcurrentplayervar("Y"));
		
		privmsg("^2»^7Area is succesfully saved!" );
		
		$hgt = 30; #Reset StartHeight of the menu
		DefineAreaMenu(GetCurrentPlayerVar("UserName"));
		openPrivButton( "DAM_Test",185,$hgt+61,14,4,1,-1,32,"^2Test Area%at%^7Test Area",TestZone);
	ELSE
		privmsg("^1»ERROR: ^7Required fields are missing!");
	ENDIF
EndSub

#----------------------------------#
# TEST Zone Function & SUB-Routine
#----------------------------------#
Sub TestZone($keyflags,$id)
	Setcurrentplayervar("IsTesting",1); #Set PlayerVar
	
	IF((Getcurrentplayervar("X_Axis") == -1) || (Getcurrentplayervar("Y_Axis") == -1))THEN
		Setcurrentplayervar("X_Axis",Getcurrentplayervar("X"));
		Setcurrentplayervar("Y_Axis",Getcurrentplayervar("Y"));
	ENDIF
	
	$hgt = 30;
	#DefineAreaMenu(GetCurrentPlayerVar("UserName")); #Goto Menu to Reset Buttons
	openPrivButton( "DAM_Cfg_ZoneID_01",181,$hgt+28,18,4,1,-1,32,"^6TEST_ZONEID");
	openPrivButton( "DAM_Cfg_SubEnter_01",181,$hgt+36,18,4,1,-1,32,"^6TEST_EnterZone");
	openPrivButton( "DAM_Cfg_SubLeave_01",181,$hgt+40,18,4,1,-1,32,"^6TEST_LeaveZone");
	openPrivButton( "DAM_Test",185,$hgt+61,14,4,1,-1,32,"^1STOP TEST",STOP_TestZone);
	openPrivButton( "DAM_GoTo",185,$hgt+65,14,4,1,-1,32,"^3Goto Zone",GoToZone);
	openPrivButton( "DAM_Save",171,$hgt+69,28,4,1,-1,32,"^8Save Zone");
	openPrivButton( "DAM_TestFile",171,$hgt+65,14,4,1,-1,32,"^8Test File");
	openPrivButton( "DAM_InZone",170,$hgt-6,30,6,1,-1,32," ^3DRIVE TO ZONE");
	
	#Enable ZoneAction registration for testing
	RegisterZoneAction("TEST_ZoneID", getLapperVar("ShortTrackName") , Getcurrentplayervar("X_Axis") , Getcurrentplayervar("Y_Axis"), Getcurrentplayervar("WidthOfZone"), TEST_EnterZone, TEST_LeaveZone);
EndSub

#When player Enter/leaves the testing zone
Sub TEST_EnterZone($UserName,$ZoneID)
#Single Area Test
    IF(Getplayervar($UserName,"IsTesting") == 1)THEN
		openPrivButton( "DAM_InZone",170,24,30,6,1,-1,32," ^2ENTERED ZONE!");
	ENDIF
#FileTest
	IF(Getplayervar($UserName,"IsTestingFile") == 1)THEN
		privmsg("EnterZone: ^3".$ZoneID);
		$Zones = trim( subStr( $ZoneID,3 ));
		$Zone = SplitToArray($Zones, "/"); 
		
		SetcurrentPlayerVar("X_Axis",$Zone[0]);
		SetcurrentPlayerVar("Y_Axis",$Zone[1]);
		SetcurrentPlayerVar("Z_Axis",$Zone[2]);
		SetcurrentPlayerVar("WidthOfZone",$Zone[3]);	
	ENDIF
EndSub
 
Sub TEST_LeaveZone($UserName,$ZoneID)
#Single Area Test
    IF(Getplayervar($UserName,"IsTesting") == 1)THEN
		openPrivButton( "DAM_InZone",170,24,30,6,1,-1,32," ^1LEFT ZONE!");
	ENDIF
#FileTest
	IF(Getplayervar($UserName,"IsTestingFile") == 1)THEN
		privmsg("»LeaveZone: ^3".$ZoneID);
	ENDIF
EndSub 

Sub GoToZone($keyflags,$id)
	IF (IsNum(Getcurrentplayervar("X_Axis")) == 1 && IsNum(Getcurrentplayervar("Y_Axis")) == 1 && IsNum(Getcurrentplayervar("Z_Axis")) == 1)THEN
		IF(Getcurrentplayervar("X_Axis") != -1 || Getcurrentplayervar("Y_Axis") != -1)THEN
			privmsg("^7»Spawned to center of the Zone!");
			
		#Calculate Heading of the car
			$Heading = ((Round(Getcurrentplayervar("CarHeading"),0) - 180) * (256 / 360));
			IF($Heading < -1) THEN
				$Heading = $Heading + 180;
			ENDIF
			
		#Spawn Player to center of Area
			joinrequest(Getcurrentplayervar("X_Axis"),Getcurrentplayervar("Y_Axis"),Getcurrentplayervar("Z_Axis"),128, Round($Heading,0),Getcurrentplayervar("UCID"),Getcurrentplayervar("PLID"),4); #Send Data to LFS
		ELSE
			privmsg("^1»ERROR: ^7You are not on the track!!");
		ENDIF
	ELSE
		privmsg("^1»ERROR: ^7joinrequest() failed: One of the parameters are incorrect.");
	ENDIF
EndSub

#Stop testing function
Sub STOP_TestZone($keyflags,$id)
	privmsg("^3»WARNING: ^7TEST-MODE DISABLED!");
	closeprivbutton("DAM_InZone"):
	RemoveZoneAction("TEST_ZoneID",getLapperVar("ShortTrackName"));
	Setcurrentplayervar("IsTesting",0);
	Setcurrentplayervar("IsTestingFile",0);
	DefineAreaMenu(GetCurrentPlayerVar("UserName"));
EndSub

#Function to test the entire loaded File with zones.
Sub TestSavedFile($keyflags,$id)

	globalmsg(Getcurrentplayervar("NickName")." ^7start testing file: ".Getcurrentplayervar("FileName").".txt");
	Setcurrentplayervar("IsTestingFile",1);
	
#Groupfile settings
	UserGroupFromFile("".Getcurrentplayervar("FileName"), "".$SavedFileDir."".Getcurrentplayervar("FileName").".txt" );
	$GetListFromFile = GetListOfUsersGroup("".Getcurrentplayervar("FileName"));
	$GetMaxLinesFromFile = arrayCount($GetListFromFile);
		
#List from File
#X-Axis | Y-Axis | Z-Axis | WidthOfZone | ZoneID | EnterZone | LeaveZone | CarHeading
		FOR ($NrOfRows=0;$NrOfRows<$GetMaxLinesFromFile;$NrOfRows=$NrOfRows+1)
			$Line = SplitToArray($GetListFromFile[$NrOfRows], "|");
			#Check if the Arrays aren't empty
			IF (($Line[0] != "")||($Line[1] != "")||($Line[3] != "")) THEN
				$ZoneID = "AID/".$Line[0]."/".$Line[1]."/".$Line[3];
				RegisterZoneAction("".$ZoneID."", getLapperVar("ShortTrackName") , $Line[0] , $Line[1] , $Line[3], TEST_EnterZone, TEST_LeaveZone);
			ENDIF
		ENDFOR
#Some buttons with "TEST" messages
	$hgt = 30; #StartHeight of the menu
	openPrivButton( "DAM_Cfg_SubEnter_01",181,$hgt+36,18,4,1,-1,32,"^6TEST_EnterZone");
	openPrivButton( "DAM_Cfg_SubLeave_01",181,$hgt+40,18,4,1,-1,32,"^6TEST_LeaveZone");
	openPrivButton( "DAM_Test",185,$hgt+61,14,4,1,-1,32,"^8Test Zone");
	openPrivButton( "DAM_TestFile",171,$hgt+65,14,4,1,-1,32,"^1STOP TEST",STOP_TestZone);
EndSub

#-----------------------#
#CLOSE SUB
#-----------------------#
Sub DAM_Close($keyflags,$id)
	RemovePrivDelayedCommand("StartLoop");
	#closeprivbutton("DAM_YLoc_X_Axis&DAM_YLoc_Y_Axis&DAM_YLoc_Z_Axis&DAM_YLoc_Z_Title&DAM_YLoc_YZ");
	#closeprivbutton("DAM_Bgddark&DAM_BgdLight&DAM_Title&DAM_YLoc_Title&DAM_YLoc_X_Title&DAM_YLoc_Y_Title&DAM_YLoc_XY");
	#closeprivbutton("DAM_Cfg_Title&DAM_Cfg_FileName&DAM_Cfg_ZoneID&DAM_Cfg_WoA&DAM_Cfg_SubEnter&DAM_Cfg_SubLeave&DAM_Cfg_X-Axis&DAM_Cfg_Y-Axis");
	#closeprivbutton("DAM_Cfg_FileName_01&DAM_Cfg_ZoneID_01&DAM_Cfg_WoA_01&DAM_Cfg_SubEnter_01&DAM_Cfg_SubLeave_01&DAM_Cfg_X-Axis_01&DAM_Cfg_Y-Axis_01");
	#closeprivbutton("DAM_Test&DAM_Edit&DAM_Save&DAM_Close&DAM_Expand&DAM_GoTo&DAM_Spare1");
	
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "DAM_*");
	
	#Edit Buttons
	closeprivbutton("DAM_Cfg_WoA_Edit&DAM_Cfg_X-Axis_Edit&DAM_Cfg_Y-Axis_Edit");
	
	#Extra menu
	closeprivbutton("DAM_E_Bgddark&DAM_E_BgdLight&DAM_E_Title&DAM_E_ListofFiles&DAM_E_Filter&DAM_E_Filter_X&DAM_E_Filter_Y&DAM_E_Filter_ZoneID&DAM_E_Filter_EnterZone&DAM_E_Filter_LeaveZone&DAM_E_PageCount");
	closeprivbutton($List_BtnClose);
	#Reset PlayerVars
	PlayerVars(GetCurrentPlayerVar("UserName"));
EndSub
