//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ReShade 3.0 effect file
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Custom post-process for Live for Speed by Nasim 'DarkDrifter' Bouguerra
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// UI variables
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

uniform float fGamma <
	ui_type = "drag";
	ui_min = 0.00; ui_max = 4.00;
        ui_label = "Gamma";
	ui_tooltip = "";
> = 2.20;

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Textures, Samplers
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#include "ReShade.fxh"

float3 PS_Gamma(float4 vpos : SV_Position, float2 texcoord : TEXCOORD): SV_Target
{
	float3 tex_col = pow(tex2D(ReShade::BackBuffer, texcoord).rgb, 1.0 / fGamma);
	
	return tex_col;
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Technique
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

technique Gamma
{
	pass P0
	{
		VertexShader = PostProcessVS;
		PixelShader  = PS_Gamma;
	}
}
