//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ReShade 3.0 effect file
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Custom post-process for Live for Speed by Nasim 'DarkDrifter' Bouguerra
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// UI variables
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

uniform float fSCuvreA <
	ui_type = "drag";
	ui_min = 0.00; ui_max = 4.00;
        ui_label = "S-curve A";
	ui_tooltip = "";
> = 2.320;

uniform float fSCuvreB <
	ui_type = "drag";
	ui_min = -4.00; ui_max = 4.00;
        ui_label = "S-curve B";
	ui_tooltip = "";
> = -1.160;


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Textures, Samplers
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#include "ReShade.fxh"

float3 PS_SCurve(float4 vpos : SV_Position, float2 texcoord : TEXCOORD): SV_Target
{
	float3 tex_col = tex2D(ReShade::BackBuffer, texcoord).rgb;
	
	// S-curve
	float3 x_sq = tex_col * tex_col;
	float3 x_cu = x_sq * tex_col;
	tex_col = fSCuvreB * x_cu + fSCuvreA * x_sq;
	
	return tex_col;
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Technique
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

technique SCurve
{
	pass P0
	{
		VertexShader = PostProcessVS;
		PixelShader  = PS_SCurve;
	}
}
