<?php

include "classes/insim_base.php";

$ply = "notanillusion"; // uname to track (for MP in case someone else has the same pname)
//$ply = "^1Pringles"; // pname (for SP, since it doesn't use uname)

$conn = new connection();
$conn->ip = "127.0.0.1";
$conn->port = "29999";
$conn->connect();

$isi = new insim_init();
$isi->admin = "original";
$isi->port = $conn->port;
$isi->flags = 1+16;
$isi->send($conn->sock_out);

$run = TRUE;

while($run) {
	while($control = fread($conn->sock_in, 1024)) {
		if(preg_match('/\/out quit/', $control)) {
			$run = FALSE;
			echo "Control : quitting, bye bye...\r\n";
		} elseif(preg_match('/NPL/', $control)) {
		 	race_control($conn->sock_in, $conn->sock_out, $control, $ply);
		}
	}
	sleep(1);
}

$conn->close();

function race_control($sock_in, $sock_out, $control, $ply) {
 	$npl = new is_npl();
 	$npl->parse($control);
	if($npl->uname != $ply)	return NULL;
	//if($npl->pname != $ply)	return NULL;
	
	$race = new race();
	$race->pname = preg_replace('/\^[0-9]/', "", $npl->pname);
	$race->uname = $npl->uname;
	$race->cname = $npl->cname;
	$race->unique_id = $npl->unique_id;
	echo "$race->pname ($race->uname) joined ($race->cname) with UID $race->unique_id\r\n";
	print_r($npl); // debug
 
 	$run = TRUE;
 	$cur_lap = 0;
 	$oldtime = time();
 
	$rst = new is_rst();
	$lap = new is_lap();
	$spx = new is_spx();
	$rst = new is_rst();
	$pll = new is_pll();
	$ack = new insim_pack();
	$ack->id = "ACK\0";
	
	while($run) {
	 	if(time() >= $oldtime + 60) {
	 	 	$ack->value = 0;
			$ack->send($sock_out);
			$oldtime = time();
			echo "Keepalive sent\r\n";
		}
		while($control = fread($sock_in, 1024)) {
		 	if(preg_match('/RST/', $control)) {
				echo "Race is starting...\r\n";
				$rst->parse($control);
				print_r(get_object_vars($rst)); // debug
			}
			if(preg_match('/SP[1-3]/', $control)) {
			 	$spx->parse($control);
			 	if($spx->unique_id == $race->unique_id) {
					$race->laps[$cur_lap][substr($spx->id, 2, 1)] = $spx->time;
					echo "Split ".substr($spx->id, 2, 1)." : ".$race->parse_time($race->laps[$cur_lap][substr($spx->id, 2, 1)])." (".($race->laps[$cur_lap][substr($spx->id, 2, 1)] - $race->laps[$cur_lap][substr($spx->id, 2, 1) - 1]).")\r\n";
				}
				$ack->value = $spx->verify_id;
				$ack->send($sock_out);
				echo "SP".substr($spx->id, 2, 1)." : UniqueID -> $spx->unique_id; RACE -> $race->unique_id\r\n";
				print_r($spx); // debug
			} elseif(preg_match('/LAP/', $control)) {
				$lap->parse($control);
				if($lap->unique_id == $race->unique_id) {
					$race->laps[$cur_lap]["time"] = $lap->time;
					echo "Lap ".($cur_lap + 1). " : ".$race->parse_time($race->laps[$cur_lap]['time'])." (".($race->laps[$cur_lap]['time'] - $race->laps[$cur_lap][substr($spx->id, 2, 1)]).")\r\n";
					$cur_lap++;
				}
				$ack->value = $spx->verify_id;
				$ack->send($sock_out);
				print_r($lap); // debug
			} elseif(preg_match('/REN/', $control)) {
				$run = FALSE;
				$ack->value = $spx->verify_id;
				$ack->send($sock_out);
			} elseif(preg_match('/pit stop/', $control) && preg_match('/'.$race->pname.'/', $control)) {
				$race->laps[$cur_lap]["pit"] = 1;
				echo $race->pname." made a pit stop\r\n";
			} elseif(preg_match('/PLL/', $control)) {
			 	$pll->parse($control);
			 	if($pll->unique_id == $race->unique_id) {
					return NULL;
				}
			}
		}
		sleep(1);
	}
	race_stats($race);
}

function race_stats($race) {
	// to do
	foreach($race->laps as $lap) {
		print_r($lap);
	}
}

?>