<?php

// version 0.1.2

include "classes/insim_base.php";

// set up sockets
$conn = new connection();
$conn->ip = "127.0.0.1"; // local ip
$conn->port = "29999"; // init this insim port in LFS
$conn->connect();

// init insim conn
$isi = new insim_init();
$isi->admin = ""; // server/insim password
$isi->nodesecs = "0";
$isi->port = $conn->port;
$isi->send($conn->sock_out);

main($conn->sock_in, $conn->sock_out);

$conn->close();

function main($sock_in, $sock_out) {
	$prefix = "/echo ^3Now playing :"; // change this to according to your preference
	
	$control = ""; // incoming read buffer
	$run = TRUE; // main loop control flag, FALSE will exit script
	$play = TRUE; // pause control
	$update = 60; // seconds between song name fetches (non-blocking)
	$delay = 2; // seconds between reading the $sock_in buffer (blocking, main loop delay)
	$oldtime = 0;
	$current = ""; // previous fetch's song name
	$song = ""; // this fetch's song name
	
	$msg = new mst_pack();
	$ack = new insim_pack();
	$ack->id = "ACK\0";
	$ack->value = 0;

	while($run) {
		while($control = fread($sock_in, 1024)) {
			if(preg_match('/\/out quit/', $control)) {
				echo "quitting, bye bye...\r\n";
				$run = FALSE;
				break;
			} elseif(preg_match('/\/out pause/', $control)) {
		 		$play = FALSE;
				echo "paused\r\n";
			} elseif(preg_match('/\/out unpause/', $control)) {
		 		$play = TRUE;
		 		echo "unpaused\r\n";
			}
		}
	
		if($play) {
			if(time() >= $oldtime + $update) {
				$current = get_song();
				$ack->send($sock_out);
				$oldtime = time();
			}
					
			if($current != $song) { // send only if song has changed
				echo substr($prefix, 8)." $current";
		 		if(strlen($current) > 52 - strlen($prefix)) { // use multiple packets
					for($i = 0; $i < ceil(strlen($current) / 52); $i++) {
						$msg_base[$i] = substr($current, 52 * $i, 52);
					}
					$msg->msg = $prefix;
					$msg->send($sock_out);
					foreach($msg_base as $msg_split) {
						$msg->msg = "/echo ^3$msg_split";
						$msg->send($sock_out);
					}
					$msg_base = ""; // clear so that the msg splits aren't sent if the next name is shorter
				} else {
					$msg->msg = "$prefix $current";
					$msg->send($sock_out);
				}
			}
			$song = $current;
		} else {
		 	if(time() >= $oldtime + 60)	$ack->send($sock_out);
		}
		sleep(2);
	}
}

function get_song() {
// this funct must be rewritten if you want to change the source of the string
// the retval is always what you want to show on-screen in LFS
	$klf = file("http://www.klf.fi/");
	$foo = explode("&nbsp;", $klf[56]);
	return $foo[2];
}

?>