<?php

// version 0.0.3, internal use only. Under development, don't bother using it for other purposes, not that I'd be stopping you

class packet {
	var $id;
}

class insim_pack extends packet {
	var $value;
	
	function send($sock_out) {
		fwrite($sock_out, $this->id.pack("L", str_pad($this->value, 32, "\0")));
	}
}

class insim_version extends packet {
	var $version;
	var $product;
	var $insimver;
	
	function parse($packet) {
		$this->id = rtrim(substr($packet, 0, 4));
		$this->version = rtrim(substr($packet, 4, 8));
		$this->product = rtrim(substr($packet, 12, 6));
		$temp = unpack("s", substr($packet, 18));
		$this->insimver = rtrim($temp[1]);
	}
}

class insim_init extends packet {
	var $port;
	var $flags;
	var $nodesecs;
	var $admin;
	
	function send($sock_out) {
		fwrite($sock_out, "ISI\0".pack("Scc", $this->port + 1, $this->flags, $this->nodesecs).str_pad($this->admin, 16, "\0"));
	}
}

class state_pack extends packet {
	var $replay_speed;
	
	var $flags;
	var $in_game_cam;
	var $view_player;
	
	var $num_players;
	var $num_conns;
	var $num_finished;
	var $race_in_progressed;
	
	var $qual_mins;
	var $race_laps;
	var $spare2;
	var $spare3;
	
	var $track;
	var $weather;
	var $wind;
	
	function parse_flags() {
		$iss_flags = array("ISS_GAME" => 1, "ISS_REPLAY" => 2, "ISS_PAUSED" => 4, "ISS_SHIFTU" => 8, "ISS_SHIFTU_HIGH" => 16,
							"ISS_SHIFTU_FOLLOW" => 32, "ISS_SHIFTU_NO_OPT" => 64, "ISS_SHOW_2D" => 128,
							"ISS_FRONT_END" => 256, "ISS_MULTI" => 512, "ISS_MPSPEEDUP" => 1024, "ISS_WINDOWED" => 2048,
							"ISS_SOUND_MUTE" => 4096, "ISS_VIEW_OVERRIDE" => 8192
							);
							
	 	$i = $this->flags;
		foreach(array_reverse($iss_flags) as $key => $value) {
			if($i - $value >= 0) {
				$set_flags[$key] = $value;
				$i -= $value;
			}
		}
		return $set_flags;
	}
	
	function parse($packet) {
	 	$foo = unpack("a4id/freplay_speed/Sflags/cin_game_cam/cview_player/cnum_players/cnum_conns/cnum_finished/crace_in_progress/cqual_mins/crace_laps/cspare2/cspare3/a6track/cweather/cwind", $packet);
	 	foreach($foo as $key => $value) {
			$this->$key = $value;
		}
	}
}

class insim_multi extends packet {
	var $host;
	var $spare1;
	var $spare2;
	var $spare3;
	var $name;
	
	function parse($packet) {
		$foo = unpack("a4id/chost/cspare1/cspare2/cspare3/a32name", $packet);
		foreach($foo as $key => $value) {
			$this->$key = $value;
		}
	}
}

class insim_vote extends packet {
	var $conn;
	var $type;
	var $spare1;
	var $spare2;
	var $vote_types = array(0 => "VOTE_NONE", 1 => "VOTE_END_RACE", 2 => "VOTE_RESTART", 3 => "VOTE_QUALIFY");
	
	function parse($packet) {
		$foo = unpack("a4id/cconn/ctype/cspare1/cspare2", $packet);
		foreach($foo as $key => $value) {
			$this->$key = $value;
		}
	}
	
	function parse_type() {
		return $this->vote_types[$this->type];
	}
}

class vote_action extends insim_vote {
	function parse($packet) {
		$foo = unpack("a4id/ctype", $packet);
		$this->type = $this->vote_types[$foo['type']];
	}
}

class is_rst extends packet {
	var $race_laps;
	var $qual_mins;
	var $num_in_race;
	var $spare;
	
	var $track;
	var $weather;
	var $wind;
	
	var $sp0;
	var $sp1;
	var $verify_id;
	
	function parse($packet) {
		$foo = unpack("a4id/crace_laps/cqual_mins/cnum_in_race/cspare/a6track/cweather/cwind/csp0/csp1/Sverify_id", $packet);
		foreach($foo as $key => $value) {
			$this->$key = $value;
		}
	}
}

class is_ren extends packet {
	var $sp0;
	var $sp1;
	var $verify_id;
	
	function parse($packet) {
		$foo = unpack("a4id/csp0/csp1/Sverify_id", $packet);
		foreach($foo as $key => $value) {
			$this->$key = $value;
		}
	}
}

class is_ncn extends packet {
	var $uname;
	var $pname;
	
	var $admin;
	var $sp1;
	var $sp2;
	var $sp3;
	
	var $conn_num;
	var $total;
	var $verify_id;
	
	function parse($packet) {
		$foo = unpack("a4id/a24uname/a24pname/cadmin/csp1/csp2/csp3/cconn_num/ctotal/Sverify_id", $packet);
		foreach($foo as $key => $value) {
			$this->$key = $value;
		}
	}
}

class is_cnl extends packet {
	var $uname;
	var $pname;
	var $conn_num;
	var $total;
	var $verify_id;
	
	function parse($packet) {
		$foo = unpack("a4id/a24uname/a24pname/cconn_num/ctotal/Sverify_id", $packet);
		foreach($foo as $key => $value) {
			$this->$key = $value;
		}
	}
}

class is_npl extends packet {
	var $uname;
	var $pname;
	var $plate;
	var $cname;
	
	var $flags;
	var $type;
	var $unique_id;
	
	var $ply_num;
	var $total;
	var $verify_id;
	
	function parse($packet) {
		$foo = unpack("a4id/a24uname/a24pname/a8plate/a32cname/Sflags/ctype/cunique_id/cply_num/ctotal/Sverify_id", $packet);
		foreach($foo as $key => $value) {
			$this->$key = $value;
		}
	}
}

class is_plp extends packet {
	var $uname;
	var $pname;
	
	var $unique_id;
	var $sp1;
	var $sp2;
	var $sp3;
	
	var $ply_num;
	var $total;
	var $verify_id;
	
	function parse($packet) {
		$foo = unpack("a4id/a24uname/a24pname/cunique_id/csp1/csp2/csp3/cply_num/ctotal/Sverify_id", $packet);
		foreach($foo as $key => $value) {
			$this->$key = $value;
		}
	}
}

class is_pll extends packet {
	var $uname;
	var $pname;
	
	var $unique_id;
	var $sp1;
	var $sp2;
	var $sp3;
	
	var $ply_num;
	var $total;
	var $verify_id;
	
	function parse($packet) {
		$foo = unpack("a4id/a24uname/a24pname/cunique_id/csp1/csp2/csp3/cply_num/ctotal/Sverify_id", $packet);
		foreach($foo as $key => $value) {
			$this->$key = $value;
		}
	}
}

class is_cpr extends packet {
	var $uname;
	var $old_name;
	var $new_name;
	var $plate;
	
	var $unique_id;
	var $sp1;
	var $verify_id;
	
	function parse($packet) {
		$foo = unpack("a4id/a24uname/a24old_name/a24new_name/a8plate/cunique_id/csp1/Sverify_id", $packet);
		foreach($foo as $key => $value) {
			$this->$key = $value;
		}
	}
}

class is_clr extends packet {
	var $sp0;
	var $sp1;
	var $verify_id;
	
	function parse($packet) {
		$foo = unpack("a4id/csp0/csp1/Sverify_id", $packet);
		foreach($foo as $key => $value) {
			$this->$key = $value;
		}
	}
}

class is_lap extends packet {
	var $uname;
	var $pname;
	var $cname;
	
	var $time;
	
	var $ply_num;
	var $unique_id;
	var $verify_id;
	
	function parse($packet) {
		$foo = unpack("a4id/a24uname/a24pname/a32cname/c3time/cply_num/cunique_id/Sverify_id", $packet);
		$foo['time'] = $foo['time1'].":".$foo['time2'].".".$foo['time3'];
		foreach($foo as $key => $value) {
		 	if(!preg_match('/time[0-9]/', $key)) {
				$this->$key = $value;
			}
		}
	}
}

class is_spx extends packet {
	var $time;
	
	var $ply_num;
	var $unique_id;
	var $verify_id;
	
	function parse($packet) {
		$foo = unpack("a4id/ltime/cply_num/cunique_id/Sverify_id", $packet);
		foreach($foo as $key => $value) {
			$this->$key = $value;
		}
	}
}

class is_res extends packet {
	var $uname;
	var $pname;
	var $plate;
	var $cname;
	
	var $spare;
	
	var $hours;
	var $spare_w;
	
	var $laps_done;
	var $flags;
	
	var $confirm_flags;
	var $num_stops;
	var $type;
	var $unique_id;
	
	var $total_time;
	var $best_lap;
	
	var $result_num;
	var $num_results;
	var $verify_id;
	
	function parse($packet) {
		$foo = unpack("a4id/a24uname/a24pname/a8plate/a4cname/a20spare/Shours/Sspare_w/Slaps_done/Sflags/cconfirm_flags/cnum_stops/ctype/cunique_id/c3total_time/c3best_lap/cresult_num/cnum_results/Sverify_id", $packet);
		$foo['total_time'] = $foo['total_time1'].":".$foo['total_time2'].".".$foo['total_time3'];
		$foo['best_lap'] = $foo['best_lap1'].":".$foo['best_lap2'].".".$foo['best_lap3'];
		foreach($foo as $key => $value) {
		 	if(!preg_match('/{total_time[0-9]}|{best_lap[0-9]}/', $key)) {
				$this->$key = $value;
			}
		}
	}
}

class mst_pack extends packet {
	var $msg;
	
	function send($sock_out) {
		fwrite($sock_out, "MST\0".str_pad($this->msg, 64, "\0"));
	}
}

class mso_pack extends packet {
	var $msg;
	
	function send($sock_out) {
		fwrite($sock_out, "MSO\0".str_pad($this->msg, 124, "\0"));
	}
}

class connection {
	var $sock_in;
	var $sock_out;
	var $ip;
	var $port;
	
	function connect() {
		$this->sock_in = stream_socket_server("udp://".$this->ip.":".($this->port + 1), $errno, $errstr, STREAM_SERVER_BIND);
		if(!$this->sock_in) return "E_BIND_FAILED";
		stream_set_blocking($this->sock_in, FALSE);
			
		$this->sock_out = stream_socket_client("udp://".$this->ip.":".$this->port);
		if(!$this->sock_out) return "E_BIND_FAILED";
		stream_set_blocking($this->sock_out, FALSE);
	}
	
	function close() {
		fclose($this->sock_in);
		fclose($this->sock_out);
	}
	
	function read() {
	 	$response = "";
	 	while(!$response) {
			usleep(1);
			$response = fread($this->sock_in, 1024);
		}
		return $response;
	}
}

?>