<?php
#################################################################
# mpres trackimage_svg.php V2.05																#
# produces track image in svg format														#
# directory: script main path																		#
#################################################################
define('NORMAL_ACCESS', null);
error_reporting(E_ERROR | E_WARNING | E_PARSE);
### define paths of this script ###
define('DS', DIRECTORY_SEPARATOR);
define('SCRIPTPATH', dirname(realpath(__FILE__)).DS);
define('SCRIPTURL', 'http://'.$_SERVER['SERVER_NAME'].pathinfo($_SERVER['PHP_SELF'], PATHINFO_DIRNAME).'/');
define('IMGTYPE', 'svg');

### include some data ###
require_once(SCRIPTPATH."config.inc.php");
require_once(SCRIPTPATH.'includes/functions.php');
require_once(SCRIPTPATH."includes/definitions.php");

### choose language for output ###
# check if user has set a language cookie or has selected a language manually instead
if(isset($_GET['lang']) && in_array($_GET['lang'], $vlangs)) $ulang = $_GET['lang'];
elseif(isset($_COOKIE['lang']) && in_array($_COOKIE['lang'], $vlangs)) $ulang = $_COOKIE['lang'];
else $ulang = null;
# load language variables
$lang = getlanguage(OUTLANG, $_SERVER['HTTP_ACCEPT_LANGUAGE'], $ulang);

### set factor for miles - km conversion ###
$distunit = (DISTUNIT=='km' || DISTUNIT=='mi') ? DISTUNIT : 'km';
$distunit = ($_GET['dunit']=='km' || $_GET['dunit']=='mi') ? $_GET['dunit'] : $distunit;
$km2mifactor = ($distunit=='km') ? 1 : KM_2_MI;

### get parameters ###
$desired_size = (!empty($_GET['size'])&& is_numeric($_GET['size'])) ? intval($_GET['size']) : 1000;
$showall = (!empty($_GET['showall']) && $_GET['showall']=='_all') ? 1 : 0;
$all = (!empty($_GET['showall']) && $_GET['showall']=='_all') ? '_all' : '';
$getlink = ($_GET['link']==1) ? true : false;


### get pth version to handle ###
$v = (!empty($_GET['ver'])) ? $_GET['ver'] : null;

if(floatval(substr($v,0,3)) < 0.6) $trackarray = $AllTracks;
elseif(floatval(substr($v,0,3)) == 0.6 && ord($v{3}) < 71) $trackarray = $AllTracks;
elseif(floatval(substr($v,0,3)) == 0.6 && ord($v{3}) == 71 && (strlen($v) < 5 || intval(substr($v,4)) < 14)) $trackarray = $AllTracks;
else $trackarray = $AllTracksNewWE;

$pthdir ='pth/';
$pthlen = strlen($pthdir);
$pthvers = glob($pthdir.'*', GLOB_ONLYDIR);
rsort($pthvers, SORT_STRING);
$actpth = (in_array($pthdir.$v,$pthvers)) ? $pthdir.$v.'/' : null;
if(!$actpth) {
	foreach($pthvers as $ver) {
		if(floatval(substr($ver,$pthlen,3))<floatval(substr($v,0,3))) {
			$actpth = $ver.'/';
			break;
		}
		elseif(floatval(substr($ver,$pthlen,3))>floatval(substr($v,0,3))) continue;
		elseif(ord($ver{3+$pthlen})>ord($v{3})) continue;
		elseif(ord($ver{3+$pthlen})==ord($v{3}) && intval(substr($ver,4+$pthlen))>intval(substr($v,4))) continue;
		else {
			$actpth = $ver.'/';
			break;
		}
	}
}
if(!empty($_GET['track']) && strtoupper(substr($_GET['track'],-1))=='X' && (strlen($_GET['track'])==4 || (strlen($_GET['track'])==5 && is_numeric($_GET['track']{4})))) {
	$track = (file_exists($actpth.strtoupper(substr($_GET['track'],0,-1)).".pth")) ? strtoupper($_GET['track']) : die($lang['errors']['invalidtrack']);
}
elseif(!empty($_GET['track']) && (strtoupper(substr($_GET['track'],-1))=='Y' || strtoupper(substr($_GET['track'],-1))=='R') && (strlen($_GET['track'])==4 || (strlen($_GET['track'])==5 && is_numeric($_GET['track']{4})))) {
	$track = (file_exists($actpth.strtoupper(substr($_GET['track'],0,-1))."R.pth")) ? strtoupper($_GET['track']) : die($lang['errors']['invalidtrack']);
}
else	$track = (!empty($_GET['track']) && file_exists($actpth.strtoupper($_GET['track']).".pth")) ? strtoupper($_GET['track']) : die($lang['errors']['invalidtrack']);

$tracks = glob($actpth.strtoupper(substr($track,0,2))."*.pth");
if(empty($tracks)) die ($lang['errors']['invalidtrack']);

$trackfile = './images/rendered/track/'.$track.'_'.$_GET['ver'].'_'.$distunit.$all.'_'.$desired_size.'.svg';

### If file isn't already rendered, do so ###
if(!is_file($trackfile)) {
	### set initial parameters ###
	$minx = $miny = 2560;
	$maxx = $maxy = 0;

### read all files for the selected track if they are to be shown ###
foreach ($tracks as $filename) {
	### Alternative Strecken ausgeben (nur Strecke) ###
	$fname = basename($filename,".pth");
	if($fname!=strtoupper($track) && (strlen($fname)==3 || (strlen($fname)==4 && is_numeric($fname{3}))) && ($showall==1 || substr(strtoupper($track),-1)=='X' || substr(strtoupper($track),-1)=='Y')) {
		### unset points ###
		unset($points_leftDrive);
		unset($points_rightDrive);
		unset($points_drive);
		unset($points);
		unset($pthdata);

		### read pth ###
		$handle = fopen ($filename, "rb");
		$filesize = filesize ($filename);
		$contents = fread ($handle,$filesize);
		fclose ($handle);

		### parse file ###
		$os = 0;
		$i = 0;
		$string ='';
		while($i<16) {
		  $string .= $contents{$os+$i};
		  $i++;
		}
		$pthheader  = unpack("@0/a6LFSPTH/Cversion/Crevision/Lnumnodes/Lfinishline",$string);
		$os = 16;
		$n=0;
		while ($n<$pthheader['numnodes']) {
			$i = 0;
			$string ='';
			while($i<40) {
			  $string .= $contents{$os+$i};
			  $i++;
			}
			$pthdata[$n]  = unpack("@0/icentreX/icentreY/icentreZ/fdirX/fdirY/fdirZ/flimitLeft/flimitRight/fdriveLeft/fdriveRight",$string);
			$os += 40;
			$n++;
		}

		### hand points to arrays ###
		foreach($pthdata as $id => $point) {
			### road ###
			$points_leftDrive[] = getOuterX($point['centreX'],$point['driveLeft'],getDir($point['dirX'],$point['dirY'])).",".getOuterY($point['centreY'],$point['driveLeft'],getDir($point['dirX'],$point['dirY']))." ";
			$points_rightDrive[] = getOuterX($point['centreX'],$point['driveRight'],getDir($point['dirX'],$point['dirY'])).",".getOuterY($point['centreY'],$point['driveRight'],getDir($point['dirX'],$point['dirY']))." ";

			### adjust track size ###
			if(getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))>getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) {
				if($maxx<getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))) $maxx = getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']));
				if($minx>getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) $minx = getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']));
			}
			elseif(getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))<getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) {
				if($maxx<getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) $maxx = getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']));
				if($minx>getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))) $minx = getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']));
			}
			if(getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))>getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) {
				if($maxy<getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))) $maxy = getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']));
				if($miny>getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) $miny = getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']));
			}
			elseif(getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))<getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) {
				if($maxy<getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) $maxy = getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']));
				if($miny>getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))) $miny = getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']));
			}
		}

		### merge left and right limits ###
		array_push($points_leftDrive,$points_leftDrive[0]);
		array_push($points_rightDrive,$points_rightDrive[0]);
		foreach($points_leftDrive as $id=>$left) {
			$points_drive .= $left;
		}
		foreach($points_rightDrive as $id=>$right) {
			$points_drive .= $points_rightDrive[count($points_rightDrive)-$id-1];
		}
		$points_drive = trim($points_drive);

		### draw track ###
		if(substr(strtoupper($track),-1)=='X' || substr(strtoupper($track),-1)=='Y') {
		$body .= '	<polygon fill="black" stroke="black" stroke-width="1" points="'.$points_drive.'" />
		';
		$body .= '	<polygon fill="black" stroke="black" stroke-width="2" points="'.$points_leftDrive[0].' '.$points_rightDrive[0].'" />';
		}
		else {
		$body .= '	<polygon fill="lightgray" stroke="darkgrey" stroke-width="1" points="'.$points_drive.'" />
		';
		$body .= '	<polygon fill="lightgray" stroke="lightgray" stroke-width="2" points="'.$points_leftDrive[0].' '.$points_rightDrive[0].'" />';
		}
	}
	### get the "real" track" ###
	if(basename($filename,".pth")==strtoupper($track) || (substr(strtoupper($track),-1)=='X' && basename($filename,".pth")==substr(strtoupper($track),0,-1)) || (substr(strtoupper($track),-1)=='Y' && basename($filename,".pth")==substr(strtoupper($track),0,-1).'R')) {
		### unset points ###
		unset($points);
		unset($points_leftDrive);
		unset($points_rightDrive);
		unset($points_leftLimit);
		unset($points_rightLimit);
		unset($points_drive);
		unset($points_limit);
		unset($pthdata);

		### read file ###
		$handle = fopen ($filename, "rb");
		$filesize = filesize ($filename);
		$contents = fread ($handle,$filesize);
		fclose ($handle);

		### parse file ###
		$os = 0;
		$i = 0;
		$string ='';
		while($i<16) {
		  $string .= $contents{$os+$i};
		  $i++;
		}
		$pthheader  = unpack("@0/a6LFSPTH/Cversion/Crevision/Lnumnodes/Lfinishline",$string);
		$os = 16;
		$n=0;
		while ($n<$pthheader['numnodes']) {
			$i = 0;
			$string ='';
			while($i<40) {
			  $string .= $contents{$os+$i};
			  $i++;
			}
			$pthdata[$n]  = unpack("@0/icentreX/icentreY/icentreZ/fdirX/fdirY/fdirZ/flimitLeft/flimitRight/fdriveLeft/fdriveRight",$string);
			$os += 40;
			$n++;
		}

		$ds=0; # tracklength
		### hand points to arrays ###
		foreach($pthdata as $id => $point) {
			### get track length ###
			if(isset($pthdata[$id+1])) {
				$dx2 = pow(($pthdata[$id+1]['centreX'] - $pthdata[$id]['centreX'])/65536,2);
				$dy2 = pow(($pthdata[$id+1]['centreY'] - $pthdata[$id]['centreY'])/65536,2);
				$dz2 = pow(($pthdata[$id+1]['centreZ'] - $pthdata[$id]['centreZ'])/65536,2);
				$ds += sqrt($dx2 + $dy2 + $dz2);
			}
			else {
				$dx2 = pow(($pthdata[0]['centreX'] - $pthdata[$id]['centreX'])/65536,2);
				$dy2 = pow(($pthdata[0]['centreY'] - $pthdata[$id]['centreY'])/65536,2);
				$dz2 = pow(($pthdata[0]['centreZ'] - $pthdata[$id]['centreZ'])/65536,2);
				$ds += sqrt($dx2 + $dy2 + $dz2);
			}
			### ideal line ###
			$points .= getX($point['centreX']).",".getY($point['centreY'])." ";
		### road ###
			$points_leftDrive[] = getOuterX($point['centreX'],$point['driveLeft'],getDir($point['dirX'],$point['dirY'])).",".getOuterY($point['centreY'],$point['driveLeft'],getDir($point['dirX'],$point['dirY']))." ";
			$points_rightDrive[] = getOuterX($point['centreX'],$point['driveRight'],getDir($point['dirX'],$point['dirY'])).",".getOuterY($point['centreY'],$point['driveRight'],getDir($point['dirX'],$point['dirY']))." ";
			### drive ###
			$points_leftLimit[] = getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY'])).",".getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))." ";
			$points_rightLimit[] = getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY'])).",".getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))." ";

			### adjust track size ###
			if(getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))>getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) {
				if($maxx<getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))) $maxx = getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']));
				if($minx>getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) $minx = getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']));
			}
			elseif(getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))<getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) {
				if($maxx<getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) $maxx = getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']));
				if($minx>getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))) $minx = getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']));
			}
			if(getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))>getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) {
				if($maxy<getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))) $maxy = getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']));
				if($miny>getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) $miny = getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']));
			}
			elseif(getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))<getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) {
				if($maxy<getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) $maxy = getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']));
				if($miny>getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))) $miny = getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']));
			}
		}

		### merge left and right limits ###
		array_push($points_leftDrive,$points_leftDrive[0]);
		array_push($points_rightDrive,$points_rightDrive[0]);
		foreach($points_leftDrive as $id=>$left) {
			$points_drive .= $left;
		}
		foreach($points_rightDrive as $id=>$right) {
			$points_drive .= $points_rightDrive[count($points_rightDrive)-$id-1];
		}
		$points_drive = trim($points_drive);

		array_push($points_leftLimit,$points_leftLimit[0]);
		array_push($points_rightLimit,$points_rightLimit[0]);

		foreach($points_leftLimit as $id=>$left) {
			$points_limit .= $left;
		}
		foreach($points_rightLimit as $id=>$right) {
			$points_limit .= $points_rightLimit[count($points_rightLimit)-$id-1];
		}
		$points_limit = trim($points_limit);

		$points =  trim($points);

		### calculate arrow ###
		if(abs($pthdata[$pthheader['finishline']]['limitLeft'])>abs($pthdata[$pthheader['finishline']]['limitRight'])) {
			if($pthdata[$pthheader['finishline']]['limitLeft']>=0) {
				$sideoffset = ($pthdata[$pthheader['finishline']]['limitLeft']>=30) ? $pthdata[$pthheader['finishline']]['limitLeft'] : 30;
			}
			else {
				$sideoffset = ($pthdata[$pthheader['finishline']]['limitLeft']<=-30) ? $pthdata[$pthheader['finishline']]['limitLeft'] : -30;
			}
			$otheroffset =$pthdata[$pthheader['finishline']]['limitRight'];
		}else {
			if($pthdata[$pthheader['finishline']]['limitRight']>=0) {
				$sideoffset = ($pthdata[$pthheader['finishline']]['limitRight']>=30) ? $pthdata[$pthheader['finishline']]['limitRight'] : 30;
			}
			else {
				$sideoffset = ($pthdata[$pthheader['finishline']]['limitRight']<=-30) ? $pthdata[$pthheader['finishline']]['limitRight'] : -30;
			}
			$otheroffset =$pthdata[$pthheader['finishline']]['limitLeft'];
		}

		if(strlen($track)>=4 && (substr(strtoupper($track),-1)=='X' || substr(strtoupper($track),-1)=='Y')) {
		### draw road ###
		$trackimage .= '	<polygon fill="black" stroke="black" stroke-width="1" points="'.$points_drive.'" />
		';
		$trackimage .= '	<polygon fill="black" stroke="black" stroke-width="2" points="'.$points_leftDrive[0].' '.$points_rightDrive[0].'" />
		';
		}
		else{
		### draw drive ###
		$trackimage .= '	<polygon fill="grey" stroke="white" stroke-width="1" points="'.$points_limit.'" />
		';
		$trackimage .= '	<polygon fill="grey" stroke="grey" stroke-width="2" points="'.$points_leftLimit[0].' '.$points_rightLimit[0].'" />';
		### draw road ###
		$trackimage .= '	<polygon fill="black" stroke="red" stroke-width="1" points="'.$points_drive.'" />
		';
		$trackimage .= '	<polygon fill="black" stroke="black" stroke-width="2" points="'.$points_leftDrive[0].' '.$points_rightDrive[0].'" />';
		### draw ideal line ###
		$trackimage .= '	<polygon fill="none" stroke="green" stroke-width="3" points="'.$points.'" />
		';
		}

		### draw finish-line ###
		$finline = getOuterX($pthdata[$pthheader['finishline']]['centreX'],$pthdata[$pthheader['finishline']]['limitRight'],0).","
		.getOuterY($pthdata[$pthheader['finishline']]['centreY'],$pthdata[$pthheader['finishline']]['limitRight'],0)." "
		.getOuterX($pthdata[$pthheader['finishline']]['centreX'],$pthdata[$pthheader['finishline']]['limitLeft'],0).","
		.getOuterY($pthdata[$pthheader['finishline']]['centreY'],$pthdata[$pthheader['finishline']]['limitLeft'],0)." "
		.getOuterX($pthdata[$pthheader['finishline']]['centreX'],$pthdata[$pthheader['finishline']]['limitLeft'],0).","
		.myadd(getOuterY($pthdata[$pthheader['finishline']]['centreY'],$pthdata[$pthheader['finishline']]['limitLeft'],0),22)." "
		.getOuterX($pthdata[$pthheader['finishline']]['centreX'],$pthdata[$pthheader['finishline']]['limitRight'],0).","
		.myadd(getOuterY($pthdata[$pthheader['finishline']]['centreY'],$pthdata[$pthheader['finishline']]['limitRight'],0),22)
		;
		$footer .= '<polygon fill="url(#chequ)" stroke="black" stroke-width="0" points="'.$finline.'" transform="rotate('.getDir2($pthdata[$pthheader['finishline']]['dirX'],$pthdata[$pthheader['finishline']]['dirY']).','.getX($pthdata[$pthheader['finishline']]['centreX']).','.getY($pthdata[$pthheader['finishline']]['centreY']).')" />';

		### draw arrow ###
		$footer .= '	<polygon fill="green" stroke="green" stroke-width="1" points="'.
		getArrow($pthdata[$pthheader['finishline']]['centreX'],$pthdata[$pthheader['finishline']]['centreY'],$sideoffset,getDir($pthdata[$pthheader['finishline']]['dirX'],$pthdata[$pthheader['finishline']]['dirY']))
		.'" />';

		### end SVG ###
		$footer .= '
</svg>';
	}
}

### put it all together ###
$h = $maxy - $miny;
$w = $maxx - $minx;
$diff = abs(($h-$w)/2);
if($h>=$w) {
	$leftborder = mysub(mysub($minx,$h/10),$diff);
	$topborder  = $miny-($h/10);
	$width = $w + 2*$h/10 + (2*$diff);
	$height = $h + 2*$h/10;
	$viewbox = $leftborder.' '.$topborder.' '.$width.' '.$height;
}
else {
	$leftborder = mysub($minx,$w/10);
	$topborder  = mysub(mysub($miny,$w/10),$diff);
	$width = $w + 2*$w/10;
	$height = $h + 2*$w/10 + (2*$diff);
	$viewbox = $leftborder.' '.$topborder.' '.$width.' '.$height;
}

foreach($trackarray as $long => $data) {
	if($data['short']==strtoupper(substr($track,0,2))) {
		$trackname = $data[$track{2}]['name'];
		break;
	}
}
if((strlen($track)==4 && strtoupper($track{3})!='R') || (strlen($track)==5 && strtoupper($track{4})!='R')) $trackname .= ' Rev.';
elseif((strlen($track)==4 && strtoupper($track{3})!='X' && strtoupper($track{3})!='Y') || (strlen($track)==5 && strtoupper($track{4})!='X' && strtoupper($track{4})!='Y')) $trackname .= ' open';

### start SVG ###
$header = '<?xml version="1.0" encoding="UTF-8"?>
<svg xmlns="http://www.w3.org/2000/svg"
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:ev="http://www.w3.org/2001/xml-events"
	version="1.1" baseProfile="full"
	width="'.$desired_size.'px" height="'.$desired_size.'px" viewBox="'.$viewbox.'">
';
### description ###
$header .= '	<desc>'.strtoupper($track).'</desc>
';
### border ###
$header .= '	<rect x="'.$leftborder.'" y="'.$topborder.'" width="'.$width.'" height="'.$height.'" fill="#b3b3b3" stroke="#b3b3b3" stroke-width="2" />
';
$header .= '	<text x="'.$leftborder.'" y="'.myadd(myadd($topborder,25),mydiv($width,13)).'" font-family="sans-serif" font-size="'.mydiv($width,10).'" fill="black" >'.strtoupper($track).'</text>
';
$header .= '	<text x="'.mysub(myadd($leftborder,$width),10).'" y="'.mysub(myadd($topborder,$height),mydiv($height,50)).'" text-anchor="end" font-family="sans-serif" font-size="'.mydiv($width,10).'" fill="black" >'.$trackname.'</text>
';
if(strtoupper($track{3})!='X' && strtoupper($track{3})!='Y') $header .= '	<text x="'.mysub(myadd($leftborder,$width),10).'" y="'.myadd(myadd($topborder,25),mydiv($width,16)).'" text-anchor="end" font-family="sans-serif" font-size="'.mydiv($width,12).'" fill="black" >'.round($ds*$km2mifactor/1000,3).' '.$distunit.'</text>
';
$header .= '	<text x="'.mysub(myadd($leftborder,$width),10).'" y="'.myadd(myadd(myadd($topborder,25),mydiv($width,16)),mydiv($width,15)).'" text-anchor="end" font-family="sans-serif" font-size="'.mydiv($width,15).'" fill="black" >'.strtoupper($v).'</text>
';
### define chequered flag ###
$header .= '	<pattern id="chequ" patternUnits="userSpaceOnUse" width="10" height="10"  x="0" y="0">
		<rect x="0" y="0" width="5" height="5" fill="black" />
		<rect x="5" y="0" width="5" height="5" fill="white" />
		<rect x="0" y="5" width="5" height="5" fill="white" />
		<rect x="5" y="5" width="5" height="5" fill="black" />
	</pattern>
';


if($getlink===true) {
	$header .= '
<a target="_blank" xlink:href="'.SCRIPTURL.'images/tracks/'.$track.'_'.$v.'_'.$distunit.$all.'_1000.svg">
	<rect x="0" y="0" width="'.$width.'" height="'.$height.'" fill-opacity="0" />
</a>';
}

	file_put_contents($trackfile,$header.$body.$trackimage.$footer);
}
### begin output ###
header("Content-type: image/svg+xml; charset=utf-8");
?>
<?php
echo file_get_contents($trackfile);
?>