<?php
#################################################################
# mpres trackimage_png.php V2.05																#
# produces track image in png format														#
# directory: script main path																		#
#################################################################
define('NORMAL_ACCESS', null);
error_reporting(E_ERROR | E_WARNING | E_PARSE);
### define paths of this script ###
define('DS', DIRECTORY_SEPARATOR);
define('SCRIPTPATH', dirname(realpath(__FILE__)).DS);
define('SCRIPTURL', 'http://'.$_SERVER['SERVER_NAME'].pathinfo($_SERVER['PHP_SELF'], PATHINFO_DIRNAME).'/');
define('IMGTYPE', 'png');

require_once(SCRIPTPATH."config.inc.php");
require_once(SCRIPTPATH.'includes/functions.php');
require_once(SCRIPTPATH."includes/definitions.php");

$unifont = SCRIPTPATH.'fonts/'.$unifont;
### choose language for output ###
# check if user has set a language cookie or has selected a language manually instead
if(isset($_GET['lang']) && in_array($_GET['lang'], $vlangs)) $ulang = $_GET['lang'];
elseif(isset($_COOKIE['lang']) && in_array($_COOKIE['lang'], $vlangs)) $ulang = $_COOKIE['lang'];
else $ulang = null;
# load language variables
$lang = getlanguage(OUTLANG, $_SERVER['HTTP_ACCEPT_LANGUAGE'], $ulang);

### set factor for miles - km conversion ###
$distunit = (DISTUNIT=='km' || DISTUNIT=='mi') ? DISTUNIT : 'km';
$distunit = ($_GET['dunit']=='km' || $_GET['dunit']=='mi') ? $_GET['dunit'] : $distunit;
$km2mifactor = ($distunit=='km') ? 1 : KM_2_MI;

### get parameters ###
$desired_size = (!empty($_GET['size'])&& is_numeric($_GET['size'])) ? intval($_GET['size']) : 100;
$showall = (!empty($_GET['showall']) && $_GET['showall']=='_all') ? 1 : 0;
$all = (!empty($_GET['showall']) && $_GET['showall']=='_all') ? '_all' : '';
$getlink = ($_GET['link']==1) ? true : false;


### get pth version to handle ###
$v = (!empty($_GET['ver'])) ? $_GET['ver'] : null;

if(floatval(substr($v,0,3)) < 0.6) $trackarray = $AllTracks;
elseif(floatval(substr($v,0,3)) == 0.6 && ord($v{3}) < 71) $trackarray = $AllTracks;
elseif(floatval(substr($v,0,3)) == 0.6 && ord($v{3}) == 71 && (strlen($v) < 5 || intval(substr($v,4)) < 14)) $trackarray = $AllTracks;
else $trackarray = $AllTracksNewWE;

$pthdir ='pth/';
$pthlen = strlen($pthdir);
$pthvers = glob($pthdir.'*', GLOB_ONLYDIR);
rsort($pthvers, SORT_STRING);
$actpth = (in_array($pthdir.$v,$pthvers)) ? $pthdir.$v.'/' : null;
if(!$actpth) {
	foreach($pthvers as $ver) {
		if(floatval(substr($ver,$pthlen,3))<floatval(substr($v,0,3))) {
			$actpth = $ver.'/';
			break;
		}
		elseif(floatval(substr($ver,$pthlen,3))>floatval(substr($v,0,3))) continue;
		elseif(ord($ver{3+$pthlen})>ord($v{3})) continue;
		elseif(ord($ver{3+$pthlen})==ord($v{3}) && intval(substr($ver,4+$pthlen))>intval(substr($v,4))) continue;
		else {
			$actpth = $ver.'/';
			break;
		}
	}
}
if(!empty($_GET['track']) && strtoupper(substr($_GET['track'],-1))=='X' && (strlen($_GET['track'])==4 || (strlen($_GET['track'])==5 && is_numeric($_GET['track']{4})))) {
	$track = (file_exists($actpth.strtoupper(substr($_GET['track'],0,-1)).".pth")) ? strtoupper($_GET['track']) : die($lang['errors']['invalidtrack']);
}
elseif(!empty($_GET['track']) && (strtoupper(substr($_GET['track'],-1))=='Y' || strtoupper(substr($_GET['track'],-1))=='R') && (strlen($_GET['track'])==4 || (strlen($_GET['track'])==5 && is_numeric($_GET['track']{4})))) {
	$track = (file_exists($actpth.strtoupper(substr($_GET['track'],0,-1))."R.pth")) ? strtoupper($_GET['track']) : die($lang['errors']['invalidtrack']);
}
else	$track = (!empty($_GET['track']) && file_exists($actpth.strtoupper($_GET['track']).".pth")) ? strtoupper($_GET['track']) : die($lang['errors']['invalidtrack']);

$tracks = glob($actpth.strtoupper(substr($track,0,2))."*.pth");
if(empty($tracks)) die ($lang['errors']['invalidtrack']);

$trackfile = './images/rendered/track/'.$track.'_'.$_GET['ver'].'_'.$distunit.$all.'_'.$desired_size.'.png';

### If file isn't already rendered, do so ###
if(!is_file($trackfile)) {
	### set initial parameters ###
	$minx = $miny = 2560;
	$maxx = $maxy = 0;

	### create blank image ###
	$im = imagecreate($minx, $miny)
	or die ("ERROR!");
	
	### define some colors ###
	$background_color = imagecolorallocate ($im, 180, 180, 180);
	$white = imagecolorallocate($im, 255, 255, 255);
	$lightgrey = imagecolorallocate($im, 230, 230, 230);
	$darkgrey = imagecolorallocate($im, 128, 128, 128);
	$black = imagecolorallocate($im, 0, 0, 0);
	$red = imagecolorallocate($im, 255, 0, 0);
	$darkred = imagecolorallocate($im, 128, 0, 0);
	$green = imagecolorallocate($im, 0, 255, 0);
	$darkgreen = imagecolorallocate($im, 0, 128, 0);
	$blue = imagecolorallocate($im, 0, 0, 255);
	$darkblue = imagecolorallocate($im, 0, 0, 128);

### read all files for the selected track if they are to be shown ###
foreach ($tracks as $filename) {
	### Alternative Strecken ausgeben (nur Strecke) ###
	$fname = basename($filename,".pth");
	if($fname!=strtoupper($track) && (strlen($fname)==3 || (strlen($fname)==4 && is_numeric($fname{3}))) && ($showall==1 || substr(strtoupper($track),-1)=='X' || substr(strtoupper($track),-1)=='Y')) {
		### unset points ###
		unset($points_leftDrive);
		unset($points_rightDrive);
		unset($points_drive);
		unset($points);
		unset($pthdata);

		### read pth ###
		$handle = fopen ($filename, "rb");
		$filesize = filesize ($filename);
		$contents = fread ($handle,$filesize);
		fclose ($handle);

		### parse file ###
		$os = 0;
		$i = 0;
		$string ='';
		while($i<16) {
		  $string .= $contents{$os+$i};
		  $i++;
		}
		$pthheader  = unpack("@0/a6LFSPTH/Cversion/Crevision/Lnumnodes/Lfinishline",$string);
		$os = 16;
		$n=0;
		while ($n<$pthheader['numnodes']) {
			$i = 0;
			$string ='';
			while($i<40) {
			  $string .= $contents{$os+$i};
			  $i++;
			}
			$pthdata[$n]  = unpack("@0/icentreX/icentreY/icentreZ/fdirX/fdirY/fdirZ/flimitLeft/flimitRight/fdriveLeft/fdriveRight",$string);
			$os += 40;
			$n++;
		}

### set thickness ###
imagesetthickness  ($im  , 1);


		### hand points to arrays ###
		foreach($pthdata as $id => $point) {
			### road ###
			$points_leftDrive[] = getOuterX($point['centreX'],$point['driveLeft'],getDir($point['dirX'],$point['dirY']));
			$points_leftDrive[] = getOuterY($point['centreY'],$point['driveLeft'],getDir($point['dirX'],$point['dirY']));
			$points_rightDrive[] = getOuterX($point['centreX'],$point['driveRight'],getDir($point['dirX'],$point['dirY']));
			$points_rightDrive[] = getOuterY($point['centreY'],$point['driveRight'],getDir($point['dirX'],$point['dirY']));
		
			### adjust track size ###
			if(getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))>getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) {
				if($maxx<getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))) $maxx = getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']));
				if($minx>getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) $minx = getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']));
			}
			elseif(getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))<getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) {
				if($maxx<getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) $maxx = getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']));
				if($minx>getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))) $minx = getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']));
			}
			if(getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))>getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) {
				if($maxy<getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))) $maxy = getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']));
				if($miny>getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) $miny = getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']));
			}
			elseif(getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))<getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) {
				if($maxy<getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) $maxy = getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']));
				if($miny>getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))) $miny = getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']));
			}
		}

		### merge left and right limits ###
		array_push($points_leftDrive,$points_leftDrive[0]);
		array_push($points_leftDrive,$points_leftDrive[1]);
		array_push($points_rightDrive,$points_rightDrive[0]);
		array_push($points_rightDrive,$points_rightDrive[1]);
		$points_drive = array_merge($points_leftDrive,$points_rightDrive);

		### draw track ###
		if(substr(strtoupper($track),-1)=='X' || substr(strtoupper($track),-1)=='Y') {
		imagefilledpolygon  ($im,$points_drive,count($points_drive)/2,$black);
		imagepolygon  ($im,$points_leftDrive,count($points_leftDrive)/2,$black);
		imagepolygon  ($im,$points_rightDrive,count($points_rightDrive)/2,$black);
		}
		else {
		imagefilledpolygon  ($im,$points_drive,count($points_drive)/2,$lightgrey);
		imagepolygon  ($im,$points_leftDrive,count($points_leftDrive)/2,$darkgrey);
		imagepolygon  ($im,$points_rightDrive,count($points_rightDrive)/2,$darkgrey);
		}
	}
}

### get the "real" track" ###
if(!empty($track) && (strlen($track)==3 || (strlen($track)>=4 && substr(strtoupper($track),-1)=='X'))) $filename = $actpth.substr(strtoupper($track),0,3).".pth";
elseif(!empty($track) && (strlen($track)==4 && (substr(strtoupper($track),-1)=='R' || substr(strtoupper($track),-1)=='Y'))) $filename = $actpth.substr(strtoupper($track),0,-1)."R.pth";
		### unset points ###
		unset($points_leftDrive);
		unset($points_rightDrive);
		unset($points_leftLimit);
		unset($points_rightLimit);
		unset($points_drive);
		unset($points_limit);
		unset($points);
		unset($pthdata);
		unset($ds);
		unset($dsmi);

		### read file ###
		$handle = fopen ($filename, "rb");
		$filesize = filesize ($filename);
		$contents = fread ($handle,$filesize);
		fclose ($handle);

		### parse file ###
		$os = 0;
		$i = 0;
		$string ='';
		while($i<16) {
		  $string .= $contents{$os+$i};
		  $i++;
		}
		$pthheader  = unpack("@0/a6LFSPTH/Cversion/Crevision/Lnumnodes/Lfinishline",$string);
		$os = 16;
		$n=0;
		while ($n<$pthheader['numnodes']) {
			$i = 0;
			$string ='';
			while($i<40) {
			  $string .= $contents{$os+$i};
			  $i++;
			}
			$pthdata[$n]  = unpack("@0/icentreX/icentreY/icentreZ/fdirX/fdirY/fdirZ/flimitLeft/flimitRight/fdriveLeft/fdriveRight",$string);
			$os += 40;
			$n++;
		}

### set thickness ###
imagesetthickness  ($im  , 1);

		$ds=0; # tracklength
		### hand points to arrays ###
		foreach($pthdata as $id => $point) {
			### get track length ###
			if(isset($pthdata[$id+1])) {
				$dx2 = pow(($pthdata[$id+1]['centreX'] - $pthdata[$id]['centreX'])/65536,2);
				$dy2 = pow(($pthdata[$id+1]['centreY'] - $pthdata[$id]['centreY'])/65536,2);
				$dz2 = pow(($pthdata[$id+1]['centreZ'] - $pthdata[$id]['centreZ'])/65536,2);
				$ds += sqrt($dx2 + $dy2 + $dz2);
			}
			else {
				$dx2 = pow(($pthdata[0]['centreX'] - $pthdata[$id]['centreX'])/65536,2);
				$dy2 = pow(($pthdata[0]['centreY'] - $pthdata[$id]['centreY'])/65536,2);
				$dz2 = pow(($pthdata[0][centreZ] - $pthdata[$id]['centreZ'])/65536,2);
				$ds += sqrt($dx2 + $dy2 + $dz2);
			}
			### ideal line ###
			$points[] = getX($point['centreX']);
			$points[] = getY($point['centreY']);
			### road ###
			$points_leftDrive[] = getOuterX($point['centreX'],$point['driveLeft'],getDir($point['dirX'],$point['dirY']));
			$points_leftDrive[] = getOuterY($point['centreY'],$point['driveLeft'],getDir($point['dirX'],$point['dirY']));
			$points_rightDrive[] = getOuterX($point['centreX'],$point['driveRight'],getDir($point['dirX'],$point['dirY']));
			$points_rightDrive[] = getOuterY($point['centreY'],$point['driveRight'],getDir($point['dirX'],$point['dirY']));
			### drive ###
			$points_leftLimit[] = getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']));
			$points_leftLimit[] = getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']));
			$points_rightLimit[] = getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']));
			$points_rightLimit[] = getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirX'],$point['dirY']));


			### adjust track size ###
			if(getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))>getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) {
				if($maxx<getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))) $maxx = getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']));
				if($minx>getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) $minx = getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']));
			}
			elseif(getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))<getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) {
				if($maxx<getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']))) $maxx = getOuterX($point['centreX'],$point['limitRight'],getDir($point['dirX'],$point['dirY']));
				if($minx>getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']))) $minx = getOuterX($point['centreX'],$point['limitLeft'],getDir($point['dirX'],$point['dirY']));
			}
			if(getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))>getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) {
				if($maxy<getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))) $maxy = getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']));
				if($miny>getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) $miny = getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']));
			}
			elseif(getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))<getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) {
				if($maxy<getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']))) $maxy = getOuterY($point['centreY'],$point['limitRight'],getDir($point['dirY'],$point['dirY']));
				if($miny>getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']))) $miny = getOuterY($point['centreY'],$point['limitLeft'],getDir($point['dirY'],$point['dirY']));
			}
		}

		### merge left and right limits ###
		array_push($points_leftDrive,$points_leftDrive[0]);
		array_push($points_leftDrive,$points_leftDrive[1]);
		array_push($points_rightDrive,$points_rightDrive[0]);
		array_push($points_rightDrive,$points_rightDrive[1]);
		
		array_push($points_leftLimit,$points_leftLimit[0]);
		array_push($points_leftLimit,$points_leftLimit[1]);
		array_push($points_rightLimit,$points_rightLimit[0]);
		array_push($points_rightLimit,$points_rightLimit[1]);
		
		$points_drive = array_merge($points_leftDrive,$points_rightDrive);
		$points_limit = array_merge($points_leftLimit,$points_rightLimit);

		imagesetthickness  ($im  , 2);
		if(substr(strtoupper($track),-1)=='X' || substr(strtoupper($track),-1)=='Y') {
		### draw road ###
		imagefilledpolygon  ($im,$points_drive,count($points_drive)/2,$black);
		imagepolygon  ($im,$points_leftDrive,count($points_leftDrive)/2,$black);
		imagepolygon  ($im,$points_rightDrive,count($points_rightDrive)/2,$black);
		}
		else {
		### draw drive ###
		imagefilledpolygon  ($im,$points_limit,count($points_limit)/2,$darkgrey);
		imagepolygon  ($im,$points_leftLimit,count($points_leftLimit)/2,$white);
		imagepolygon  ($im,$points_rightLimit,count($points_rightLimit)/2,$white);
		### draw road ###
		imagefilledpolygon  ($im,$points_drive,count($points_drive)/2,$black);
		imagepolygon  ($im,$points_leftDrive,count($points_leftDrive)/2,$darkred);
		imagepolygon  ($im,$points_rightDrive,count($points_rightDrive)/2,$darkred);
		### draw ideal line ###
		imagesetthickness  ($im  , 3);
		imagepolygon  ($im,$points,count($points)/2,$darkgreen);
		}

		### calculate arrow ###
		if(abs($pthdata[$pthheader['finishline']]['limitLeft'])>abs($pthdata[$pthheader['finishline']]['limitRight'])) {
			if($pthdata[$pthheader['finishline']]['limitLeft']>=0) {
				$sideoffset = ($pthdata[$pthheader['finishline']]['limitLeft']>=30) ? $pthdata[$pthheader['finishline']]['limitLeft'] : 30;
			}
			else {
				$sideoffset = ($pthdata[$pthheader['finishline']]['limitLeft']<=-30) ? $pthdata[$pthheader['finishline']]['limitLeft'] : -30;
			}
		}else {
			if($pthdata[$pthheader['finishline']]['limitRight']>=0) {
				$sideoffset = ($pthdata[$pthheader['finishline']]['limitRight']>=30) ? $pthdata[$pthheader['finishline']]['limitRight'] : 30;
			}
			else {
				$sideoffset = ($pthdata[$pthheader['finishline']]['limitRight']<=-30) ? $pthdata[$pthheader['finishline']]['limitRight'] : -30;
			}
		}

		### draw finish-line ###
		imagesetthickness  ($im  , 5);
		if(abs($pthdata[$pthheader['finishline']]['limitLeft'])>abs($pthdata[$pthheader['finishline']]['limitRight'])) {
			imageline($im  , getOuterX($pthdata[$pthheader['finishline']]['centreX'],$pthdata[$pthheader['finishline']]['limitRight'],getDir($pthdata[$pthheader['finishline']]['dirX'],$pthdata[$pthheader['finishline']]['dirY'])), getOuterY($pthdata[$pthheader['finishline']]['centreY'],$pthdata[$pthheader['finishline']]['limitRight'],getDir($pthdata[$pthheader['finishline']]['dirX'],$pthdata[$pthheader['finishline']]['dirY'])), getOuterX($pthdata[$pthheader['finishline']]['centreX'],$sideoffset,getDir($pthdata[$pthheader['finishline']]['dirX'],$pthdata[$pthheader['finishline']]['dirY'])), getOuterY($pthdata[$pthheader['finishline']]['centreY'],$sideoffset,getDir($pthdata[$pthheader['finishline']]['dirX'],$pthdata[$pthheader['finishline']]['dirY'])), $darkgreen);
		}
		
		if(abs($pthdata[$pthheader['finishline']]['limitLeft'])<abs($pthdata[$pthheader['finishline']]['limitRight'])) {
			imageline($im  , getOuterX($pthdata[$pthheader['finishline']]['centreX'],$sideoffset,getDir($pthdata[$pthheader['finishline']]['dirX'],$pthdata[$pthheader['finishline']]['dirY'])), getOuterY($pthdata[$pthheader['finishline']]['centreY'],$sideoffset,getDir($pthdata[$pthheader['finishline']]['dirX'],$pthdata[$pthheader['finishline']]['dirY'])), getOuterX($pthdata[$pthheader['finishline']]['centreX'],$pthdata[$pthheader['finishline']]['limitLeft'],getDir($pthdata[$pthheader['finishline']]['dirX'],$pthdata[$pthheader['finishline']]['dirY'])), getOuterY($pthdata[$pthheader['finishline']]['centreY'],$pthdata[$pthheader['finishline']]['limitLeft'],getDir($pthdata[$pthheader['finishline']]['dirX'],$pthdata[$pthheader['finishline']]['dirY'])), $darkgreen);
		}
		
		### draw arrow ###
		imagefilledpolygon  ($im,getArrow($pthdata[$pthheader['finishline']]['centreX'],$pthdata[$pthheader['finishline']]['centreY'],$sideoffset,getDir($pthdata[$pthheader['finishline']]['dirX'],$pthdata[$pthheader['finishline']]['dirY'])),3,$darkgreen);


### now print it all ###
$dst_im = imagecreatetruecolor($desired_size, $desired_size);
$fsize= ceil(7/120*$desired_size);
$fpad= ceil(2/120*$desired_size);

$background_color = imagecolorallocate ($dst_im, 180, 180, 180);
imagefill($dst_im, 0, 0, $background_color);
$bbox = imagettfbbox($fsize, 0, $unifont, $track);
$trackwidth = $bbox[2]-$bbox[0];
$trackheight = $bbox[1]-$bbox[7];
$dist = round($ds*$km2mifactor/1000,3).' '.$distunit;
$bbox = imagettfbbox($fsize, 0, $unifont, $dist);
$distwidth = $bbox[2]-$bbox[0];
$distheight = $bbox[1]-$bbox[7];
$bbox = imagettfbbox(mymul($fsize,0.75), 0, $unifont, strtoupper($v));
$vwidth = $bbox[2]-$bbox[0];
$vheight = $bbox[1]-$bbox[7];
foreach($trackarray as $long => $data) {
	if($data['short']==substr($track,0,2)) {
		$trackname = $data[$track{2}]['name'];
		$longname = $long;
		break;
	}
}
if(strlen($track)==4 && strtoupper($track{3})=='R') $trackname .= ' Rev.';
elseif(strlen($track)==4 && (strtoupper($track{3})=='X' || strtoupper($track{3})=='Y')) $trackname .= ' open';
$bbox = imagettfbbox($fsize, 0, $unifont, $trackname);
$namewidth = $bbox[2]-$bbox[0];
$nameheight = $bbox[1]-$bbox[7];
$bbox = imagettfbbox($fsize, 0, $unifont, $longname);
$longwidth = $bbox[2]-$bbox[0];
$longheight = $bbox[1]-$bbox[7];
$gap = ($longheight>$distheight) ? $longheight : $distheight;
$gap2 = ($trackheight>$nameheight) ? $trackheight : $nameheight;
$dh = $desired_size-$gap-$gap2;
$xyr = ($maxx-$minx)/($maxy-$miny);
$dxy = (($maxx-$minx)>($maxy-$miny)) ? ($maxx-$minx) : ($maxy-$miny);
$dx = ($desired_size/2)-(($dh*$xyr)/2);
imagecopyresampled  ($dst_im, $im, $dx, $gap, $minx-15, $miny-15, $dh, $dh, $dxy+30, $dxy+30);
imagettftext($dst_im, $fsize, 0, $fpad, $fsize+$fpad, $black, $unifont, $longname);
if((strlen($track)==4 && strtoupper($track{3})!='X' && strtoupper($track{3})!='Y') || (strlen($track)==5 && strtoupper($track{4})!='X' && strtoupper($track{4})!='Y')) imagettftext($dst_im, $fsize, 0,$desired_size-$distwidth-$fpad, $distheight+$fpad, $black, $unifont, $dist);
imagettftext($dst_im, mymul($fsize,0.75), 0,$desired_size-$vwidth-$fpad, $distheight+$fpad+$fsize, $black, $unifont, strtoupper($v));
imagettftext($dst_im, $fsize, 0, $fpad, $desired_size-$fpad, $black, $unifont, strtoupper($_GET['track']));
imagettftext($dst_im, $fsize, 0, $desired_size-$namewidth-$fpad, $desired_size-$fpad, $black, $unifont, $trackname);
imagepng($dst_im, $trackfile);
imagedestroy($im);
}
### display image ###
header("Content-type: image/png");
echo file_get_contents($trackfile);
?>