<?php
#################################################################
# mpres bodydata.php V2.05																			#
# parses the race part of the replay														#
# directory: /includes/readmpr																	#
#################################################################
if (!defined('NORMAL_ACCESS')) {header("HTTP/1.1 404 File Not Found");echo "<h1>404 File Not Found</h1>";exit;}

$race_finished = false;
$maxlapsdone = 0;
$go = true;

### go through timeframes and trigger events ###
while(!feof($handle) && $go===true) {
	### get timeframe-ID and type ###
	$tf = unpack("@0/vid/Ctype",fread($handle,3));
	if($tf['id']<$lasttf) $tfcycle++;
	$lasttf = $tf['id'];
	$tf['id'] = $tfcycle*65535+$lasttf;
	if($racetype==RACETYPE_QUAL && $tf['id']>=$duration+$racedata['racedelay']*100) $race_finished = true;


	### last timeframe -> replay ends ###
	if($tf['type']==FP_REPLAYEND) {
		fseek($handle, 1, SEEK_CUR);
		$go = false;
	}
	### tf regarding car position and controller input(?) --> skip it ###
	elseif($tf['type']==FP_STATEFRAME) {
		fseek($handle, 69, SEEK_CUR);
	}
	### tf containing chat messages --> skip them ###
	elseif($tf['type']==FP_MSGFRAME) {
		$tfdata = unpack("@0/Cconnid/vlength",fread($handle,3));
		fseek($handle, $tfdata['length'], SEEK_CUR);
	}
	### here's the interesting part ###
	elseif($tf['type']==FP_EVENTFRAME) {
		### get subframes and their  types ###
		$tfdata = unpack("@0/Cconnid/vlength",fread($handle,3));
		$j=0;
		while($j<$tfdata['length']) {
			$sf = unpack("@0/Clength/Ctype",fread($handle,2));
			$j += $sf['length']+1;
			if(!array_key_exists($sf['type'],$framepackets) || $sf['type'] == FP_LAYOUT) {
				fseek($handle, $sf['length']-1, SEEK_CUR);
				continue;
			}
			$data = fread($handle,$sf['length']-1);
			$sfdata = unpack($framepackets[$sf['type']],$data);
			### on subframe types: do what you ought to do ... ###
			switch($sf['type']) {
				case FP_CARSTATUS:	#car status
					$stint = $stintplayers[$cars[$sfdata['carid']]];
					if($stints[$stint]['unallTOC']!==true) {
						if($stints[$stint]['engine'] && $stints[$stint]['engine']>$sfdata['engine']) $stints[$stint]['engdamage'][$stints[$stint]['lapsdone']+1] .= myadd($stints[$stint]['lastsplit'],1).round($sfdata['engine']*(100/255),1).'#';
						if($stints[$stint]['clutch'] && $stints[$stint]['clutch']<$sfdata['clutch']) $stints[$stint]['cludamage'][$stints[$stint]['lapsdone']+1] .= $stints[$stint]['lastsplit']+1;
						if($CarsDrive[array_search($stints[$stint]['carname'], $AllCars)]==DRIVE_FRONT) {
							if(!isset($stints[$stint]['initFront']) || !isset($stints[$stint]['initRear'])) {
								if($sfdata['tRL'] == 2663050) $stints[$stint]['tyreRear'] = 0;
								elseif($sfdata['tRL'] == 4260880) $stints[$stint]['tyreRear'] = 1;
								elseif($sfdata['tRL'] == 5592405) $stints[$stint]['tyreRear'] = 2;
								elseif($sfdata['tRL'] == 6923930) $stints[$stint]['tyreRear'] = 3;
								elseif($sfdata['tRL'] == 1864135) $stints[$stint]['tyreRear'] = 4;
								elseif($sfdata['tRL'] == 1065220) $stints[$stint]['tyreRear'] = 5;
								elseif($sfdata['tRL'] == 0) $stints[$stint]['tyreRear'] = 7;
								if($sfdata['tFL'] == 2663050) $stints[$stint]['tyreFront'] = 0;
								elseif($sfdata['tFL'] == 4260880) $stints[$stint]['tyreFront'] = 1;
								elseif($sfdata['tFL'] == 5592405) $stints[$stint]['tyreFront'] = 2;
								elseif($sfdata['tFL'] == 6923930) $stints[$stint]['tyreFront'] = 3;
								elseif($sfdata['tFL'] == 1864135) $stints[$stint]['tyreFront'] = 4;
								elseif($sfdata['tFL'] == 1065220) $stints[$stint]['tyreFront'] = 5;
								elseif($sfdata['tFL'] == 0) $stints[$stint]['tyreFront'] = 7;
								$stints[$stint]['initFront'] = $stints[$stint]['tyreFront'];
								$stints[$stint]['initRear'] = $stints[$stint]['tyreRear'];
							}
							if($sfdata['tRL'] & 2147483648 && !($stints[$stint]['tbroken'] & 1)) {$stints[$stint]['tbreak'][$stints[$stint]['lapsdone']+1] .= myadd($stints[$stint]['lastsplit'],1).'1'; $stints[$stint]['tbroken'] += 1;}
							if($sfdata['tRR'] & 2147483648 && !($stints[$stint]['tbroken'] & 2)) {$stints[$stint]['tbreak'][$stints[$stint]['lapsdone']+1] .= myadd($stints[$stint]['lastsplit'],1).'2'; $stints[$stint]['tbroken'] += 2;}
							if($sfdata['tFL'] & 2147483648 && !($stints[$stint]['tbroken'] & 4)) {$stints[$stint]['tbreak'][$stints[$stint]['lapsdone']+1] .= myadd($stints[$stint]['lastsplit'],1).'4'; $stints[$stint]['tbroken'] += 4;}
							if($sfdata['tFR'] & 2147483648 && !($stints[$stint]['tbroken'] & 8)) {$stints[$stint]['tbreak'][$stints[$stint]['lapsdone']+1] .= myadd($stints[$stint]['lastsplit'],1).'8'; $stints[$stint]['tbroken'] += 8;}
						}
						elseif($CarsDrive[array_search( $stints[$stint]['carname'],$AllCars)]==DRIVE_REAR || $CarsDrive[array_search( $stints[$stint]['carname'],$AllCars)]==DRIVE_ALL) {
							if(!isset($stints[$stint]['initFront']) || !isset($stints[$stint]['initRear'])) {
								if($sfdata['tFL'] == 2663050) $stints[$stint]['tyreRear'] = 0;
								elseif($sfdata['tFL'] == 4260880) $stints[$stint]['tyreRear'] = 1;
								elseif($sfdata['tFL'] == 5592405) $stints[$stint]['tyreRear'] = 2;
								elseif($sfdata['tFL'] == 6923930) $stints[$stint]['tyreRear'] = 3;
								elseif($sfdata['tFL'] == 1864135) $stints[$stint]['tyreRear'] = 4;
								elseif($sfdata['tFL'] == 1065220) $stints[$stint]['tyreRear'] = 5;
								elseif($sfdata['tFL'] == 0) $stints[$stint]['tyreRear'] = 7;
								if($sfdata['tRL'] == 2663050) $stints[$stint]['tyreFront'] = 0;
								elseif($sfdata['tRL'] == 4260880) $stints[$stint]['tyreFront'] = 1;
								elseif($sfdata['tRL'] == 5592405) $stints[$stint]['tyreFront'] = 2;
								elseif($sfdata['tRL'] == 6923930) $stints[$stint]['tyreFront'] = 3;
								elseif($sfdata['tRL'] == 1864135) $stints[$stint]['tyreFront'] = 4;
								elseif($sfdata['tRL'] == 1065220) $stints[$stint]['tyreFront'] = 5;
								elseif($sfdata['tRL'] == 0) $stints[$stint]['tyreFront'] = 7;
								$stints[$stint]['initFront'] = $stints[$stint]['tyreFront'];
								$stints[$stint]['initRear'] = $stints[$stint]['tyreRear'];
							}
							if($sfdata['tFL'] & 2147483648 && !($stints[$stint]['tbroken'] & 1)) {$stints[$stint]['tbreak'][$stints[$stint]['lapsdone']+1] .= myadd($stints[$stint]['lastsplit'],1).'1'; $stints[$stint]['tbroken'] += 1;}
							if($sfdata['tFR'] & 2147483648 && !($stints[$stint]['tbroken'] & 2)) {$stints[$stint]['tbreak'][$stints[$stint]['lapsdone']+1] .= myadd($stints[$stint]['lastsplit'],1).'2'; $stints[$stint]['tbroken'] += 2;}
							if($sfdata['tRL'] & 2147483648 && !($stints[$stint]['tbroken'] & 4)) {$stints[$stint]['tbreak'][$stints[$stint]['lapsdone']+1] .= myadd($stints[$stint]['lastsplit'],1).'4'; $stints[$stint]['tbroken'] += 4;}
							if($sfdata['tRR'] & 2147483648 && !($stints[$stint]['tbroken'] & 8)) {$stints[$stint]['tbreak'][$stints[$stint]['lapsdone']+1] .= myadd($stints[$stint]['lastsplit'],1).'8'; $stints[$stint]['tbroken'] += 8;}
						}
						$stints[$stint]['engine'] = $sfdata['engine'];
						$stints[$stint]['clutch'] = $sfdata['clutch'];
						if(isset($stints[$stints[$stint]['tocfrom']]['pitstops'][myadd($stints[$stints[$stint]['tocfrom']]['lapsdone'],1)]) && $stints[$stint]['lapsdone']==0) {
							$pst = $stints[$stint]['tocfrom'];
							$ldo = $stints[$stints[$stint]['tocfrom']]['lapsdone']+1;
							if(is_array($stints[$stints[$stint]['tocfrom']]['pitstops'])) $lastpitkey = end(array_keys($stints[$stints[$stint]['tocfrom']]['pitstops']));
							$lastpit = (!empty($lastpitkey)) ? $stints[$stints[$stint]['tocfrom']]['pitstops'][$lastpitkey] : null;
						}
						else {
							$pst = $stint;
							$ldo = $stints[$stint]['lapsdone']+1;
							if(is_array($stints[$stint]['pitstops'])) $lastpitkey = end(array_keys($stints[$stint]['pitstops']));
							$lastpit = (!empty($lastpitkey)) ? $stints[$stint]['pitstops'][$lastpitkey] : null;
						}
						if(isset($lastpit['time']) && ($lastpitkey==$stints[$stint]['lapsdone']+1 || ($lastpitkey==$stints[$stint]['lapsdone'] && $stints[$stint]['lastsplit']==0)) && $stints[$stint]['currfuel'] < round($sfdata['currfuel']/2.55,2)) {
							if($lastpitkey==$stints[$stint]['lapsdone']) $ldo -= 1;
							if(($stints[$pst]['pitstops'][$ldo]['work'] & 131072)==0) $stints[$pst]['pitstops'][$ldo]['work'] += 131072;
							$stints[$pst]['pitstops'][$ldo]['refueled'] = round($sfdata['currfuel']/2.55,2) - $stints[$stint]['currfuel'];
							$stints[$pst]['usedfuel'] += $stints[$stint]['initfuel']-$stints[$stint]['currfuel'];
							$stints[$pst]['initfuel'] = round($sfdata['currfuel']/2.55,2);
							$stints[$pst]['currfuel'] = round($sfdata['currfuel']/2.55,2);
						}
						elseif(!isset($stints[$stint]['currfuel']) || $stints[$stint]['currfuel'] >= round($sfdata['currfuel']/2.55,2)) {
							if(!isset($stints[$stint]['currfuel']))  $stints[$stint]['initfuel'] = round($sfdata['currfuel']/2.55,2);
							$stints[$stint]['currfuel'] = round($sfdata['currfuel']/2.55,2);
						}
					}
					break;
				case FP_RACEJOIN:	#racejoin
					if($race_finished===false && ((($maxleavelaps>1 || $maxleavelaps===1) && $maxlapsdone<$maxleavelaps) || ($racetype==RACETYPE_LAPS && $maxlapsdone<$duration*$maxleavelaps && $maxleavelaps<=1) || ($racetype==RACETYPE_TIME && $tf['id']<$duration*$maxleavelaps && $maxleavelaps<=1) || $racetype==RACETYPE_QUAL)) {
						$sfdata['nick'] = codepage_convert(strtok($sfdata['nick'],"\0"));
						$sfdata['plate'] = codepage_convert(strtok($sfdata['plate'],"\0"));
						$cars[$sfdata['carid']] = ($sfdata['AI']==2 || $sfdata['AI']==3) ? 'AIBOTdummyname'.$sfdata['nick'] : $conns[$sfdata['connid']];
						$players[$cars[$sfdata['carid']]]['nick'] = $sfdata['nick'];
						$players[$cars[$sfdata['carid']]]['plate'] = $sfdata['plate'];
						$players[$cars[$sfdata['carid']]]['connid'] = $sfdata['connid'];
						$players[$cars[$sfdata['carid']]]['pflags'] = $sfdata['pflags'];
						$players[$cars[$sfdata['carid']]]['initfuel'] = $sfdata['initfuel'];
						$players[$cars[$sfdata['carid']]]['pitfuel'] = $sfdata['pitfuel'];
					}
					break;
				case FP_LEAVEPIT:	#leave pits
					if(substr($cars[$sfdata['carid']],0,14)!='AIBOTdummyname') $cars[$sfdata['carid']] = $conns[$tfdata['connid']];
					$sfdata['carname'] = strtok($sfdata['carname'],"\0");
					if($istoc===true && $hasteams===true) {
						unset($tm);
						foreach($teams as $id => $team) {
							if(is_array($teams[$id]['drivers'])){
								if(in_array($cars[$sfdata['carid']],$team['drivers']) && $team['car']==array_search($sfdata['carname'],$AllCars)) {
									$tm = $id;
									break;
								}
								else continue;
							}
						}
						if(empty($tm)) {
							$errors[] = ftell($handle).': '.$lang['errors']['no_playerteam'].' ('.$cars[$sfdata['carid']].'/'.nameblank($players[$cars[$sfdata['carid']]]['nick']).')';
							$go = false;
						}
					}
					else {
						$tm = 't'.$cars[$sfdata['carid']];
						if(!isset($teams[$tm])){
							$teams[$tm]['car'] = array_search($sfdata['carname'],$AllCars);
							$teams[$tm]['drivers'][0] = $cars[$sfdata['carid']];
							$teams[$tm]['name'] = $players[$cars[$sfdata['carid']]]['nick'];
							$teams[$tm]['stints'] = array();
						}
						elseif($teams[$tm]['car']==array_search($sfdata['carname'],$AllCars)){
							$teams[$tm]['name'] = $players[$cars[$sfdata['carid']]]['nick'];
						}
					}
					$players_in_race++;
					if($race_finished===false && ((($maxleavelaps>1 || $maxleavelaps===1) && $maxlapsdone<$maxleavelaps) || ($racetype==RACETYPE_LAPS && $maxlapsdone<$duration*$maxleavelaps && $maxleavelaps<=1) || ($racetype==RACETYPE_TIME && $tf['id']<$duration*$maxleavelaps && $maxleavelaps<=1) || $racetype==RACETYPE_QUAL)) {
						if($tf['id']<=$racedata['racedelay']*100 && !empty($players[$cars[$sfdata['carid']]]['stints']) && $stints[$players[$cars[$sfdata['carid']]]['stints'][0]]['inrace']===true) {
							$stints[$players[$cars[$sfdata['carid']]]['stints'][0]]['carid'] = $sfdata['carid'];
							$stints[$players[$cars[$sfdata['carid']]]['stints'][0]]['carname'] = $sfdata['carname'];
						}
						else {
							$stnum = count($stints);
							$stintplayers[$cars[$sfdata['carid']]] = $stnum;
							$players[$cars[$sfdata['carid']]]['stints'][] = $stnum;
							$players[$cars[$sfdata['carid']]]['carid'] = $sfdata['carid'];
							$stints[$stnum]['connid'] = $tfdata['connid'];
							$stints[$stnum]['playerid'] = array_search($conns[$tfdata['connid']],$plids);
							$stints[$stnum]['nick'] = $players[$cars[$sfdata['carid']]]['nick'];
							$stints[$stnum]['plate'] = $players[$cars[$sfdata['carid']]]['plate'];
							$stints[$stnum]['lfsw'] = $cars[$sfdata['carid']];
							$stints[$stnum]['pflags'] = $players[$cars[$sfdata['carid']]]['pflags'];
							$stints[$stnum]['carid'] = $sfdata['carid'];
							$stints[$stnum]['carlaps'] = 0;
							$stints[$stnum]['initfuel'] = $players[$cars[$sfdata['carid']]]['initfuel'];
							$stints[$stnum]['pitfuel'] = $players[$cars[$sfdata['carid']]]['pitfuel'];
							$stints[$stnum]['carname'] = $sfdata['carname'];
							$stints[$stnum]['wasontrack'] = true;
							$stints[$stnum]['isontrack'] = true;
							$stints[$stnum]['leftpits'] = false;
							$stints[$stnum]['inrace'] = false;
							$stints[$stnum]['wasinrace'] = false;
							$stints[$stnum]['finished'] = false;
							$stints[$stnum]['lapsdone'] = 0;
							$stints[$stnum]['lastsplit'] = 0;
							$stints[$stnum]['lastsplittime'] = 0;
							$stints[$stnum]['sectimes'][1] = array();
							$stints[$stnum]['sectimes'][2] = array();
							$stints[$stnum]['sectimes'][3] = array();
							$stints[$stnum]['sectimes'][4] = array();
							$stints[$stnum]['sectimes']['lap'] = array();
							$stints[$stnum]['bestsectime'][1] = '';
							$stints[$stnum]['bestsectime'][2] = '';
							$stints[$stnum]['bestsectime'][3] = '';
							$stints[$stnum]['bestsectime'][4] = '';
							$stints[$stnum]['bestsectime']['lap'] = '';
							$stints[$stnum]['bestseclap'][1] = '';
							$stints[$stnum]['bestseclap'][2] = '';
							$stints[$stnum]['bestseclap'][3] = '';
							$stints[$stnum]['bestseclap'][4] = '';
							$stints[$stnum]['bestseclap']['lap'] = '';
							$stints[$stnum]['yellowflags'] = array();
							$stints[$stnum]['blueflags'] = array();
							$stints[$stnum]['pitstops'] = array();
							$stints[$stnum]['penalties'] = array();
							$stints[$stnum]['gospec'] = false;
							$stints[$stnum]['topit'] = false;
							$stints[$stnum]['reset'] = array();
							$stints[$stnum]['leftserver'] = false;
							$stints[$stnum]['rejoined'] = false;
							$stints[$stnum]['tocto'] = '';
							$stints[$stnum]['tocfrom'] = '';
							if(!empty($tm)) {
								$stints[$stnum]['team'] = $tm;
								$players[$cars[$sfdata['carid']]]['team'] = $tm;
								$teams[$tm]['stints'][] = $stnum;
								$players[$cars[$sfdata['carid']]]['teams'][$tm]['nick'] = $players[$cars[$sfdata['carid']]]['nick'];
								$players[$cars[$sfdata['carid']]]['teams'][$tm]['plate'] =  $players[$cars[$sfdata['carid']]]['plate'];
								$players[$cars[$sfdata['carid']]]['teams'][$tm]['stints'][] = $stnum;
								$players[$cars[$sfdata['carid']]]['teams'][$tm]['pflags'] =  $players[$cars[$sfdata['carid']]]['pflags'];
							}
							if($tf['id']<=$racedata['racedelay']*100) {
								$stints[$stnum]['leftpits'] = true;
								$stints[$stnum]['wasinrace'] = true;
								$stints[$stnum]['inrace'] = true;
								if(!empty($tm)) $teams[$tm]['wasinrace'] = true;
								$players[$cars[$sfdata['carid']]]['wasinrace'] = true;
							}
							if($mprheader['mprversion']<10 || $trackarray[$mprheader['trackname']][$mprheader['config']]['haspit']==0) {
								$stints[$stnum]['leftpits'] = true;
								$stints[$stnum]['wasinrace'] = true;
								$stints[$stnum]['inrace'] = true;
								if($teams[$stints[$stnum]['team']]['wasinrace'] === true && $racetype!=3) $stints[$stnum]['rejoined'] = true;
								$teams[$stints[$stnum]['team']]['wasinrace'] = true;
							}
						}
					}
					break;
				case FP_PLRUPDATE:	#player changed nick or plate
					$stint = $stintplayers[$conns[$tfdata['connid']]];
					$sfdata['nick'] = codepage_convert(strtok($sfdata['nick'],"\0"));
					$sfdata['plate'] = codepage_convert(strtok($sfdata['plate'],"\0"));
					if($race_finished===false || $stints[$stint]['inrace']===true) {
						$players[$conns[$tfdata['connid']]]['nick'] = $sfdata['nick'];
						$players[$conns[$tfdata['connid']]]['plate'] = $sfdata['plate'];
					}
					if($stints[$stint]['inrace']===true) {
						$stints[$stint]['nick'] = $sfdata['nick'];
						$stints[$stint]['plate'] = $sfdata['plate'];
						$players[$conns[$tfdata['connid']]]['teams'][$stints[$stint]['team']]['nick'] = $sfdata['nick'];
						$players[$conns[$tfdata['connid']]]['teams'][$stints[$stint]['team']]['plate'] =  $sfdata['plate'];
					}
					break;
				case FP_SPECVOTE:	#player (was) spectated | sent to pitlane
					if($sfdata['carid']!=0) $stint = $stintplayers[$cars[$sfdata['carid']]];
					if($race_finished===false || ($sfdata['carid']!=0 && $stints[$stint]['isontrack']===true)) {
						if($sfdata['carid']!=0 && ($sfdata['reason']==SPEC_SELF || $sfdata['reason']==SPEC_FORCED || $sfdata['reason']==PIT_SELF || $sfdata['reason']==PIT_ALL)) {
							$stints[$stint]['inrace'] = false;
							$stints[$stint]['leftpits'] = false;
							if($sfdata['reason']==SPEC_SELF || $sfdata['reason']==SPEC_FORCED) $players_in_race--;
							if($teams[$stints[$stint]['team']]['totlaps']==$maxlapsdone) {
								$maxlapsdone=0;
								foreach($stints as $id=>$st){
									if($stints[$id]['inrace']===true && $teams[$st['team']]['totlaps']>$maxlapsdone) $maxlapsdone = $teams[$st['team']]['totlaps'];
								}
							}
							if($sfdata['stayontrack']==0 || ($sfdata['reason']==SPEC_FORCED && ($sfdata['stayontrack']==2 || $sfdata['stayontrack']==3))) {
								$stints[$stint]['isontrack'] = false;
								$stints[$stint]['gospec'] = true;
								unset($stintplayers[$cars[$sfdata['carid']]]);
							}
							elseif($sfdata['stayontrack']==1) {
								$stints[$stint]['topit']  = true;
								$stints[$stint]['isontrack'] = false;
								$stnum = count($stints);
								$stintplayers[$cars[$sfdata['carid']]] = $stnum;
								$players[$cars[$sfdata['carid']]]['stints'][] = $stnum;
								$players[$cars[$sfdata['carid']]]['carid'] = $sfdata['carid'];
								$stints[$stnum]['connid'] = $tfdata['connid'];
								$stints[$stnum]['playerid'] = array_search($cars[$sfdata['carid']],$plids);
								$stints[$stnum]['nick'] = $players[$cars[$sfdata['carid']]]['nick'];
								$stints[$stnum]['plate'] = $players[$cars[$sfdata['carid']]]['plate'];
								$stints[$stnum]['lfsw'] = $cars[$sfdata['carid']];
								$stints[$stnum]['pflags'] = $players[$cars[$sfdata['carid']]]['pflags'];
								$stints[$stnum]['carid'] = $sfdata['carid'];
								$stints[$stnum]['carlaps'] = 0;
								$stints[$stnum]['initfuel'] = $stints[$stint]['initfuel'];
								$stints[$stnum]['pitfuel'] = $stints[$stint]['pitfuel'];
								$stints[$stnum]['carname'] = $sfdata['carname'];
								$stints[$stnum]['wasontrack'] = true;
								$stints[$stnum]['isontrack'] = true;
								$stints[$stnum]['leftpits'] = false;
								$stints[$stnum]['inrace'] = false;
								$stints[$stnum]['wasinrace'] = false;
								$stints[$stnum]['finished'] = false;
								$stints[$stnum]['lapsdone'] = 0;
								$stints[$stnum]['lastsplit'] = 0;
								$stints[$stnum]['lastsplittime'] = 0;
								$stints[$stnum]['sectimes'][1] = array();
								$stints[$stnum]['sectimes'][2] = array();
								$stints[$stnum]['sectimes'][3] = array();
								$stints[$stnum]['sectimes'][4] = array();
								$stints[$stnum]['sectimes']['lap'] = array();
								$stints[$stnum]['bestsectime'][1] = '';
								$stints[$stnum]['bestsectime'][2] = '';
								$stints[$stnum]['bestsectime'][3] = '';
								$stints[$stnum]['bestsectime'][4] = '';
								$stints[$stnum]['bestsectime']['lap'] = '';
								$stints[$stnum]['bestseclap'][1] = '';
								$stints[$stnum]['bestseclap'][2] = '';
								$stints[$stnum]['bestseclap'][3] = '';
								$stints[$stnum]['bestseclap'][4] = '';
								$stints[$stnum]['bestseclap']['lap'] = '';
								$stints[$stnum]['yellowflags'] = array();
								$stints[$stnum]['blueflags'] = array();
								$stints[$stnum]['pitstops'] = array();
								$stints[$stnum]['penalties'] = array();
								$stints[$stnum]['gospec'] = false;
								$stints[$stnum]['topit'] = false;
								$stints[$stnum]['reset'] = array();
								$stints[$stnum]['leftserver'] = false;
								$stints[$stnum]['rejoined'] = false;
								$stints[$stnum]['tocto'] = '';
								$stints[$stnum]['tocfrom'] = '';
								$stints[$stnum]['team'] = $stints[$stint]['team'];
								$teams[$stints[$stint]['team']]['stints'][] = $stnum;
								$players[$cars[$sfdata['carid']]]['teams'][$stints[$stint]['team']]['nick'] = $players[$cars[$sfdata['carid']]]['nick'];
								$players[$cars[$sfdata['carid']]]['teams'][$stints[$stint]['team']]['plate'] =  $players[$cars[$sfdata['carid']]]['plate'];
								$players[$cars[$sfdata['carid']]]['teams'][$stints[$stint]['team']]['stints'][] = $stnum;
								$players[$cars[$sfdata['carid']]]['teams'][$stints[$stint]['team']]['pflags'] =  $players[$cars[$sfdata['carid']]]['pflags'];
							}
						}
						if($sfdata['carid']==0 && $sfdata['reason']==PIT_ALL) {
							$maxlapsdone=0;
							$maxstints = count($stints);
							unset($stintplayers);
							foreach($stints as $id=>$st) {
								if($st['isontrack']===true && $id<$maxstints) {
									$st['inrace'] = false;
									$st['leftpits'] = false;
									$st['isontrack'] = false;
									$st['topit']  = true;
									$stnum = count($stints);
									$stintplayers[$st['lfsw']] = $stnum;
									$players[$st['lfsw']]['stints'][] = $stnum;
									$players[$st['lfsw']]['carid'] = $st['carid'];
									$stints[$stnum]['connid'] = $st['connid'];
									$stints[$stnum]['playerid'] = $st['playerid'];
									$stints[$stnum]['nick'] = $st['nick'];
									$stints[$stnum]['plate'] = $st['plate'];
									$stints[$stnum]['lfsw'] = $st['lfsw'];
									$stints[$stnum]['pflags'] = $st['pflags'];
									$stints[$stnum]['carid'] = $st['carid'];
									$stints[$stnum]['carlaps'] = 0;
									$stints[$stnum]['initfuel'] = $st['initfuel'];
									$stints[$stnum]['pitfuel'] = $st['pitfuel'];
									$stints[$stnum]['carname'] = $st['carname'];
									$stints[$stnum]['wasontrack'] = true;
									$stints[$stnum]['isontrack'] = true;
									$stints[$stnum]['leftpits'] = false;
									$stints[$stnum]['inrace'] = false;
									$stints[$stnum]['wasinrace'] = false;
									$stints[$stnum]['finished'] = false;
									$stints[$stnum]['lapsdone'] = 0;
									$stints[$stnum]['lastsplit'] = 0;
									$stints[$stnum]['lastsplittime'] = 0;
									$stints[$stnum]['sectimes'][1] = array();
									$stints[$stnum]['sectimes'][2] = array();
									$stints[$stnum]['sectimes'][3] = array();
									$stints[$stnum]['sectimes'][4] = array();
									$stints[$stnum]['sectimes']['lap'] = array();
									$stints[$stnum]['bestsectime'][1] = '';
									$stints[$stnum]['bestsectime'][2] = '';
									$stints[$stnum]['bestsectime'][3] = '';
									$stints[$stnum]['bestsectime'][4] = '';
									$stints[$stnum]['bestsectime']['lap'] = '';
									$stints[$stnum]['bestseclap'][1] = '';
									$stints[$stnum]['bestseclap'][2] = '';
									$stints[$stnum]['bestseclap'][3] = '';
									$stints[$stnum]['bestseclap'][4] = '';
									$stints[$stnum]['bestseclap']['lap'] = '';
									$stints[$stnum]['yellowflags'] = array();
									$stints[$stnum]['blueflags'] = array();
									$stints[$stnum]['pitstops'] = array();
									$stints[$stnum]['penalties'] = array();
									$stints[$stnum]['gospec'] = false;
									$stints[$stnum]['topit'] = false;
									$stints[$stnum]['reset'] = array();
									$stints[$stnum]['leftserver'] = false;
									$stints[$stnum]['rejoined'] = false;
									$stints[$stnum]['tocto'] = '';
									$stints[$stnum]['tocfrom'] = '';
									$stints[$stnum]['team'] = $st['team'];
									$teams[$st['team']]['stints'][] = $stnum;
									$players[$st['lfsw']]['teams'][$st['team']]['nick'] = $st['nick'];
									$players[$st['lfsw']]['teams'][$st['team']]['plate'] = $st['plate'];
									$players[$st['lfsw']]['teams'][$st['team']]['stints'][] = $stnum;
									$players[$st['lfsw']]['teams'][$st['team']]['pflags'] = $st['pflags'];
								}
							}
						}
					}
					break;
				case FP_TOPITS:	#player jumped to pits
					$stint = $stintplayers[$conns[$tfdata['connid']]];
					if($race_finished===false || $stints[$stint]['isontrack']===true) {
						$stints[$stint]['isontrack'] = false;
						$stints[$stint]['inrace'] = false;
						$stints[$stint]['leftpits'] = false;
						$stints[$stint]['topits'] = true;
						$players_in_race--;
						if($teams[$stints[$stint]['team']]['totlaps']==$maxlapsdone) {
							$maxlapsdone=0;
							foreach($stints as $id=>$st){
								if($st['inrace']===true && $teams[$st['team']]['totlaps']>$maxlapsdone) $maxlapsdone = $teams[$st['team']]['totlaps'];
							}
						}
					}
					unset($stintplayers[$conns[$tfdata['connid']]]);
					break;
				case FP_PLRCONNECT:	#player connects to server
					$sfdata['lfsw'] = (!empty($sfdata['lfsw'])) ? codepage_convert(strtolower(strtok($sfdata['lfsw'],"\0"))) : 'demodummyname'.nameblank(codepage_convert(strtok($sfdata['nick'],"\0")));
					$sfdata['nick'] = codepage_convert(strtok($sfdata['nick'],"\0"));
					$sfdata['plate'] = codepage_convert(strtok($sfdata['plate']),"\0");
					$players[$sfdata['lfsw']]['connid'] = count($conns);
					$players[$sfdata['lfsw']]['playerid'] = $sfdata['playerid'];
					$players[$sfdata['lfsw']]['isadmin'] = ($sfdata['isadmin']==1) ? true: false;
					$players[$sfdata['lfsw']]['nick'] = $sfdata['nick'];
					$players[$sfdata['lfsw']]['plate'] = $sfdata['plate'];
					$conns[count($conns)] = $sfdata['lfsw'];
					$plids[$sfdata['playerid']] = $sfdata['lfsw'];
					if(!array_key_exists($sfdata['lfsw'],$players)) {
						$players[$sfdata['lfsw']]['stints'] = array();
						$players[$sfdata['lfsw']]['wasinrace'] = false;
					}
					break;
				case FP_PLRFLAGS:	#player changes player flags
					$stint = $stintplayers[$cars[$sfdata['carid']]];
					if($race_finished===false || $stints[$stint]['inrace']===true) {
						$players[$cars[$sfdata['carid']]]['pflags'] = $sfdata['pflags'];
					}
					if($stints[$stint]['inrace']===true) {
						$stints[$stint]['pflags'] = $sfdata['pflags'];
						$players[$cars[$sfdata['carid']]]['teams'][$stints[$stint]['team']]['pflags'] = $sfdata['pflags'];
					}
					break;
				case FP_QUALLENGTH:	#length of qualifying was changed
					if($race_finished===false && empty($setduration)) {
						$racedata['qualmins'] = $sfdata['quallength'];
						if($racedata['type']==2) {
							$duration = $sfdata['quallength']*6000;
							if($duration<=$tf['id']) $race_finished=true;
						}
					}
					break;
				case FP_RACELENGTH:	#length of race was changed
					if($race_finished===false && (empty($setduration) || $_GET['force_load']!=FORCE_LOAD_PASS)) {
						$racedata['laphours'] = $sfdata['laphours'];
						if($racedata['type']==1 && $sfdata['laphours']==0) $racetype = RACETYPE_TRAINING;
						elseif($racedata['type']==1 && $racedata['laphours']<191) {
							$duration = ($racedata['laphours'] - floor($racedata['laphours']/100)*100)*pow(10,floor($racedata['laphours']/100)) + floor($racedata['laphours']/100)*100;
							$racetype = RACETYPE_LAPS;
						}
						elseif($racedata['type']==1) {
							$duration = ($racedata['laphours']-190)*360000;
							$racetype = RACETYPE_TIME;
						}
						if(($racetype==RACETYPE_LAPS && $maxlapsdone>=$duration) || ($racetype==RACETYPE_TIME && $tf['id']>=$duration)) {
							$race_finished=true;
						}
					}
					break;
				case FP_SPLIT:	#player passed a split
					$stint = $stintplayers[$cars[$sfdata['carid']]];
					if($stints[$stint]['inrace']===true && $racetype==RACETYPE_QUAL) {
						$thissplit = $sfdata['split']-2;
						if($thissplit==1 && $sfdata['splittime']!=360000) $stints[$stint]['lastsplittime'] = 0;
						if($sfdata['splittime']!=360000) {
							$thissectime = $sfdata['splittime'] - $stints[$stint]['lastsplittime'];
							$stints[$stint]['sectimes'][$thissplit][myadd($stints[$stint]['lapsdone'],1)] = $thissectime;
							if($thissectime<$stints[$stint]['bestsectime'][$thissplit] || empty($stints[$stint]['bestsectime'][$thissplit])) {
								$stints[$stint]['bestsectime'][$thissplit] = $thissectime;
								$stints[$stint]['bestseclap'][$thissplit] = $stints[$stint]['lapsdone']+1;
							}
							$stints[$stint]['lastsplittime'] = $sfdata['splittime'];
						}
					}
					elseif($stints[$stint]['inrace']===true) {
						$thissplit = $sfdata['split']-2;
						if($stints[$stint]['lapsdone']==0 && $thissplit==1) $stints[$stint]['lastsplittime'] = 0;
						$thissectime = $sfdata['splittime'] - $stints[$stint]['lastsplittime'];
						$stints[$stint]['sectimes'][$thissplit][myadd($stints[$stint]['lapsdone'],1)] = $stints[$stint]['totaltime'] + $sfdata['splittime'];
						if($thissectime<$stints[$stint]['bestsectime'][$thissplit] || empty($stints[$stint]['bestsectime'][$thissplit])) {
							$stints[$stint]['bestsectime'][$thissplit] = $thissectime;
							$stints[$stint]['bestseclap'][$thissplit] = $stints[$stint]['lapsdone']+1;
						}
						$stints[$stint]['lastsplit'] = $thissplit;
						$stints[$stint]['lastsplittime'] = $sfdata['splittime'];
					}
					break;
				case FP_LAP:	#player passed finish line
					$stint = $stintplayers[$cars[$sfdata['carid']]];
					if($stints[$stint]['inrace']===true && $racetype==RACETYPE_QUAL) {
						if($sfdata['laptime']!=360000) {
							$thissectime = $sfdata['laptime'] - $stints[$stint]['lastsplittime'];
							$stints[$stint]['sectimes'][$sectors][myadd($stints[$stint]['lapsdone'],1)] = $thissectime;
							$stints[$stint]['sectimes']['lap'][myadd($stints[$stint]['lapsdone'],1)] = $sfdata['laptime'];
							if($thissectime<$stints[$stint]['bestsectime'][$sectors] || empty($stints[$stint]['bestsectime'][$sectors])) {
								$stints[$stint]['bestsectime'][$sectors] = $thissectime;
								$stints[$stint]['bestseclap'][$sectors] = $stints[$stint]['lapsdone']+1;
							}
							if(($sfdata['laptime']<$stints[$stint]['bestsectime']['lap'] || empty($stints[$stint]['bestsectime']['lap']))) {
								$stints[$stint]['bestsectime']['lap'] = $sfdata['laptime'];
								$stints[$stint]['bestseclap']['lap'] = $stints[$stint]['lapsdone']+1;
								$stints[$stint]['totaltime'] = $sfdata['totaltime'];
							}
							$stints[$stint]['lapsdone'] += 1;
							$stints[$stint]['carlaps'] += 1;
						}
						$stints[$stint]['lastsplit'] = 0;
						$stints[$stint]['lastsplittime'] = 0;
						if($race_finished===false && $sfdata['totaltime']>=$duration) {
							$race_finished = true;
							$teams[$stints[$stint]['team']]['finished'] = true;
							$stints[$stint]['inrace'] = false;
							$players_in_race--;
						}
						elseif($race_finished===true) {
							$teams[$stints[$stint]['team']]['finished'] = true;
							$stints[$stint]['inrace'] = false;
							$players_in_race--;
						}
					}
					elseif($stints[$stint]['inrace']===true && $tf['id']>=$racedata['racedelay']*100) {
						$stints[$stint]['carlaps'] += 1;
						$lead = false;
						if($stints[$stint]['carlaps']>$maxlapsdone) {
							$lead = true;
							$maxlapsdone = $stints[$stint]['carlaps'];
						}
						$thissectime = $sfdata['laptime'] - $stints[$stint]['lastsplittime'];
						$stints[$stint]['sectimes'][$sectors][myadd($stints[$stint]['lapsdone'],1)] = $sfdata['totaltime'];
						$stints[$stint]['sectimes']['lap'][myadd($stints[$stint]['lapsdone'],1)] = $sfdata['totaltime'];
						if($thissectime<$stints[$stint]['bestsectime'][$sectors] || empty($stints[$stint]['bestsectime'][$sectors])) {
							$stints[$stint]['bestsectime'][$sectors] = $thissectime;
							$stints[$stint]['bestseclap'][$sectors] = $stints[$stint]['lapsdone']+1;
						}
						if(($sfdata['laptime']<$stints[$stint]['bestsectime']['lap'] || empty($stints[$stint]['bestsectime']['lap']))) {
							$stints[$stint]['bestsectime']['lap'] = $sfdata['laptime'];
							$stints[$stint]['bestseclap']['lap'] = $stints[$stint]['lapsdone']+1;
						}
						$teams[$stints[$stint]['team']]['totlaps'] = $stints[$stint]['carlaps'];
						$stints[$stint]['lapsdone'] += 1;
						$stints[$stint]['totaltime'] = $sfdata['totaltime'];
						$stints[$stint]['lastsplit'] = 0;
						$stints[$stint]['lastsplittime'] = 0;
						if($race_finished===false && (($racetype==RACETYPE_LAPS && $maxlapsdone>=$duration) || ($racetype==RACETYPE_TIME && $lead===true && $sfdata['totaltime']>=$duration) || ($racetype==RACETYPE_QUAL && $sfdata['totaltime']>=$duration))) {
							$race_finished = true;
							$totaltime = $sfdata['totaltime'];
							$teams[$stints[$stint]['team']]['finished'] = true;
							$stints[$stint]['inrace'] = false;
							$stints[$stint]['isontrack'] = false;
							$players_in_race--;
						}
						elseif($race_finished===true) {
							$teams[$stints[$stint]['team']]['finished'] = true;
							$stints[$stint]['inrace'] = false;
							$stints[$stint]['isontrack'] = false;
							if(($maxlapsdone==$stints[$stint]['carlaps'] && $totaltime>=$sfdata['totaltime'])) $totaltime = $sfdata['totaltime'];
							$players_in_race--;
						}
					}
					break;
				case FP_WIND:	#wind & weather
					$racedata['windspeed'] = $sfdata['windspeed'];
					break;
				case FP_SERVERFLAGS:	#server flags are changed
					$mprheader['serverflags'] = $sfdata['sflags'];
					break;
				case FP_PITSHEDULE:	#pitwork shedule
					$stint = $stintplayers[$cars[$sfdata['carid']]];
					$stints[$stint]['pitfuel'] = $sfdata['pitfuel'];
					$players[$cars[$sfdata['carid']]]['pitfuel'] = $sfdata['pitfuel'];
					break;
				case FP_LEAVESERVER:	#player leaves server
					$stint = $stintplayers[$plids[$sfdata['plid']]];
					$gone[array_search($plids[$sfdata['plid']],$conns)] = $sfdata['plid'];
					if(!empty($stint)) {
						$stints[$stint]['isontrack'] = false;
						$stints[$stint]['leftpits'] = false;
						$stints[$stint]['leftserver'] = $sfdata['reason'];
					}
					if($stints[$stint]['inrace']===true && $race_finished===false) {
						$stints[$stint]['inrace'] = false;
						$players_in_race--;
						if($teams[$stints[$stint]['team']]['totlaps']==$maxlapsdone) {
							$maxlapsdone=0;
							foreach($stints as $id=>$st){
								if($st['inrace']===true && $teams[$st['team']]['totlaps']>$maxlapsdone) $maxlapsdone = $teams[$st['team']]['totlaps'];
							}
						}
					}
					unset($stintplayers[$plids[$gone[$key]]]);
					break;
				case FP_PENALTY:	#player got penalty
					$stint = $stintplayers[$cars[$sfdata['carid']]];
					if($race_finished===false || $stints[$stint]['inrace']===true) {
						if($sfdata['pentype']==PENTYPE_NONE && $sfdata['penreason']==PENREASON_NONE) {
							$stints[$stint]['penalties'][myadd($stints[$stint]['lapsdone'],1)] .= $stints[$stint]['penalties_open']{0}.$sfdata['penreason'];
							$stints[$stint]['penalties_open'] = '';
						}
						else $stints[$stint]['penalties'][myadd($stints[$stint]['lapsdone'],1)] .= $sfdata['pentype'].$sfdata['penreason'];
						$stints[$stint]['penalties_open'] = $sfdata['pentype'].$sfdata['penreason'];
					}
					break;
				case FP_FLAGS:	#player saw a flag
					$stint = $stintplayers[$cars[$sfdata['carid']]];
					if($race_finished===false || $stints[$stint]['inrace']===true) {
						if($sfdata['flagbit']==YELLOW_SHOWN && (!isset($stints[$stint]['ybit']) || !isset($stints[$stint]['yellowflags'][myadd($stints[$stint]['lapsdone'],1)]))) {
							$stints[$stint]['yellowflags'][myadd($stints[$stint]['lapsdone'],1)] .= myadd($stints[$stint]['lastsplit'],1);
							$stints[$stint]['ybit'] = 1;
						}
						if($sfdata['flagbit']==YELLOW_CLEARED &&  isset($stints[$stint]['ybit'])) unset($stints[$stint]['ybit']);
						if($sfdata['flagbit']==BLUE_SHOWN && (!isset($stints[$stint]['bbit']) || !isset($stints[$stint]['blueflags'][myadd($stints[$stint]['lapsdone'],1)]))) {
							$stints[$stint]['blueflags'][myadd($stints[$stint]['lapsdone'],1)] .= myadd($stints[$stint]['lastsplit'],1);
							$stints[$stint]['bbit'] = 1;
						}
						if($sfdata['flagbit']==BLUE_CLEARED && isset($stints[$stint]['bbit'])) unset($stints[$stint]['bbit']);
					}
					break;
				case FP_TAKEOVER:	#player requested a driver change
					if($sfdata['reqtype']==TOC_TAKE && array_search($plids[$sfdata['reqto']],$cars) && ($race_finished===false || $stints[$stint]['inrace']===true)) { # $plids[$sfdata['reqto']] -> $conns[$tfdata['connid']]
						$stint = $stintplayers[$plids[$sfdata['reqto']]];
						$tocto[$conns[$tfdata['connid']]] = $plids[$sfdata['reqto']];
						if($tocfrom[$plids[$sfdata['reqto']]]==$conns[$tfdata['connid']]) {
							if($istoc===true && $hasteams===false) {
								$errors[] = $lang['errors']['takeover_detected'];
								$go = false;
							}
							if($istoc===false || $stints[$stint]['inrace']===false) {
								$stints[$stint]['inrace'] = false;
								$stints[$stint]['unallTOC'] = true;
#								print_r($teams);
								break;
							}
							if(is_array($teams[$stints[$stint]['team']]['drivers'])) {
								if(!in_array($conns[$tfdata['connid']], $teams[$stints[$stint]['team']]['drivers'])) {
									$errors[] = $lang['errors']['rec_not_in_team'].' ('.$stints[$stint]['team'].'/'.$conns[$tfdata['connid']].')';
									$go = false;
								}
							}
							$stnum = count($stints);
							$stintplayers[$conns[$tfdata['connid']]] = $stnum;
							$players[$conns[$tfdata['connid']]]['stints'][] = $stnum;
							$players[$conns[$tfdata['connid']]]['carid'] = $stints[$stint]['carid'];
							$stints[$stnum]['connid'] = $tfdata['connid'];
							$stints[$stnum]['playerid'] = $players[$conns[$tfdata['connid']]]['playerid'];
							$stints[$stnum]['nick'] = $players[$conns[$tfdata['connid']]]['nick'];
							$stints[$stnum]['plate'] = $players[$conns[$tfdata['connid']]]['plate'];
							$stints[$stnum]['lfsw'] = $conns[$tfdata['connid']];
							$stints[$stnum]['pflags'] = $stints[$stint]['pflags'];
							$stints[$stnum]['carid'] = $stints[$stint]['carid'];
							$stints[$stnum]['carlaps'] = $stints[$stint]['carlaps'];
							$stints[$stnum]['initfuel'] = $stints[$stint]['initfuel'];
							$stints[$stnum]['pitfuel'] = $stints[$stint]['pitfuel'];
							$stints[$stnum]['currfuel'] = $stints[$stint]['currfuel'];
							$stints[$stnum]['carname'] = $stints[$stint]['carname'];
							$stints[$stnum]['tyreFront'] = $stints[$stint]['tyreFront'];
							$stints[$stnum]['tyreRear'] = $stints[$stint]['tyreRear'];
							$stints[$stnum]['initFront'] = $stints[$stint]['tyreFront'];
							$stints[$stnum]['initRear'] = $stints[$stint]['tyreRear'];
							$stints[$stnum]['wasontrack'] = true;
							$stints[$stnum]['isontrack'] = true;
							$stints[$stnum]['leftpits'] = true;
							$stints[$stnum]['inrace'] = true;
							$stints[$stnum]['wasinrace'] = true;
							$stints[$stnum]['finished'] = false;
							$stints[$stnum]['lapsdone'] = 0;
							$stints[$stnum]['lastsplit'] = 0;
							$stints[$stnum]['lastsplittime'] = 0;
							$stints[$stnum]['sectimes'][1] = array();
							$stints[$stnum]['sectimes'][2] = array();
							$stints[$stnum]['sectimes'][3] = array();
							$stints[$stnum]['sectimes'][4] = array();
							$stints[$stnum]['sectimes']['lap'] = array();
							$stints[$stnum]['bestsectime'][1] = '';
							$stints[$stnum]['bestsectime'][2] = '';
							$stints[$stnum]['bestsectime'][3] = '';
							$stints[$stnum]['bestsectime'][4] = '';
							$stints[$stnum]['bestsectime']['lap'] = '';
							$stints[$stnum]['bestseclap'][1] = '';
							$stints[$stnum]['bestseclap'][2] = '';
							$stints[$stnum]['bestseclap'][3] = '';
							$stints[$stnum]['bestseclap'][4] = '';
							$stints[$stnum]['bestseclap']['lap'] = '';
							$stints[$stnum]['yellowflags'] = array();
							$stints[$stnum]['blueflags'] = array();
							$stints[$stnum]['pitstops'] = array();
							$stints[$stnum]['penalties'] = array();
							$stints[$stnum]['gospec'] = false;
							$stints[$stnum]['topit'] = false;
							$stints[$stnum]['reset'] = array();
							$stints[$stnum]['leftserver'] = false;
							$stints[$stnum]['rejoined'] = false;
							$stints[$stnum]['tocto'] = '';
							$stints[$stnum]['tocfrom'] = $stint;
							$stints[$stnum]['team'] = $stints[$stint]['team'];
							$teams[$stints[$stint]['team']]['stints'][] = $stnum;
							$cars[$stints[$stint]['carid']] = $conns[$tfdata['connid']];
							$stints[$stint]['tocto'] = $stnum;
							$stints[$stint]['inrace'] = false;
							unset($stintplayers[$plids[$sfdata['reqto']]]);
							$players[$conns[$tfdata['connid']]]['teams'][$stints[$stint]['team']]['nick'] = $players[$conns[$tfdata['connid']]]['nick'];
							$players[$conns[$tfdata['connid']]]['teams'][$stints[$stint]['team']]['plate'] = $players[$conns[$tfdata['connid']]]['plate'];
							$players[$conns[$tfdata['connid']]]['teams'][$stints[$stint]['team']]['stints'][] = $stnum;
							$players[$conns[$tfdata['connid']]]['teams'][$stints[$stint]['team']]['pflags'] = $stints[$stint]['pflags'];
							if(empty($stints[$stint]['team'])) {
								$errors[] = $lang['errors']['takeover_noteam_1'].' ('.$stint.')';
								$go = false;
							}
							unset($tocto[$conns[$tfdata['connid']]]);
							unset($tocfrom[$plids[$sfdata['reqto']]]);
						}
					}
					if($sfdata['reqtype']==TOC_GIVE && array_search($conns[$tfdata['connid']],$cars) && ($race_finished===false || $stints[$stint]['inrace']===true)) {  # $conns[$tfdata['connid']] -> $plids[$sfdata['reqto']]
						$stint = $stintplayers[$conns[$tfdata['connid']]];
						$tocfrom[$conns[$tfdata['connid']]] = $plids[$sfdata['reqto']];
						if($tocto[$plids[$sfdata['reqto']]]==$conns[$tfdata['connid']]) {
							if($istoc===true && $hasteams===false) {
								$errors[] = $lang['errors']['takeover_detected'];
								$go = false;
							}
							if($istoc===false || $stints[$stint]['inrace']===false) {
								$stints[$stint]['inrace'] = false;
								$stints[$stint]['unallTOC'] = true;
#								print_r($teams);
								break;
							}
							if(empty($stints[$stint]['team'])) {
							$errors[] = $lang['errors']['takeover_noteam_2'].' ('.$stint.')';
								$go = false;
							}
							$stnum = count($stints);
							$stintplayers[$plids[$sfdata['reqto']]] = $stnum;
							$players[$plids[$sfdata['reqto']]]['stints'][] = $stnum;
							$players[$plids[$sfdata['reqto']]]['carid'] = $stints[$stint]['carid'];
							$stints[$stnum]['connid'] = array_search($plids[$sfdata['reqto']],$conns);
							$stints[$stnum]['playerid'] = $sfdata['reqto'];
							$stints[$stnum]['nick'] = $players[$plids[$sfdata['reqto']]]['nick'];
							$stints[$stnum]['plate'] = $players[$plids[$sfdata['reqto']]]['plate'];
							$stints[$stnum]['lfsw'] = $plids[$sfdata['reqto']];
							$stints[$stnum]['pflags'] = $stints[$stint]['pflags'];
							$stints[$stnum]['carid'] = $stints[$stint]['carid'];
							$stints[$stnum]['carlaps'] = $stints[$stint]['carlaps'];
							$stints[$stnum]['initfuel'] = $stints[$stint]['initfuel'];
							$stints[$stnum]['pitfuel'] = $stints[$stint]['pitfuel'];
							$stints[$stnum]['currfuel'] = $stints[$stint]['currfuel'];
							$stints[$stnum]['carname'] = $stints[$stint]['carname'];
							$stints[$stnum]['tyreFront'] = $stints[$stint]['tyreFront'];
							$stints[$stnum]['tyreRear'] = $stints[$stint]['tyreRear'];
							$stints[$stnum]['initFront'] = $stints[$stint]['tyreFront'];
							$stints[$stnum]['initRear'] = $stints[$stint]['tyreRear'];
							$stints[$stnum]['wasontrack'] = true;
							$stints[$stnum]['isontrack'] = true;
							$stints[$stnum]['leftpits'] = true;
							$stints[$stnum]['inrace'] = true;
							$stints[$stnum]['wasinrace'] = true;
							$stints[$stnum]['finished'] = false;
							$stints[$stnum]['lapsdone'] = 0;
							$stints[$stnum]['lastsplit'] = 0;
							$stints[$stnum]['lastsplittime'] = 0;
							$stints[$stnum]['sectimes'][1] = array();
							$stints[$stnum]['sectimes'][2] = array();
							$stints[$stnum]['sectimes'][3] = array();
							$stints[$stnum]['sectimes'][4] = array();
							$stints[$stnum]['sectimes']['lap'] = array();
							$stints[$stnum]['bestsectime'][1] = '';
							$stints[$stnum]['bestsectime'][2] = '';
							$stints[$stnum]['bestsectime'][3] = '';
							$stints[$stnum]['bestsectime'][4] = '';
							$stints[$stnum]['bestsectime']['lap'] = '';
							$stints[$stnum]['bestseclap'][1] = '';
							$stints[$stnum]['bestseclap'][2] = '';
							$stints[$stnum]['bestseclap'][3] = '';
							$stints[$stnum]['bestseclap'][4] = '';
							$stints[$stnum]['bestseclap']['lap'] = '';
							$stints[$stnum]['yellowflags'] = array();
							$stints[$stnum]['blueflags'] = array();
							$stints[$stnum]['pitstops'] = array();
							$stints[$stnum]['penalties'] = array();
							$stints[$stnum]['gospec'] = false;
							$stints[$stnum]['topit'] = false;
							$stints[$stnum]['reset'] = array();
							$stints[$stnum]['leftserver'] = false;
							$stints[$stnum]['rejoined'] = false;
							$stints[$stnum]['tocto'] = '';
							$stints[$stnum]['tocfrom'] = $stint;
							$stints[$stnum]['team'] = $stints[$stint]['team'];
							$teams[$stints[$stint]['team']]['stints'][] = $stnum;
							$cars[$stints[$stint]['carid']] = $plids[$sfdata['reqto']];
							$stints[$stint]['tocto'] = $stnum;
							$stints[$stint]['inrace'] = false;
							unset($stintplayers[$conns[$tfdata['connid']]]);
							$players[$plids[$sfdata['reqto']]]['teams'][$stints[$stint]['team']]['nick'] = $players[$plids[$sfdata['reqto']]]['nick'];
							$players[$plids[$sfdata['reqto']]]['teams'][$stints[$stint]['team']]['plate'] = $players[$plids[$sfdata['reqto']]]['plate'];
							$players[$plids[$sfdata['reqto']]]['teams'][$stints[$stint]['team']]['stints'][] = $stnum;
							$players[$plids[$sfdata['reqto']]]['teams'][$stints[$stint]['team']]['pflags'] = $stints[$stint]['pflags'];
							unset($tocfrom[$conns[$tfdata['connid']]]);
							unset($tocto[$plids[$sfdata['reqto']]]);
						}
					}
					if($sfdata['reqtype']==0 && $sfdata['reqto']==0) { # $plids[$sfdata['reqto']] -> $conns[$tfdata['connid']]
						unset($tocfrom[$conns[$tfdata['connid']]]);
						unset($tocto[$conns[$tfdata['connid']]]);
					}
					break;
				case FP_TOCINFO:	#pitinfo on driver change
					$stint = $stintplayers[$cars[$sfdata['carid']]];
					if(!empty($stints[$stint]['toctime'])) $stints[$stint]['toctime'] = $tf['id']-$stints[$stint]['toctime'];
					$stints[$stint]['tocsplit'] = $sfdata['lastsplit'];
					break;
				case FP_PITWORK:	#pitstop info
					$stint = $stintplayers[$cars[$sfdata['carid']]];
					if($stints[$stint]['inrace']===true) {
						$tbit = 0;
						$tbit += (255 ^ $sfdata['LRtyre']) ? 1 : 0;
						$tbit += (255 ^ $sfdata['RRtyre']) ? 2 : 0;
						$tbit += (255 ^ $sfdata['LFtyre']) ? 4 : 0;
						$tbit += (255 ^ $sfdata['RFtyre']) ? 8 : 0;
#						if($tbit>0) {
							$stints[$stint]['tbroken'] = 0;
							if($tbit & 1 && $stints[$stint]['tyreRear'] != $sfdata['LRtyre']) {$stints[$stint]['pitstops'][myadd($stints[$stint]['lapsdone'],1)]['changeRear'] = $stints[$stint]['tyreRear'].$sfdata['LRtyre'];$stints[$stint]['tyreRear'] = $sfdata['LRtyre'];}
							elseif($tbit & 2 && $stints[$stint]['tyreRear'] != $sfdata['RRtyre']) {$stints[$stint]['pitstops'][myadd($stints[$stint]['lapsdone'],1)]['changeRear'] = $stints[$stint]['tyreRear'].$sfdata['RRtyre'];$stints[$stint]['tyreRear'] = $sfdata['RRtyre'];}
							else $stints[$stint]['pitstops'][myadd($stints[$stint]['lapsdone'],1)]['changeRear'] = $stints[$stint]['tyreRear'];
							if($tbit & 4 && $stints[$stint]['tyreFront'] != $sfdata['LFtyre']) {$stints[$stint]['pitstops'][myadd($stints[$stint]['lapsdone'],1)]['changeFront'] = $stints[$stint]['tyreFront'].$sfdata['LFtyre'];$stints[$stint]['tyreFront'] = $sfdata['LFtyre'];}
							elseif($tbit & 8 && $stints[$stint]['tyreFront'] != $sfdata['RFtyre']) {$stints[$stint]['pitstops'][myadd($stints[$stint]['lapsdone'],1)]['changeFront'] = $stints[$stint]['tyreFront'].$sfdata['RFtyre'];$stints[$stint]['tyreFront'] = $sfdata['RFtyre'];}
							else $stints[$stint]['pitstops'][myadd($stints[$stint]['lapsdone'],1)]['changeFront'] = $stints[$stint]['tyreFront'];
#						}
						$stints[$stint]['pitstops'][myadd($stints[$stint]['lapsdone'],1)]['work'] = $sfdata['pwork'];
						$stints[$stint]['pitstops'][myadd($stints[$stint]['lapsdone'],1)]['tbit'] = $tbit;
						$stints[$stint]['pitstops'][myadd($stints[$stint]['lapsdone'],1)]['from'] = $cars[$sfdata['carid']];
						if(131072 & $sfdata['pwork']) {
							$stints[$stint]['pitstops'][myadd($stints[$stint]['lapsdone'],1)]['refueled'] = ($stints[$stint]['pitfuel']+$stints[$stint]['currfuel']>=100) ? 100-$stints[$stint]['currfuel'] : $stints[$stint]['pitfuel'];
							$stints[$stint]['usedfuel'] += $stints[$stint]['initfuel']-$stints[$stint]['currfuel'];
							$stints[$stint]['initfuel'] = ($stints[$stint]['pitfuel']+$stints[$stint]['currfuel']>=100) ? 100 : $stints[$stint]['pitfuel']+$stints[$stint]['currfuel'];
						}
						$stints[$stint]['toctime'] = $tf['id'];
						$stints[$stint]['tbroken']=false;
					}
					break;
				case FP_PITTIME:	#pitstop duration
					$stint = $stintplayers[$cars[$sfdata['carid']]];
					if($stints[$stint]['inrace']===true) {
						if(isset($stints[$stint]['pitstops'][myadd($stints[$stint]['lapsdone'],1)])) {
							$stints[$stint]['pitstops'][myadd($stints[$stint]['lapsdone'],1)]['time'] = $sfdata['ptime'];
							$stints[$stint]['pitstops'][myadd($stints[$stint]['lapsdone'],1)]['to'] = $cars[$sfdata['carid']];
							unset($stints[$stint]['toctime']);
							unset($stints[$stint]['tocsplit']);
						}
						elseif(isset($stints[$stints[$stint]['tocfrom']]['pitstops'][myadd($stints[$stints[$stint]['tocfrom']]['lapsdone'],1)]) && isset($stints[$stints[$stint]['tocfrom']]['toctime'])) {
							$stints[$stints[$stint]['tocfrom']]['pitstops'][myadd($stints[$stints[$stint]['tocfrom']]['lapsdone'],1)]['time'] = $stints[$stints[$stint]['tocfrom']]['toctime']+$sfdata['ptime'];
							$stints[$stints[$stint]['tocfrom']]['pitstops'][myadd($stints[$stints[$stint]['tocfrom']]['lapsdone'],1)]['to'] = $cars[$sfdata['carid']];
							unset($stints[$stints[$stint]['tocfrom']]['toctime']);
						}
					}
					break;
				case FP_PITLANE:	#player enters/leves pitlane
					$stint = $stintplayers[$cars[$sfdata['carid']]];
					if($race_finished===false && $stints[$stint]['finished']===false && $stints[$stint]['inrace']===false && $sfdata['enterbit']==0 && $stints[$stint]['isontrack']===true && $stints[$stint]['unallTOC']!==true) {
						$stints[$stint]['leftpits'] = true;
						$stints[$stint]['wasinrace'] = true;
						$stints[$stint]['inrace'] = true;
						if($teams[$stints[$stint]['team']]['wasinrace'] === true && $racetype!=RACETYPE_QUAL) $stints[$stint]['rejoined'] = true;
						$teams[$stints[$stint]['team']]['wasinrace'] = true;
					}
					break;
				case FP_CARRESET:	#player reset car
					$stint = $stintplayers[$cars[$sfdata['carid']]];
					if($stints[$stint]['inrace']===true) $stints[$stint]['reset'][myadd($stints[$stint]['lapsdone'],1)] .= $stints[$stint]['lastsplit']+1;
					break;
				default:		continue;
			}
		}
		if(is_array($gone)) {
			$gkeys = array_keys($gone);
			sort($gkeys);
			foreach($gkeys as $key) {
				$players[$plids[$gone[$key]]]['playerid'] = '-';
				$players[$plids[$gone[$key]]]['connid'] = '-';
				$oldconnid = $key;
				$oldhighest = array_pop($conns);
				if(in_array($plids[$gone[$key]],$conns)) {
					$conns[$oldconnid] = $oldhighest;
					$players[$oldhighest]['connid'] = $oldconnid;
					if(!empty($stintplayers[$oldhighest])) $stints[$stintplayers[$oldhighest]]['connid'] = $oldconnid;
				}
				unset($plids[$gone[$key]]);
			}
			unset($gone);
		}
	}
}
?>