<?php
#################################################################
# mpres functions.php V2.04-hf																	#
# just some functions used witin the script											#
# directory: /includes																					#
#################################################################
if (!defined('NORMAL_ACCESS')) {header("HTTP/1.1 404 File Not Found");echo "<h1>404 File Not Found</h1>";exit;}

### basic math ###
function myadd($a,$b){return $a+$b;}
function mysub($a,$b){return $a-$b;}
function mymul($a,$b){return $a*$b;}
function mydiv($a,$b){return $a/$b;}

### x-position of a point ###
function getX($x) {
	$x0=1280;
	return $x0 + $x/65536;
}
### y-position of a point ###
function getY($y) {
	$y0=1280;
	return $y0 - $y/65536;
}
### x-position of a boundary point ###
function getOuterX($x,$dx,$a) {
	$x0=1280;
	$xp = $x0 + ($x/65536);
	return $xp + ($dx*cos($a));
}
### y-position of a boundary point ###
function getOuterY($y,$dy,$a) {
	$y0=1280;
	$yp = $y0 - ($y/65536);
	return $yp + ($dy*sin($a));
}
### get rotation angle ###
function getDir($xd,$yd) {
	return atan2($xd,$yd);
}
### rotation angle for direction arrow ###
function getDir2($xd,$yd) {
	return (atan2($xd,$yd)/pi())*180;
}

### get arrow for finish-line ###
function getArrow($x,$y,$dx,$a) {
	$xp = getOuterX($x,$dx,$a);
	$yp = getOuterY($y,$dx,$a);

	if(IMGTYPE == 'png') {
		$points[] = $xp - 15*cos($a);
		$points[] = $yp - 15*sin($a);
		$points[] = $xp + 15*cos($a);
		$points[] = $yp + 15*sin($a);
		$points[] = $xp + 40*cos($a-deg2rad(90));
		$points[] = $yp - 40*sin($a+deg2rad(90));
	}
	elseif(IMGTYPE == 'svg') {
		$points = mysub($xp,mymul(15,cos($a))).",".mysub($yp,mymul(15,sin($a)))." ";
		$points .= myadd($xp,mymul(15,cos($a))).",".myadd($yp,mymul(15,sin($a)))." ";	
		$points .= myadd($xp,mymul(40,cos(mysub($a,deg2rad(90))))).",".mysub($yp,mymul(40,sin(myadd($a,deg2rad(90)))));
	}
	return $points;
}

### convert foreign codepages in names to utf8 ###
function codepage_convert ($str, $conv_to = 'UTF-8') {
	$sets = array ('L' => 'CP1252',			# Latin 1
						'G' => 'ISO-8859-7',		# Greek CP1253?!?!
						'C' => 'CP1251',			# Cyrillic
						'E' => 'ISO-8859-2',		# Central Europe CP1250 ?!?!
						'T' => 'ISO-8859-9',		# Turkish CP1254?!?!
						'B' => 'ISO-8859-13',	# Baltic CP1254?!?!
						'J' => 'SJIS-win',		# Japanese CP932 ?!?!
						'S' => 'CP936',			# Simplified Chinese
						'K' => 'CP949',			# Korean
						'H' => 'CP950'				# Traditional Chinese
				);
	$tr_ptrn = array ("/\^d/", "/\^s/", "/\^c/", "/\^a/", "/\^q/", "/\^t/", "/\^l/", "/\^r/", "/\^v/");
	$tr_ptrn_r = array ("\\", "/", ":", "*", "?", "\"", "<", ">", "|");
	$str = preg_replace ($tr_ptrn, $tr_ptrn_r, $str);

	$newstr = $tmp = '';
	$current_cp = 'L';
	$len = strlen ($str);
	for ($i=0; $i<$len; $i++) {
		if ($str{$i} == '^' && isset ($sets[$str{$i+1}]) && $str{$i-1} != "^") {
			if ($tmp != '') {
				$newstr .= mb_convert_encoding ($tmp, $conv_to, $sets[$current_cp]);
				$tmp = '';
			}
			$current_cp = $str{++$i};
		}
		# Filter out every character below 0x20
		elseif (ord ($str{$i}) > 31) $tmp .= $str{$i};
	}
	if ($tmp != '') $newstr .= mb_convert_encoding ($tmp, $conv_to, $sets[$current_cp]);

	# Final special char to convert - could not do that before codepage conversion
	return str_replace ('^^', '^', $newstr);
}

function getColorCode($col) {
	switch ($col) {
		case 0 : return "#000000";
		case 1 : return "#ff0000";
		case 2 : return "#00ff00";
		case 3 : return "#ffff00";
		case 4 : return "#0000ff";
		case 5 : return "#ff00ff";
		case 6 : return "#00ffff";
		case 7 : return "#ffffff";
		case 8 : return "#000000";
		case 9 : return "#000000";
		default : return "#000000";
	}
}
### strip colors from names ###
function nameblank($name) {
	return stripslashes(preg_replace("/(\^([0-9]))+([^\^]*((\^\^)+[^\^]*)*)/",'$3',htmlspecialchars($name)));
}
#function nameblank($name) {
#	return stripslashes(preg_replace("/\^[0-9]/","",htmlspecialchars($name)));
#}

### get colored names for html-output ###
function namecolored($name) {
	return stripslashes(preg_replace("/(\^([0-9]))+([^\^]*((\^\^)+[^\^]*)*)/e",'"<span style=\"color:".getColorCode($2).";\">$3</span>"',htmlspecialchars($name)));
}
#function namecolored($name) {
#	return stripslashes(preg_replace("/\^([0-9])(.[^\^]*)/e",'"<span style=\"color:".getColorCode($1).";\">$2</span>"',htmlspecialchars($name)));
#}

### check player flags ###
function get_pflags($i,$item) {
	switch($item) {
		case "LH":	if($i & 1) return "X";				# LEFTHANDDRIVE
						break;
		case "AU":	if($i & 8) return "X";				# AUTOGEAR
						break;
		case "SH":	if($i & 16) return "X";				# SHIFTER
						break;
		case "BH":	if($i & 64) return "X";				# BRAKEHELP
						break;
		case "CL":	if($i & 128) return "X";			# AXISCLUTCH
						break;
		case "AC":	if($i & 512) return "X";			# AUTOCLUTCH
						break;
		case "CV":	if($i & 8192) return "X";			# CUSTOM VIEW
						break;
		case "ST":	if($i & 1024) return "M";			# MOUSESTEER
						elseif($i & 2048) return "Kn";	# Keyboard notstailized
						elseif($i & 4096) return "Ks";	# Keyboard stabilized
						else return "W";						# if not 1024, 2048 or 4096, steering is wheel.
						break;
		default:		return "";
	}
}

### get allowed cars ($num=true => return number of allowed cars) ###
function convert_car_bits($bits, $num=false) {
	$data = array();
	if ($bits & 1)			$data[]			= 'XFG';
	if ($bits & 2)			$data[]			= 'XRG';
	if ($bits & 4)			$data[]			= 'XRT';
	if ($bits & 8)			$data[]			= 'RB4';
	if ($bits & 16)		$data[]		= 'FXO';
	if ($bits & 32)		$data[]		= 'LX4';
	if ($bits & 64)		$data[]		= 'LX6';
	if ($bits & 128)		$data[]		= 'MRT';
	if ($bits & 256)		$data[]		= 'UF1';
	if ($bits & 512)		$data[]		= 'RAC';
	if ($bits & 1024)		$data[]		= 'FZ5';
	if ($bits & 2048)		$data[]		= 'FOX';
	if ($bits & 4096)		$data[]		= 'XFR';
	if ($bits & 8192)		$data[]		= 'UFR';
	if ($bits & 16384)	$data[]	= 'FO8';
	if ($bits & 32768)	$data[]	= 'FXR';
	if ($bits & 65536)	$data[]	= 'XRR';
	if ($bits & 131072)	$data[]	= 'FZR';
	if ($bits & 262144)	$data[]	= 'BF1';
	if ($bits & 524288)	$data[]	= 'FBM';
	return ($num===false) ? $data : count($data);
}

function rom2ara($rn) {
	if(is_numeric($rn)) return $rn;
	$roman_values = array('I'=>1,'V'=>5,'X'=>10,'L'=>50,'C'=>100,'D'=>500,'M'=>1000);
	$support_values = array('V','L','D');
	$substractions = array('IV'=>4,'IX'=>9,'XL'=>40,'XC'=>90,'CD'=>400,'CM'=>900);
	$roman_keys = array_keys($roman_values);
	$rn = str_split(strtoupper($rn));
	$an = 0;
	foreach ($rn as $i=>$n) {
		if(!array_key_exists($n,$roman_values)) die('invalid roman number');
		if(count(array_keys($rn,$n))>1 && in_array($n,$support_values)) die('invalid roman number');
		if(count(array_keys($rn,$n))>1 && array_key_exists($n.$rn[$i+1],$substractions)) die('invalid roman number');
		if(array_key_exists($rn[$i-1].$n,$substractions)) continue;
		if(array_key_exists($n.$rn[$i+1],$substractions)) $an += $substractions[$n.$rn[$i+1]];
		else $an += $roman_values[$n];
	}
	return $an;
}
function sort_roman($a, $b) {
	return (rom2ara($a) > rom2ara($b)) ? +1 : -1;
}
function sort_roman_rev($a, $b) {
	return (rom2ara($a) > rom2ara($b)) ? -1 : +1;
}

function sort_bestlap($a, $b) {
	return ($a['bestsectime']['lap'] > $b['bestsectime']['lap']) ? +1 : -1;
}
function sort_firstlap($a, $b) {
	return ($a['sectimes']['lap'][1] > $b['sectimes']['lap'][1]) ? +1 : -1;
}
function sort_lap($a, $b) {
	return ($a['lap'] > $b['lap']) ? +1 : -1;
}
function sort_laptime($a, $b) {
	global $lap;
	return ($a['sectimes']['lap'][$lap] > $b['sectimes']['lap'][$lap]) ? +1 : -1;
}

### get colors for lap-by-lap-table ###
function getcolor($v, $wert) {
	if($v==$wert) return 'lbl100';
	elseif($v<=$wert*1.01) return 'lbl101';
	elseif($v<=$wert*1.03) return 'lbl103';
	elseif($v<=$wert*1.05) return 'lbl105';
	elseif($v<=$wert*1.07) return 'lbl107';
	elseif($v>$wert*1.07) return 'lbl108';
}

### bring times to a well formatted output ###
function printTime($time,$sec=false, $ms=false) {
	# $time in 100th of a second
	# $ms: true =>  $time comes in milliseconds
	# $sec: true => return time in seconds (no minutes or hours)
	# $sec: false=> return hours and/or minutes
	if($ms===true) $time=$time/10;
	if(floor($time/360000)>0 && $sec===false) return sprintf('%dh&#160;%02d:%05.2F', floor($time/360000), floor(($time % 360000)/6000), ($time % 6000)/100);
	elseif(floor($time/6000)>0 && $sec===false) return sprintf('%d:%05.2F', floor($time/6000), ($time % 6000)/100);
	else return sprintf('%.2F', $time/100);
}
### bring times to a well formatted output ###
function printTime2($time,$min=false, $ms=false) {
	# $time in 100th of a second
	# $ms: true =>  $time comes in milliseconds
	# $min: true => return time in minutes (no hours)
	# $sec: false=> return hours and/or minutes
	if($ms===true) $time=$time/10;
	if(floor($time/360000)>0 && $min===false) return sprintf('%dh&#160;%02d:%05.2F', floor($time/360000), floor(($time % 360000)/6000), ($time % 6000)/100);
	elseif(floor($time/6000)>0) return sprintf('%d:%05.2F', floor($time/6000), ($time % 6000)/100);
	else return sprintf('%.2F', $time/100);
}

function getGap($lfsw,$lead=true,$ms=false) {
	global $lang;
	global $playerkeys_finished;
	global $teams;
	if($lead===true){
		if($lfsw==$playerkeys_finished[0]) return printTime($teams[$lfsw]['totaltime'],false,$ms);
		elseif($teams[$lfsw]['totlaps']==$teams[$playerkeys_finished[0]]['totlaps']) {
			return "+&#160;".printTime((($teams[$lfsw]['totaltime']+$teams[$lfsw]['pentime']) - ($teams[$playerkeys_finished[0]]['totaltime']+$teams[$playerkeys_finished[0]]['pentime'])),false,$ms);
		}
		else {
			$gap = "+&#160;".mysub($teams[$playerkeys_finished[0]]['totlaps'],$teams[$lfsw]['totlaps']);
			if(mysub($teams[$playerkeys_finished[0]]['totlaps'],$teams[$lfsw]['totlaps'])>1) $gap .= '&#160;'.$lang['general']['laps'];
			else $gap .= '&#160;'.$lang['general']['lap'];
			return $gap;
		}
	}
	else {
		if($lfsw==$playerkeys_finished[0]) return '---';
		elseif($teams[$lfsw]['totlaps']==$teams[$playerkeys_finished[mysub(array_search($lfsw,$playerkeys_finished),1)]]['totlaps']) {
			return "+ ".printTime((($teams[$lfsw]['totaltime']+$teams[$lfsw]['pentime']) - ($teams[$playerkeys_finished[mysub(array_search($lfsw,$playerkeys_finished),1)]]['totaltime']+$teams[$playerkeys_finished[mysub(array_search($lfsw,$playerkeys_finished),1)]]['pentime'])),false,$ms);
		}
		else {
			$gap = "+&#160;".mysub($teams[$playerkeys_finished[mysub(array_search($lfsw,$playerkeys_finished),1)]]['totlaps'],$teams[$lfsw]['totlaps']);
			if(mysub($teams[$playerkeys_finished[mysub(array_search($lfsw,$playerkeys_finished),1)]]['totlaps'],$teams[$lfsw]['totlaps'])>1) $gap .='&#160;'.$lang['general']['laps'];
			else $gap .= '&#160;'.$lang['general']['lap'];
			return $gap;
		}
	}
}
function getQualGap($lfsw,$lead=true,$ms=false) {
	global $playerkeys;
	global $teams;
	$leadid = 0;
	foreach($playerkeys as $id => $key) {
		if($teams[$key]['lapsdone']<1) continue;
		else {
			$leadid = $id;
			break;
		}
	}
	if($lead===true){
		if($lfsw==$playerkeys[$leadid]) return printTime($teams[$lfsw]['bestsectime']['lap'],false,$ms);
#		if($lfsw==$playerkeys[$leadid]) return '---';
		else {
			return "+&#160;".printTime(($teams[$lfsw]['bestsectime']['lap'] - $teams[$playerkeys[$leadid]]['bestsectime']['lap']),false,$ms);
		}
	}
	else {
		if($lfsw==$playerkeys[$leadid]) return '---';
		else {
			return "+&#160;".printTime(($teams[$lfsw]['bestsectime']['lap'] - $teams[$playerkeys[mysub(array_search($lfsw,$playerkeys),1)]]['bestsectime']['lap']),false,$ms);
		}
	}
}

function get_secgap($sectime, $type, $ptb=NULL) {
	global $bestseclaps;

	switch($type) {
		case 1: return ($sectime==$bestseclaps[1]) ? '---' : printTime($sectime-$bestseclaps[1],true);
			break;
		case 2: return ($sectime==$bestseclaps[2]) ? '---' : printTime($sectime-$bestseclaps[2],true);
			break;
		case 3: return ($sectime==$bestseclaps[3]) ? '---' : printTime($sectime-$bestseclaps[3],true);
			break;
		case 4: return ($sectime==$bestseclaps[4]) ? '---' : printTime($sectime-$bestseclaps[4],true);
			break;
		case 'lap': return ($sectime==$bestseclaps['lap']) ? '---' : printTime($sectime-$bestseclaps['lap'],true);
			break;
		case 'tpb': return ($sectime==$ptb) ? '---' : printTime($sectime-$ptb,true);
			break;
		default: return '';
	}

}

function get_teamsecgap($sectime, $reftime) {
	return ($sectime==$reftime) ? '---' : printTime($sectime-$reftime,true);
}

### did player start race from the grid? ###
function getStartpos($startpos) {
	if($startpos==0) return '-';
	else return $startpos;
}

### get open penalties at race end ###
function getPenalty($pen, $res=false) {
	global $lang;

	if($res==true && ($pen=='00' || $pen=="")) return '-';
	else {
	if($pen=="") return '';
		switch($pen{0}) {
			case 0:  $type = "";
				break;
			case 1:  $type = $lang['pens']['DT'];
				break;
			case 2:  $type = $lang['pens']['DT'];
				break;
			case 3:  $type = $lang['pens']['SG'];
				break;
			case 4:  $type = $lang['pens']['SG'];
				break;
			case 5:  $type = $lang['pens']['30s'];
				break;
			case 6:  $type = $lang['pens']['45s'];
				break;
			default:  $type = "";
		}
		switch($pen{1}) {
			case 0:  $reason = " ".$lang['pens']['cleared'];
				break;
			case 1:  $reason = " ".$lang['pens']['admin'];
				break;
			case 2:  $reason = " ".$lang['pens']['wrongway'];
				break;
			case 3:  $reason = " ".$lang['pens']['falsestart'];
				break;
			case 4:  $reason = " ".$lang['pens']['speeding'];
				break;
			case 5:  $reason = " ".$lang['pens']['shortSG'];
				break;
			case 6:  $reason = " ".$lang['pens']['latepit'];
				break;
			default:  $reason = "";
		}
		$res = $type.$reason;
		return $res;
	}
}
# get penalties for alternate results table ... not finished yet #
function getPenalty2($open, $clear) {
	if(empty($clear) && ($open=='00' || $open=="")) return '-';
	else {
		$pen = '';
		$pens = str_split($clear,2);
		foreach ($pens as $pty) $pen .= ', <span style="color:green;">'.getPenalty($pty).'</span>';
		if($open!='00' && $open!="")$pen .= ', <span style="color:red;">'.getPenalty($open).'</span>';
		$pen = substr($pen,2);
		return $pen;
	}
}

#scan files
function scan_files($t=null,$e=null) {
	global $events;
	if(empty($events)) return false;
	$files = array();

	if(!empty($t) && is_array($events[$t])) {
		foreach($events[$t] as $short => $event) {
			if($short!=$e) continue;
			if(is_array($event['seasons'])) {
				foreach($event['seasons'] as $season => $data) {
		#			if(!empty($s) && $season!=$s) continue;
					$mprfiles = glob($data['dir'].'*.mpr');
					if($mprfiles) foreach($mprfiles as $file) {
						unset($matches);
						preg_match("#".$data['replay_prefix']."(([0-9]+)_)?(g([0-9]+)_)?([qrs][0-9]?)\.mpr$#",$file,$matches);
						$day = (empty($matches[2])) ? 0 : $matches[2];
						$grid = (empty($matches[4])) ? 0 : $matches[4];
						$session = $matches[5];
						if(!empty($matches)) $files[$t][$short][$season][$day][$grid][$session] = $file;
					}
					if(is_array($files[$t][$short][$season])) uksort($files[$t][$short][$season], sort_roman_rev);
				}
			}
			if(is_array($files[$t][$short])) uksort($files[$t][$short], sort_roman_rev);
		}
	}
	if(is_array($files[$t])) ksort($files[$t], SORT_STRING);

	if(empty($files)) return false;
	return $files;
}

#get tracklength
function get_tracklength ($track, $v=null) {
	$pthdir ='pth/';
	$pthlen = strlen($pthdir);
	$pthvers = glob($pthdir.'*', GLOB_ONLYDIR);
	rsort($pthvers, SORT_STRING);
	$actpth = (in_array($pthdir.$v,$pthvers)) ? $pthdir.$v.'/' : null;
	if(!$actpth) {
		foreach($pthvers as $ver) {
			if(floatval(substr($ver,$pthlen,3))<floatval(substr($v,0,3))) {
				$actpth = $ver.'/';
				break;
			}
			elseif(floatval(substr($ver,$pthlen,3))>floatval(substr($v,0,3))) continue;
			elseif(ord($ver{3+$pthlen})>ord($v{3})) continue;
			elseif(ord($ver{3+$pthlen})==ord($v{3}) && intval(substr($ver,4+$pthlen))>intval(substr($v,4))) continue;
			else {
				$actpth = $ver.'/';
				break;
			}
		}
	}
	### Datei einlesen ###
	if(!file_exists($actpth.$track.'.pth')) return 0;
	$handle = fopen ($actpth.$track.'.pth', "rb");
	$filesize = filesize ($actpth.$track.'.pth');
	$contents = fread ($handle,$filesize);
	fclose ($handle);
	### PTH auslesen ###
	$os = 0;
	$i = 0;
	$string ='';
	while($i<16) {
		$string .= $contents{$os+$i};
		$i++;
	}
	$pthheader = unpack("@0/a6LFSPTH/Cversion/Crevision/Lnumnodes/Lfinishline",$string);
	$os = 16;
	$n=0;
	while ($n<$pthheader['numnodes']) {
		$i = 0;
		$string ='';
		while($i<40) {
			$string .= $contents{$os+$i};
			$i++;
		}
		$pthdata[$n] = unpack("@0/icentreX/icentreY/icentreZ/x28",$string);
		$os += 40;
		$n++;
	}
	### Streckenlänge ermitteln ###
	foreach($pthdata as $id => $point) {
		if(isset($pthdata[$id+1])) {
			$dx2 = pow(($pthdata[$id+1]['centreX'] - $pthdata[$id]['centreX'])/65536,2);
			$dy2 = pow(($pthdata[$id+1]['centreY'] - $pthdata[$id]['centreY'])/65536,2);
			$dz2 = pow(($pthdata[$id+1]['centreZ'] - $pthdata[$id]['centreZ'])/65536,2);
			$ds += sqrt($dx2 + $dy2 + $dz2);
		}
		else {
			$dx2 = pow(($pthdata[0]['centreX'] - $pthdata[$id]['centreX'])/65536,2);
			$dy2 = pow(($pthdata[0]['centreY'] - $pthdata[$id]['centreY'])/65536,2);
			$dz2 = pow(($pthdata[0]['centreZ'] - $pthdata[$id]['centreZ'])/65536,2);
			$ds += sqrt($dx2 + $dy2 + $dz2);
		}
	}
	return $ds;
}

function getevents($file) {
	$tvartypes = array('short', 'name', 'headlink', 'headlogo');
	$svartypes = array('number', 'dir', 'replay_prefix', 'daterange', 'logo', 'toc', 'maxleavelaps', 'minracepart', 'keeplapsonrejoin', 'rejoinpenlaps', 'appendunfinished', 'safetycarstart');
	$events = array('league'=>array(), 'single'=>array());
	if(empty($file) || !file_exists($file)) return $events;
	$lines = array_map('trim',@file($file));
	if(is_array($lines) && !empty($lines)) foreach($lines as $line) {
		unset($currline);
		if(empty($line) || $line{0}==';') continue;
		if($line=='### league ###') $type = 'league';
		elseif($line=='### single ###') $type = 'single';
		elseif($line=='+++ global +++') {
			foreach($tvartypes as $var) unset(${$var});
		}
		elseif($line=='--- global ---'){
			if(isset($type)) foreach($tvartypes as $var) {
				if($var!='short' && isset($short)) $events[$type][$short][$var] = (isset(${$var})) ? ${$var} : null;
			}
		}
		elseif($line=='+++ season +++') {
			foreach($svartypes as $var) unset(${$var});
		}
		elseif($line=='--- season ---') {
			if(isset($type) && isset($short)) foreach($svartypes as $var) {
				if($var!='number' && isset($number)) $events[$type][$short]['seasons'][$number][$var] = (isset(${$var})) ? ${$var} : null;
			}
		}
		else $currline = array_map('trim', explode(':', $line));
		if(isset($currline)) {
			if(count($currline)>2 && $currline[1]=='http' && substr($currline[2],0,2)=='//') {
				$currline[1] .= ':'.$currline[2];
				unset($currline[2]);
			}
			if($currline[0]=='dir' && !in_array(substr(str_replace('\\', '/', $currline[1]),-1), array('/','\\'))) $currline[1] = str_replace('\\', '/', $currline[1]).'/';
			elseif($currline[0]=='dir') $currline[1] = str_replace('\\', '/', $currline[1]);
			elseif((ctype_digit($currline[1]) || $currline[1]>1) && $currline[0]!='daterange') $currline[1] = intval($currline[1],10);
			elseif(is_numeric($currline[1]) && $currline[0]!='daterange') $currline[1] = floatval($currline[1]);
			elseif($currline[1]=='true' || $currline[1]=='false') $currline[1] = filter_var($currline[1], FILTER_VALIDATE_BOOLEAN);
			${$currline[0]} = $currline[1];
		}
	}
	return $events;
}

function playerurl($lfsw,$nick) {
	if(substr($lfsw,0,14)=='AIBOTdummyname') return "<span title=\"AI\">".namecolored($nick)."</span>";
	elseif(substr($lfsw,0,13)=='demodummyname') return "<span title=\"DEMO\">".namecolored($nick)."</span>";
	else return "<a href=\"http://lfsworld.com/?win=stats&amp;racer=".urlencode(utf8_decode($lfsw))."\">".namecolored($nick)."</a>";

}

function getmprdates($file) {
	$files = array();
	if(empty($file) || !file_exists($file)) return $names;
	$lines = array_map('trim',@file($file));
	if(is_array($lines) && !empty($lines)) foreach($lines as $line) {
		unset($currline);
		unset($data);
		if(empty($line) || $line{0}==';') continue;
		$currline = array_map('trim', explode(':', $line));
		$data = explode('|', $currline[1]);
		if(is_array($data) && !empty($data)) $files[$currline[0]] = array('date'=>$data[0], 'track'=>$data[1], 'car'=>$data[2], 'length'=>$data[3]);
	}
	return $files;
}

function addmprdate($file,$mpr) {
	$mprname = basename($mpr);
	$mprpath = dirname(realpath(SCRIPTPATH.$mpr)).DS;
	$handle = @fopen($mprpath.$mprname, "rb");
	$header = fread($handle,80);
	$mprheader = unpack("@0/x12/Vallowedcars/x4/Claphours/x11/a4shorttrack/Lstarttime/x40",$header);
	file_put_contents($file, $mpr.':'.$mprheader['starttime'].'|'.strtok($mprheader['shorttrack'],"\0").'|'.$mprheader['allowedcars'].'|'.$mprheader['laphours']."\n", FILE_APPEND);
	return getmprdates($file);
}

function getlanguage($config, $browser=null, $user=null, $showlang=0) {
	$blangs = $vlangs = $langs = array();
	# get a list of valid languages, give language set in config highest priority
	foreach(glob(SCRIPTPATH.'lang/*.ini') as $langfile) $vlangs[] = basename($langfile, '.ini');
	if(in_array('en', $vlangs)) {
			unset($vlangs[array_search('en', $vlangs)]);
			array_unshift($vlangs, 'en');
	}
	if(in_array($config, $vlangs)) {
			unset($vlangs[array_search($config, $vlangs)]);
			array_unshift($vlangs, $config);
	}
	# check user's browser for language settings, include cookies if present
	$pattern = '/([[:alpha:]]{2})(?:-[[:alpha:]]{2}|)(?:;q=([[:digit:]\.]*)|())/i';
	$result = preg_match_all($pattern, $browser, $langDefs,	PREG_SET_ORDER);
	if(!empty($langDefs)) foreach($langDefs as $langDef){
			list($match, $lang, $prio) = $langDef;
			$prio = (float) (($prio=='') ? 1 : $prio);
			$langs[$lang] = (isset($lang, $langs[$lang])) ? max($langs[$lang], $prio) : $prio;
	}
	if(isset($user)) $langs[$user] = 1.1;
	if(!empty($langs)) {
			arsort($langs);
			$langprefs = array_keys($langs);
			# choose language
			$lang = array_shift(array_intersect($langprefs, $vlangs));
	}
	$langfile = (is_null($lang)) ? SCRIPTPATH.'lang/'.array_shift($vlangs).'.ini' : SCRIPTPATH.'lang/'.$lang.'.ini';
	# load language variables
	if($showlang==1) return (is_null($lang)) ? array_shift($vlangs) : $lang;
	else return parse_ini_file($langfile, true);
}
function getteams($file) {
	$tvartypes = array('number', 'name', 'car');
	$teams = array();
	$t = 1;
	if(empty($file) || !file_exists($file)) return $events;
	$lines = array_map('trim',@file($file));
	if(is_array($lines) && !empty($lines)) foreach($lines as $line) {
		unset($currline);
		if(empty($line) || $line{0}==';') continue;
		if($line=='### team ###') {
			foreach($tvartypes as $var) unset(${$var});
			unset($tn);
		}
		elseif($line=='+++ drivers +++') {
			$drivers = array();
			if(isset($number) && !array_key_exists('t'.$number,$teams)) {
				$tn = 't'.$number;
			}
			else {
				while(array_key_exists('t'.$t,$teams)) $t++;
				$tn = 't'.$t;
			}
			foreach($tvartypes as $var) {
				if($var!='number') $teams[$tn][$var] = (isset(${$var})) ? ${$var} : null;
			}
		}
		elseif($line=='--- drivers ---') {
			if(isset($drivers) && isset($tn)) foreach($drivers as $lfsw) {
				$lfsw = (@iconv('UTF-8','UTF-8',$lfsw) === $lfsw) ? strtolower($lfsw) : codepage_convert(strtolower($lfsw));
				$teams[$tn]['drivers'][] = codepage_convert(strtolower(utf8_decode($lfsw)));
			}
			unset($drivers);
		}
		elseif(isset($drivers)) $drivers[] = trim($line);
		else $currline = array_map('trim', explode(':', $line));
		if(isset($currline)) {
			if(is_numeric($currline[1]) && $currline[0]=='number') $currline[1] = intval($currline[1]);
			${$currline[0]} = $currline[1];
		}
	}
	foreach($teams as $id => $team) if(empty($team['car']) || empty($team['drivers'])) unset($teams[$id]);
	return $teams;
}
?>