<?php
#################################################################
# mpres graphs_png.php V2.02																		#
# produces race graphs in png format														#
# directory: script main path																		#
#################################################################
define('NORMAL_ACCESS', null);
error_reporting(E_ERROR | E_WARNING | E_PARSE);
### a sort function ###
function _compSTime($a, $b) {
	global $lap,$s;
	return ($a['sectimes'][$s][$lap] > $b['sectimes'][$s][$lap]) ? +1 : -1;
}
function getpentagonpoints($x,$y) {
		$poly = array($x, $y-7, $x-7, $y-1, $x-5, $y+7, $x+5, $y+7, $x+7, $y-1);
		return $poly;
}
function gettrispoints($x,$y) {
		$poly = array($x, $y-4, $x-5, $y+5, $x+5, $y+5);
		return $poly;
}

require_once('global.inc.php');
if(GOT_RESULT === false) exit;
if($racetype==RACETYPE_QUAL) exit;

$unifont = SCRIPTPATH.'fonts/'.$unifont;

### define graphtype to display ###
$allowed_graphtypes = array(GRAPH_BLG, GRAPH_PLR, GRAPH_RPG, GRAPH_PAVG);	# 1: lap-by-lap, 2: player-graph, 3: race-progress
$graphtype = (isset($_GET['graphtype']) && in_array($_GET['graphtype'],$allowed_graphtypes)) ? $_GET['graphtype'] : 1;

if($graphtype==GRAPH_BLG) $gt = 'blg';
if($graphtype==GRAPH_PLR) $gt = 'plg';
if($graphtype==GRAPH_RPG) $gt = 'rpg';
if($graphtype==GRAPH_PAVG) $gt = 'pavg';
$gpl = (isset($_GET['plyrs'])) ? '_'.$_GET['plyrs'] : '';
$gpy = (isset($_GET['player']) && ($graphtype==GRAPH_PLR || $graphtype==GRAPH_PAVG)) ? '_'.$_GET['player'] : '';
$gsi = (isset($_GET['size'])) ? '_si'.intval($_GET['size']) : '';
$gmg = (isset($_GET['maxgap'])) ? '_mg'.intval($_GET['maxgap']) : '';
$olang = getlanguage(OUTLANG, $_SERVER['HTTP_ACCEPT_LANGUAGE'], $ulang, 1);
$graphfile = './images/rendered/graphs/'.$gt.'/'.$gettype.'_'.$getevent.'_'.$getseason.'_R'.$getday.'_G'.$getgrid.'_'.$getsession.'_'.$gt.$gsi.$gmg.'_'.$olang.$gpl.$gpy.'.png';


if(!is_file($graphfile)) {
$player = (isset($_GET['player']) && array_key_exists(mysub($_GET['player'],1),$playerkeys_finished)) ? $_GET['player'] : '';

### set max namewidth & count listed players ###
$maxnamewidth = 0;
$pcount = count($teams);
foreach ($teams as $lfsw=>$data) {
	$car = (convert_car_bits($mprheader['allowedcars'],true)>1) ? ' ('.$teams[$lfsw]['car'].')' : '';
	$name = (count($teams[$lfsw]['drivers'])==1 && $istoc===false) ? html_entity_decode(nameblank($teams[$lfsw]['drivers'][substr($lfsw,1)]['nick'])).$car : html_entity_decode(nameblank($teams[$lfsw]['name'])).$car;
	$bbox = imagettfbbox(10, 0, $unifont, $name);
	$namewidth = $bbox[2]-$bbox[0];
	if($maxnamewidth<$namewidth) $maxnamewidth = $namewidth;
}

### some length variables ###
$secwidth = 10;
$nameoffset = 20;
$nameextra = 20;
$posheight = 30;
$topoffset = 15;
$bottomoffset = 60;
$legendoffset = 20;

### offsets for legend ###
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['exit']);
$exitwidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['penalty']);
$penaltywidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['pitstop']);
$stopwidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['toc']);
$tocwidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['damage']);
$damagewidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['wheel']);
$tyrewidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['rejoin']);
$rejoinwidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['lapped']);
$lappedwidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['yellow']);
$yellowwidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['blue']);
$bluewidth = $bbox[2]-$bbox[0];

$epwidth = ($exitwidth>=$penaltywidth) ? $exitwidth : $penaltywidth;
$ptwidth = ($stopwidth>=$tocwidth) ? $stopwidth : $tocwidth;
$dtwidth = ($damagewidth>=$tyrewidth) ? $damagewidth : $tyrewidth;
$rlwidth = ($rejoinwidth>=$lappedwidth) ? $rejoinwidth : $lappedwidth;
$ybwidth = ($yellowwidth>=$bluewidth) ? $yellowwidth : $bluewidth;

$eppos = $nameoffset;
$ptpos = $eppos+$epwidth+35;
$dtpos = $ptpos+$ptwidth+35;
$rlpos = $dtpos+$dtwidth+35;
$ybpos = $rlpos+$rlwidth+35;


switch($graphtype) {
	###lap by lap graph ###
	case GRAPH_BLG:
		### create image & set some colors ###
		if($ybpos+$ybwidth>($maxlapsdone*$secwidth*$sectors)+2*($maxnamewidth+$nameoffset+$nameextra)) $secwidth = ($ybpos+$ybwidth -2*($maxnamewidth+$nameoffset+$nameextra))/($maxlapsdone*$sectors);
		$width = ($maxlapsdone*$secwidth*$sectors)+2*($maxnamewidth+$nameoffset+$nameextra);
		$height = (($pcount+1)*$posheight)+$topoffset+$bottomoffset;
		$im = imagecreate($width, $height);
#die(print($width));
		$colid = sscanf($col[0], '#%2x%2x%2x');
		$background_color = imagecolorallocate($im,$colid[0],$colid[1],$colid[2]);
		$lapcol	= imagecolorallocate($im, 178, 178, 178);
		$black	= imagecolorallocate($im,   0,   0,   0);
		$grey		= imagecolorallocate($im, 220, 220, 220);
		$white	= imagecolorallocate($im, 255, 255, 255);
		$red		= imagecolorallocate($im, 255,   0,   0);
		$blue		= imagecolorallocate($im,   0,   0, 255);
		$yellow	= imagecolorallocate($im, 255, 255,   0);

		### set startpos ###
		foreach ($teams as $lfsw=>$data) {
			if(isset($data['startpos'])) $teams[$lfsw]['rank'][0] = $data['startpos']+1;
			else $teams[$lfsw]['rank'][0] = ++$mprheader['startplayers'];
		}
		### set positions & lappings for each split ###
		$i=1;
		$lapped = array();
		for($lap=1; $lap<=$maxlapsdone; $lap++) {
			for($s=1; $s<=$sectors; $s++) {
				uasort($teams, "_compSTime");
				$playerkeys = array_keys($teams);
				$pl=1;
				foreach ($teams as $lfsw=>$data) {
					if($pl==1) $leader = $lfsw;
					if((isset($teams[$leader]['sectimes'][$s][$lap+1]) && $teams[$leader]['sectimes'][$s][$lap+1]<=$data['sectimes'][$s][$lap]) && !isset($lapped[$i])) $lapped[$i] = $pl;
					if($data['sectimes'][$s][$lap]) $teams[$lfsw]['rank'][$i] = $pl++;
				}
				$i++;
			}
		}
		### resort players array ###
		unset($ldone);
		unset($ttime);
		unset($fin);
		foreach ($teams as $lfsw => $data) {
			$ldone[$lfsw] = $data['totlaps'];
			$ttime[$lfsw] = $data['tottime'];
			$fin[$lfsw] = $teams[$lfsw]['finished'];
		}
		array_multisort($fin, SORT_DESC, $ldone, SORT_DESC, $ttime, SORT_ASC, $teams);
		$playerkeys = array_keys($teams);
		### select players to draw ###
		if(isset($_GET['plyrs'])) {
			$plyrs = explode("_",$_GET['plyrs']);
			foreach ($plyrs as $plyr) if(array_key_exists($plyr,$playerkeys)) $showpids[$plyr] = $playerkeys[$plyr];
		}


		### put bars for lapped players ###
		foreach($lapped as $split=>$pos) {
			imagefilledrectangle ($im, $maxnamewidth+$nameoffset+$nameextra-$secwidth+($secwidth*($split+1))-($secwidth/2), $height-$bottomoffset, $maxnamewidth+$nameoffset+$nameextra-$secwidth+($secwidth*($split+1))+($secwidth/2), $pos*$posheight, $lapcol);
		}

		### put position-lines ###
		imagesetthickness ($im, 1);
		$i=1;
		do {
			imageline($im, $maxnamewidth+$nameoffset+$nameextra, ($i)*$posheight+($posheight/2), $width-$maxnamewidth-($nameoffset+$nameextra), ($i)*$posheight+($posheight/2), $grey);
		} while(++$i<=$pcount);

		### put split- & laplines, lap-numbers, start, finish ###
		$i=1;
		do {
			# lap
			if($i % $sectors == 0) imageline($im, ($i*$secwidth)+$maxnamewidth+$nameoffset+$nameextra, $topoffset, ($i*$secwidth)+$maxnamewidth+$nameoffset+$nameextra, $height-$bottomoffset, $black);
			# split
			else imageline($im, ($i*$secwidth)+$maxnamewidth+$nameoffset+$nameextra, $topoffset, ($i*$secwidth)+$maxnamewidth+$nameoffset+$nameextra, $height-$bottomoffset, $grey);
			# lap number above
			if(($sectors+1)&1 && $i % $sectors == $sectors/2) imagestring($im, 2, ($i*$secwidth)+$maxnamewidth+$nameoffset+$nameextra-4, 1, ceil($i/$sectors), $black);
			elseif($sectors&1 && $i % $sectors == ($sectors-1)/2 ) imagestring($im, 2, ($i*$secwidth)+5+$maxnamewidth+$nameoffset+$nameextra-4, 1, ceil($i/$sectors), $black);
			# lap number below
			if(($sectors+1)&1 && $i % $sectors == $sectors/2) imagestring($im, 2, ($i*$secwidth)+$maxnamewidth+$nameoffset+$nameextra-4, $height-$bottomoffset+1, ceil($i/$sectors), $black);
			elseif($sectors&1 && $i % $sectors == ($sectors-1)/2 ) imagestring($im, 2, ($i*$secwidth)+5+$maxnamewidth+$nameoffset+$nameextra-4, $height-$bottomoffset+1, ceil($i/$sectors), $black);
		} while (++$i<=$maxlapsdone*$sectors);
		imagestring($im, 4, 40, 1, $lang['general']['start'], $black);
		imagestring($im, 4, ($maxlapsdone*$secwidth*$sectors)+$maxnamewidth+$nameoffset+$nameextra+25, 1, $lang['general']['finish'], $black);

		### put axes ###
		imagesetthickness ($im, 2);
		imageline($im, $maxnamewidth+$nameoffset+$nameextra, $topoffset,	$width-$maxnamewidth-($nameoffset+$nameextra), $topoffset, $black);
		imageline($im, $maxnamewidth+$nameoffset+$nameextra, $height-$bottomoffset, $width-$maxnamewidth-($nameoffset+$nameextra), $height-$bottomoffset, $black);
		imageline($im, $maxnamewidth+$nameoffset+$nameextra, $topoffset, $maxnamewidth+$nameoffset+$nameextra, $height-$bottomoffset, $black);
		imageline($im, $width-$maxnamewidth-($nameoffset+$nameextra), $topoffset,	$width-$maxnamewidth-($nameoffset+$nameextra), $height-$bottomoffset, $black);

		### make legend ###
		### Exit ###
		imagesetthickness ($im, 1);
		imagefilledrectangle ($im, $eppos-4, $height-$legendoffset-20, $eppos-4+16, $height-$legendoffset-20+16, $white);
		imagerectangle ($im, $eppos-4, $height-$legendoffset-20, $eppos-4+16, $height-$legendoffset-20+16, $black);
		imagettftext ($im, 11, 0, $eppos, $height-$legendoffset-6, $black, $unifont, $lang['graph']['E']);
		imagettftext ($im, 11, 0, $eppos+16, $height-$legendoffset-6, $black, $unifont, $lang['graph']['exit']);
		### Penlaps ###
		imagesetthickness ($im, 1);
		imagefilledrectangle ($im, $eppos-4, $height-$legendoffset, $eppos-4+16, $height-$legendoffset+16, $white);
		imagerectangle ($im, $eppos-4, $height-$legendoffset, $eppos-4+16, $height-$legendoffset+16, $black);
		imagettftext ($im, 11, 0, $eppos, $height-$legendoffset+14, $black, $unifont, $lang['graph']['Pen']);
		imagettftext ($im, 11, 0, $eppos+16, $height-$legendoffset+14, $black, $unifont, $lang['graph']['penalty']);
		### pitstop ###
		imagefilledellipse ($im, $ptpos+4, $height-$legendoffset-12, 17, 17, $white);
		imageellipse ($im, $ptpos+4, $height-$legendoffset-12, 17, 17,$black);
		imagettftext ($im, 11, 0, $ptpos, $height-$legendoffset-6, $black, $unifont, $lang['graph']['P']);
		imagettftext ($im, 11, 0, $ptpos+16, $height-$legendoffset-6, $black, $unifont, $lang['graph']['pitstop']);
		### pitstop + TOC ###
		imagefilledellipse ($im, $ptpos+4, $height-$legendoffset+8, 17, 17, $white);
		imageellipse ($im, $ptpos+4, $height-$legendoffset+8, 17, 17,$black);
		imagettftext ($im, 11, 0, $ptpos, $height-$legendoffset+14, $black, $unifont, $lang['graph']['T']);
		imagettftext ($im, 11, 0, $ptpos+16, $height-$legendoffset+14, $black, $unifont, $lang['graph']['toc']);
		### engine ###
		imagefilledpolygon($im, getpentagonpoints($dtpos,$height-$legendoffset-12), 5, $white);
		imagepolygon($im, getpentagonpoints($dtpos,$height-$legendoffset-12), 5, $black);
		imagettftext($im, 9, 0, $dtpos-4, $height-$legendoffset-6, $black, $unifont, $lang['graph']['D']);
		imagettftext ($im, 11, 0, $dtpos+16, $height-$legendoffset-6, $black, $unifont, $lang['graph']['damage']);
		### tyre ###
		imagefilledpolygon($im, getpentagonpoints($dtpos,$height-$legendoffset+8), 5, $white);
		imagepolygon($im, getpentagonpoints($dtpos,$height-$legendoffset+8), 5, $black);
		imagettftext($im, 9, 0, $dtpos-4, $height-$legendoffset+14, $black, $unifont, $lang['graph']['W']);
		imagettftext ($im, 11, 0, $dtpos+16, $height-$legendoffset+14, $black, $unifont, $lang['graph']['wheel']);
		### rejoin ###
		imagefilledpolygon($im, gettrispoints($rlpos,$height-$legendoffset-12), 3, $black);
		imagettftext ($im, 11, 0, $rlpos+16, $height-$legendoffset-6, $black, $unifont, $lang['graph']['rejoin']);
		### lapped ###
		imagefilledrectangle ($im, $rlpos-8, $height-$legendoffset-4, $rlpos+12, $height-$legendoffset+16, $lapcol);
		imagettftext ($im, 11, 0, $rlpos+16, $height-$legendoffset+14, $black, $unifont, $lang['graph']['lapped']);
		### yellow flags ###
		imagefilledellipse ($im, $ybpos, $height-$legendoffset-10, 10, 10, $yellow);
		imageellipse ($im, $ybpos, $height-$legendoffset-10, 10, 10, $black);
		imagettftext ($im, 11, 0, $ybpos+12, $height-$legendoffset-6, $black, $unifont, $lang['graph']['yellow']);
		### blue flags ###
		imagefilledellipse ($im, $ybpos, $height-$legendoffset+10, 10, 10, $blue);
		imageellipse ($im, $ybpos, $height-$legendoffset+10, 10, 10, $black);
		imagettftext ($im, 11, 0, $ybpos+12, $height-$legendoffset+14, $black, $unifont, $lang['graph']['blue']);

		### draw each player's lines ###
		$id=0;
		$font = imageloadfont("fonts/aums.gdf");
		foreach ($teams as $lfsw=>$data) {
			### set color
			$car = (convert_car_bits($mprheader['allowedcars'],true)>1) ? ' ('.$teams[$lfsw]['car'].')' : '';
			$name = (count($teams[$lfsw]['drivers'])==1 && $istoc===false) ? html_entity_decode(nameblank($teams[$lfsw]['drivers'][substr($lfsw,1)]['nick'])).$car : html_entity_decode(nameblank($teams[$lfsw]['name'])).$car;
			$colid = sscanf($col[myadd(1,$id++)], '#%2x%2x%2x');
			$color = imagecolorallocate($im,$colid[0],$colid[1],$colid[2]);
			### skip player if not selected
			if (!empty($showpids) && !in_array($lfsw,$showpids)) continue;
			# name left
			imagettftext($im, 10, 0, $nameoffset, $data['rank'][0]*$posheight+10, $black, $unifont, $name);
			# line on the left
			imagefilledrectangle ($im, $nameoffset, $data['rank'][0]*$posheight+($posheight/2)-1, $maxnamewidth+40, $data['rank'][0]*$posheight+($posheight/2), $color );
			# name right
			imagettftext($im, 10, 0, ($maxlapsdone*$secwidth*$sectors)+$maxnamewidth+$nameoffset+$nameextra+5, $id*$posheight+10, $black, $unifont, $name);
			# line on the right
			imagefilledrectangle ($im, ($maxlapsdone*$secwidth*$sectors)+$maxnamewidth+$nameoffset+$nameextra, $id*$posheight+($posheight/2)-1, ($maxlapsdone*$secwidth*$sectors)+2*$maxnamewidth+$nameoffset+$nameextra+5, $id*$posheight+($posheight/2), $color );
			# startpos
			if(isset($teams[$lfsw]['startpos'])) imagestring($im, 4, 1, $data['rank'][0]*$posheight+5, $data['rank'][0], $black);
			else imagestring($im, 4, 1, $data['rank'][0]*$posheight+5, $lang['graph']['P'], $black);
			# race result (position)
			if($data['DQ']==1) imagestring($im, 3, ($maxlapsdone*$secwidth*$sectors)+2*$maxnamewidth+$nameoffset+$nameextra+20, ($id)*$posheight+5,  $lang['general']['DQ'], $black);
			elseif($data['finished']===true) imagestring($im, 4, ($maxlapsdone*$secwidth*$sectors)+2*$maxnamewidth+$nameoffset+$nameextra+20, ($id)*$posheight+5, $id, $black);
			elseif(($teams[$lfsw]['lapsdone']<floor($maxlapsdone*$minracepart))) imagestring($im, 3, ($maxlapsdone*$secwidth*$sectors)+2*$maxnamewidth+$nameoffset+$nameextra+20, ($id)*$posheight+5, $lang['general']['DNF'], $black);
			else imagestring($im, 4, ($maxlapsdone*$secwidth*$sectors)+2*$maxnamewidth+$nameoffset+$nameextra+20, ($id)*$posheight+5, $id.'†', $black);
			# draw the line
			imagesetthickness ($im, 2);
			foreach ($data['rank'] as $split=>$rank) {
				### player in race -> draw full line ###
				imagesetthickness  ($im  , 2);
				if($data['rank'][$split+1]) imageline($im, $maxnamewidth+$nameoffset+$nameextra+($secwidth*$split),$rank*$posheight+($posheight/2),$maxnamewidth+$nameoffset+$nameextra+($secwidth*($split+1)),$data['rank'][$split+1]*$posheight+($posheight/2), $color);
				### player left race ###
				if(!$data['rank'][$split+1] && $data['finished']===false) {
					imagesetthickness  ($im  , 1);
					imagefilledrectangle($im,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split)-8, $rank*$posheight+($posheight/2)-8,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split)+8, $rank*$posheight+($posheight/2)+8,$white);
					imagerectangle($im,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split)-8, $rank*$posheight+($posheight/2)-8,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split)+8, $rank*$posheight+($posheight/2)+8,$color);
					imagesetthickness  ($im  , 3);
					imagettftext($im, 11, 0, $maxnamewidth+$nameoffset+$nameextra+($secwidth*$split)-4, $rank*$posheight+($posheight/2)+6, $color, $unifont, $lang['graph']['E']);
				}
				imagesetthickness  ($im  , 1);

				### penlaps ###
			if($split==$sectors*$data['totlaps'] && $data['totlaps']!=$data['lapsdone']) {
					imagefilledrectangle($im,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split)-8, $rank*$posheight+($posheight/2)-8,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split)+8, $rank*$posheight+($posheight/2)+8,$white);
					imagerectangle($im,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split)-8, $rank*$posheight+($posheight/2)-8,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split)+8, $rank*$posheight+($posheight/2)+8,$color);
					imagesetthickness  ($im  , 3);
					imagettftext($im, 11, 0, $maxnamewidth+$nameoffset+$nameextra+($secwidth*$split)-4, $rank*$posheight+($posheight/2)+6, $color, $unifont, $lang['graph']['Pen']);
					imagesetthickness  ($im  , 1);
				}
				### player rejoined ###

				if(in_array(ceil(($split+$sectors)/$sectors),$data['rejoins']) && $split % $sectors == 0) {
						$lastx = $maxnamewidth+$nameoffset+$nameextra+($secwidth*$split);
						$lasty = $rank*$posheight+($posheight/2);
						$joinpoints = array($lastx, $lasty-4, $lastx-5, $lasty+5, $lastx+5, $lasty+5);
						imagefilledpolygon($im, $joinpoints, 3, $color);
				}
				### player resetted ###
				if($data['reset'][ceil($split/$sectors)]) {
					$resets = str_split($data['reset'][ceil($split/$sectors)],1);
					foreach($resets as $sec) {
						if(($split % $sectors == $sec) || ($split % $sectors == 0 && $sec == $sectors)) {
							$lastx = $maxnamewidth+$nameoffset+$nameextra+($secwidth*$split);
							$lasty = $rank*$posheight+($posheight/2);
							$joinpoints = array($lastx, $lasty-4, $lastx-5, $lasty+5, $lastx+5, $lasty+5);
							imagefilledpolygon($im, $joinpoints, 3, $color);
						}
					}
				}
				### player pitted ###
				if($data['pitstops'][ceil($split/$sectors)] && $split % $sectors == $sectors-1) {
					$text = ($data['pitstops'][ceil($split/$sectors)]['from']!=$data['pitstops'][ceil($split/$sectors)]['to'] && !empty($data['pitstops'][ceil($split/$sectors)]['to'])) ? $lang['graph']['T'] : $lang['graph']['P'];
					imagefilledellipse($im,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split), $rank*$posheight+($posheight/2),17,17,$white);
					imageellipse($im,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split), $rank*$posheight+($posheight/2),17,17,$color);
					imagettftext($im, 11, 0, $maxnamewidth+$nameoffset+$nameextra+($secwidth*$split)-4, $rank*$posheight+($posheight/2)+7, $color, $unifont, $text);
				}
				### player got engine damage ###
				if($data['engdamage'][ceil($split/$sectors)]) {
					$dams = explode('#',$data['engdamage'][ceil($split/$sectors)]);
					foreach($dams as $sec) {
						if((($split % $sectors == $sec{0}) || ($split % $sectors == 0 && $sec{0} == $sectors)) && !empty($sec)) {
						$lastx = $maxnamewidth+$nameoffset+$nameextra+($secwidth*$split);
						$lasty = $rank*$posheight+($posheight/2);
						$dampoints = array($lastx, $lasty-8, $lastx-7, $lasty-2, $lastx-5, $lasty+6, $lastx+5, $lasty+6, $lastx+7, $lasty-2);
						imagefilledpolygon($im, $dampoints, 5, $white);
						imagepolygon($im, $dampoints, 5, $color);
						imagettftext($im, 9, 0, $lastx-4, $lasty+5, $color, $unifont, $lang['graph']['D']);
						imagestring($im, 1, $lastx-6, $lasty+8, substr($sec,1), $color);
						}
					}
				}
				### player broke tyre ###
				if($data['tbreak'][ceil($split/$sectors)]) {
					$tyres = array(1 => 'RL', 2 => 'RR', 4 => 'FL', 8 => 'FR');
					$dams = str_split($data['tbreak'][ceil($split/$sectors)],1);
					foreach($dams as $sec) {
						$tyre = array();
						$tyre[] = $tyres[$sec{1}];
						if(($split % $sectors == $sec{0}) || ($split % $sectors == 0 && $sec{0} == $sectors) && !empty($sec)) {
						$lastx = $maxnamewidth+$nameoffset+$nameextra+($secwidth*$split);
						$lasty = $rank*$posheight+($posheight/2);
						$dampoints = array($lastx, $lasty-8, $lastx-7, $lasty-2, $lastx-5, $lasty+6, $lastx+5, $lasty+6, $lastx+7, $lasty-2);
						imagefilledpolygon($im, $dampoints, 5, $white);
						imagepolygon($im, $dampoints, 5, $color);
						imagettftext($im, 9, 0, $lastx-4, $lasty+5, $color, $unifont, $lang['graph']['W']);
						imagestring($im, 1, $lastx-6, $lasty+8, implode(', ', $tyre), $color);
						}
					}
				}

				### player caused yellow flag ###
				if($data['yellowflags'][ceil($split/$sectors)]) {
					$flags = str_split($data['yellowflags'][ceil($split/$sectors)],1);
					foreach($flags as $sec) {
						if(($split % $sectors == $sec) || ($split % $sectors == 0 && $sec == $sectors)) {
							imagefilledellipse($im,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split), $rank*$posheight+($posheight/2),9,9,$yellow);
							imageellipse($im,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split), $rank*$posheight+($posheight/2),10,10,$color);
						}
					}
				}
				### player saw blue flag ###
				if($data['blueflags'][ceil($split/$sectors)]) {
					$flags = str_split($data['blueflags'][ceil($split/$sectors)],1);
					foreach($flags as $sec) {
						if(($split % $sectors == $sec) || ($split % $sectors == 0 && $sec == $sectors)) {
							imagefilledellipse($im,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split), $rank*$posheight+($posheight/2),9,9,$blue);
							imageellipse($im,$maxnamewidth+$nameoffset+$nameextra+($secwidth*$split), $rank*$posheight+($posheight/2),10,10,$color);
						}
					}
				}

			}
			imagesetthickness ($im, 2);
			### player not in race -> draw dashed line ###
			$style = array($color, $color, $color, IMG_COLOR_TRANSPARENT, IMG_COLOR_TRANSPARENT, IMG_COLOR_TRANSPARENT);
			imagesetstyle($im, $style);
			if(count($data['rank'])<$sectors*$maxlapsdone && $data['finished']===true) imageline ($im, $maxnamewidth+$nameoffset+$nameextra+($secwidth*(count($data['rank'])-1)),array_pop($data['rank'])*$posheight+($posheight/2),($maxlapsdone*$secwidth*$sectors)+$maxnamewidth+$nameoffset+$nameextra,$id*$posheight+($posheight/2), IMG_COLOR_STYLED);
			### player not in race -> draw dashed line ###
			$style = array( IMG_COLOR_TRANSPARENT, IMG_COLOR_TRANSPARENT, IMG_COLOR_TRANSPARENT, IMG_COLOR_TRANSPARENT, $color);
			imagesetstyle($im, $style);
			if(count($data['rank'])<$sectors*$maxlapsdone && $data['finished']===false) {
				imageline ($im, $maxnamewidth+$nameoffset+$nameextra+($secwidth*(count($data['rank'])-1)),array_pop($data['rank'])*$posheight+($posheight/2)+8,$maxnamewidth+$nameoffset+$nameextra+($secwidth*(count($data['rank']))),$id*$posheight+($posheight/2), IMG_COLOR_STYLED);
				imageline ($im, $maxnamewidth+$nameoffset+$nameextra+($secwidth*(count($data['rank']))),$id*$posheight+($posheight/2),($maxlapsdone*$secwidth*$sectors)+$maxnamewidth+$nameoffset+$nameextra,$id*$posheight+($posheight/2), IMG_COLOR_STYLED);
			}
		}
		break;

	case GRAPH_PLR:
		### get player & some special laptimes ###
		$pid = (isset($_GET['player']) && array_key_exists(mysub($_GET['player'],1),$playerkeys_finished)) ? $playerkeys_finished[mysub($_GET['player'],1)] : die($lang['graph']['noplayer']);
		if($teams[$pid]['lapsdone']==0) die($lang['graph']['nolaps']);
		for($lap=1; $lap<=$teams[$pid]['lapsdone']; $lap++) {
			if(!$worstlap || $teams[$pid]['sectimes']['lap'][$lap]-$teams[$pid]['sectimes']['lap'][$lap-1]>$worstlap) $worstlap = $teams[$pid]['sectimes']['lap'][$lap]-$teams[$pid]['sectimes']['lap'][$lap-1];
		}
		$bestlap = $teams[$pid]['bestsectime']['lap'];
		$lap107 = $bestlap*1.07;

		### create image & set some colors ###
		$width = 550;
		$lineheight = 15;
		$height = $lineheight*$teams[$pid]['lapsdone']+60;
		$im = @imagecreate($width, $height);
		$colid = sscanf($col[0], '#%2x%2x%2x');
		$background_color = imagecolorallocate($im,$colid[0],$colid[1],$colid[2]);
		$black	= imagecolorallocate($im,   0,   0,   0);
		$lgreen	= imagecolorallocate($im,   0, 255,  55);
		$mgreen	= imagecolorallocate($im,   0, 255, 155);
		$green	= imagecolorallocate($im,   0, 255,   0);
		$lblue	= imagecolorallocate($im,   0, 255, 255);
		$mblue	= imagecolorallocate($im,   0, 155, 255);
		$blue		= imagecolorallocate($im,   0,   0, 255);
		$lred		= imagecolorallocate($im, 255, 255,   0);
		$mred		= imagecolorallocate($im, 255, 155,   0);
		$red		= imagecolorallocate($im, 255,   0,   0);
		$yellow	= imagecolorallocate($im, 255, 255,   0);
		imagesetthickness ($im, 1);
		$car = (convert_car_bits($mprheader['allowedcars'],true)>1) ? ' ('.$teams[$pid]['car'].')' : '';
		$name = (count($teams[$pid]['drivers'])==1 && $istoc===false) ? html_entity_decode(nameblank($teams[$pid]['drivers'][substr($pid,1)]['nick'])).$car : html_entity_decode(nameblank($teams[$pid]['name'])).$car;
		$bbox = imagettfbbox (10, 0, $unifont, $name);
		$namewidth = $bbox[2]-$bbox[0];

		### put player name ###
		imagettftext($im, 10, 0, $width/2-$namewidth/2, 20, $black, $unifont, $name);

		### put each lap ###
		for($lap=1; $lap<=$teams[$pid]['lapsdone']; $lap++) {
			$l = array();
			# get time and textwidth for splittimes #
			for($s=1; $s<=$sectors; $s++) {
				$str = 's'.$s;
				if($s==1) ${$str}[0] = $teams[$pid]['sectimes'][$s][$lap]-$teams[$pid]['sectimes'][$sectors][$lap-1];
				else ${$str}[0] = $teams[$pid]['sectimes'][$s][$lap]-$teams[$pid][sectimes][$s-1][$lap];
				${$str}[1] = strlen(printTime(${$str}[0])) * imagefontwidth($font)+20;
			}
			# get time and textwidth for laptimes #
			$l[0] = $teams[$pid]['sectimes']['lap'][$lap]-$teams[$pid]['sectimes'][lap][$lap-1];
			$l[1] = strlen('=> '.printTime($l[0])) * imagefontwidth($font)+15;
			# put line & number for lap
			imageline ( $im, 10, ($lap-0.4)*$lineheight+30, $width-40, ($lap-0.4)*$lineheight+30, $black );
			imagestring($im, 2, $width-35, ($lap-0.4)*$lineheight+24, $lap, $black);

			# rejoin lap
			if(in_array($lap,$teams[$pid]['rejoins']) || array_key_exists($lap, $teams[$pid]['reset'])) imagefilledrectangle ( $im, 10, ($lap-1)*$lineheight+31, ($l[0]-$bestlap)/($worstlap-$bestlap)*275+235, $lap*$lineheight+30, $red );
			# lap with pitstop
			if($teams[$pid]['pitstops'][$lap]) imagefilledrectangle ( $im, 10, ($lap-1)*$lineheight+31, ($l[0]-$bestlap)/($worstlap-$bestlap)*275+235, $lap*$lineheight+30, $yellow );
			# player's best lap
			elseif($l[0]==$bestlap) imagefilledrectangle ( $im, 10, ($lap-1)*$lineheight+31, ($l[0]-$bestlap)/($worstlap-$bestlap)*275+235, $lap*$lineheight+30, $blue );
			# lap outside 107%
			elseif($l[0]>$lap107) imagefilledrectangle ( $im, 10, ($lap-1)*$lineheight+31, ($l[0]-$bestlap)/($worstlap-$bestlap)*275+235, $lap*$lineheight+30, $red );
			# each other lap
			else imagefilledrectangle ( $im, 10, ($lap-1)*$lineheight+31, ($l[0]-$bestlap)/($worstlap-$bestlap)*275+235, $lap*$lineheight+30, $green );
			# border for lapbar
			imagerectangle ( $im, 10, ($lap-1)*$lineheight+31, ($l[0]-$bestlap)/($worstlap-$bestlap)*275+235, $lap*$lineheight+30, $black );
			# split 1 time
			if($sectors>1) imagettftext($im, 10, 0, 15, ($lap-1)*$lineheight+43, $black, $unifont, printTime($s1[0]));
			# split 2 time
			if($sectors>=2) imagettftext($im, 10, 0, $s1[1]+15, ($lap-1)*$lineheight+43, $black, $unifont, printTime($s2[0]));
			# split 3 time
			if($sectors>=3) imagettftext($im, 10, 0, $s1[1]+$s2[1]+15, ($lap-1)*$lineheight+43, $black, $unifont, printTime($s3[0]));
			# split 4 time
			if($sectors>=4) imagettftext($im, 10, 0, $s1[1]+$s2[1]+$s3[1]+15, ($lap-1)*$lineheight+43, $black, $unifont, printTime($s4[0]));
			# laptime
			imagettftext($im, 10, 0, $s1[1]+$s2[1]+$s3[1]+$s4[1]+15, ($lap-1)*$lineheight+43, $black, $unifont, '=>   '.printTime($l[0]));
			# text if rejoined
			if(in_array($lap,$teams[$pid]['rejoins'])) imagettftext($im, 10, 0, 260, ($lap-1)*$lineheight+43, $black, $unifont, $lang['graph']['rejoin']);
			# pittime if pitted
			if($teams[$pid]['pitstops'][$lap] && $teams[$pid]['pitstops'][$lap]['from']!=$teams[$pid]['pitstops'][$lap]['to']) {
				$from = (empty($players[$teams[$pid]['pitstops'][$lap]['from']]['realname'])) ? nameblank($players[$teams[$pid]['pitstops'][$lap]['from']]['teams'][$lfsw]['nick']) : nameblank($players[$teams[$pid]['pitstops'][$lap]['from']]['realname']);
				$to = (empty($players[$teams[$pid]['pitstops'][$lap]['to']]['realname'])) ? nameblank($players[$teams[$pid]['pitstops'][$lap]['to']]['teams'][$lfsw]['nick']) : nameblank($players[$teams[$pid]['pitstops'][$lap]['to']]['realname']);
				imagettftext($im, 10, 0, 240, ($lap-1)*$lineheight+43, $black, $unifont, $lang['graph']['pitstop'].' ('.printTime($teams[$pid]['pitstops'][$lap]['time']).') '.$from.' => '.$to);
			}
			elseif($teams[$pid]['pitstops'][$lap]) imagettftext($im, 10, 0, 240, ($lap-1)*$lineheight+43, $black, $unifont, $lang['graph']['pitstop'].' ('.printTime($teams[$pid]['pitstops'][$lap]['time']).')');

		}

		### put grid ###
		# 100%
		imagedashedline ( $im, 235, 31, 235, $height-30, $black );
		imagestring($im, 2, 225, $height-25, '100%', $black);
		# 107%
		imagedashedline ( $im, ($lap107-$bestlap)/($worstlap-$bestlap)*275+235, 31, ($lap107-$bestlap)/($worstlap-$bestlap)*275+235, $height-30, $black );
		imagestring($im, 2, ($lap107-$bestlap)/($worstlap-$bestlap)*275+225, $height-25, '107%', $black);
		# axes
		imagettftext($im, 10, 0, $width-70, $height-15, $black, $unifont, $lang['general']['time']);
		imagettftext($im, 10, 90, $width-8, $height/2, $black, $unifont, $lang['general']['lap']);
		imagesetthickness  ($im  , 2);
		imageline ( $im, 10, $height-29, $width-40, $height-29, $black );
		imageline ( $im, 10, 31, $width-40, 31, $black );
		imageline($im, 10, 30, 10, $height-30, $black);
		imageline($im, $width-40, 30, $width-40, $height-30, $black);
		break;

	case GRAPH_RPG:
		if(isset($_GET['plyrs'])) {
			$plyrs = explode("_",$_GET['plyrs']);
			if(count($plyrs)>=2) {
				foreach ($teams as $lfsw=>$data) if(!in_array(array_search($lfsw,$playerkeys_finished),$plyrs)) {
					unset($teams[$lfsw]);
					unset($fin[$lfsw]);
					unset($ldone[$lfsw]);
					unset($ttime[$lfsw]);
				}
#				array_multisort($fin, SORT_DESC, $ldone, SORT_DESC, $ttime, SORT_ASC, $teams);
				$playerkeys = array_keys($teams);
			}
		}
		$leader = $playerkeys[0];

		for($s=1; $s<=$sectors; $s++) {
			if($s==1) $avgsec[$s] = (array_sum($teams[$leader]['sectimes'][$s]) - array_sum($teams[$leader]['sectimes'][$sectors]) + end($teams[$leader]['sectimes'][$sectors]))/count($teams[$leader]['sectimes'][$s]);
			else $avgsec[$s] = (array_sum($teams[$leader]['sectimes'][$s]) - array_sum($teams[$leader]['sectimes'][$s-1]))/count($teams[$leader]['sectimes'][$s]);
		}

		$mingap=$maxgap=0;
		for($lap=1; $lap<=$maxlapsdone; $lap++) {
			for($s=1; $s<=$sectors; $s++) {
		unset($reftime);
		foreach($avgsec as $sec => $avg) $reftime += ($sec<=$s) ? $avg*($lap-1) + $avg : $avg*($lap-1);
		foreach ($teams as $lfsw=>$data) {
					if($data['sectimes'][$s][$lap]) {
						if(($data['sectimes'][$s][$lap]-$reftime)/100>$maxgap) $maxgap = ($data['sectimes'][$s][$lap]-$reftime)/100;
						if(($data['sectimes'][$s][$lap]-$reftime)/100<$mingap) $mingap = ($data['sectimes'][$s][$lap]-$reftime)/100;
#						if(($data['sectimes'][$s][$lap]-$teams[$leader]['sectimes'][$s][$lap])/100>$maxgap) $maxgap = ($data['sectimes'][$s][$lap]-$teams[$leader]['sectimes'][$s][$lap])/100;
#						if(($data['sectimes'][$s][$lap]-$teams[$leader]['sectimes'][$s][$lap])/100<$mingap) $mingap = ($data['sectimes'][$s][$lap]-$teams[$leader]['sectimes'][$s][$lap])/100;
					}
				}
			}
		}


		### create image ###
		$totgap = $maxgap-$mingap;
		$miny = floor($mingap/10)*10;
		if($miny==0) $miny = -1;
		$maxy = ceil($maxgap/10)*10;
		$toty = $maxy-$miny;

		if($_GET['maxgap'] && is_numeric($_GET['maxgap'])) $maxshown = intval($_GET['maxgap']);
		else $maxshown = 200;
		$nameextra += 10;
		if($ybpos+$ybwidth>($maxlapsdone*$secwidth*$sectors)+ ($maxnamewidth+$nameoffset+$nameextra)) $secwidth = ($ybpos+$ybwidth - ($maxnamewidth+$nameoffset+$nameextra))/($maxlapsdone*$sectors);
		elseif($maxlapsdone<15) ceil(($ybpos+$bwidth)/($maxlapsdone*$sectors));
		$width = ($maxlapsdone*$secwidth*$sectors)+$maxnamewidth+70;
		if($pcount*30+31<500) $baseheight = 500;
		else $baseheight = $pcount*30+31;
		if($toty>$maxshown) $gapheight = ($baseheight/$maxshown);
		else $gapheight = ($baseheight/$toty);
		if($toty<=$maxshown) $height = ($gapheight*$toty)+$gapheight+80;
		else $height = ($gapheight*$maxshown)-($gapheight*$miny)+80;
		$im = imagecreate($width, $height);
		$colid = sscanf($col[0], '#%2x%2x%2x');
		$background_color = imagecolorallocate($im,$colid[0],$colid[1],$colid[2]);
		$black	= imagecolorallocate($im,   0,   0,   0);
		$white	= imagecolorallocate($im, 255, 255, 255);
		$blue		= imagecolorallocate($im,   0,   0, 255);
		$red		= imagecolorallocate($im, 255,   0,   0);
		$yellow	= imagecolorallocate($im, 255, 255,   0);
		$grey		= imagecolorallocate($im, 220, 220, 220);
		$lapcol	= imagecolorallocate($im, 178, 178, 178);
		imagesetthickness ($im, 1);

		### make grid ###
		for ($i=$miny; $i<=$maxy; $i++) {
			if($i<($maxshown+1)) {
				if ($i % 50==0 || $i==0) imagesetthickness ($im, 2);
				else imagesetthickness ($im, 1);
				if ($i % 10==0) {
					imagestring($im, 2, $nameoffset+6, myadd($i,abs($miny))*$gapheight+20, $i, $black);
					if($i==0) imageline($im, $nameoffset+$nameextra, myadd($i,abs($miny))*$gapheight+25, ($maxlapsdone*$secwidth*$sectors)+$nameoffset+$nameextra, myadd($i,abs($miny))*$gapheight+25, $black);
					else imageline($im, $nameoffset+$nameextra, myadd($i,abs($miny))*$gapheight+25, ($maxlapsdone*$secwidth*$sectors)+$nameoffset+$nameextra, myadd($i,abs($miny))*$gapheight+25, $grey);
				}
			}
		}

		$i=1;
		imagesetthickness ($im, 1);
		do {
			#lap
			if($i % $sectors == 0) imageline($im, ($i*$secwidth)+$nameoffset+$nameextra, 25, ($i*$secwidth)+$nameoffset+$nameextra, $height-55, $black);
			#sector
			else imageline($im, ($i*$secwidth)+$nameoffset+$nameextra, 25, ($i*$secwidth)+$nameoffset+$nameextra, $height-55, $grey);
			# lapnumber above
			if(($sectors+1)&1 && $i % $sectors == $sectors/2) imagestring($im, 2, ($i*$secwidth)+$nameoffset+$nameextra-6, 10, ceil($i/$sectors), $black);
			elseif($sectors&1 && $i % $sectors == ($sectors-1)/2 ) imagestring($im, 2, ($i*$secwidth)+5+$nameoffset+$nameextra-6, 10, ceil($i/$sectors), $black);
			# lapnumber below
			if(($sectors+1)&1 && $i % $sectors == $sectors/2) imagestring($im, 2, ($i*$secwidth)+$nameoffset+$nameextra-6, $height-55, ceil($i/$sectors), $black);
			elseif($sectors&1 && $i % $sectors == ($sectors-1)/2 ) imagestring($im, 2, ($i*$secwidth)+5+$nameoffset+$nameextra-6, $height-55, ceil($i/$sectors), $black);
		} while (++$i<=$maxlapsdone*$sectors);

		$id=0;
		foreach ($teams as $lfsw=>$data) {
			$car = (convert_car_bits($mprheader['allowedcars'],true)>1) ? ' ('.$teams[$lfsw]['car'].')' : '';
			$name = (count($teams[$lfsw]['drivers'])==1 && $istoc===false) ? html_entity_decode(nameblank($teams[$lfsw]['drivers'][substr($lfsw,1)]['nick'])).$car : html_entity_decode(nameblank($teams[$lfsw]['name'])).$car;
			$colid = sscanf($col[myadd(1,$id++)], '#%2x%2x%2x');
			$color = imagecolorallocate($im,$colid[0],$colid[1],$colid[2]);
			imagettftext($im, 10, 0, ($maxlapsdone*$secwidth*$sectors)+$nameoffset+$nameextra+10, $id*30+10, $black, $unifont, $name); // Name links
			imagefilledrectangle ($im, ($maxlapsdone*$secwidth*$sectors)+$nameoffset+$nameextra+10, $id*30+14, ($maxlapsdone*$secwidth*$sectors)+$nameoffset+$nameextra+$maxnamewidth+10, $id*30+16, $color );     // Linie links
			imagesetthickness  ($im  , 1);

			for($lap=1; $lap<=$maxlapsdone; $lap++) {
				for($s=1; $s<=$sectors; $s++) {



					unset($reftime);
					foreach($avgsec as $sec => $avg) {
						$reftime += ($sec<=$s) ? $avg*($lap-1) + $avg : $avg*($lap-1);
						$reftime2 = ($s == $sectors) ? $reftime + $avgsec[1] : $reftime + $avgsec[$s+1];
					}
					if($data['sectimes'][$s+1][$lap] && $s<$sectors) imageline($im, $nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s),(($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*($s+1)),(($data['sectimes'][$s+1][$lap]-$reftime2)/100)*$gapheight-$miny*$gapheight+25, $color);
					elseif($data['sectimes'][1][$lap+1] && $s==$sectors) imageline($im, $nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s),(($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*($s+1)),(($data['sectimes'][1][$lap+1]-$reftime2)/100)*$gapheight-$miny*$gapheight+25, $color);
					### player rejoined ###
					if(in_array($lap+1,$data['rejoins']) && $s==$sectors) {
							$lastx = $nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s);
							$lasty = (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25;
							$joinpoints = array($lastx, $lasty-4, $lastx-5, $lasty+5, $lastx+5, $lasty+5);
							imagefilledpolygon($im, $joinpoints, 3, $color);
					}
					### player resetted ###
					if($data['reset'][$lap]) {
						$resets = str_split($data['reset'][$lap],1);
						foreach($resets as $sec) {
							if(($s==$sec{0})) {
								$lastx = $nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s);
								$lasty = (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25;
								$joinpoints = array($lastx, $lasty-4, $lastx-5, $lasty+5, $lastx+5, $lasty+5);
								imagefilledpolygon($im, $joinpoints, 3, $color);
							}
						}
					}
					### pitstop ###
					if($data['pitstops'][$lap] && $s == $sectors-1) {
						$text = ($data['pitstops'][$lap]['from']!=$data['pitstops'][$lap]['to'] && !empty($data['pitstops'][$lap]['to'])) ? $lang['graph']['T'] : $lang['graph']['P'];
						imagefilledellipse($im,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s), (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25,17,17,$white);
						imageellipse($im,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s), (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25,17,17,$color);
						imagettftext($im, 11, 0, $nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)-4, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25+7, $color, $unifont, $text);
					}
					imagesetthickness  ($im  , 1);
					### penlaps ###
					if($lap==$data['totlaps'] && $data['totlaps']!=$data['lapsdone'] && $s==$sectors) {
						imagefilledrectangle($im,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)-8, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25-8,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)+8, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25+8,$white);
						imagerectangle($im,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)-8, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25-8,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)+8, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25+8,$color);
						imagettftext($im, 11, 0, $nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)-4, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25+7, $color, $unifont, $lang['graph']['Pen']);
					}
					### player got engine damage ###
					if($data['engdamage'][$lap]) {
						$dams = explode('#',$data['engdamage'][$lap]);
						foreach($dams as $sec) {
							if((($s == $sec{0})) && !empty($sec)) {
							$lastx = $nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s);
							$lasty = (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25;
							$dampoints = array($lastx, $lasty-8, $lastx-7, $lasty-2, $lastx-5, $lasty+6, $lastx+5, $lasty+6, $lastx+7, $lasty-2);
							imagefilledpolygon($im, $dampoints, 5, $white);
							imagepolygon($im, $dampoints, 5, $color);
							imagettftext($im, 9, 0, $lastx-4, $lasty+5, $color, $unifont, $lang['graph']['D']);
							imagestring($im, 1, $lastx-6, $lasty+8, substr($sec,1), $color);
							}
						}
					}
				### player broke tyre ###
				### player got broken tyre ###
				if($data['tbreak'][$lap]) {
					$tyres = array(1 => 'RL', 2 => 'RR', 4 => 'FL', 8 => 'FR');
					$dams = str_split($data['tbreak'][$lap],1);
					foreach($dams as $sec) {
						$tyre = array();
						$tyre[] = $tyres[$sec{1}];
						if(($sec{0} == $sectors) && !empty($sec)) {
#						if((($split % $sectors == $sec{0}) || ($split % $sectors == 0 && $sec{0} == $sectors)) && !empty($sec)) {
						$lastx = $nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s);
						$lasty = (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25;
						$dampoints = array($lastx, $lasty-8, $lastx-7, $lasty-2, $lastx-5, $lasty+6, $lastx+5, $lasty+6, $lastx+7, $lasty-2);
						imagefilledpolygon($im, $dampoints, 5, $white);
						imagepolygon($im, $dampoints, 5, $color);
						imagettftext($im, 9, 0, $lastx-4, $lasty+5, $color, $unifont, $lang['graph']['W']);
						imagestring($im, 1, $lastx-6, $lasty+8, implode(', ', $tyre), $color);
						}
					}
				}
					### player left race ###
					if(!($data['sectimes'][$s+1][$lap]) && $s<$sectors && $data['finished']===false) {
						imagefilledrectangle($im,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)-8, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25-8,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)+8, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25+8,$white);
						imagerectangle($im,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)-8, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25-8,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)+8, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25+8,$color);
						imagettftext($im, 11, 0, $nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)-4, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25+7, $color, $unifont, $lang['graph']['E']);
					}
					elseif(!($data['sectimes'][1][$lap+1]) && $s==$sectors && $data['finished']===false) {
						imagefilledrectangle($im,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)-8, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25-8,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)+8, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25+8,$white);
						imagerectangle($im,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)-8, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25-8,$nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)+8, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25+8,$color);
						imagettftext($im, 11, 0, $nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s)-4, (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+25+7, $color, $unifont, $lang['graph']['E']);
					}
				}
			}
		}

		### draw axes ###
		imagesetthickness ($im, 2);
		imageline ( $im, $nameoffset+$nameextra, $height-55, ($maxlapsdone*$secwidth*$sectors)+$nameoffset+$nameextra, $height-55, $black );
		imageline ( $im, $nameoffset+$nameextra, 25, ($maxlapsdone*$secwidth*$sectors)+$nameoffset+$nameextra, 25, $black );
		imageline($im, $nameoffset+$nameextra, 25, $nameoffset+$nameextra, $height-55, $black);
		imageline($im, ($maxlapsdone*$secwidth*$sectors)+$nameoffset+$nameextra, 25, ($maxlapsdone*$secwidth*$sectors)+$nameoffset+$nameextra, $height-55, $black);
		imagettftext($im, 10, 0,($maxlapsdone*$secwidth*$sectors)+$nameoffset+$nameextra+5, $height-$legendoffset-25, $black, $unifont, $lang['general']['lap']);
		imagettftext($im, 10, 90, 16, $height/2, $black, $unifont, $lang['general']['gap']);

		### make legend ###
		### Exit ###
		imagesetthickness ($im, 1);
		imagefilledrectangle ($im, $eppos-4, $height-$legendoffset-20, $eppos-4+16, $height-$legendoffset-20+16, $white);
		imagerectangle ($im, $eppos-4, $height-$legendoffset-20, $eppos-4+16, $height-$legendoffset-20+16, $black);
		imagettftext ($im, 11, 0, $eppos, $height-$legendoffset-6, $black, $unifont, $lang['graph']['E']);
		imagettftext ($im, 11, 0, $eppos+16, $height-$legendoffset-6, $black, $unifont, $lang['graph']['exit']);
		### Penlaps ###
		imagesetthickness ($im, 1);
		imagefilledrectangle ($im, $eppos-4, $height-$legendoffset, $eppos-4+16, $height-$legendoffset+16, $white);
		imagerectangle ($im, $eppos-4, $height-$legendoffset, $eppos-4+16, $height-$legendoffset+16, $black);
		imagettftext ($im, 11, 0, $eppos, $height-$legendoffset+14, $black, $unifont, $lang['graph']['Pen']);
		imagettftext ($im, 11, 0, $eppos+16, $height-$legendoffset+14, $black, $unifont, $lang['graph']['penalty']);
		### pitstop ###
		imagefilledellipse ($im, $ptpos+4, $height-$legendoffset-12, 17, 17, $white);
		imageellipse ($im, $ptpos+4, $height-$legendoffset-12, 17, 17,$black);
		imagettftext ($im, 11, 0, $ptpos, $height-$legendoffset-6, $black, $unifont, $lang['graph']['P']);
		imagettftext ($im, 11, 0, $ptpos+16, $height-$legendoffset-6, $black, $unifont, $lang['graph']['pitstop']);
		### pitstop + TOC ###
		imagefilledellipse ($im, $ptpos+4, $height-$legendoffset+8, 17, 17, $white);
		imageellipse ($im, $ptpos+4, $height-$legendoffset+8, 17, 17,$black);
		imagettftext ($im, 11, 0, $ptpos, $height-$legendoffset+14, $black, $unifont, $lang['graph']['T']);
		imagettftext ($im, 11, 0, $ptpos+16, $height-$legendoffset+14, $black, $unifont, $lang['graph']['toc']);
		### engine ###
		imagefilledpolygon($im, getpentagonpoints($dtpos,$height-$legendoffset-12), 5, $white);
		imagepolygon($im, getpentagonpoints($dtpos,$height-$legendoffset-12), 5, $black);
		imagettftext($im, 9, 0, $dtpos-4, $height-$legendoffset-6, $black, $unifont, $lang['graph']['D']);
		imagettftext ($im, 11, 0, $dtpos+16, $height-$legendoffset-6, $black, $unifont, $lang['graph']['damage']);
		### tyre ###
		imagefilledpolygon($im, getpentagonpoints($dtpos,$height-$legendoffset+8), 5, $white);
		imagepolygon($im, getpentagonpoints($dtpos,$height-$legendoffset+8), 5, $black);
		imagettftext($im, 9, 0, $dtpos-4, $height-$legendoffset+14, $black, $unifont, $lang['graph']['W']);
		imagettftext ($im, 11, 0, $dtpos+16, $height-$legendoffset+14, $black, $unifont, $lang['graph']['wheel']);
		### rejoin ###
		imagefilledpolygon($im, gettrispoints($rlpos,$height-$legendoffset-12), 3, $black);
		imagettftext ($im, 11, 0, $rlpos+16, $height-$legendoffset-6, $black, $unifont, $lang['graph']['rejoin']);
		### lapped ###
		imagefilledrectangle ($im, $rlpos-8, $height-$legendoffset-4, $rlpos+12, $height-$legendoffset+16, $lapcol);
		imagettftext ($im, 11, 0, $rlpos+16, $height-$legendoffset+14, $black, $unifont, $lang['graph']['lapped']);
		### yellow flags ###
		imagefilledellipse ($im, $ybpos, $height-$legendoffset-10, 10, 10, $yellow);
		imageellipse ($im, $ybpos, $height-$legendoffset-10, 10, 10, $black);
		imagettftext ($im, 11, 0, $ybpos+12, $height-$legendoffset-6, $black, $unifont, $lang['graph']['yellow']);
		### blue flags ###
		imagefilledellipse ($im, $ybpos, $height-$legendoffset+10, 10, 10, $blue);
		imageellipse ($im, $ybpos, $height-$legendoffset+10, 10, 10, $black);
		imagettftext ($im, 11, 0, $ybpos+12, $height-$legendoffset+14, $black, $unifont, $lang['graph']['blue']);


		break;
	default: exit;
}
imagepng($im,$graphfile);
imagedestroy($im);
}
header("Content-type: image/png");
echo file_get_contents($graphfile);
?>