<?php
#################################################################
# mpres graph_select.php V2.02																	#
# selection screen for graphs belonging to a replay							#
# directory: script main path																		#
#################################################################
define('NORMAL_ACCESS', null);
error_reporting(E_ERROR | E_WARNING | E_PARSE);
require_once('global.inc.php');
if(GOT_RESULT === false) exit;
if($racetype==RACETYPE_QUAL) exit;
### define graphtype to display ###
$allowed_graphtypes = array(GRAPH_BLG, GRAPH_PLR, GRAPH_RPG, GRAPH_PAVG);	# 1: lap-by-lap, 2: player-graph, 3: race-progress
$graphtype = (isset($_GET['graphtype']) && in_array($_GET['graphtype'],$allowed_graphtypes)) ? $_GET['graphtype'] : 1;

$player = (isset($_GET['player']) && array_key_exists(mysub($_GET['player'],1),$playerkeys_finished)) ? $_GET['player'] : 1;
$plarr = (isset($_GET['plyrs']) && $_GET['plyrs']!="-1") ? explode('_',$_GET['plyrs']) : null;
if($_POST) {
	$graphtype = ($_POST['gtype'] && in_array($_POST['gtype'],$allowed_graphtypes)) ? $_POST['gtype'] : $graphtype;
	$player = ($_POST['player'] && array_key_exists(mysub($_POST['player'],1),$playerkeys_finished)) ? $_POST['player'] : $player;
	$plarr = (isset($_POST['plyrs']) && $_POST['plyrs'][0]!="-1") ? $_POST['plyrs'] : $plarr;
}
if(is_array($plarr)) {
	foreach($plarr as $i => $pl) {
		if(!is_numeric($pl)) unset($plarr[$i]);
	}
	$plyrs = implode('_',$plarr);
}
$maxgap = ($_POST['maxgap'] && is_numeric($_POST['maxgap'])) ? intval($_POST['maxgap']) : 200;
$format = ($_POST['format'] == 'png') ? 'png' : 'svg';
$uday = ($getday>0 && $events[$gettype][$getevent]['seasons'][$getseason]['maxdays']>0) ? $lang['menu']['day'].' '.$getday.' ' : '';
$ugrid = ($getgrid>0 && $events[$gettype][$getevent]['seasons'][$getseason]['maxgrids']>0) ? $lang['menu']['grid'].' '.$getgrid.' ' : '';
$useday = ($getday>0 && $events[$gettype][$getevent]['seasons'][$getseason]['maxdays']>0) ? 'R'.$getday.'/' : '';
$usegrid = ($getgrid>0 && $events[$gettype][$getevent]['seasons'][$getseason]['maxgrids']>0) ? 'G'.$getgrid.'/' : '';
$session = (isset($getsession{1})) ? $lang['menu']['sess'.$getsession{0}].' '.substr($getsession,1) : $lang['menu']['sess'.$getsession{0}];
if($getsession && !empty($filename)) $breadcrumb = '<a href="'.SCRIPTURL.'">mpRes</a> » <a href="'.SCRIPTURL.$gettype.'/">'.$lang['general'][$gettype].'</a> » <a href="'.SCRIPTURL.$gettype.'/'.$getevent.'/">'.$events[$gettype][$getevent]['name'].'</a> » <a href="'.SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.'/">'.$getseason.'</a> » <a href="'.SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.'/'.$useday.$usegrid.$getsession.'">'.$uday.$ugrid.$session.'</a>';
elseif(isset($getseason)) $breadcrumb = '<a href="'.SCRIPTURL.'">mpRes</a> » <a href="'.SCRIPTURL.$gettype.'/">'.$lang['general'][$gettype].'</a> » <a href="'.SCRIPTURL.$gettype.'/'.$getevent.'/">'.$events[$gettype][$getevent]['name'].'</a> » '.$getseason;
elseif(isset($getevent)) $breadcrumb = '<a href="'.SCRIPTURL.'">mpRes</a> » <a href="'.SCRIPTURL.$gettype.'/">'.$lang['general'][$gettype].'</a> » '.$events[$gettype][$getevent]['name'];
elseif(isset($gettype)) $breadcrumb = '<a href="'.SCRIPTURL.'">mpRes</a> » '.$lang['general'][$gettype];
else $breadcrumb = '<a href="'.SCRIPTURL.'">mpRes</a>';
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="content-type" content="application/xhtml+xml; charset=utf-8" />
		<link href="<?php echo SCRIPTURL.GRAPHSTYLE;?>" type="text/css" rel="stylesheet" media="all" />
		<title><?php echo $lang['graph']['title'];?></title>
	</head>
	<body style="background-color:#c1c1c1;">
		<h1><?php echo $breadcrumb;?></h1>
		<form name="type" method="post" action="#">
			<table>
			<tr>
				<td><label for="gtype"><?php echo $lang['graph']['graphselect'];?>:</label></td>
				<td>
					<select name="gtype" size="3" onChange="this.form.submit()">
						<option value="<?php echo GRAPH_BLG;?>" <?php if($graphtype==GRAPH_BLG) echo ' selected="selected"';?>><?php echo $lang['blg']['alt'];?></option>
						<option value="<?php echo GRAPH_PLR;?>" <?php if($graphtype==GRAPH_PLR) echo ' selected="selected"';?>><?php echo $lang['graph']['playergraph'];?></option>
						<option value="<?php echo GRAPH_RPG;?>" <?php if($graphtype==GRAPH_RPG) echo ' selected="selected"';?>><?php echo $lang['rpg']['alt'];?></option>
					</select>
				</td>
			</tr>
			<tr>
				<td><label for="format">png/svg:</label></td>
				<td><input type="radio" name="format" value="png"<?php if($format=='png') echo' checked="checked"';?> onChange="this.form.submit()" /> png <input type="radio" name="format" value="svg"<?php if($format!='png') echo ' checked="checked"';?> onChange="this.form.submit()" /> svg</td>
			</tr>
<?php
if($graphtype==GRAPH_BLG) {
	echo '
			<tr>
				<td><label for="plyrs">'.$lang['graph']['player'].' ('.$lang['graph']['1ormore'].'):</label></td>
				<td>
					<select name="plyrs[]" size="10" multiple="multiple">
						<option value="-1"';
		if(!isset($plyrs)) echo ' selected="selected"';
		echo '>'.$lang['graph']['all'].'</option>';
	foreach($playerkeys_finished as $id=>$lfsw) {
		$car = (convert_car_bits($mprheader['allowedcars'],true)>1) ? ' ('.$teams[$lfsw]['car'].')' : '';
		$name = (count($teams[$lfsw]['drivers'])==1 && $istoc===false) ? nameblank($teams[$lfsw]['drivers'][substr($lfsw,1)]['nick']).$car : nameblank($teams[$lfsw]['name']).$car;
		echo '
						<option value="'.$id.'"';
		if(isset($plarr) && in_array($id,$plarr)) echo ' selected="selected"';
		echo '>'.$name.'</option>';
	}
	echo '
					</select>
				</td>
			</tr>';
}
if($graphtype==GRAPH_PLR) {
	echo '
			<tr>
				<td><label for="player">'.$lang['graph']['player'].':</label></td>
				<td>
					<select name="player" size="1" onChange="this.form.submit()">';
	foreach($playerkeys_finished as $id=>$lfsw) {
		$car = (convert_car_bits($mprheader['allowedcars'],true)>1) ? ' ('.$teams[$lfsw]['car'].')' : '';
		$name = (count($teams[$lfsw]['drivers'])==1 && $istoc===false) ? nameblank($teams[$lfsw]['drivers'][substr($lfsw,1)]['nick']).$car : nameblank($teams[$lfsw]['name']).$car;
		echo '
						<option value="'.myadd($id,1).'"';
		if($player==myadd($id,1)) echo ' selected="selected"';
		echo '>'.$name.'</option>';
	}
	echo '
					</select>
				</td>
			</tr>';
}
if($graphtype==GRAPH_RPG) {
	echo '
			<tr>
				<td><label for="plyrs">'.$lang['graph']['player'].' ('.$lang['graph']['2ormore'].'):</label></td>
				<td>
					<select name="plyrs[]" size="10" multiple="multiple">
						<option value="-1"';
		if(!isset($plyrs)) echo ' selected="selected"';
		echo '>'.$lang['graph']['all'].'</option>';
	foreach($playerkeys_finished as $id=>$lfsw) {
		$car = (convert_car_bits($mprheader['allowedcars'],true)>1) ? ' ('.$teams[$lfsw]['car'].')' : '';
		$name = (count($teams[$lfsw]['drivers'])==1 && $istoc===false) ? nameblank($teams[$lfsw]['drivers'][substr($lfsw,1)]['nick']).$car : nameblank($teams[$lfsw]['name']).$car;
		echo '
						<option value="'.$id.'"';
		if(isset($plarr) && in_array($id,$plarr)) echo ' selected="selected"';
		echo '>'.$name.'</option>';
	}
	echo '
					</select>
			</td>
			</tr>
			<tr>
				<td><label for="maxgap">'.$lang['graph']['maxshowngap'].':</label></td>
				<td>
					<input type="text" size="5" name="maxgap" value="'.$maxgap.'" />
				</td>
			</tr>';
}
?>
			<tr>
				<td>&nbsp;</td>
				<td>
					<input type="submit" value="<?php echo $lang['graph']['submit'];?>" onSubmit="this.form.submit()" />
				</td>
			</tr>
			</table>
		</form>
		<br />
<?php
$usegrid = ($getgrid>0) ? '/G'.$getgrid : '';
$useday = ($getday>0) ? '/R'.$getday : '';
#$useplrs = (!empty($plyrs)) ? '&amp;plyrs='.$plyrs : '';
if($graphtype==GRAPH_BLG && $format =='png') {
?>
			<a href="<?php echo SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.$useday.$usegrid.'/'.$getsession.'/graphs/blg.png';if(isset($plyrs)) echo '?plyrs='.$plyrs;?>" target="_blank">
				<img style="max-width:100%;" src="<?php echo SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.$useday.$usegrid.'/'.$getsession.'/graphs/blg.png';if(isset($plyrs)) echo '?plyrs='.$plyrs;?>" alt="<?php echo $lang['blg']['alt'];?>" />
			</a>
<?php
}
elseif($graphtype==GRAPH_BLG) {
?>
		<object data="<?php echo SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.$useday.$usegrid.'/'.$getsession.'/graphs/blg.svg?link=2';if(isset($plyrs)) echo '&amp;plyrs='.$plyrs;?>" type="image/svg+xml" style="width:100%;">
			<span><?php echo $lang['graph']['nosvg'];?></span>
		</object>
<?php
}
if($graphtype==GRAPH_PLR && $format =='png') {
?>
			<a href="<?php echo SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.$useday.$usegrid.'/'.$getsession.'/graphs/player_'.$player.'.png';?>" target="_blank">
				<img style="max-width:100%;" src="<?php echo SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.$useday.$usegrid.'/'.$getsession.'/graphs/player_'.$player.'.png';?>" alt="<?php echo $lang['plg']['alt'];?>" />
			</a>
<?php
}
elseif($graphtype==GRAPH_PLR) {
?>
		<object data="<?php echo SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.$useday.$usegrid.'/'.$getsession.'/graphs/player_'.$player.'.svg';?>" type="image/svg+xml" style="width:550px;">
			<span><?php echo $lang['graph']['nosvg'];?></span>
		</object>
<?php
}
if($graphtype==GRAPH_RPG && $format =='png') {
?>
			<a href="<?php echo SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.$useday.$usegrid.'/'.$getsession.'/graphs/rpg.png?maxgap='.$maxgap;if(isset($plyrs)) echo '&amp;plyrs='.$plyrs;?>" target="_blank">
				<img style="max-width:100%;" src="<?php echo SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.$useday.$usegrid.'/'.$getsession.'/graphs/rpg.png?maxgap='.$maxgap;if(isset($plyrs)) echo '&amp;plyrs='.$plyrs;?>" alt="<?php echo $lang['rpg']['alt'];?>" />
			</a>
<?php
}
elseif($graphtype==GRAPH_RPG) {
?>
		<object data="<?php echo SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.$useday.$usegrid.'/'.$getsession.'/graphs/rpg.svg?link=2&amp;maxgap='.$maxgap;if(isset($plyrs)) echo '&amp;plyrs='.$plyrs;?>" type="image/svg+xml" style="width:100%;">
			<span><?php echo $lang['graph']['nosvg'];?></span>
		</object>
<?php
}
?>
	</body>
</html>