<?php
#################################################################
# mpres graphs_svg.php V2.00																		#
# produces race graphs in svg format														#
# directory: script main path																		#
#################################################################
define('NORMAL_ACCESS', null);
error_reporting(E_ERROR | E_WARNING | E_PARSE);
### a sort function ###
function _compSTime($a, $b) {
	global $lap,$s;
	return ($a['sectimes'][$s][$lap] > $b['sectimes'][$s][$lap]) ? +1 : -1;
}
function getpentagonpoints($x,$y) {
	return $x.','.round($y-0.76,2).' '.round($x-7.6,2).','.round($y+5.24,2).' '.round($x-4.72,2).','.round($y+13.72,2).' '.round($x+4.72,2).','.round($y+13.72,2).' '.round($x+7.6,2).','.round($y+5.24,2);
}
function gettrispoints($x,$y) {
	return $x.','.round($y-4,2).' '.round($x-4.72,2).','.round($y+4.48,2).' '.round($x+4.72,2).','.round($y+4.48,2);
}

require_once('global.inc.php');
if(GOT_RESULT === false) exit;
if($racetype==RACETYPE_QUAL) exit;

$unifont = SCRIPTPATH.'fonts/'.$unifont;

### define graphtype to display ###
$allowed_graphtypes = array(GRAPH_BLG, GRAPH_PLR, GRAPH_RPG, GRAPH_PAVG);	# 1: lap-by-lap, 2: player-graph, 3: race-progress
$graphtype = (isset($_GET['graphtype']) && in_array($_GET['graphtype'],$allowed_graphtypes)) ? $_GET['graphtype'] : 1;

if($graphtype==GRAPH_BLG) $gt = 'blg';
if($graphtype==GRAPH_PLR) $gt = 'plg';
if($graphtype==GRAPH_RPG) $gt = 'rpg';
if($graphtype==GRAPH_PAVG) $gt = 'pavg';
$gpl = (isset($_GET['plyrs'])) ? '_'.$_GET['plyrs'] : '';
$gpy = (isset($_GET['player']) && ($graphtype==GRAPH_PLR || $graphtype==GRAPH_PAVG)) ? '_'.$_GET['player'] : '';
$gsi = (isset($_GET['size'])) ? '_si'.intval($_GET['size']) : '';
$gmg = (isset($_GET['maxgap'])) ? '_mg'.intval($_GET['maxgap']) : '';
$olang = getlanguage(OUTLANG, $_SERVER['HTTP_ACCEPT_LANGUAGE'], $ulang, 1);
$graphfile = './images/rendered/graphs/'.$gt.'/'.$gettype.'_'.$getevent.'_'.$getseason.'_R'.$getday.'_G'.$getgrid.'_'.$getsession.'_'.$gt.$gsi.$gmg.'_'.$olang.$gpl.$gpy.'.svg';


if(!is_file($graphfile)) {
$player = (isset($_GET['player']) && array_key_exists(mysub($_GET['player'],1),$playerkeys_finished)) ? $_GET['player'] : '';

### use advanced display only with short races ###
$usefilter = ($maxlapsdone<100) ? ' filter="url(#MyFilter)"' : '';
### set max namewidth & count listed players ###
$maxnamewidth = 0;
$pcount = count($teams);
foreach ($teams as $lfsw=>$data) {
	$car = (convert_car_bits($mprheader['allowedcars'],true)>1) ? ' ('.$teams[$lfsw]['car'].')' : '';
	$name = (count($teams[$lfsw]['drivers'])==1 && $istoc===false) ? html_entity_decode(nameblank($teams[$lfsw]['drivers'][substr($lfsw,1)]['nick'])).$car : html_entity_decode($teams[$lfsw]['name']).$car;
	$bbox = imagettfbbox(10, 0, $unifont, $name);
	$namewidth = $bbox[2]-$bbox[0];
	if($maxnamewidth<$namewidth) $maxnamewidth = $namewidth;
}

### some length variables ###
$secwidth = 10;
$nameoffset = 20;
$nameextra = 20;
$posheight = 30;
$topoffset = 15;
$bottomoffset = 60;
$legendoffset = 25;

### offsets for legend ###
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['exit']);
$exitwidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['penalty']);
$penaltywidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['pitstop']);
$stopwidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['toc']);
$tocwidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['damage']);
$damagewidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['wheel']);
$tyrewidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['rejoin']);
$rejoinwidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['lapped']);
$lappedwidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['yellow']);
$yellowwidth = $bbox[2]-$bbox[0];
$bbox = imagettfbbox(11, 0, $unifont, $lang['graph']['blue']);
$bluewidth = $bbox[2]-$bbox[0];

$epwidth = ($exitwidth>=$penaltywidth) ? $exitwidth : $penaltywidth;
$ptwidth = ($stopwidth>=$tocwidth) ? $stopwidth : $tocwidth;
$dtwidth = ($damagewidth>=$tyrewidth) ? $damagewidth : $tyrewidth;
$rlwidth = ($rejoinwidth>=$lappedwidth) ? $rejoinwidth : $lappedwidth;
$ybwidth = ($yellowwidth>=$bluewidth) ? $yellowwidth : $bluewidth;

$eppos = $nameoffset;
$ptpos = $eppos+$epwidth+15;
$dtpos = $ptpos+$ptwidth+15;
$rlpos = $dtpos+$dtwidth+15;
$ybpos = $rlpos+$rlwidth+15;

switch($graphtype) {
	###lap by lap graph ###
	case GRAPH_BLG:
		### set startpos ###
		foreach ($teams as $lfsw=>$data) {
			if(isset($teams[$lfsw]['startpos'])) $teams[$lfsw]['rank'][0] = $teams[$lfsw]['startpos']+1;
			else $teams[$lfsw]['rank'][0] = ++$mprheader['startplayers'];
		}
		### set positions & lappings for each split ###
		$i=1;
		$lapped = array();
		for($lap=1; $lap<=$maxlapsdone; $lap++) {
			for($s=1; $s<=$sectors; $s++) {
				uasort($teams, "_compSTime");
				$playerkeys = array_keys($teams);
				$pl=1;
				foreach ($teams as $lfsw=>$data) {
					if($pl==1) $leader = $lfsw;
					if((isset($teams[$leader]['sectimes'][$s][$lap+1]) && $teams[$leader]['sectimes'][$s][$lap+1]<=$data['sectimes'][$s][$lap]) && !isset($lapped[$i])) $lapped[$i] = $pl;
					if($data['sectimes'][$s][$lap]) $teams[$lfsw]['rank'][$i] = $pl++;
				}
				$i++;
			}
		}

		### get desired width if set ###
		if($bpos+$bwidth>($maxlapsdone*$secwidth*$sectors)+2*($maxnamewidth+$nameoffset+$nameextra)) $secwidth = ($bpos+$bwidth -2*($maxnamewidth+$nameoffset+$nameextra))/($maxlapsdone*$sectors);
		$width = ($maxlapsdone*$secwidth*$sectors)+2*($maxnamewidth+$nameoffset+$nameextra);
		$height = (($pcount+1)*$posheight)+$topoffset+$bottomoffset;

		$desired_size = (!empty($_GET['size']) && is_numeric($_GET['size'])) ? intval($_GET['size']) : $width;
		$wh = $width/$height;

		### begin SVG (set size & viewbox)###
		$header = '<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
	<svg xmlns="http://www.w3.org/2000/svg"
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:ev="http://www.w3.org/2001/xml-events"
 onload="getSVGDoc(evt)" onzoom="ZoomControl()"
	version="1.1" baseProfile="full"
	width="'.$desired_size.'px" height="'.mydiv($desired_size,$wh).'px" viewBox="0 0 '.$width.' '.$height.'">
		<desc>'.$lang['blg']['alt'].'</desc>
		<defs>
			<filter id="MyFilter" filterUnits="userSpaceOnUse">
        <feGaussianBlur in="SourceAlpha" stdDeviation="2" result="out1" />
        <feOffset in="out1" dx="4" dy="3" result="out2" />
        <feSpecularLighting in="out1" surfaceScale="3" specularExponent="50" specularConstant="0.7" result="out3">
        <fePointLight x="-150" y="-200" z="100" />
        </feSpecularLighting>
        <feComposite in="SourceGraphic" in2="out3" operator="arithmetic" k1="0" k2="1" k3="1" k4="0" result="out4" />
        <feComposite in="out4" in2="out2" operator="over" />
      </filter> 
<script type="text/javascript">
  <![CDATA[
  var svgdoc,svgroot;

  function getSVGDoc(load_evt)
  {
    svgdoc=load_evt.target.ownerDocument;
    svgroot=svgdoc.documentElement;
  }

  function TextHover(objid,color,decor)
  {
    var element;
    element=svgdoc.getElementById(objid);
    element.setAttribute("style","font-size: 12px; fill: "+color+"; text-decoration: "+decor);
  }

  function SetOpacity(e,op)
  {
    e.target.style.setProperty("fill-opacity",op,"");
  }

  function ShowTooltip(e,txt)
  {
    var ttrelem, ttrelem, posx, posy, curtrans, ctx, cty;
         var newScale = svgroot.currentScale;
         var tipScale = 1/newScale;
    ttrelem=svgdoc.getElementById("ttr");
    tttelem=svgdoc.getElementById("ttt");
    tttelem.childNodes.item(0).data=txt
if (e.pageX) posx = e.pageX;
else if (e.clientX)
   posx = e.clientX + (document.documentElement.scrollLeft) ? document.documentElement.scrollLeft : document.body.scrollLeft;
if (e.pageY) posy = e.pageY;
else if (e.clientY)
   posy = e.clientY + (document.documentElement.scrollTop) ? document.documentElement.scrollTop : document.body.scrollTop;

    curtrans=svgroot.currentTranslate;
    ctx=curtrans.x;
    cty=curtrans.y;
         posx = (posx - ctx)/newScale;
         posy = (posy - cty)/newScale;
    ttrelem.setAttribute("x",posx + (10 * tipScale));
    ttrelem.setAttribute("y",posy + (10 * tipScale));
    tttelem.setAttribute("x",posx + (10 * tipScale) + 5);
    tttelem.setAttribute("y",posy + (10 * tipScale) + 12);
    ttrelem.setAttribute("width",tttelem.getComputedTextLength()+10);
    tttelem.setAttribute("style","fill: #0000CC; font-size: 11px; visibility: visible");
    ttrelem.setAttribute("style","fill: #FFFFCC; stroke: #000000; stroke-width: 0.5px; visibility: visible");
  }

  function HideTooltip()
  {
    var ttrelem, ttrelem;
    ttrelem=svgdoc.getElementById("ttr");
    tttelem=svgdoc.getElementById("ttt");
    ttrelem.setAttribute("style","visibility: hidden");
    tttelem.setAttribute("style","visibility: hidden");
  }

  function ZoomControl()
  {
    var curzoom;
    curzoom=svgroot.currentScale;
    svgdoc.getElementById("tooltip").setAttribute("transform","scale("+1/curzoom+")");
  }
  ]]>
</script>
		</defs>
		<rect x="0" y="0" width="'.$width.'" height="'.$height.'" fill="'.$col[0].'" stroke="'.$col[0].'" stroke-width="2" />';

		$usegrid = ($events[$gettype][$getevent]['seasons'][$getseason]['maxgrids']>0) ? '/G'.$getgrid : '';
		$useday = ($events[$gettype][$getevent]['seasons'][$getseason]['maxdays']>0) ? '/R'.$getday : '';
		if($_GET['link']==1) {
			$link = '
		<a target="_blank" xlink:href="'.SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.$useday.$usegrid.'/'.$getsession.'/graphs/blg.html">
			<rect x="0" y="0" width="'.$width.'" height="'.$height.'" fill-opacity="0" />
		</a>';
		}
		elseif($_GET['link']==2) {
			$link = '
		<a target="_blank" xlink:href="'.SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.$useday.$usegrid.'/'.$getsession.'/graphs/blg_'.$width.'.svg?plyrs='.$_GET['plyrs'].'">
			<rect x="0" y="0" width="'.$width.'" height="'.$height.'" fill-opacity="0" />
		</a>';
		}


		### draw bars for lapped players ###
		$lappoints = '';
		$lapkeys = array_keys($lapped);
		foreach($lapped as $split=>$pos) {
			$lappoints .= " ";
			$lappoints .= $maxnamewidth+$nameoffset+$nameextra-$secwidth+($secwidth*($split+1))-($secwidth/2).','.$pos*$posheight;
			$lappoints .= " ";
			$lappoints .= $maxnamewidth+$nameoffset+$nameextra-$secwidth+($secwidth*($split+1))+($secwidth/2).','.$pos*$posheight;
		}
		$lappointfirst = $maxnamewidth+$nameoffset+$nameextra-$secwidth+($secwidth*($lapkeys[0]+1))-($secwidth/2);
		$lappointfirst .= ',';
		$lappointfirst .= $height-$bottomoffset;
		$lappointlast = ' ';
		$lappointlast .= $maxnamewidth+$nameoffset+$nameextra-$secwidth+($secwidth*(array_pop($lapkeys)+1))+($secwidth/2);
		$lappointlast .= ',';
		$lappointlast .= $height-$bottomoffset;

		$lappedbg = '
		<polyline fill="rgb(178,178,178)" stroke="rgb(178,178,178)" stroke-width="1" points="'.$lappointfirst.$lappoints.$lappointlast.'" />';
		$grid = '
		<g stroke-width="1" stroke="black">';
		$axtext = '
		<g font-family="sans-serif" font-size="10" fill="black">';
		$i=1;
		do {
			# lap
			if($i % $sectors == 0) 		$grid .= '
			<line x1="'.myadd(myadd(myadd(mymul($i,$secwidth),$maxnamewidth),$nameoffset),$nameextra).'" y1="'.$topoffset.'" x2="'.myadd(myadd(myadd(mymul($i,$secwidth),$maxnamewidth),$nameoffset),$nameextra).'" y2="'.mysub($height,$bottomoffset).'" />';
			# split
			else $grid .= '
			<line x1="'.myadd(myadd(myadd(mymul($i,$secwidth),$maxnamewidth),$nameoffset),$nameextra).'" y1="'.$topoffset.'" x2="'.myadd(myadd(myadd(mymul($i,$secwidth),$maxnamewidth),$nameoffset),$nameextra).'" y2="'.mysub($height,$bottomoffset).'" stroke="gray" />';
			# lap number above
			if(($sectors+1)&1 && $i % $sectors == $sectors/2) $axtext .= '
			<text x="'.mysub(myadd(myadd(myadd(mymul($i,$secwidth),$maxnamewidth),$nameoffset),$nameextra),4).'" y="10">'.ceil($i/$sectors).'</text>';
			elseif($sectors&1 && $i % $sectors == ($sectors-1)/2 ) $axtext .= '
			<text x="'.mysub(myadd(myadd(myadd(myadd(mymul($i,$secwidth),$maxnamewidth),$nameoffset),$nameextra),mydiv($secwidth,2)),4).'" y="10">'.ceil($i/$sectors).'</text>';
			# lap number below
			if(($sectors+1)&1 && $i % $sectors == $sectors/2) $axtext .= '
			<text x="'.mysub(myadd(myadd(myadd(mymul($i,$secwidth),$maxnamewidth),$nameoffset),$nameextra),4).'" y="'.myadd(mysub($height,$bottomoffset),10).'">'.ceil($i/$sectors).'</text>';
			elseif($sectors&1 && $i % $sectors == ($sectors-1)/2 ) $axtext .= '
			<text x="'.mysub(myadd(myadd(myadd(myadd(mymul($i,$secwidth),$maxnamewidth),$nameoffset),$nameextra),mydiv($secwidth,2)),4).'" y="'.myadd(mysub($height,$bottomoffset),10).'">'.ceil($i/$sectors).'</text>';
		} while (++$i<=$maxlapsdone*$sectors);
		### put starting-positions & position-lines ###
		$i=1;
		do {
			$grid .= '
			<line x1="'.myadd(myadd($maxnamewidth,$nameoffset),$nameextra).'" y1="'.myadd(mymul($i,$posheight),mydiv($posheight,2)).'" x2="'.mysub(mysub($width,$maxnamewidth),myadd($nameoffset,$nameextra)).'" y2="'.myadd(mymul($i,$posheight),mydiv($posheight,2)).'" stroke="gray" />';
		} while(++$i<=$pcount);

		### put split- & laplines, lap-numbers, start, finish ###
		$axtext .= '
			<text x="40" y="10">'.$lang['general']['start'].'</text>';
		$axtext .= '
			<text x="'.myadd(myadd(myadd(myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),$maxnamewidth),$nameoffset),$nameextra),25).'" y="10">'.$lang['general']['finish'].'</text>';
		### put axes ###
		$axes = '
		<rect x="'.myadd(myadd($maxnamewidth,$nameoffset),$nameextra).'" y="'.$topoffset.'" width="'.mymul(mymul($maxlapsdone,$sectors),$secwidth).'" height="'.mymul(myadd($pcount,1),$posheight).'" fill="none" stroke-width="2" stroke="black" />';


		### make legend ###
		$legend = '
		<g font-family="sans-serif" font-size="11" fill="black">';
		### Exit ###
		$legend .= '
			<rect x="'.mysub($eppos,4).'" y="'.mysub(mysub($height,$legendoffset),20).'" width="16" height="16" stroke-width="1" stroke="black" fill="white" />
			<text x="'.$eppos.'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['E'].'</text>
			<text x="'.myadd($eppos,16).'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['exit'].'</text>';
		### Penlaps ###
		$legend .= '
			<rect x="'.mysub($eppos,4).'" y="'.mysub($height,$legendoffset).'" width="16" height="16" stroke-width="1" stroke="black" fill="white" />
			<text x="'.$eppos.'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['Pen'].'</text>
			<text x="'.myadd($eppos,16).'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['penalty'].'</text>';
		### pitstop ###
		$legend .= '
			<circle cx="'.myadd($ptpos,3).'" cy="'.mysub(mysub($height,$legendoffset),12).'" r="8" stroke-width="1" stroke="black" fill="white" />
			<text x="'.$ptpos.'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['P'].'</text>
			<text x="'.myadd($ptpos,16).'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['pitstop'].'</text>';
		### pitstop + Takeover ###
		$legend .= '
			<circle cx="'.myadd($ptpos,3).'" cy="'.myadd(mysub($height,$legendoffset),8).'" r="8" stroke-width="1" stroke="black" fill="white" />
			<text x="'.$ptpos.'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['T'].'</text>
			<text x="'.myadd($ptpos,16).'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['toc'].'</text>';
		### engine damage ###
			$legend .= '
			<polygon points="'.getpentagonpoints($dtpos, mysub(mysub($height,$legendoffset),20)).'" fill="white" stroke="black" stroke-width="1" />
			<text x="'.mysub($dtpos,0).'" y="'.myadd(mysub($height,$legendoffset),-8).'" text-anchor="middle" fill="black" >'.$lang['graph']['D'].'</text>
			<text x="'.myadd($dtpos,16).'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['damage'].'</text>';
		### tyre broken ###
			$legend .= '
			<polygon points="'.getpentagonpoints($dtpos, mysub(mysub($height,$legendoffset),0)).'" fill="white" stroke="black" stroke-width="1" />
			<text x="'.mysub($dtpos,0).'" y="'.myadd(mysub($height,$legendoffset),12).'" text-anchor="middle" fill="black" >'.$lang['graph']['W'].'</text>
			<text x="'.myadd($dtpos,16).'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['wheel'].'</text>';
		### rejoin ###
		$legend .= '
			<polygon points="'.gettrispoints($rlpos, mysub(mysub($height,$legendoffset),12)).'" fill="black" stroke="black" stroke-width="1" />
			<text x="'.myadd($rlpos,16).'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['rejoin'].'</text>';
		### lapped ###
		$legend .= '
			<rect x="'.mysub($rlpos,8).'" y="'.mysub(mysub($height,$legendoffset),4).'" width="20" height="20" fill="rgb(178,178,178)" stroke-width="1" stroke="rgb(178,178,178)" />
			<text x="'.myadd($rlpos,16).'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['lapped'].'</text>';
		### yellow flags ###
		$legend .= '
			<circle cx="'.$ybpos.'" cy="'.mysub(mysub($height,$legendoffset),12).'" r="4" stroke-width="1" stroke="black" fill="yellow" />
			<text x="'.myadd($ybpos,10).'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['yellow'].'</text>';
		### blue flags ###
		$legend .= '
			<circle cx="'.$ybpos.'" cy="'.myadd(mysub($height,$legendoffset),8).'" r="4" stroke-width="1" stroke="black" fill="blue" />
			<text x="'.myadd($ybpos,10).'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['blue'].'</text>';


		$names = '
		<g font-family="sans-serif" font-size="12" fill="black">';
		$lines = '
		<g stroke-width="2"'.$usefilter.'>';
    		$symbols = '
				<g font-family="sans-serif" font-size="11"'.$usefilter.'>';

		### resort players array ###
		unset($ldone);
		unset($ttime);
		unset($fin);
		foreach ($teams as $lfsw => $data) {
			$ldone[$lfsw] = $data['totlaps'];
			$ttime[$lfsw] = $data['tottime'];
			$fin[$lfsw] = $teams[$lfsw]['finished'];
		}
		array_multisort($fin, SORT_DESC, $ldone, SORT_DESC, $ttime, SORT_ASC, $teams);
		$playerkeys = array_keys($teams);
		### select players to draw ###
		if(isset($_GET['plyrs'])) {
			$plyrs = explode("_",$_GET['plyrs']);
			foreach ($plyrs as $plyr) if(array_key_exists($plyr,$playerkeys)) $showpids[$plyr] = $playerkeys[$plyr];
		}
		### draw each player's lines ###
		$id=0;
		foreach ($teams as $lfsw=>$data) {
			$id++;
			### skip player if not selected
			if (!empty($showpids) && !in_array($lfsw,$showpids)) continue;
			$car = (convert_car_bits($mprheader['allowedcars'],true)>1) ? ' ('.$teams[$lfsw]['car'].')' : '';
			$name = (count($teams[$lfsw]['drivers'])==1 && $istoc===false) ? nameblank($teams[$lfsw]['drivers'][substr($lfsw,1)]['nick']).$car : nameblank($teams[$lfsw]['name']).$car;
			# name left
			$names .= '
			<text x="'.$nameoffset.'" y="'.myadd(mymul($data['rank'][0],$posheight),10).'">'.$name.'</text>';
			# name right
			$names .= '
			<text x="'.myadd(myadd(myadd(myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),$maxnamewidth),$nameoffset),$nameextra),5).'" y="'.myadd(mymul($id,$posheight),10).'">'.$name.'</text>';
			# startpos
			if(isset($teams[$lfsw]['startpos'])) $axtext .= '
			<text x="5" y="'.myadd(mymul($data['rank'][0],$posheight),mydiv($posheight,2)).'">'.$data['rank'][0].'</text>';
			else $axtext .= '
			<text x="5" y="'.myadd(mymul($data['rank'][0],$posheight),mydiv($posheight,2)).'">'.$lang['graph']['P'].'</text>';
			# race result (position)
			if($data['DQ']==1) $axtext .= '
			<text x="'.myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),myadd(myadd(myadd(mymul($maxnamewidth,2),$nameoffset),$nameextra),10)).'" y="'.myadd(mymul($id,$posheight),15).'">'.$lang['general']['DQ'].'</text>';
			elseif($data['finished']===true) $axtext .= '
			<text x="'.myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),myadd(myadd(myadd(mymul($maxnamewidth,2),$nameoffset),$nameextra),10)).'" y="'.myadd(mymul($id,$posheight),15).'">'.$id.'</text>';
			elseif(($teams[$lfsw]['lapsdone']<floor($maxlapsdone*$minracepart))) $axtext .= '
			<text x="'.myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),myadd(myadd(myadd(mymul($maxnamewidth,2),$nameoffset),$nameextra),10)).'" y="'.myadd(mymul($id,$posheight),15).'">'.$lang['general']['DNF'].'</text>';
			else $axtext .= '
			<text x="'.myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),myadd(myadd(myadd(mymul($maxnamewidth,2),$nameoffset),$nameextra),10)).'" y="'.myadd(mymul($id,$posheight),15).'">'.$id.'†</text>';
			# line on the left
			$lines .= '
			<line x1="'.$nameoffset.'" y1="'.myadd(mymul($data['rank'][0],$posheight),mydiv($posheight,2)).'" x2="'.myadd(myadd($nameoffset,$nameextra),$maxnamewidth).'" y2="'.myadd(mymul($data['rank'][0],$posheight),mydiv($posheight,2)).'" stroke="'.$col[$id].'" />';
			# line on the right
			$lines .= '
			<line x1="'.myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),myadd(myadd($maxnamewidth,$nameoffset),$nameextra)).'" y1="'.myadd(mymul($id,$posheight),mydiv($posheight,2)).'" x2="'.myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),myadd(myadd(myadd(mymul($maxnamewidth,2),$nameoffset),$nameextra),5)).'" y2="'.myadd(mymul($id,$posheight),mydiv($posheight,2)).'" stroke="'.$col[$id].'" />';
			# draw the line
			unset($posline);
			foreach ($data['rank'] as $split=>$rank) {
			if($split==$sectors*$data['totlaps']+1 && $data['totlaps']!=$data['lapsdone']) {
				$symbols .= '
			<rect x="'.mysub(myadd(myadd(myadd($nameoffset,$nameextra),$maxnamewidth),mymul($secwidth,($split-1))),8).'" y="'.mysub(myadd(mymul($data['rank'][$split-1],$posheight),mydiv($posheight,2)),8).'" width="16" height="16" fill="white" stroke="'.$col[$id].'" stroke-width="1" />
			<text x="'.mysub(myadd(myadd(myadd($nameoffset,$nameextra),$maxnamewidth),mymul($secwidth,($split-1))),4).'" y="'.myadd(myadd(mymul($data['rank'][$split-1],$posheight),mydiv($posheight,2)),4).'" fill="'.$col[$id].'" >'.$lang['graph']['Pen'].'</text>';
				}
				$lastx = $maxnamewidth+$nameoffset+$nameextra+($secwidth*$split);
				$lasty = $rank*$posheight+($posheight/2);
				$posline .= ' ';
				$posline .= $maxnamewidth+$nameoffset+$nameextra+($secwidth*$split);
				$posline .= ',';
				$posline .=$rank*$posheight+($posheight/2);
				### player in race -> draw full line ###

				### player rejoined ###
				if(in_array(ceil(($split+$sectors)/$sectors),$data['rejoins']) && $split % $sectors == 0) {
						$rpoints = $lastx.','.round($lasty-4,2).' '.round($lastx-4.72,2).','.round($lasty+4.48,2).' '.round($lastx+4.72,2).','.round($lasty+4.48,2);
						$symbols .= '
			<polygon points="'.$rpoints.'" fill="'.$col[$id].'" stroke="'.$col[$id].'" stroke-width="1" />';
				}
				### player resetted ###
				if($data['reset'][ceil($split/$sectors)]) {
					$resets = str_split($data['reset'][ceil($split/$sectors)],1);
					foreach($resets as $sec) {
						if(($split % $sectors == $sec) || ($split % $sectors == 0 && $sec == $sectors)) {
						$rpoints = $lastx.','.round($lasty-4,2).' '.round($lastx-4.72,2).','.round($lasty+4.48,2).' '.round($lastx+4.72,2).','.round($lasty+4.48,2);
						$symbols .= '
			<polygon points="'.$rpoints.'" fill="'.$col[$id].'" stroke="'.$col[$id].'" stroke-width="1" />';
						}
					}
				}
				### player got engine damage ###
				if($data['engdamage'][ceil($split/$sectors)]) {
					$dams = explode('#',$data['engdamage'][ceil($split/$sectors)]);
					foreach($dams as $sec) {
						if((($split % $sectors == $sec{0}) || ($split % $sectors == 0 && $sec{0} == $sectors)) && !empty($sec)) {
						$dampoints = $lastx.','.round($lasty-8,2).' '.round($lastx-7.6,2).','.round($lasty-2.48,2).' '.round($lastx-4.72,2).','.round($lasty+6.48,2).' '.round($lastx+4.72,2).','.round($lasty+6.48,2).' '.round($lastx+7.6,2).','.round($lasty-2.48,2);
						$symbols .= '
			<polygon points="'.$dampoints.'" fill="white" stroke="'.$col[$id].'" stroke-width="1" onmousemove="ShowTooltip(evt,\''.substr($sec,1).'%\')" onmouseout="HideTooltip()" />
			<text x="'.mysub($lastx,0).'" y="'.myadd($lasty,4).'" text-anchor="middle" fill="'.$col[$id].'" onmousemove="ShowTooltip(evt,\''.substr($sec,1).'%\')" onmouseout="HideTooltip()" >'.$lang['graph']['D'].'</text>';
						}
					}
				}
				### player broke tyre ###
				if($data['tbreak'][ceil($split/$sectors)]) {
					$tyres = array(1 => 'RL', 2 => 'RR', 4 => 'FL', 8 => 'FR');
					$break = str_split($data['tbreak'][ceil($split/$sectors)],2);
					$dams = explode('#',$data['engdamage'][ceil($split/$sectors)]);
					foreach($break as $sec) {
						$tyre = array();
						$tyre[] = $tyres[$sec{1}];
						if((($split % $sectors == $sec{0}) || ($split % $sectors == 0 && $sec{0} == $sectors)) && !empty($sec)) {
						$dampoints = $lastx.','.round($lasty-8,2).' '.round($lastx-7.6,2).','.round($lasty-2.48,2).' '.round($lastx-4.72,2).','.round($lasty+6.48,2).' '.round($lastx+4.72,2).','.round($lasty+6.48,2).' '.round($lastx+7.6,2).','.round($lasty-2.48,2);
						$symbols .= '
			<polygon points="'.$dampoints.'" fill="white" stroke="'.$col[$id].'" stroke-width="1" onmousemove="ShowTooltip(evt,\''.implode(', ', $tyre).'\')" onmouseout="HideTooltip()" />
			<text x="'.mysub($lastx,0).'" y="'.myadd($lasty,4).'" text-anchor="middle" fill="'.$col[$id].'" onmousemove="ShowTooltip(evt,\''.implode(', ', $tyre).'\')" onmouseout="HideTooltip()" >'.$lang['graph']['W'].'</text>';
						}
					}
				}
				### player pitted ###
				if($data['pitstops'][ceil($split/$sectors)] && $split % $sectors == $sectors-1) {
					$text = ($data['pitstops'][ceil($split/$sectors)]['from']!=$data['pitstops'][ceil($split/$sectors)]['to'] && !empty($data['pitstops'][ceil($split/$sectors)]['to'])) ? $lang['graph']['T'] : $lang['graph']['P'];
					$from = (empty($data['drivers'][$data['pitstops'][ceil($split/$sectors)]['from']]['realname'])) ? nameblank($data['drivers'][$data['pitstops'][ceil($split/$sectors)]['from']]['nick']) : nameblank($data['drivers'][$data['pitstops'][ceil($split/$sectors)]['from']]['realname']);
					$to = (empty($data['drivers'][$data['pitstops'][ceil($split/$sectors)]['to']]['realname'])) ? nameblank($data['drivers'][$data['pitstops'][ceil($split/$sectors)]['to']]['nick']) : nameblank($data['drivers'][$data['pitstops'][ceil($split/$sectors)]['to']]['realname']);
					$title1 = ($data['pitstops'][ceil($split/$sectors)]['from']!=$data['pitstops'][ceil($split/$sectors)]['to'] && !empty($data['pitstops'][ceil($split/$sectors)]['to'])) ? $from.' => '.$to : $from;
					$symbols .= '
			<circle cx="'.myadd(myadd(myadd($nameoffset,$nameextra),$maxnamewidth),mymul($secwidth,$split)).'" cy="'.myadd(mymul($rank,$posheight),mydiv($posheight,2)).'" r="8" fill="white" stroke="'.$col[$id].'" stroke-width="1" onmousemove="ShowTooltip(evt,\''.$title1.': '.printTime($data['pitstops'][ceil($split/$sectors)]['time']).'s\')" onmouseout="HideTooltip()" />
			<text x="'.mysub(myadd(myadd(myadd($nameoffset,$nameextra),$maxnamewidth),mymul($secwidth,$split)),3).'" y="'.myadd(myadd(mymul($rank,$posheight),mydiv($posheight,2)),4).'" fill="'.$col[$id].'" onmousemove="ShowTooltip(evt,\''.$title1.': '.printTime($data['pitstops'][ceil($split/$sectors)]['time']).'s\')" onmouseout="HideTooltip()" >'.$text.'</text>';
				}
				### player caused yellow flag ###
				if($data['yellowflags'][ceil($split/$sectors)]) {
					$flags = str_split($data['yellowflags'][ceil($split/$sectors)],1);
					foreach($flags as $sec) {
						if(($split % $sectors == $sec) || ($split % $sectors == 0 && $sec == $sectors)) {
						$symbols .= '
			<circle cx="'.myadd(myadd(myadd($nameoffset,$nameextra),$maxnamewidth),mymul($secwidth,$split)).'" cy="'.myadd(mymul($rank,$posheight),mydiv($posheight,2)).'" r="4" fill="yellow" stroke="'.$col[$id].'" stroke-width="1" />';
						}
					}
				}
				### player saw blue flag ###
				if($data['blueflags'][ceil($split/$sectors)]) {
					$flags = str_split($data['blueflags'][ceil($split/$sectors)],1);
					foreach($flags as $sec) {
						if(($split % $sectors == $sec) || ($split % $sectors == 0 && $sec == $sectors)) {
						$symbols .= '
			<circle cx="'.myadd(myadd(myadd($nameoffset,$nameextra),$maxnamewidth),mymul($secwidth,$split)).'" cy="'.myadd(mymul($rank,$posheight),mydiv($posheight,2)).'" r="4" fill="blue" stroke="'.$col[$id].'" stroke-width="1" />';
						}
					}
				}
			}
		$lines .= '
			<polyline fill="none" stroke="'.$col[$id].'" stroke-width="2" points="'.$posline.'" onmousemove="ShowTooltip(evt,\''.$name.'\')" onmouseout="HideTooltip()" />';

			### player not in race -> draw dashed line ###
			if(count($data['rank'])<$sectors*$maxlapsdone && $data['finished']===true) 			$lines .= '
			<line x1="'.myadd(myadd(myadd($nameoffset,$nameextra),$maxnamewidth),mymul($secwidth,mysub(count($data['rank']),1))).'" y1="'.myadd(mymul(array_pop($data['rank']),$posheight),mydiv($posheight,2)).'" x2="'.myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),myadd(myadd($maxnamewidth,$nameoffset),$nameextra)).'" y2="'.myadd(mymul($id,$posheight),mydiv($posheight,2)).'" stroke="'.$col[$id].'" stroke-width="2" stroke-dasharray="4, 2" />';

			### player not in race -> draw dashed line ###
			if(count($data['rank'])<$sectors*$maxlapsdone && $data['finished']===false) {
				$finrank = array_pop($data['rank']);
				$lines .= '
			<line x1="'.myadd(myadd(myadd($nameoffset,$nameextra),$maxnamewidth),mymul($secwidth,count($data['rank']))).'" y1="'.myadd(myadd(mymul($finrank,$posheight),mydiv($posheight,2)),8).'" x2="'.myadd(myadd(myadd($nameoffset,$nameextra),$maxnamewidth),mymul($secwidth,count($data['rank']))).'" y2="'.myadd(mymul($id,$posheight),mydiv($posheight,2)).'" stroke="'.$col[$id].'" stroke-width="2" stroke-dasharray="2, 6" />';
				$lines .= '
			<line x1="'.myadd(myadd(myadd($nameoffset,$nameextra),$maxnamewidth),mymul($secwidth,count($data['rank']))).'" y1="'.myadd(mymul($id,$posheight),mydiv($posheight,2)).'" x2="'.myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),myadd(myadd($maxnamewidth,$nameoffset),$nameextra)).'" y2="'.myadd(mymul($id,$posheight),mydiv($posheight,2)).'" stroke="'.$col[$id].'" stroke-width="2" stroke-dasharray="2, 6" />';
				$symbols .= '
			<rect x="'.mysub(myadd(myadd(myadd($nameoffset,$nameextra),$maxnamewidth),mymul($secwidth,count($data['rank']))),8).'" y="'.mysub(myadd(mymul($finrank,$posheight),mydiv($posheight,2)),8).'" width="16" height="16" fill="white" stroke="'.$col[$id].'" stroke-width="1" />
			<text x="'.mysub(myadd(myadd(myadd($nameoffset,$nameextra),$maxnamewidth),mymul($secwidth,count($data['rank']))),4).'" y="'.myadd(myadd(mymul($finrank,$posheight),mydiv($posheight,2)),4).'" fill="'.$col[$id].'" >'.$lang['graph']['E'].'</text>';
			}
		}

		$grid .= '
		</g>';
		$legend .= '
		</g>';
		$axtext .= '
		</g>';
		$names .= '
		</g>';
		$lines .= '
		</g>';
		$symbols .= '
		</g>';
		$footer = '
<g id="tooltip">
  <rect id="ttr" x="0" y="0" rx="5" ry="5" width="100" height="16" style="visibility: hidden"/>
  <text id="ttt" x="0" y="0" style="visibility: hidden">dyn. Text</text>
</g>
</svg>';
		break;

	case GRAPH_PLR:
		### get player & some special laptimes ###
		$pid = (isset($_GET['player']) && array_key_exists(mysub($_GET['player'],1),$playerkeys_finished)) ? $playerkeys_finished[mysub($_GET['player'],1)] : die($lang['graph']['noplayer']);
		if($teams[$pid]['lapsdone']==0) die($lang['graph']['nolaps']);
		for($lap=1; $lap<=$teams[$pid]['lapsdone']; $lap++) {
			if(!$worstlap || $teams[$pid]['sectimes']['lap'][$lap]-$teams[$pid]['sectimes']['lap'][$lap-1]>$worstlap) $worstlap = $teams[$pid]['sectimes']['lap'][$lap]-$teams[$pid]['sectimes']['lap'][$lap-1];
		}
		$bestlap = $teams[$pid]['bestsectime']['lap'];
		$lap107 = $bestlap*1.07;

		### create image & set some colors ###
		$width = 550;
		$lineheight = 16;
		$height = $lineheight*$teams[$pid]['lapsdone']+60;


		### create image & set some colors ###
		$desired_size = (!empty($_GET['size']) && is_numeric($_GET['size'])) ? intval($_GET['size']) : $width;
		$wh = $width/$height;

		$header = '<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
	<svg width="'.$desired_size.'px" height="'.mydiv($desired_size,$wh).'px" viewBox="0 0 '.$width.' '.$height.'" xmlns="http://www.w3.org/2000/svg" version="1.1">
		<desc>'.$lang['plg']['alt'].'</desc>
		<defs>
			<filter id="MyFilter" filterUnits="userSpaceOnUse">
        <feGaussianBlur in="SourceAlpha" stdDeviation="2" result="out1" />
        <feOffset in="out1" dx="4" dy="3" result="out2" />
        <feSpecularLighting in="out1" surfaceScale="3" specularExponent="50" specularConstant="0.7" result="out3">
        <fePointLight x="-150" y="-200" z="100" />
        </feSpecularLighting>
        <feComposite in="SourceGraphic" in2="out3" operator="arithmetic" k1="0" k2="1" k3="1" k4="0" result="out4" />
        <feComposite in="out4" in2="out2" operator="over" />
      </filter> 
		</defs>
		<rect x="0" y="0" width="'.$width.'" height="'.$height.'" fill="rgb(255, 255, 234)" stroke="rgb(255, 255, 234" stroke-width="2" />';

		$grid = '
		<g stroke-width="1" stroke="black">';
		$names = '
		<g font-family="sans-serif" font-size="12" fill="black">';
		$axtext = '
		<g font-family="sans-serif" font-size="10" fill="black">';
		$lines = '
		<g stroke-width="1" stroke="black" height="'.$lineheight.'">';
		$linetext = '
		<g font-family="sans-serif" font-size="10" fill="black">';

		$car = (convert_car_bits($mprheader['allowedcars'],true)>1) ? ' ('.$teams[$pid]['car'].')' : '';
		$name = (count($teams[$pid]['drivers'])==1 && $istoc===false) ? nameblank($teams[$pid]['drivers'][substr($pid,1)]['nick']).$car : nameblank($teams[$pid]['name']).$car;
		$names .= '
			<text x="225" y="20">'.$name.'</text>';

		### put each lap ###
		for($lap=1; $lap<=$teams[$pid]['lapsdone']; $lap++) {
			$l = array();
			# get time and textwidth for splittimes #
			for($s=1; $s<=$sectors; $s++) {
				$str = 's'.$s;
				if($s==1) ${$str} = $teams[$pid]['sectimes'][$s][$lap]-$teams[$pid]['sectimes'][$sectors][$lap-1];
				else ${$str} = $teams[$pid]['sectimes'][$s][$lap]-$teams[$pid]['sectimes'][$s-1][$lap];
			}
			# get time and textwidth for laptimes #
			$l = $teams[$pid]['sectimes']['lap'][$lap]-$teams[$pid]['sectimes']['lap'][$lap-1];
			# put line & number for lap
			$grid .= '
			<line  x1="10" y1="'.myadd(mymul($lap,$lineheight),30).'" x2="'.mysub($width,40).'" y2="'.myadd(mymul($lap,$lineheight),30).'" />';
			# lap number above
			$axtext .= '
			<text x="'.mysub($width,35).'" y="'.myadd(mymul($lap,$lineheight),34).'">'.$lap.'</text>';
			$lapwidth = ($l-$bestlap)/($worstlap-$bestlap)*275+225;

			# rejoin lap
			if(in_array($lap,$teams[$pid]['rejoins']) || array_key_exists($lap, $teams[$pid]['reset'])) $lines .= '
			<rect x="10" y="'.myadd(myadd(mymul(mysub($lap,1),$lineheight),30),mydiv($lineheight,2)).'" width="'.$lapwidth.'" height="'.$lineheight.'" fill="#ff0000" />';
			# lap with pitstop
			if($teams[$pid]['pitstops'][$lap]) $lines .= '
			<rect x="10" y="'.myadd(myadd(mymul(mysub($lap,1),$lineheight),30),mydiv($lineheight,2)).'" width="'.$lapwidth.'" height="'.$lineheight.'" fill="#ffff00" />';
			# player's best lap
			elseif($l==$bestlap) $lines .= '
			<rect x="10" y="'.myadd(myadd(mymul(mysub($lap,1),$lineheight),30),mydiv($lineheight,2)).'" width="'.$lapwidth.'" height="'.$lineheight.'" fill="#0000ff" />';
			# lap outside 107%
			elseif($l>$lap107) $lines .= '
			<rect x="10" y="'.myadd(myadd(mymul(mysub($lap,1),$lineheight),30),mydiv($lineheight,2)).'" width="'.$lapwidth.'" height="'.$lineheight.'" fill="#ff0000" />';
			# each other lap
			else  $lines .= '
			<rect x="10" y="'.myadd(myadd(mymul(mysub($lap,1),$lineheight),30),mydiv($lineheight,2)).'" width="'.$lapwidth.'" height="'.$lineheight.'" fill="#00ff00" />';
			$linetext .= '
			<text x="15" y="'.myadd(mymul($lap,$lineheight),34).'">';
			if($sectors>1) $linetext .= printTime($s1);
			if($sectors>=2) $linetext .= '<tspan dx="10px">'.printTime($s2).'</tspan>';
			if($sectors>=3) $linetext .= '<tspan dx="10px">'.printTime($s3).'</tspan>';
			if($sectors>=4) $linetext .= '<tspan dx="10px">'.printTime($s4).'</tspan>';
			$linetext .= '<tspan dx="10px">=><tspan dx="10px">'.printTime($l).'</tspan></tspan>';
			if(in_array($lap,$teams[$pid]['rejoins'])) $linetext .= '<tspan dx="70px">'.$lang['graph']['rejoin'].'</tspan>';
			if($teams[$pid]['pitstops'][$lap] && $teams[$pid]['pitstops'][$lap]['from']!=$teams[$pid]['pitstops'][$lap]['to']) {
				$from = (empty($players[$teams[$pid]['pitstops'][$lap]['from']]['realname'])) ? nameblank($players[$teams[$pid]['pitstops'][$lap]['from']]['teams'][$lfsw]['nick']) : nameblank($players[$teams[$pid]['pitstops'][$lap]['from']]['realname']);
				$to = (empty($players[$teams[$pid]['pitstops'][$lap]['to']]['realname'])) ? nameblank($players[$teams[$pid]['pitstops'][$lap]['to']]['teams'][$lfsw]['nick']) : nameblank($players[$teams[$pid]['pitstops'][$lap]['to']]['realname']);
				$linetext .= '<tspan dx="45px">'.$lang['graph']['pitstop'].' ('.printTime($teams[$pid]['pitstops'][$lap]['time']).') '.$from.' => '.$to.'</tspan>';
			}
			elseif($teams[$pid]['pitstops'][$lap]) $linetext .= '<tspan dx="45px">'.$lang['graph']['pitstop'].' ('.printTime($teams[$pid]['pitstops'][$lap]['time']).')</tspan>';
			$linetext .= '</text>';
		}

		# 100% | 107%
		$w107 = ($lap107-$bestlap)/($worstlap-$bestlap)*275+235;
		$lines .= '
			<line  x1="235" y1="'.myadd(30,mydiv($lineheight,2)).'" x2="235" y2="'.myadd(myadd(30,mydiv($lineheight,2)),mymul($teams[$pid]['lapsdone'],$lineheight)).'" stroke-dasharray="3, 3" />
			<line  x1="'.$w107.'" y1="'.myadd(30,mydiv($lineheight,2)).'" x2="'.$w107.'" y2="'.myadd(myadd(30,mydiv($lineheight,2)),mymul($teams[$pid]['lapsdone'],$lineheight)).'" stroke-dasharray="3, 3" />';
			$axtext .= '
			<text x="225" y="'.mysub($height,10).'">100%</text>
			<text x="'.mysub($w107,10).'" y="'.mysub($height,10).'">107%</text>';


		### put axes ###
		$axes = '
		<rect x="10" y="'.myadd(30,mydiv($lineheight,2)).'" width="'.mysub($width,50).'" height="'.mymul($teams[$pid]['lapsdone'],$lineheight).'" fill="none" stroke-width="2" stroke="black" />';

		$grid .= '
		</g>';
		$axtext .= '
		</g>';
		$names .= '
		</g>';
		$lines .= '
		</g>';
		$linetext .= '
		</g>';
		$footer = '
</svg>';
		break;

	case GRAPH_RPG:
		if(isset($_GET['plyrs'])) {
			$plyrs = explode("_",$_GET['plyrs']);
			if(count($plyrs)>=2) {
				foreach ($teams as $lfsw=>$data) if(!in_array(array_search($lfsw,$playerkeys_finished),$plyrs)) {
					unset($teams[$lfsw]);
					unset($fin[$lfsw]);
					unset($ldone[$lfsw]);
					unset($ttime[$lfsw]);
				}
				$playerkeys = array_keys($teams);
			}
		}
		$leader = $playerkeys[0];
		for($s=1; $s<=$sectors; $s++) {
			if($s==1) $avgsec[$s] = (array_sum($teams[$leader]['sectimes'][$s]) - array_sum($teams[$leader]['sectimes'][$sectors]) + end($teams[$leader]['sectimes'][$sectors]))/count($teams[$leader]['sectimes'][$s]);
			else $avgsec[$s] = (array_sum($teams[$leader]['sectimes'][$s]) - array_sum($teams[$leader]['sectimes'][$s-1]))/count($teams[$leader]['sectimes'][$s]);
		}

		$mingap=$maxgap=0;
		for($lap=1; $lap<=$maxlapsdone; $lap++) {
			for($s=1; $s<=$sectors; $s++) {
		unset($reftime);
		foreach($avgsec as $sec => $avg) $reftime += ($sec<=$s) ? $avg*($lap-1) + $avg : $avg*($lap-1);
		foreach ($teams as $lfsw=>$data) {
					if($data['sectimes'][$s][$lap]) {
						if(($data['sectimes'][$s][$lap]-$reftime)/100>$maxgap) $maxgap = ($data['sectimes'][$s][$lap]-$reftime)/100;
						if(($data['sectimes'][$s][$lap]-$reftime)/100<$mingap) $mingap = ($data['sectimes'][$s][$lap]-$reftime)/100;
					}
				}
			}
		}

		$totgap = $maxgap-$mingap;
		$miny = floor($mingap/10)*10;
		if($miny==0) $miny = -1;
		$maxy = ceil($maxgap/10)*10;
		$toty = $maxy-$miny;

		if($_GET['maxgap'] && is_numeric($_GET['maxgap'])) $maxshown = intval($_GET['maxgap']);
		else $maxshown = 200;
		$nameextra +=10;
		if($bpos+$bwidth>($maxlapsdone*$secwidth*$sectors)+ ($maxnamewidth+$nameoffset+$nameextra)) $secwidth = ($bpos+$bwidth - ($maxnamewidth+$nameoffset+$nameextra))/($maxlapsdone*$sectors);
		elseif($maxlapsdone<15) ceil(($bpos+$bwidth)/($maxlapsdone*$sectors));
		$width = ($maxlapsdone*$secwidth*$sectors)+$maxnamewidth+70;
		if($pcount*$posheight+$topoffset+$bottomoffset<500) $baseheight = 500;
		else $baseheight = $pcount*$posheight+$topoffset+$bottomoffset;
		if($toty>$maxshown) $gapheight = ($baseheight/$maxshown);
		else $gapheight = ($baseheight/$toty);
		if($toty<=$maxshown) $height = ($gapheight*$toty)+$gapheight+$topoffset+$bottomoffset;
		else $height = ($gapheight*$maxshown)-($gapheight*$miny)+$topoffset+$bottomoffset;


		$desired_size = (!empty($_GET['size']) && is_numeric($_GET['size'])) ? intval($_GET['size']) : $width;
		$wh = $width/$height;

		$header = '<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
	<svg xmlns="http://www.w3.org/2000/svg"
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:ev="http://www.w3.org/2001/xml-events"
 onload="getSVGDoc(evt)" onzoom="ZoomControl()"
	version="1.1" baseProfile="full"
	width="'.$desired_size.'px" height="'.mydiv($desired_size,$wh).'px" viewBox="0 0 '.$width.' '.$height.'">
		<desc>'.$lang['rpg']['alt'].'</desc>
		<defs>
			<filter id="MyFilter" filterUnits="userSpaceOnUse">
        <feGaussianBlur in="SourceAlpha" stdDeviation="2" result="out1" />
        <feOffset in="out1" dx="4" dy="3" result="out2" />
        <feSpecularLighting in="out1" surfaceScale="3" specularExponent="50" specularConstant="0.7" result="out3">
        <fePointLight x="-150" y="-200" z="100" />
        </feSpecularLighting>
        <feComposite in="SourceGraphic" in2="out3" operator="arithmetic" k1="0" k2="1" k3="1" k4="0" result="out4" />
        <feComposite in="out4" in2="out2" operator="over" />
       </filter> 
<script type="text/javascript">
  <![CDATA[
  var svgdoc,svgroot;

  function getSVGDoc(load_evt)
  {
    svgdoc=load_evt.target.ownerDocument;
    svgroot=svgdoc.documentElement;
  }

  function TextHover(objid,color,decor)
  {
    var element;
    element=svgdoc.getElementById(objid);
    element.setAttribute("style","font-size: 12px; fill: "+color+"; text-decoration: "+decor);
  }

  function SetOpacity(e,op)
  {
    e.target.style.setProperty("fill-opacity",op,"");
  }

  function ShowTooltip(e,txt)
  {
    var ttrelem, ttrelem, posx, posy, curtrans, ctx, cty;
         var newScale = svgroot.currentScale;
         var tipScale = 1/newScale;
    ttrelem=svgdoc.getElementById("ttr");
    tttelem=svgdoc.getElementById("ttt");
    tttelem.childNodes.item(0).data=txt
if (e.pageX) posx = e.pageX;
else if (e.clientX)
   posx = e.clientX + (document.documentElement.scrollLeft) ? document.documentElement.scrollLeft : document.body.scrollLeft;
if (e.pageY) posy = e.pageY;
else if (e.clientY)
   posy = e.clientY + (document.documentElement.scrollTop) ? document.documentElement.scrollTop : document.body.scrollTop;

    curtrans=svgroot.currentTranslate;
    ctx=curtrans.x;
    cty=curtrans.y;
         posx = (posx - ctx)/newScale;
         posy = (posy - cty)/newScale;
    ttrelem.setAttribute("x",posx + (10 * tipScale));
    ttrelem.setAttribute("y",posy + (10 * tipScale));
    tttelem.setAttribute("x",posx + (10 * tipScale) + 5);
    tttelem.setAttribute("y",posy + (10 * tipScale) + 12);
    ttrelem.setAttribute("width",tttelem.getComputedTextLength()+10);
    tttelem.setAttribute("style","fill: #0000CC; font-size: 11px; visibility: visible");
    ttrelem.setAttribute("style","fill: #FFFFCC; stroke: #000000; stroke-width: 0.5px; visibility: visible");
  }

  function HideTooltip()
  {
    var ttrelem, ttrelem;
    ttrelem=svgdoc.getElementById("ttr");
    tttelem=svgdoc.getElementById("ttt");
    ttrelem.setAttribute("style","visibility: hidden");
    tttelem.setAttribute("style","visibility: hidden");
  }

  function ZoomControl()
  {
    var curzoom;
    curzoom=svgroot.currentScale;
    svgdoc.getElementById("tooltip").setAttribute("transform","scale("+1/curzoom+")");
  }
  ]]>
</script>
		</defs>
		<rect x="0" y="0" width="'.$width.'" height="'.$height.'" fill="rgb(255, 255, 234)" stroke="rgb(255, 255, 234" stroke-width="2" />';

		$usegrid = ($events[$gettype][$getevent]['seasons'][$getseason]['maxgrids']>0) ? '/G'.$getgrid : '';
		$useday = ($events[$gettype][$getevent]['seasons'][$getseason]['maxdays']>0) ? '/R'.$getday : '';
		if($_GET['link']==1) {
			$link = '
		<a target="_blank" xlink:href="'.SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.$useday.$usegrid.'/'.$getsession.'/graphs/rpg.html">
			<rect x="0" y="0" width="'.$width.'" height="'.$height.'" fill-opacity="0" />
		</a>';
		}
		elseif($_GET['link']==2) {
			$link = '
		<a target="_blank" xlink:href="'.SCRIPTURL.$gettype.'/'.$getevent.'/'.$getseason.$useday.$usegrid.'/'.$getsession.'/graphs/rpg_'.$width.'.svg?plyrs='.$_GET['plyrs'].'&amp;maxgap='.$maxgap.'">
			<rect x="0" y="0" width="'.$width.'" height="'.$height.'" fill-opacity="0" />
		</a>';
		}

		### put axes ###
		$axes = '
		<rect x="'.myadd($nameoffset,$nameextra).'" y="'.$topoffset.'" width="'.mymul(mymul($maxlapsdone,$sectors),$secwidth).'" height="'.mysub($height,myadd($topoffset,$bottomoffset)).'" fill="none" stroke-width="2" stroke="black" />';

		$grid = '
		<g stroke-width="1" stroke="black">';
		$axtext = '
		<g font-family="sans-serif" font-size="10" fill="black">';
		$names = '
		<g font-family="sans-serif" font-size="12" fill="black">';
		$lines = '
		<g stroke-width="2"'.$usefilter.'>';
		$symbols = '
		<g font-family="sans-serif" font-size="11"'.$usefilter.'>';

		### make legend ###
		$legend = '
		<g font-family="sans-serif" font-size="11" fill="black">';
		### Exit ###
		$legend .= '
			<rect x="'.mysub($eppos,4).'" y="'.mysub(mysub($height,$legendoffset),20).'" width="16" height="16" stroke-width="1" stroke="black" fill="white" />
			<text x="'.$eppos.'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['E'].'</text>
			<text x="'.myadd($eppos,16).'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['exit'].'</text>';
		### Penlaps ###
		$legend .= '
			<rect x="'.mysub($eppos,4).'" y="'.mysub($height,$legendoffset).'" width="16" height="16" stroke-width="1" stroke="black" fill="white" />
			<text x="'.$eppos.'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['Pen'].'</text>
			<text x="'.myadd($eppos,16).'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['penalty'].'</text>';
		### pitstop ###
		$legend .= '
			<circle cx="'.myadd($ptpos,3).'" cy="'.mysub(mysub($height,$legendoffset),12).'" r="8" stroke-width="1" stroke="black" fill="white" />
			<text x="'.$ptpos.'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['P'].'</text>
			<text x="'.myadd($ptpos,16).'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['pitstop'].'</text>';
		### pitstop + Takeover ###
		$legend .= '
			<circle cx="'.myadd($ptpos,3).'" cy="'.myadd(mysub($height,$legendoffset),8).'" r="8" stroke-width="1" stroke="black" fill="white" />
			<text x="'.$ptpos.'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['T'].'</text>
			<text x="'.myadd($ptpos,16).'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['toc'].'</text>';
		### engine damage ###
			$legend .= '
			<polygon points="'.getpentagonpoints($dtpos, mysub(mysub($height,$legendoffset),20)).'" fill="white" stroke="black" stroke-width="1" />
			<text x="'.mysub($dtpos,0).'" y="'.myadd(mysub($height,$legendoffset),-8).'" text-anchor="middle" fill="black" >'.$lang['graph']['D'].'</text>
			<text x="'.myadd($dtpos,16).'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['damage'].'</text>';
		### tyre broken ###
			$legend .= '
			<polygon points="'.getpentagonpoints($dtpos, mysub(mysub($height,$legendoffset),0)).'" fill="white" stroke="black" stroke-width="1" />
			<text x="'.mysub($dtpos,0).'" y="'.myadd(mysub($height,$legendoffset),12).'" text-anchor="middle" fill="black" >'.$lang['graph']['W'].'</text>
			<text x="'.myadd($dtpos,16).'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['wheel'].'</text>';
		### rejoin ###
		$legend .= '
			<polygon points="'.gettrispoints($rlpos, mysub(mysub($height,$legendoffset),12)).'" fill="black" stroke="black" stroke-width="1" />
			<text x="'.myadd($rlpos,16).'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['rejoin'].'</text>';
		### lapped ###
		$legend .= '
			<rect x="'.mysub($rlpos,8).'" y="'.mysub(mysub($height,$legendoffset),4).'" width="20" height="20" fill="rgb(178,178,178)" stroke-width="1" stroke="rgb(178,178,178)" />
			<text x="'.myadd($rlpos,16).'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['lapped'].'</text>';
		### yellow flags ###
		$legend .= '
			<circle cx="'.$ybpos.'" cy="'.mysub(mysub($height,$legendoffset),12).'" r="4" stroke-width="1" stroke="black" fill="yellow" />
			<text x="'.myadd($ybpos,10).'" y="'.myadd(mysub($height,$legendoffset),-8).'">'.$lang['graph']['yellow'].'</text>';
		### blue flags ###
		$legend .= '
			<circle cx="'.$ybpos.'" cy="'.myadd(mysub($height,$legendoffset),8).'" r="4" stroke-width="1" stroke="black" fill="blue" />
			<text x="'.myadd($ybpos,10).'" y="'.myadd(mysub($height,$legendoffset),12).'">'.$lang['graph']['blue'].'</text>';

		# horizontal grid
		$i=$miny;
		while ($i<=$maxy) {
			if($i<($maxshown+1)) {
				if ($i % 10==0) {
					$axtext .= '
			<text x="'.myadd($nameoffset,8).'" y="'.myadd(mymul(myadd($i,abs($miny)),$gapheight),$topoffset).'">'.$i.'</text>';
					$grid .= ($i==0) ? '
			<line x1="'.myadd($nameoffset,$nameextra).'" y1="'.myadd(mymul(myadd($i,abs($miny)),$gapheight),$topoffset).'" x2="'.myadd(myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),$nameoffset),$nameextra).'" y2="'.myadd(mymul(myadd($i,abs($miny)),$gapheight),$topoffset).'" stroke="black" stroke-width="2" />' : '
			<line x1="'.myadd($nameoffset,$nameextra).'" y1="'.myadd(mymul(myadd($i,abs($miny)),$gapheight),$topoffset).'" x2="'.myadd(myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),$nameoffset),$nameextra).'" y2="'.myadd(mymul(myadd($i,abs($miny)),$gapheight),$topoffset).'" stroke="gray" />';
				}
			}
			$i++;
		}

		$i=1;
		do {
			# lap
			if($i % $sectors == 0) 		$grid .= '
			<line x1="'.myadd(myadd(mymul($i,$secwidth),$nameoffset),$nameextra).'" y1="'.$topoffset.'" x2="'.myadd(myadd(mymul($i,$secwidth),$nameoffset),$nameextra).'" y2="'.mysub($height,$bottomoffset).'" />';
			# split
			else $grid .= '
			<line  x1="'.myadd(myadd(mymul($i,$secwidth),$nameoffset),$nameextra).'" y1="'.$topoffset.'" x2="'.myadd(myadd(mymul($i,$secwidth),$nameoffset),$nameextra).'" y2="'.mysub($height,$bottomoffset).'" stroke="gray" />';
			# lap number above
			if(($sectors+1)&1 && $i % $sectors == $sectors/2) $axtext .= '
			<text x="'.mysub(myadd(myadd(mymul($i,$secwidth),$nameoffset),$nameextra),4).'" y="'.mysub($topoffset,5).'">'.ceil($i/$sectors).'</text>';
			elseif($sectors&1 && $i % $sectors == ($sectors-1)/2 ) $axtext .= '
			<text x="'.mysub(myadd(myadd(myadd(mymul($i,$secwidth),$nameoffset),$nameextra),mydiv($secwidth,2)),4).'" y="'.$topoffset.'">'.ceil($i/$sectors).'</text>';
			# lap number below
			if(($sectors+1)&1 && $i % $sectors == $sectors/2) $axtext .= '
			<text x="'.mysub(myadd(myadd(mymul($i,$secwidth),$nameoffset),$nameextra),4).'" y="'.myadd(mysub($height,$bottomoffset),12).'">'.ceil($i/$sectors).'</text>';
			elseif($sectors&1 && $i % $sectors == ($sectors-1)/2 ) $axtext .= '
			<text x="'.mysub(myadd(myadd(myadd(mymul($i,$secwidth),$nameoffset),$nameextra),mydiv($secwidth,2)),4).'" y="'.myadd(mysub($height,$bottomoffset),12).'">'.ceil($i/$sectors).'</text>';
		} while (++$i<=$maxlapsdone*$sectors);

		$axtext .= '
			<text x="'.myadd(mymul(mymul($maxlapsdone+1,$sectors),$secwidth),myadd($nameoffset,0)).'" y="'.myadd(myadd(mysub($height,$bottomoffset),$topoffset),-5).'">'.$lang['general']['lap'].'</text>
			<text x="'.$legendoffset.'" y="'.mydiv($height,2).'" transform="rotate(270,'.$legendoffset.','.mydiv($height,2).')">'.$lang['general']['gap'].'</text>';

		$id=0;
		foreach ($teams as $lfsw=>$data) if($teams[$lfsw]['wasinrace']===true) {
			$id++;
			# name right
			$car = (convert_car_bits($mprheader['allowedcars'],true)>1) ? ' ('.$teams[$lfsw]['car'].')' : '';
			$name = (count($teams[$lfsw]['drivers'])==1 && $istoc===false) ? nameblank($teams[$lfsw]['drivers'][substr($lfsw,1)]['nick']).$car : nameblank($teams[$lfsw]['name']).$car;
			$names .= '
			<text x="'.myadd(myadd(myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),$nameoffset),$nameextra),10).'" y="'.myadd(mymul($id,$posheight),10).'">'.$name.'</text>';
			# line on the right
			$lines .= '
			<line x1="'.myadd(myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),myadd($nameoffset,$nameextra)),10).'" y1="'.myadd(mymul($id,$posheight),mydiv($posheight,2)).'" x2="'.myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),myadd(myadd(myadd($maxnamewidth,$nameoffset),$nameextra),10)).'" y2="'.myadd(mymul($id,$posheight),mydiv($posheight,2)).'" stroke="'.$col[$id].'" />';

			# draw the line
			unset($posline);
			$lastx = $nameoffset+$nameextra;
			$lasty = $topoffset-$miny*$gapheight;
			for($lap=1; $lap<=$maxlapsdone; $lap++) {
				for($s=1; $s<=$sectors; $s++) {
				unset($reftime);
				foreach($avgsec as $sec => $avg) $reftime += ($sec<=$s) ? $avg*($lap-1) + $avg : $avg*($lap-1);
					if($data['sectimes'][$s][$lap]) {
						$posline .= ' ';
						$posline .= $nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s);
						$lastx = $nameoffset+$nameextra+($lap-1)*$sectors*$secwidth+($secwidth*$s);
						$posline .= ',';
						$posline .=(($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+$topoffset;
						$lasty = (($data['sectimes'][$s][$lap]-$reftime)/100)*$gapheight-$miny*$gapheight+$topoffset;

						if($lap==$data['totlaps'] && $s==$sectors && $data['totlaps']!=$data['lapsdone']) {
							$symbols .= '
						<rect x="'.mysub($lastx,8).'" y="'.mysub($lasty,8).'" width="16" height="16" fill="white" stroke="'.$col[$id].'" stroke-width="1" />
						<text x="'.mysub($lastx,4).'" y="'.myadd($lasty,4).'" fill="'.$col[$id].'" >'.$lang['graph']['Pen'].'</text>';
						}
						### player rejoined ###
						if(in_array($lap+1,$data['rejoins']) && $s==$sectors) {
								$rpoints = $lastx.','.round($lasty-4,2).' '.round($lastx-4.72,2).','.round($lasty+4.48,2).' '.round($lastx+4.72,2).','.round($lasty+4.48,2);
								$symbols .= '
					<polygon points="'.$rpoints.'" fill="'.$col[$id].'" stroke="'.$col[$id].'" stroke-width="1" />';
						}
						### player resetted ###
						if($data['reset'][$lap]) {
							$resets = str_split($data['reset'][$lap],1);
							foreach($resets as $sec) {
								if((($s == $sec{0}) || ($s == $sectors && $sec{0} == $sectors)) && !empty($sec)) {
								$rpoints = $lastx.','.round($lasty-4,2).' '.round($lastx-4.72,2).','.round($lasty+4.48,2).' '.round($lastx+4.72,2).','.round($lasty+4.48,2);
								$symbols .= '
					<polygon points="'.$rpoints.'" fill="'.$col[$id].'" stroke="'.$col[$id].'" stroke-width="1" />';
								}
							}
						}
						### player got engine damage ###
						if($data['engdamage'][$lap]) {
							$dams = explode('#',$data['engdamage'][$lap]);
							foreach($dams as $sec) {
								if((($s == $sec{0}) || ($s == $sectors && $sec{0} == $sectors)) && !empty($sec)) {
								$dampoints = $lastx.','.round($lasty-8,2).' '.round($lastx-7.6,2).','.round($lasty-2.48,2).' '.round($lastx-4.72,2).','.round($lasty+6.48,2).' '.round($lastx+4.72,2).','.round($lasty+6.48,2).' '.round($lastx+7.6,2).','.round($lasty-2.48,2);
								$symbols .= '
					<polygon points="'.$dampoints.'" fill="white" stroke="'.$col[$id].'" stroke-width="1" onmousemove="ShowTooltip(evt,\''.substr($sec,1).'%\')" onmouseout="HideTooltip()" />
					<text x="'.mysub($lastx,0).'" y="'.myadd($lasty,4).'" text-anchor="middle" fill="'.$col[$id].'" onmousemove="ShowTooltip(evt,\''.substr($sec,1).'%\')" onmouseout="HideTooltip()" >'.$lang['graph']['D'].'</text>';
								}
							}
						}
				### player broke tyre ###
				if($data['tbreak'][$lap]) {
					$tyres = array(1 => 'RL', 2 => 'RR', 4 => 'FL', 8 => 'FR');
					$break = str_split($data['tbreak'][$lap],2);
					$dams = explode('#',$data['engdamage'][$lap]);
					foreach($break as $sec) {
						$tyre = array();
						$tyre[] = $tyres[$sec{1}];
						if((($s % $sectors == $sec{0}) || ($s % $sectors == 0 && $sec{0} == $sectors)) && !empty($sec)) {
						$dampoints = $lastx.','.round($lasty-8,2).' '.round($lastx-7.6,2).','.round($lasty-2.48,2).' '.round($lastx-4.72,2).','.round($lasty+6.48,2).' '.round($lastx+4.72,2).','.round($lasty+6.48,2).' '.round($lastx+7.6,2).','.round($lasty-2.48,2);
						$symbols .= '
			<polygon points="'.$dampoints.'" fill="white" stroke="'.$col[$id].'" stroke-width="1" onmousemove="ShowTooltip(evt,\''.implode(', ', $tyre).'\')" onmouseout="HideTooltip()" />
			<text x="'.mysub($lastx,0).'" y="'.myadd($lasty,4).'" text-anchor="middle" fill="'.$col[$id].'" onmousemove="ShowTooltip(evt,\''.implode(', ', $tyre).'\')" onmouseout="HideTooltip()" >'.$lang['graph']['W'].'</text>';
						}
					}
				}
						### player pitted ###
						if($data['pitstops'][$lap] && $s == $sectors-1) {
							$text = ($data['pitstops'][$lap]['from']!=$data['pitstops'][$lap]['to'] && !empty($data['pitstops'][$lap]['to'])) ? $lang['graph']['T'] : $lang['graph']['P'];
							$from = (empty($data['drivers'][$data['pitstops'][$lap]['from']]['realname'])) ? nameblank($data['drivers'][$data['pitstops'][$lap]['from']]['nick']) : nameblank($data['drivers'][$data['pitstops'][$lap]['from']]['realname']);
							$to = (empty($data['drivers'][$data['pitstops'][$lap]['to']]['realname'])) ? nameblank($data['drivers'][$data['pitstops'][$lap]['to']]['nick']) : nameblank($data['drivers'][$data['pitstops'][$lap]['to']]['realname']);
							$title1 = ($data['pitstops'][$lap]['from']!=$data['pitstops'][$lap]['to'] && !empty($data['pitstops'][$lap]['to'])) ? $from.' => '.$to : $from;
							$symbols .= '
					<circle cx="'.$lastx.'" cy="'.$lasty.'" r="8" fill="white" stroke="'.$col[$id].'" stroke-width="1" onmousemove="ShowTooltip(evt,\''.$title1.': '.printTime($data['pitstops'][$lap]['time']).'s\')" onmouseout="HideTooltip()" />
					<text x="'.mysub($lastx,3).'" y="'.myadd($lasty,4).'" fill="'.$col[$id].'" onmousemove="ShowTooltip(evt,\''.$title1.': '.printTime($data['pitstops'][$lap]['time']).'s\')" onmouseout="HideTooltip()" >'.$text.'</text>';
						}
					}
				}
			}

			$lines .= '
			<polyline fill="none" stroke="'.$col[$id].'" points="'.$posline.'" onmousemove="ShowTooltip(evt,\''.$name.'\')" onmouseout="HideTooltip()" />';

			### player not in race -> draw dashed line ###
			if($data['lapdsone']<$maxlapsdone && $data['finished']===true) 			$lines .= '
			<line x1="'.$lastx.'" y1="'.$lasty.'" x2="'.myadd(mymul(mymul($maxlapsdone,$secwidth),$sectors),myadd($nameoffset,$nameextra)).'" y2="'.$lasty.'" stroke="'.$col[$id].'" stroke-width="2" stroke-dasharray="4, 2" />';

			### player not in race -> draw dashed line ###
			if($data['lapdsone']<$maxlapsdone && $data['finished']===false) {
				$symbols .= '
			<rect x="'.mysub($lastx,8).'" y="'.mysub($lasty,8).'" width="16" height="16" fill="white" stroke="'.$col[$id].'" stroke-width="1" />
			<text x="'.mysub($lastx,4).'" y="'.myadd($lasty,4).'" fill="'.$col[$id].'" >'.$lang['graph']['E'].'</text>';
			}
		}
		$grid .= '
		</g>';
		$legend .= '
		</g>';
		$axtext .= '
		</g>';
		$names .= '
		</g>';
		$lines .= '
		</g>';
		$symbols .= '
		</g>';
		$footer = '
<g id="tooltip">
  <rect id="ttr" x="0" y="0" rx="5" ry="5" width="100" height="16" style="visibility: hidden"/>
  <text id="ttt" x="0" y="0" style="visibility: hidden">dyn. Text</text>
</g>
</svg>';
		break;
	default: exit;
}
$svg = '<?xml version="1.0" encoding="UTF-8"?>';
switch($graphtype) {
	###lap by lap graph ###
	case 1:
		$svg .= $header.$link.$lappedbg.$grid.$axes.$axtext.$legend.$names.$lines.$symbols.$footer;
		break;
	case 2:
		$svg .= $header.$grid.$axes.$axtext.$names.$lines.$linetext.$footer;
		break;
	case 3:
		$svg .= $header.$link.$lappedbg.$grid.$axes.$axtext.$legend.$names.$lines.$symbols.$footer;
		break;
	case 4:
		$svg .= $header.$grid.$axes.$axtext.$names.$lines.$linetext.$footer;
		break;
	default: exit;
}
	file_put_contents($graphfile,$svg);
}
### begin output ###
header("Content-type: image/svg+xml; charset=utf-8");
echo file_get_contents($graphfile);
?>
