<?php
#################################################################
# mpres index.php V2.04																					#
# script main file																							#
# directory: script main path																		#
#################################################################
define('NORMAL_ACCESS', null);
error_reporting(E_ERROR | E_WARNING | E_PARSE);

### grab required files ###
require_once('global.inc.php');

### no replay found or chosen -> go to selection screen ###
if(GOT_RESULT === false || !defined('GOT_RESULT')) {
	require_once(SCRIPTPATH.'tpl/header.tpl.php');
	if($_GET['page']=='credits') echo '<div id="tables">'.html_entity_decode($lang['credits']['credits']);
	elseif(!empty($errors)) {
		echo '<div id="tables">';
		foreach($errors as $error) echo '<p>'.$lang['errors']['error'].': '.$error.'</p>';
	}
	else require_once(SCRIPTPATH.'tpl/raceselect.tpl.php');
	require_once(SCRIPTPATH.'tpl/footer.tpl.php');
	exit;
}

### we got a replay ... use it! ###

### get track config ###
$track = $mprheader['trackname'];
$track .=  " ".$trackarray[$mprheader['trackname']][$mprheader['config']]['name'];
if($mprheader['reversed']==1) $track .= " Reversed";
elseif($mprheader['reversed']==2) $track .= " Open";
elseif($mprheader['reversed']==3) $track .= " Open Rev.";
$altconfigs = (ALTCONFIGS === true) ? '_all' : '';
$tracklength = get_tracklength ($mprheader['shorttrack'], $mprheader['lfsversion']);
### get travelled distance ###
$racedistance = ($tracklength==0) ? '-' : sprintf("%.2f", round($tracklength*$maxlapsdone*$km2mifactor/1000,2)).' '.$distunit;
### get race length & date ###
if($racetype==RACETYPE_TRAINING) $raceduration = $lang['general']['training'];
elseif($racetype==RACETYPE_LAPS) $raceduration = $duration.' '.(($duration>1) ? $lang['general']['laps'] : $lang['general']['lap']);
elseif($racetype==RACETYPE_TIME) $raceduration = mydiv($duration,360000).' '.(($duration>360000) ? $lang['general']['hours'] : $lang['general']['hour']);
elseif($racetype==RACETYPE_QUAL) $raceduration = mydiv($duration,6000).' '.(($duration>6000) ? $lang['general']['minutes'] : $lang['general']['minute']);
$starttime = ($mprheader['starttime']==0) ? $lang['general']['unknown'] : date('d.m.Y, H:i:s',$mprheader['starttime']);
### get wind ###
$windspeed = sprintf("%.2f", round($racedata['windspeed']*3.6*$km2mifactor,2));
switch($mprheader['wind']) {
	case WIND_NO: $wind = $lang['general']['nowind'];break;
	case WIND_LOW: $wind = $lang['general']['lowwind'].' ('.$windspeed.' '.$speedunit.')';break;
	case WIND_STRONG: $wind = $lang['general']['strongwind'].' ('.$windspeed.' '.$speedunit.')';break;
	default: $wind = $lang['general']['nowind'];
}

### only csv style wanted -> get it ###
if($_GET['resulttype']=='csv') {
	require_once(SCRIPTPATH.'tpl/csv.tpl.php');
	exit;
}
### only minimum-result wanted -> get it ###
elseif($_GET['resulttype']=='res') {
	require_once(SCRIPTPATH.'tpl/res.tpl.php');
	exit;
}
### only summary-result wanted -> get it ###
elseif($_GET['resulttype']=='small') {
	require_once(SCRIPTPATH.'tpl/smallresult.tpl.php');
	exit;
}
### begin "normal" output ###
else {
	require_once(SCRIPTPATH.'tpl/header.tpl.php');
	require_once(SCRIPTPATH.'tpl/menus.tpl.php');
	# race result
	if($racetype!=RACETYPE_QUAL) {
		require_once(SCRIPTPATH.'tpl/erg.tpl.php');
		require_once(SCRIPTPATH.'tpl/pit.tpl.php');
		require_once(SCRIPTPATH.'tpl/sta.tpl.php');
		### resort players array to get best laptimes ###
		uasort($teams, "sort_bestlap");
		require_once(SCRIPTPATH.'tpl/sec.tpl.php');
		require_once(SCRIPTPATH.'tpl/flg.tpl.php');
		require_once(SCRIPTPATH.'tpl/pen.tpl.php');
		require_once(SCRIPTPATH.'tpl/lbl.tpl.php');
		require_once(SCRIPTPATH.'tpl/blg.tpl.php');
		require_once(SCRIPTPATH.'tpl/rpg.tpl.php');
	}
	# qual result
	else {
		require_once(SCRIPTPATH.'tpl/ergqual.tpl.php');
		require_once(SCRIPTPATH.'tpl/sec.tpl.php');
		require_once(SCRIPTPATH.'tpl/lblqual.tpl.php');
	}
	require_once(SCRIPTPATH.'tpl/footer.tpl.php');
	exit;
}
?>