<?php
#################################################################
# mpres postprocess.php V2.03																		#
# processes all the data that was gathered from the replay			#
# directory: /includes/readmpr																	#
#################################################################
if (!defined('NORMAL_ACCESS')) {header("HTTP/1.1 404 File Not Found");echo "<h1>404 File Not Found</h1>";exit;}

	$totalnums = array('finpl'=>0, 'unfinpl'=>0, 'pitpl'=>0, 'totpits'=>0, 'totptime'=>0, 'ypl'=>0, 'ys'=>0, 'bpl'=>0, 'bs'=>0, 'penpl'=>0, 'pens'=>0, 'tblap'=>0);
	### so much for the replay ... now put all that info together ... ###
	foreach($teams as $id=>$team) {
		### delete teams that weren't on track ###
		if(!isset($team['wasinrace']) || $team['wasinrace']===false || empty($id) || ($safetycarstart===true && $team['startpos']==0)) {
			unset($teams[$id]);
			continue;
		}
		if($safetycarstart===true && $team['startpos']>0 && is_numeric($team['startpos'])) {
			$teams[$id]['startpos'] -= 1;
		}

		### if stints aren't to be conserved upon rejoin, delete all of them but the last one ###
		if($keeplapsonrejoin===false) {
			rsort($team['stints']);
			$del = false;
			unset($delarr);
			foreach($team['stints'] as $num=>$stint) {
				if($stints[$stint]['wasinrace']===false) {
					unset($players[$stints[$stint]['lfsw']]['teams'][$id]['stints'][array_search($stint,$players[$stints[$stint]['lfsw']]['teams'][$id]['stints'])]);
					unset($stints[$stint]);
					$delarr[] = $stint;
					continue;
				}
				if($del === true) {
					unset($players[$stints[$stint]['lfsw']]['teams'][$id]['stints'][array_search($stint,$players[$stints[$stint]['lfsw']]['teams'][$id]['stints'])]);
					unset($stints[$stint]);
					$delarr[] = $stint;
					continue;
				}
				if($stints[$stint]['rejoined']===true) {
					$del = true;
					continue;
				}
			}
			if(is_array($delarr)) foreach($delarr as $ds) unset($teams[$id]['stints'][array_search($ds,$teams[$id]['stints'])]);
		}

		### now get the total values for each team ... set empty values first ###
		$teams[$id]['lapsdone'] = 0;
		$teams[$id]['penlaps'] = 0;
		$teams[$id]['totaltime'] = '';
		$teams[$id]['sectimes'][1] = array();
		$teams[$id]['sectimes'][2] = array();
		$teams[$id]['sectimes'][3] = array();
		$teams[$id]['sectimes'][4] = array();
		$teams[$id]['sectimes']['lap'] = array();
		$teams[$id]['bestsectime'][1] = '';
		$teams[$id]['bestsectime'][2] = '';
		$teams[$id]['bestsectime'][3] = '';
		$teams[$id]['bestsectime'][4] = '';
		$teams[$id]['bestsectime']['lap'] = '';
		$teams[$id]['bestseclap'][1] = '';
		$teams[$id]['bestseclap'][2] = '';
		$teams[$id]['bestseclap'][3] = '';
		$teams[$id]['bestseclap'][4] = '';
		$teams[$id]['bestseclap']['lap'] = '';
		$teams[$id]['yellowflags'] = array();
		$teams[$id]['blueflags'] = array();
		$teams[$id]['pitstops'] = array();
		$teams[$id]['penalties'] = array();
		$teams[$id]['rejoins'] = array();
		$teams[$id]['reset'] = array();
		$teams[$id]['tocs'] = array();
		
		### now fill them one stint after another ###
		if(!empty($team['stints'])) sort($team['stints']);
		if(!empty($team['stints'])) foreach($team['stints'] as $num=>$stint) {
			$stints[$stint]['offset'] = $teams[$id]['lapsdone'];
			### penalize rejoins if necessary ###
			if($stints[$stint]['rejoined']===true) {
				$teams[$id]['penlaps'] += $rejoinpenlaps;
				$teams[$id]['rejoins'][] = $teams[$id]['lapsdone']+1;
			}
			$teamreset = 0;
			if(!empty($stints[$stint]['reset'])) {
				foreach($stints[$stint]['reset'] as $reset) {
					$teams[$id]['penlaps'] += $rejoinpenlaps*strlen($reset);
					$teamreset += strlen($reset);
				}
			}
			### update fuel consumption ###
			$stints[$stint]['usedfuel'] += (isset($stints[$stint]['currfuel'])) ? $stints[$stint]['initfuel']-$stints[$stint]['currfuel'] : 0;
			$teams[$id]['usedfuel'] += $stints[$stint]['usedfuel'];
			### update TOC info ###
			$teams[$id]['unallTOC'] = $stints[$stint]['unallTOC'];
			if(!empty($stints[$stint]['tocfrom'])) $teams[$id]['tocs'][] = $teams[$id]['lapsdone']+1;
			### get open penalties if any ###
			$teams[$id]['penalties_open'] = $stints[$stint]['penalties_open'];
			### adjust sector times ###
			if((empty($teams[$id]['bestsectime'][1]) || $teams[$id]['bestsectime'][1]>$stints[$stint]['bestsectime'][1]) && !empty($stints[$stint]['bestsectime'][1])) {
				$teams[$id]['bestsectime'][1] = $stints[$stint]['bestsectime'][1];
				$teams[$id]['bestseclap'][1] = $teams[$id]['lapsdone']+$stints[$stint]['bestseclap'][1];
			}
			if((empty($teams[$id]['bestsectime'][2]) || $teams[$id]['bestsectime'][2]>$stints[$stint]['bestsectime'][2]) && !empty($stints[$stint]['bestsectime'][2])) {
				$teams[$id]['bestsectime'][2] = $stints[$stint]['bestsectime'][2];
				$teams[$id]['bestseclap'][2] = $teams[$id]['lapsdone']+$stints[$stint]['bestseclap'][2];
			}
			if((empty($teams[$id]['bestsectime'][3]) || $teams[$id]['bestsectime'][3]>$stints[$stint]['bestsectime'][3]) && !empty($stints[$stint]['bestsectime'][3])) {
				$teams[$id]['bestsectime'][3] = $stints[$stint]['bestsectime'][3];
				$teams[$id]['bestseclap'][3] = $teams[$id]['lapsdone']+$stints[$stint]['bestseclap'][3];
			}
			if((empty($teams[$id]['bestsectime'][4]) || $teams[$id]['bestsectime'][4]>$stints[$stint]['bestsectime'][4]) && !empty($stints[$stint]['bestsectime'][4])) {
				$teams[$id]['bestsectime'][4] = $stints[$stint]['bestsectime'][4];
				$teams[$id]['bestseclap'][4] = $teams[$id]['lapsdone']+$stints[$stint]['bestseclap'][4];
			}
			if((empty($teams[$id]['bestsectime']['lap']) || $teams[$id]['bestsectime']['lap']>$stints[$stint]['bestsectime']['lap']) && !empty($stints[$stint]['bestsectime']['lap'])) {
				$teams[$id]['bestsectime']['lap'] = $stints[$stint]['bestsectime']['lap'];
				$teams[$id]['bestseclap']['lap'] = $teams[$id]['lapsdone']+$stints[$stint]['bestseclap']['lap'];
				if(!empty($stints[$stint]['totaltime']) && $racetype==RACETYPE_QUAL) $teams[$id]['totaltime'] = $stints[$stint]['totaltime'];
			}
			### adjust total racetime ###
			if(!empty($stints[$stint]['totaltime']) && $teams[$id]['totaltime']<=$stints[$stint]['totaltime'] && $racetype!=RACETYPE_QUAL) $teams[$id]['totaltime'] = $stints[$stint]['totaltime'];
			### add sector times, flags, pitstops, penalties, damages and drivers lapwise ###
			$i=1;
			while($i<=$stints[$stint]['lapsdone']) {
				if(!empty($stints[$stint]['sectimes'][1][$i])) $teams[$id]['sectimes'][1][$teams[$id]['lapsdone']+1] = $stints[$stint]['sectimes'][1][$i];
				if(!empty($stints[$stint]['sectimes'][2][$i])) $teams[$id]['sectimes'][2][$teams[$id]['lapsdone']+1] = $stints[$stint]['sectimes'][2][$i];
				if(!empty($stints[$stint]['sectimes'][3][$i])) $teams[$id]['sectimes'][3][$teams[$id]['lapsdone']+1] = $stints[$stint]['sectimes'][3][$i];
				if(!empty($stints[$stint]['sectimes'][4][$i])) $teams[$id]['sectimes'][4][$teams[$id]['lapsdone']+1] = $stints[$stint]['sectimes'][4][$i];
				if(!empty($stints[$stint]['sectimes']['lap'][$i])) $teams[$id]['sectimes']['lap'][$teams[$id]['lapsdone']+1] = $stints[$stint]['sectimes']['lap'][$i];
				if(!empty($stints[$stint]['yellowflags'][$i])) $teams[$id]['yellowflags'][$teams[$id]['lapsdone']+1] = $stints[$stint]['yellowflags'][$i];
				if(!empty($stints[$stint]['blueflags'][$i])) $teams[$id]['blueflags'][$teams[$id]['lapsdone']+1] = $stints[$stint]['blueflags'][$i];
				if(!empty($stints[$stint]['pitstops'][$i])) $teams[$id]['pitstops'][$teams[$id]['lapsdone']+1] = $stints[$stint]['pitstops'][$i];
				if(!empty($stints[$stint]['penalties'][$i])) $teams[$id]['penalties'][$teams[$id]['lapsdone']+1] = $stints[$stint]['penalties'][$i];
				if(!empty($stints[$stint]['engdamage'][$i])) $teams[$id]['engdamage'][$teams[$id]['lapsdone']+1] = $stints[$stint]['engdamage'][$i];
				if(!empty($stints[$stint]['tbreak'][$i])) $teams[$id]['tbreak'][$teams[$id]['lapsdone']+1] = $stints[$stint]['tbreak'][$i];
				if(!empty($stints[$stint]['reset'][$i])) $teams[$id]['reset'][$teams[$id]['lapsdone']+1] = $stints[$stint]['reset'][$i];
				$teams[$id]['lapdrivers'][$teams[$id]['lapsdone']+1] = $stints[$stint]['lfsw'];
				$teams[$id]['lapsdone'] += 1;
				$i++;
			}
			if(!empty($stints[$stint]['sectimes'][1][$i])) $teams[$id]['sectimes'][1][$teams[$id]['lapsdone']+1] = $stints[$stint]['sectimes'][1][$i];
			if(!empty($stints[$stint]['sectimes'][2][$i])) $teams[$id]['sectimes'][2][$teams[$id]['lapsdone']+1] = $stints[$stint]['sectimes'][2][$i];
			if(!empty($stints[$stint]['sectimes'][3][$i])) $teams[$id]['sectimes'][3][$teams[$id]['lapsdone']+1] = $stints[$stint]['sectimes'][3][$i];
			if(!empty($stints[$stint]['sectimes'][4][$i])) $teams[$id]['sectimes'][4][$teams[$id]['lapsdone']+1] = $stints[$stint]['sectimes'][4][$i];
			if(!empty($stints[$stint]['sectimes']['lap'][$i])) $teams[$id]['sectimes']['lap'][$teams[$id]['lapsdone']+1] = $stints[$stint]['sectimes']['lap'][$i];
			if(!empty($stints[$stint]['yellowflags'][$i])) $teams[$id]['yellowflags'][$teams[$id]['lapsdone']+1] = $stints[$stint]['yellowflags'][$i];
			if(!empty($stints[$stint]['blueflags'][$i])) $teams[$id]['blueflags'][$teams[$id]['lapsdone']+1] = $stints[$stint]['blueflags'][$i];
			if(!empty($stints[$stint]['pitstops'][$i])) $teams[$id]['pitstops'][$teams[$id]['lapsdone']+1] = $stints[$stint]['pitstops'][$i];
			if(!empty($stints[$stint]['penalties'][$i])) $teams[$id]['penalties'][$teams[$id]['lapsdone']+1] = $stints[$stint]['penalties'][$i];
			if(!empty($stints[$stint]['engdamage'][$i])) $teams[$id]['engdamage'][$teams[$id]['lapsdone']+1] = $stints[$stint]['engdamage'][$i];
			if(!empty($stints[$stint]['tbreak'][$i])) $teams[$id]['tbreak'][$teams[$id]['lapsdone']+1] = $stints[$stint]['tbreak'][$i];
			if(!empty($stints[$stint]['reset'][$i])) $teams[$id]['reset'][$teams[$id]['lapsdone']+1] = $stints[$stint]['reset'][$i];
		}

		### manually assign penalties or "goodies" to a player/team ###
		if(isset($playerhandle) && is_array($playerhandle)) {
			foreach($playerhandle as $key => $item) {
				$key2 = (@iconv('UTF-8','UTF-8',$key) === $key) ? strtolower($key) : codepage_convert(strtolower($key));
				if ( $key2 != $key) {
					$playerhandle[$key2]=$item;
					unset($playerhandle[$key]);
				}
			}
		}
		if(!empty($playerhandle[substr($id,1)])) {
			$teams[$id]['pentime'] = $playerhandle[substr($id,1)]['pentime'];
			if($playerhandle[substr($id,1)]['freerejoins'] <= count($teams[$id]['rejoins'])+$teamreset) $teams[$id]['penlaps'] -= $rejoinpenlaps*$playerhandle[substr($id,1)]['freerejoins'];
			elseif($playerhandle[substr($id,1)]['freerejoins'] > count($teams[$id]['rejoins'])+$teamreset) $teams[$id]['penlaps'] = 0;
			$teams[$id]['penlaps'] -= $playerhandle[substr($id,1)]['penlaps'];
			$teams[$id]['DQ'] = $playerhandle[substr($id,1)]['DQ'];
		}

		### set corrected total laps ###
		$teams[$id]['totlaps'] = $teams[$id]['lapsdone']-$teams[$id]['penlaps'];

		### delete any drivers from list that never where on the car ###
		foreach($team['drivers'] as $did=>$driver) {
			if(!is_array($players[$driver]['teams']) || !isset($players[$driver]['teams'][$id])) unset($teams[$id]['drivers'][$did]);
		}
		sort($teams[$id]['drivers']);
	}

	### reset total racetime / adjust for penalties ###
	unset($totaltime);
	foreach ($teams as $id=>$team) {
		if($team['wasinrace']===true) {
			$teams[$id]['tottime'] = $teams[$id]['totaltime']+$teams[$id]['pentime'];
			if($team['penalties_open']{0}==PENTYPE_30) $teams[$id]['tottime'] += 3000;
			if($team['penalties_open']{0}==PENTYPE_45) $teams[$id]['tottime'] += 4500;
			if($team['finished']===true && (empty($totaltime) || $teams[$id]['tottime']<$totaltime)) $totaltime = $teams[$id]['tottime'];
		}
	}

	### set leading laps ###
	$lap=1;
	while($lap<=$maxlapsdone) {
		uasort($teams, "sort_laptime");
		foreach ($teams as $id=>$team) {
			if($team['wasinrace']===true && $team['sectimes']['lap'][$lap]) {
				$teams[$id]['leadinglaps'][] = $lap++;
				break;
			}
		}
	}

	### presort teams array to get race result ###
	# qualifying => sort best lap first, then time of doing it
	if($racetype==RACETYPE_QUAL) {
		$minracepart = 0;
		foreach ($teams as $id=>$team) {
			$blap[$id] = (!empty($team['bestsectime']['lap'])) ? $team['bestsectime']['lap'] : 99999999;
			$ttime[$id] = $team['tottime'];
		}
		array_multisort($blap, SORT_ASC, $ttime, SORT_ASC, $teams);
		$playerkeys_finished = array_keys($teams);
	}
	# race => sort laps then time
	else {
		foreach ($teams as $id=>$team) {
			$ldone[$id] = $team['totlaps'];
			$ttime[$id] = $team['tottime'];
		}
		array_multisort($ldone, SORT_DESC, $ttime, SORT_ASC, $teams);
	}
	### make an ordered list of players ###
	$playerkeys = array_keys($teams);

	### get some playerdata from array ###
	foreach ($teams as $id=>$team) {
		### update finish-status ###
		if($racetype!=RACETYPE_QUAL && (($team['lapsdone']>=floor($maxlapsdone*$minracepart) && $appendunfinished===false) || $team['totaltime']>=$totaltime) && $team['DQ']==0) {
			$teams[$id]['finished'] = true;
			$totalnums['finpl']++;
		}
		elseif($racetype!=RACETYPE_QUAL && $team['wasinrace']===true) {
			if($team['DQ']==1) $teams[$id]['finished'] = false;
			if(!isset($teams[$id]['finished'])) $teams[$id]['finished'] = false;
			$totalnums['unfinpl']++;
		}
		$fin[$id] = ($teams[$id]['DQ']==0) ? $teams[$id]['finished'] : 0;
		### get team's avg-lap & lap-deviation ###
		if($racetype!=RACETYPE_QUAL && $team['lapsdone']>0) {
			$avglap[$id] = round(mydiv($team['totaltime'],$team['lapsdone']),0);
			$teams[$id]['avglap'] = $avglap[$id];
			$tgap = 0;
			foreach($team['sectimes']['lap'] as $lap => $time)
			if($lap!=1) {
				if(isset($team['sectimes']['lap'][$lap-1])) $tgap += pow(mysub(mysub($team['sectimes']['lap'][$lap],$team['sectimes']['lap'][$lap-1]),$avglap[$id]),2);
				else $tgap += pow(mysub($team['sectimes']['lap'][$lap],$avglap[$id]),2);
			}
			if($team['lapsdone']>2) $lapdev[$id] = round(sqrt(mydiv($tgap,mysub($team['lapsdone'],2))),0);
			else $lapdev[$id] = 0;
			$teams[$id]['lapdev'] = $lapdev[$id];
		}
		### get team's best possible lap ###
		if($team['lapsdone']>0){
			$s=1;
			$tpb[$id]=0;
			for($s=1; $s<=$sectors; $s++) $tpb[$id] += $team['bestsectime'][$s];
			$teams[$id]['tpb'] = $tpb[$id];
		}
		### get team's leading laps ###
		unset($llaps);
		unset($start);
		unset($end);
		$teams[$id]['lapslead'] = count($team['leadinglaps']);
		for($l=0; $l<count($team['leadinglaps']); $l++) {
			if(empty($start)) $start = $team['leadinglaps'][$l];
			if($team['leadinglaps'][$l+1]!=$team['leadinglaps'][$l]+1) {
				$end = $team['leadinglaps'][$l];
				if($start!=$end) $llaps[] = $start.'-'.$end;
				elseif($start==$end) $llaps[] = $start;
				$start = '';
			}
		}
		$teams[$id]['leadinglaps'] = (empty($llaps)) ? '' : " (".implode(", ",$llaps).")";
		### add team's pitstops to totalpits ###
		if($racetype!=RACETYPE_QUAL && count($team['pitstops'])>0) {
			$totalnums['pitpl']++;
			foreach($team['pitstops'] as $pit => $stop) {
				$totalnums['totpits']++;
				$tpittime[$id] += $stop['time'];
				$totalnums['totptime'] += $stop['time'];
			}
			$teams[$id]['tpittime'] = $tpittime[$id];
		}
		### add team's flags to totalflags ###
		if($racetype!=RACETYPE_QUAL && $team['wasinrace']===true && (!empty($team['yellowflags']) || !empty($team['blueflags']))) {
			$y[$id]=$b[$id]=0;
			if(!empty($team['yellowflags'])) {
				$totalnums['ypl']++;
				foreach($team['yellowflags'] as $lap => $yf) {
					$yf = str_split($yf,1);
					$y[$id] += count($yf);
					$totalnums['ys'] += count($yf);
				}
				$teams[$id]['y'] = $y[$id];
			}
			if(!empty($team['blueflags'])) {
				$totalnums['bpl']++;
				foreach($team['blueflags'] as $lap => $bf) {
					$bf = str_split($bf,1);
					$b[$id] += count($bf);
					$totalnums['bs'] += count($bf);
				}
				$teams[$id]['b'] = $b[$id];
			}
		}
		### add team's penalties to total penalties ###
		if($racetype!=RACETYPE_QUAL && $team['wasinrace']===true && !empty($team['penalties'])) {
			$totalnums['penpl']++;
			foreach($team['penalties'] as $lap => $pen) {
				$pen = str_split($pen,2);
				foreach($pen as $penalty) if(!empty($penalty) && $penalty{1}!=PENREASON_NONE) $totalnums['pens']++;
			}
		}
		### set best sector times ###
		if($team['lapsdone']>0) {
			if(empty($bestseclaps[1]) || $team['bestsectime'][1]<$bestseclaps[1]) $bestseclaps[1] = $team['bestsectime'][1];
			if(empty($bestseclaps[2]) || $team['bestsectime'][2]<$bestseclaps[2]) $bestseclaps[2] = $team['bestsectime'][2];
			if(empty($bestseclaps[3]) || $team['bestsectime'][3]<$bestseclaps[3]) $bestseclaps[3] = $team['bestsectime'][3];
			if(empty($bestseclaps[4]) || $team['bestsectime'][4]<$bestseclaps[4]) $bestseclaps[4] = $team['bestsectime'][4];
			if(empty($bestseclaps['lap']) || $team['bestsectime']['lap']<$bestseclaps['lap']) $bestseclaps['lap'] = $team['bestsectime']['lap'];
		}
		unset($teamplayers);
		foreach($team['drivers'] as $driver) {
			### get handicaps from resultarray ###
			foreach($resultarray as $i=>$res) {
				if($res['car']==$team['car']) {
					if(substr($res['lfsw'],0,15)!='resultdummyname' && $res['lfsw']==$driver) {
						$teams[$id]['handicap'] = $res['handicap'];
						$teams[$id]['restrictor'] = $res['restrictor'];
					}
					elseif(substr($res['lfsw'],0,15)!='resultdummyname' && ((substr($driver,0,14)=='AIBOTdummyname' && substr($res['lfsw'],15)==substr($driver,14)) || (substr($driver,0,13)=='demodummyname' && substr($res['lfsw'],15)==substr($driver,13)))) {
						$teams[$id]['handicap'] = $res['handicap'];
						$teams[$id]['restrictor'] = $res['restrictor'];
					}
				}
			}
			$players[$driver]['teams'][$id]['lapslead'] = 0;
			$players[$driver]['teams'][$id]['pitstops'] = 0;
			$players[$driver]['teams'][$id]['usedfuel'] = 0;
			### get player's avg-lap & lap-deviation ###
			$stime = 0;
			$slaps = 0;
			$tgap = 0;
			$py[$driver]=$pb[$driver]=0;
			unset($pllaps);
			unset($pstart);
			unset($pend);
			foreach($players[$driver]['teams'][$id]['stints'] as $pstint) {
				if($stints[$pstint]['lapsdone']>0){
				$stime += $stints[$pstint]['sectimes']['lap'][$stints[$pstint]['lapsdone']]-$team['sectimes']['lap'][$stints[$pstint]['offset']];
				$slaps += $stints[$pstint]['lapsdone'];
				### add player's flags to totalflags ###
				if($racetype!=RACETYPE_QUAL && $stints[$pstint]['wasinrace']===true && (!empty($stints[$pstint]['yellowflags']) || !empty($stints[$pstint]['blueflags']))) {
					if(!empty($stints[$pstint]['yellowflags'])) {
						foreach($stints[$pstint]['yellowflags'] as $pyf) {
							$pyf = str_split($pyf,1);
							$py[$driver] += count($pyf);
						}
					}
					if(!empty($stints[$pstint]['blueflags'])) {
						foreach($stints[$pstint]['blueflags'] as $pbf) {
							$pbf = str_split($pbf,1);
							$pb[$driver] += count($pbf);
						}
					}
				}
				$players[$driver]['teams'][$id]['pitstops'] += count($stints[$pstint]['pitstops']);
				$players[$driver]['teams'][$id]['usedfuel'] += $stints[$pstint]['usedfuel'];
				### get player's best possible lap ###
				if(empty($players[$driver]['teams'][$id]['bestsectime'][1]) || $stints[$pstint]['bestsectime'][1]<$players[$driver]['teams'][$id]['bestsectime'][1]) { $players[$driver]['teams'][$id]['bestsectime'][1] = $stints[$pstint]['bestsectime'][1]; $players[$driver]['teams'][$id]['bestseclap'][1] = $stints[$pstint]['bestseclap'][1]+$stints[$pstint]['offset'];}
				if(empty($players[$driver]['teams'][$id]['bestsectime'][2]) || $stints[$pstint]['bestsectime'][2]<$players[$driver]['teams'][$id]['bestsectime'][2]) { $players[$driver]['teams'][$id]['bestsectime'][2] = $stints[$pstint]['bestsectime'][2]; $players[$driver]['teams'][$id]['bestseclap'][2] = $stints[$pstint]['bestseclap'][2]+$stints[$pstint]['offset'];}
				if(empty($players[$driver]['teams'][$id]['bestsectime'][3]) || $stints[$pstint]['bestsectime'][3]<$players[$driver]['teams'][$id]['bestsectime'][3]) { $players[$driver]['teams'][$id]['bestsectime'][3] = $stints[$pstint]['bestsectime'][3]; $players[$driver]['teams'][$id]['bestseclap'][3] = $stints[$pstint]['bestseclap'][3]+$stints[$pstint]['offset'];}
				if(empty($players[$driver]['teams'][$id]['bestsectime'][4]) || $stints[$pstint]['bestsectime'][4]<$players[$driver]['teams'][$id]['bestsectime'][4]) { $players[$driver]['teams'][$id]['bestsectime'][4] = $stints[$pstint]['bestsectime'][4]; $players[$driver]['teams'][$id]['bestseclap'][4] = $stints[$pstint]['bestseclap'][4]+$stints[$pstint]['offset'];}
				if(empty($players[$driver]['teams'][$id]['bestsectime']['lap']) || $stints[$pstint]['bestsectime']['lap']<$players[$driver]['teams'][$id]['bestsectime']['lap']) { $players[$driver]['teams'][$id]['bestsectime']['lap'] = $stints[$pstint]['bestsectime']['lap']; $players[$driver]['teams'][$id]['bestseclap']['lap'] = $stints[$pstint]['bestseclap']['lap']+$stints[$pstint]['offset'];}
				if(!empty($team['leadinglaps'])) foreach($team['leadinglaps'] as $l=>$lap) {
					if($lap>=$stints[$pstint]['offset'] && $lap<=$stints[$pstint]['offset']+$stints[$pstint]['lapsdone']) {
						$players[$driver]['teams'][$id]['lapslead'] += 1;
						if(empty($pstart)) $pstart = $lap;
						if($team['leadinglaps'][$l+1]!=$team['leadinglaps'][$l]+1 || $team['leadinglaps'][$l+1]>$stints[$pstint]['offset']+$stints[$pstint]['lapsdone']) {
							$pend = $lap;
							if($pstart!=$pend) $pllaps[] = $pstart.'-'.$pend;
							elseif($pstart==$pend) $pllaps[] = $pstart;
							$pstart = '';
						}
					}
				}
				}
			}
			$s=1;
			$ptpb[$driver]=0;
			for($s=1; $s<=$sectors; $s++) $ptpb[$driver] += $players[$driver]['teams'][$id]['bestsectime'][$s];
			### get player's leading laps ###
			$players[$driver]['teams'][$id]['leadinglaps'] = (empty($pllaps)) ? null : " (".implode(", ",$pllaps).")";
			$pavg[$driver] = ($slaps>0) ? round(mydiv($stime,$slaps),0) : '---';
			$players[$driver]['teams'][$id]['lapsdone'] = $slaps;
			$players[$driver]['teams'][$id]['totaltime'] = $stime;
			$sdone = 0;
			foreach($players[$driver]['teams'][$id]['stints'] as $pstint) {
				$sdone += ($stints[$pstint]['lapsdone']>=2) ? $stints[$pstint]['lapsdone']-1 : 0;
				foreach($stints[$pstint]['sectimes']['lap'] as $lap => $time)
				if($lap!=1) {
					if(isset($stints[$pstint]['sectimes']['lap'][$lap-1])) $tgap += pow(mysub(mysub($stints[$pstint]['sectimes']['lap'][$lap],$stints[$pstint]['sectimes']['lap'][$lap-1]),$pavg[$driver]),2);
					else $tgap += pow(mysub($stints[$pstint]['sectimes']['lap'][$lap],$pavg[$driver]),2);
				}
			}
			if($sdone>1) $pdev[$driver] = round(sqrt(mydiv($tgap,mysub($sdone,1))),0);
			else $pdev[$driver] = 0;
			$players[$driver]['teams'][$id]['y'] = $py[$driver];
			$players[$driver]['teams'][$id]['b'] = $pb[$driver];
			$players[$driver]['teams'][$id]['ptpb'] = $ptpb[$driver];
			$players[$driver]['teams'][$id]['pavg'] = $pavg[$driver];
			$players[$driver]['teams'][$id]['pdev'] = $pdev[$driver];
			$players[$driver]['teams'][$id]['lfsw'] = $driver;
			$players[$driver]['teams'][$id]['realname'] = $players[$driver]['realname'];
			$teamplayers[$driver] = $players[$driver]['teams'][$id];
		}
		if($team['lapsdone']>=$maxlapsdone) $maxlapsdone=$team['lapsdone'];
		$teams[$id]['drivers'] = $teamplayers;
	}

	### resort players array ###
	if($racetype!=RACETYPE_QUAL) {
		array_multisort($fin, SORT_DESC, $ldone, SORT_DESC, $ttime, SORT_ASC, $teams);
		$playerkeys_finished = array_keys($teams);
	}

	### sort arrays for lep-deviation, avg-lap & pittime if they exist ###
	if(!empty($lapdev)) asort($lapdev);
	if(!empty($avglap)) asort($avglap);
	if(!empty($tpittime)) asort($tpittime);

	### get best possible lap ###
	for($s=1; $s<=$sectors; $s++) {
		$totalnums['tblap'] += $bestseclaps[$s];
	}

	### save the data to a file, so that the replay doesn't have to be scanned each time ###
	$savestring = $minracepart."\n";
	$savestring .= "\n";
	$savestring .= "\n";
	$savestring .= $racetype."\n";
	$savestring .= $duration."\n";
	$savestring .= $sectors."\n";
	$savestring .= $maxlapsdone."\n";
	$savestring .= $totaltime."\n";
	$savestring .= json_encode($mprheader)."\n";
	$savestring .= "\n";
	$savestring .= "\n";
	$savestring .= "\n";
	$savestring .= json_encode($racedata)."\n";
	$savestring .= "\n";
	$savestring .= "\n";
	$savestring .= json_encode($teams)."\n";
	$savestring .= json_encode($totalnums)."\n";
	$savestring .= json_encode($bestseclaps)."\n";
	$savestring .= json_encode($lapdev)."\n";
	$savestring .= json_encode($avglap)."\n";
	$savestring .= json_encode($tpittime)."\n";
	$savestring .= json_encode($playerkeys)."\n";
	$savestring .= json_encode($playerkeys_finished)."\n";
	$savestring .= MPRES_VERSION;
	file_put_contents(SAVEFILE,$savestring);
	unset($savestring);
?>