<?php
#################################################################
# mpres get_replays.php V2.08																		#
# fetches the data or the replay to parse												#
# directory: /includes																					#
#################################################################
if (!defined('NORMAL_ACCESS')) {header("HTTP/1.1 404 File Not Found");echo "<h1>404 File Not Found</h1>";exit;}

### check if result was created with older version of mpRes ###
$oldver = false;
if(file_exists(SAVEFILE)) {
	$old = array_map('rtrim',file(SAVEFILE));
	if($old[23]<MPRES_VERSION) $oldver = true;
}
### load and scan replay if not done before ###
if(!file_exists(SAVEFILE) || $_GET['force_load']==FORCE_LOAD_PASS || $oldver===true) {
	### delete prerendered graphs if any ###
	$graphs = glob(SCRIPTPATH.'images/rendered/graphs/*/'.$gettype.'_'.$getevent.'_'.$getseason.'_R'.$getday.'_G'.$getgrid.'_'.$getsession.'*');
	if(is_array($graphs)) foreach($graphs as $gfile) unlink($gfile);

	### manually override parsing parameters ###
	if(is_file(REPLAYPATH.$basefilename.'.mprdiff')) include_once(REPLAYPATH.$basefilename.'.mprdiff');
	$maxleavelaps = (!empty($setmaxleavelaps) && $_GET['force_load']==FORCE_LOAD_PASS) ? $setmaxleavelaps : $events[$gettype][$getevent]['seasons'][$getseason]['maxleavelaps'];
	$minracepart = (!empty($setminracepart) && $_GET['force_load']==FORCE_LOAD_PASS) ? $setminracepart : $events[$gettype][$getevent]['seasons'][$getseason]['minracepart'];
	$appendunfinished = (!empty($setappendunfinished) && $_GET['force_load']==FORCE_LOAD_PASS) ? $setappendunfinished : $events[$gettype][$getevent]['seasons'][$getseason]['appendunfinished'];
	$keeplapsonrejoin = (!empty($setkeeplapsonrejoin) && $_GET['force_load']==FORCE_LOAD_PASS) ? $setkeeplapsonrejoin : $events[$gettype][$getevent]['seasons'][$getseason]['keeplapsonrejoin'];
	$rejoinpenlaps = (!empty($setrejoinpenlaps) && $_GET['force_load']==FORCE_LOAD_PASS) ? $setrejoinpenlaps : $events[$gettype][$getevent]['seasons'][$getseason]['rejoinpenlaps'];
	$safetycarstart = (!empty($setsafetycarstart) && $_GET['force_load']==FORCE_LOAD_PASS) ? $setsafetycarstart : $events[$gettype][$getevent]['seasons'][$getseason]['safetycarstart'];

	### read teamdata if set. If not set but expected exit with error ###
	$teams = array();
	if($istoc===true && !file_exists(REPLAYPATH.$basefilename.'.tocdata')) $errors[] = $lang['errors']['no_tocfile'].' ('.REPLAYPATH.$basefilename.'.tocdata)';
	elseif($istoc===true) {
		$teams = getteams(REPLAYPATH.$basefilename.'.tocdata');
		if(empty($teams)) $errors[] = $lang['errors']['no_valid_teams'];
		else $hasteams = true;
	}
	
	### load replay ###
	$handle = @fopen(REPLAYPATH.$filename, "rb");
	if(!$handle) $errors[] = $lang['errors']['file_not_open'].' ('.REPLAYPATH.$filename.')';
	$filesize = filesize(REPLAYPATH.$filename);
	if($filesize<3980) $errors[] = $lang['errors']['invalid_replay'];

	if(empty($errors)) {
		### set initial values ###
		$haslayout = false;
		$players_in_race = 0; # not in use yet

		### get replay header including results###
		$header = fread($handle,80);
		require_once(SCRIPTPATH.'includes/readmpr/header.php');
		unset($header);

		### skip skins ###
		fseek($handle, 40*MAXPLAYERS, SEEK_CUR);

		### determine parsing files ###
		if($mprheader['mprversion']<18) $trackarray = $AllTracks;
		elseif($mprheader['mprversion']<20) $trackarray = $AllTracksNewWE;
		else $trackarray = $AllTracksNewBL;

		if($mprheader['mprversion']>=8 && $mprheader['mprversion']<13) $framefile = SCRIPTPATH.'includes/readmpr/framepackets_13.php';
		else $framefile = SCRIPTPATH.'includes/readmpr/framepackets_'.$mprheader['mprversion'].'.php';
		clearstatcache();
		if(!file_exists($framefile)) $errors[] = $lang['errors']['unsuppver'].' ('.$mprheader['lfsversion'].')';

		### if framefile exits: go ###
		if(empty($errors)) {
			### get replay start ###
			require_once($framefile);
			require_once(SCRIPTPATH.'includes/readmpr/initdata.php');

			### gather all the relevant data from the race ###
			if(empty($errors)) require_once(SCRIPTPATH.'includes/readmpr/bodydata.php');
			fclose ($handle);
			if(empty($teams)) $errors[] = $lang['errors']['no_teams'];
			if(empty($errors)) require_once(SCRIPTPATH.'includes/readmpr/postprocess.php');
		}
	}
}
if(file_exists(SAVEFILE)) {
### load the saved replaydata and work with it ###
	$lines = array_map('rtrim',file(SAVEFILE));
	$minracepart = $lines[0];
	$racetype = $lines[3];
	$duration = $lines[4];
	$sectors = $lines[5];
	$maxlapsdone = $lines[6];
	$totaltime = $lines[7];
	$mprheader = json_decode($lines[8],true);
	$racedata = json_decode($lines[12],true);
	$teams = json_decode($lines[15],true);
	$totalnums = json_decode($lines[16],true);
	$bestseclaps = json_decode($lines[17],true);
	$lapdev = json_decode($lines[18],true);
	$avglap = json_decode($lines[19],true);
	$tpittime = json_decode($lines[20],true);
	$playerkeys = json_decode($lines[21],true);
	$playerkeys_finished = json_decode($lines[22],true);
}
if(!empty($lines) && empty($errors)) {
	define('GOT_RESULT', true);
	unset($lines);
	if(!isset($trackarray)) 	$trackarray = ($mprheader['mprversion']<18) ? $AllTracks : $AllTracksNewWE;

	define('CARS_FINISHED', $totalnums['finpl']);
	define('CARS_UNFINISHED', $totalnums['unfinpl']);
	define('CARS_TOTAL', CARS_FINISHED + CARS_UNFINISHED);
	define('CARS_YELLOW', $totalnums['ypl']);
	define('CARS_BLUE', $totalnums['bpl']);
	define('CARS_PENALTY', $totalnums['penpl']);
	define('CARS_PITTED', $totalnums['pitpl']);
	define('NUM_YELLOW', $totalnums['ys']);
	define('NUM_BLUE', $totalnums['bs']);
	define('NUM_PENALTY', $totalnums['pens']);
	define('NUM_PIT', $totalnums['totpits']);
	define('TIME_PIT', printTime($totalnums['totptime']));
	define('T_BEST_LAP', $totalnums['tblap']);
}
else define('GOT_RESULT', false);
?>