﻿#NoEnv  ; Recommended for performance and compatibility with future AutoHotkey releases.
#Warn  ; Enable warnings to assist with detecting common errors.
SendMode Input  ; Recommended for new scripts due to its superior speed and reliability.
SetWorkingDir %A_ScriptDir%  ; Ensures a consistent starting directory.

; Wait for LFS (window title) for 10 seconds
WinWait, Live for Speed,,10
if ErrorLevel 
{
	MsgBox A running Live for Speed instance/window not found - Please start LFS first!
	return
}
else 
{
;	MsgBox The view switch is based on TV cam as first view! - Please change it first in LFS

	loop
	{
		; If LFS has focus
		IfWinActive, Live for Speed
		{
			; Get a random sleep time
			randomSleepTime := getRandomSleepTime()
			
			; Get a random view
			newView := getRandomView()

			; Get a random answer to switch to an other car
			changeCar := getRandomChangeCar()
			if changeCar > 0 ; Switch to other car
			{
				numSwitches := getRandomSwitchNumCars()
				send, {TAB %numSwitches%}
				;send {TAB}
				driver = switching %numSwitches%
				;driver = switching driver
			}
			if newView = 1 ; Cockpit
			{
				send +{F1}
				cockpit = cockpit 
			}

			if newView = 2 ; Behind car view
			{
				send +{F1}
				send vv
				cockpit = behind 
			}

			if newView = 3 ; TV view
			{
				send +{F1}
				send V
				cockpit = TV
			}

			; Send a info to all - DEBUG
			;send, t%driver% %cockpit% %randomSleepTime%{Enter}

			sleep, %randomSleepTime%
		}
		else
			sleep, 1000

	}

}

getRandomChangeCar()
{
	Random, newValue, 0, 2
	return newValue
}

getRandomSwitchNumCars()
{ 
	Random, newValue, 1, 3
	return newValue
}

getRandomView()
{
	Random, newValue, 1, 3
	return newValue
}

getRandomSleepTime()
{
	Random, newValue, 5500, 12500
	Return newValue
}

