﻿namespace LfsInSimLib.IS_SubPackets
{
    using System;
    using System.Runtime.InteropServices;

    [StructLayout(LayoutKind.Sequential, Pack=1)]
    public class PLIDOrder
    {
        [MarshalAs(UnmanagedType.ByValArray, SizeConst=0x20)]
        public byte[] PLID;
        public PLIDOrder()
        {
            this.PLID = new byte[0x20];
        }

        public PLIDOrder(byte[] PLID) : this()
        {
            Array.Copy(PLID, this.PLID, PLID.LongLength);
        }

        public override string ToString()
        {
            string str = string.Empty;
            for (int i = 0; i < 0x20; i++)
            {
                str = str + string.Format("{0}, ", this.PLID[i]);
            }
            str.Remove(str.Length - 2);
            return str;
        }
    }
}

