﻿namespace LfsInSimLib.IS_Packets
{
    using LfsInSimLib;
    using LfsInSimLib.IS_Enums;
    using System;
    using System.Runtime.InteropServices;

    [StructLayout(LayoutKind.Sequential, Pack=1), IS_Sendable]
    public class IS_TINY
    {
        private byte size;
        private PacketTypeEnum type;
        private byte reqI;
        private IS_TINYTypeEnum subT;
        public byte ReqI
        {
            get
            {
                return this.reqI;
            }
            set
            {
                this.reqI = value;
            }
        }
        public IS_TINYTypeEnum SubT
        {
            get
            {
                return this.subT;
            }
            set
            {
                this.subT = value;
            }
        }
        public IS_TINY()
        {
            this.size = 4;
            this.type = PacketTypeEnum.ISP_TINY;
        }

        public IS_TINY(byte reqI) : this()
        {
            this.reqI = reqI;
        }

        public IS_TINY(IS_TINYTypeEnum subT) : this()
        {
            this.subT = subT;
        }

        public IS_TINY(byte reqI, IS_TINYTypeEnum subT) : this()
        {
            this.reqI = reqI;
            this.subT = subT;
        }
    }
}

