﻿namespace LfsInSimLib
{
    using System;
    using System.Runtime.InteropServices;

    public class RawSerialize
    {
        public static object Deserialize(byte[] rawdatas, Type anytype)
        {
            int cb = Marshal.SizeOf(anytype);
            IntPtr destination = Marshal.AllocHGlobal(cb);
            int length = Math.Min(cb, rawdatas.Length);
            byte[] destinationArray = new byte[cb];
            Array.Copy(rawdatas, destinationArray, length);
            Marshal.Copy(destinationArray, 0, destination, cb);
            object obj2 = Marshal.PtrToStructure(destination, anytype);
            Marshal.FreeHGlobal(destination);
            return obj2;
        }

        public static byte[] Serialize(object anything)
        {
            int cb = Marshal.SizeOf(anything);
            IntPtr ptr = Marshal.AllocHGlobal(cb);
            Marshal.StructureToPtr(anything, ptr, false);
            byte[] destination = new byte[cb];
            Marshal.Copy(ptr, destination, 0, cb);
            Marshal.FreeHGlobal(ptr);
            return destination;
        }
    }
}

