﻿namespace LfsInSimLib
{
    using LfsInSimLib.IS_Enums;
    using LfsInSimLib.IS_Packets;
    using System;
    using System.Net;
    using System.Net.Sockets;
    using System.Runtime.CompilerServices;

    public abstract class IsSocket
    {
        protected Socket clientSocket;

        public event IS_BFNReceivedDelegate IS_BFNReceived;

        public event IS_BFNSentDelegate IS_BFNSent;

        public event IS_BTCReceivedDelegate IS_BTCReceived;

        public event IS_BTCSentDelegate IS_BTCSent;

        public event IS_BTNReceivedDelegate IS_BTNReceived;

        public event IS_BTNSentDelegate IS_BTNSent;

        public event IS_BTTReceivedDelegate IS_BTTReceived;

        public event IS_BTTSentDelegate IS_BTTSent;

        public event IS_CCHReceivedDelegate IS_CCHReceived;

        public event IS_CCHSentDelegate IS_CCHSent;

        public event IS_CNLReceivedDelegate IS_CNLReceived;

        public event IS_CNLSentDelegate IS_CNLSent;

        public event IS_CPPReceivedDelegate IS_CPPReceived;

        public event IS_CPPSentDelegate IS_CPPSent;

        public event IS_CPRReceivedDelegate IS_CPRReceived;

        public event IS_CPRSentDelegate IS_CPRSent;

        public event IS_CRSReceivedDelegate IS_CRSReceived;

        public event IS_CRSSentDelegate IS_CRSSent;

        public event IS_FINReceivedDelegate IS_FINReceived;

        public event IS_FINSentDelegate IS_FINSent;

        public event IS_FLGReceivedDelegate IS_FLGReceived;

        public event IS_FLGSentDelegate IS_FLGSent;

        public event IS_IIIReceivedDelegate IS_IIIReceived;

        public event IS_IIISentDelegate IS_IIISent;

        public event IS_ISIReceivedDelegate IS_ISIReceived;

        public event IS_ISISentDelegate IS_ISISent;

        public event IS_ISMReceivedDelegate IS_ISMReceived;

        public event IS_ISMSentDelegate IS_ISMSent;

        public event IS_LAPReceivedDelegate IS_LAPReceived;

        public event IS_LAPSentDelegate IS_LAPSent;

        public event IS_MCIReceivedDelegate IS_MCIReceived;

        public event IS_MCISentDelegate IS_MCISent;

        public event IS_MODReceivedDelegate IS_MODReceived;

        public event IS_MODSentDelegate IS_MODSent;

        public event IS_MSLReceivedDelegate IS_MSLReceived;

        public event IS_MSLSentDelegate IS_MSLSent;

        public event IS_MSOReceivedDelegate IS_MSOReceived;

        public event IS_MSOSentDelegate IS_MSOSent;

        public event IS_MSTReceivedDelegate IS_MSTReceived;

        public event IS_MSTSentDelegate IS_MSTSent;

        public event IS_MSXReceivedDelegate IS_MSXReceived;

        public event IS_MSXSentDelegate IS_MSXSent;

        public event IS_MTCReceivedDelegate IS_MTCReceived;

        public event IS_MTCSentDelegate IS_MTCSent;

        public event IS_NCNReceivedDelegate IS_NCNReceived;

        public event IS_NCNSentDelegate IS_NCNSent;

        public event IS_NLPReceivedDelegate IS_NLPReceived;

        public event IS_NLPSentDelegate IS_NLPSent;

        public event IS_NPLReceivedDelegate IS_NPLReceived;

        public event IS_NPLSentDelegate IS_NPLSent;

        public event IS_PENReceivedDelegate IS_PENReceived;

        public event IS_PENSentDelegate IS_PENSent;

        public event IS_PFLReceivedDelegate IS_PFLReceived;

        public event IS_PFLSentDelegate IS_PFLSent;

        public event IS_PITReceivedDelegate IS_PITReceived;

        public event IS_PITSentDelegate IS_PITSent;

        public event IS_PLAReceivedDelegate IS_PLAReceived;

        public event IS_PLASentDelegate IS_PLASent;

        public event IS_PLLReceivedDelegate IS_PLLReceived;

        public event IS_PLLSentDelegate IS_PLLSent;

        public event IS_PLPReceivedDelegate IS_PLPReceived;

        public event IS_PLPSentDelegate IS_PLPSent;

        public event IS_PSFReceivedDelegate IS_PSFReceived;

        public event IS_PSFSentDelegate IS_PSFSent;

        public event IS_REOReceivedDelegate IS_REOReceived;

        public event IS_REOSentDelegate IS_REOSent;

        public event IS_RESReceivedDelegate IS_RESReceived;

        public event IS_RESSentDelegate IS_RESSent;

        public event IS_RSTReceivedDelegate IS_RSTReceived;

        public event IS_RSTSentDelegate IS_RSTSent;

        public event IS_SCCReceivedDelegate IS_SCCReceived;

        public event IS_SCCSentDelegate IS_SCCSent;

        public event IS_SCHReceivedDelegate IS_SCHReceived;

        public event IS_SCHSentDelegate IS_SCHSent;

        public event IS_SFPReceivedDelegate IS_SFPReceived;

        public event IS_SFPSentDelegate IS_SFPSent;

        public event IS_SMALLReceivedDelegate IS_SMALLReceived;

        public event IS_SMALLSentDelegate IS_SMALLSent;

        public event IS_SPXReceivedDelegate IS_SPXReceived;

        public event IS_SPXSentDelegate IS_SPXSent;

        public event IS_STAReceivedDelegate IS_STAReceived;

        public event IS_STASentDelegate IS_STASent;

        public event IS_TINYReceivedDelegate IS_TINYReceived;

        public event IS_TINYSentDelegate IS_TINYSent;

        public event IS_TOCReceivedDelegate IS_TOCReceived;

        public event IS_TOCSentDelegate IS_TOCSent;

        public event IS_VERReceivedDelegate IS_VERReceived;

        public event IS_VERSentDelegate IS_VERSent;

        public event IS_VTNReceivedDelegate IS_VTNReceived;

        public event IS_VTNSentDelegate IS_VTNSent;

        private event MessageReceivedDelegate MessageReceived;

        private event MessageSentDelegate MessageSent;

        public IsSocket()
        {
            this.MessageReceived = (MessageReceivedDelegate) Delegate.Combine(this.MessageReceived, new MessageReceivedDelegate(this.StructSocket_MessageReceived));
            this.MessageSent = (MessageSentDelegate) Delegate.Combine(this.MessageSent, new MessageSentDelegate(this.StructSocket_MessageSent));
            this.IS_TINYReceived = (IS_TINYReceivedDelegate) Delegate.Combine(this.IS_TINYReceived, new IS_TINYReceivedDelegate(this.StructSocket_IS_TINYReceived));
        }

        public void Connect(string ipAddressOrHostNameAndPort)
        {
            string[] strArray = ipAddressOrHostNameAndPort.Split(new char[] { ':' });
            string ipAddressOrHostName = strArray[0];
            int port = Convert.ToInt32(strArray[1]);
            this.Connect(ipAddressOrHostName, port);
        }

        public void Connect(string ipAddressOrHostName, int port)
        {
            this.Connect(ipAddressOrHostName, port, false);
        }

        public void Connect(string ipAddressOrHostName, int port, bool asynchronous)
        {
            IPEndPoint point;
            if ((ipAddressOrHostName == "localhost") || (ipAddressOrHostName == "127.0.0.1"))
            {
                point = new IPEndPoint(IPAddress.Loopback, port);
            }
            else
            {
                IPAddress address = Dns.GetHostAddresses(ipAddressOrHostName)[0];
                point = new IPEndPoint(address, port);
            }
            this.clientSocket = new Socket(AddressFamily.InterNetwork, this.SocketType, this.ProtocolType);
            if (!asynchronous)
            {
                this.clientSocket.Connect(point);
                StateObject state = new StateObject();
                this.clientSocket.BeginReceive(state.initBuf, 0, state.initBuf.Length, SocketFlags.None, new AsyncCallback(this.OnReceiveInit), state);
            }
            else
            {
                this.clientSocket.BeginConnect(point, new AsyncCallback(this.OnConnect), null);
            }
        }

        public void Disconnect()
        {
            this.Disconnect(false);
        }

        public void Disconnect(bool asynchronous)
        {
            if ((this.clientSocket != null) && this.clientSocket.Connected)
            {
                if (!asynchronous)
                {
                    this.clientSocket.Shutdown(SocketShutdown.Both);
                    this.clientSocket.Disconnect(false);
                }
                else
                {
                    this.clientSocket.BeginDisconnect(false, new AsyncCallback(this.OnDisconnect), null);
                }
            }
        }

        private void OnConnect(IAsyncResult ar)
        {
            this.clientSocket.EndConnect(ar);
            StateObject state = new StateObject();
            this.clientSocket.BeginReceive(state.initBuf, 0, state.initBuf.Length, SocketFlags.None, new AsyncCallback(this.OnReceiveInit), state);
        }

        private void OnDisconnect(IAsyncResult ar)
        {
            this.clientSocket.Shutdown(SocketShutdown.Both);
            this.clientSocket.EndDisconnect(ar);
        }

        private void OnReceive(IAsyncResult ar)
        {
            StateObject asyncState = (StateObject) ar.AsyncState;
            if ((this.clientSocket.EndReceive(ar) > 0) && (this.MessageReceived != null))
            {
                this.MessageReceived(asyncState.messageBuf);
            }
            this.clientSocket.BeginReceive(asyncState.initBuf, 0, asyncState.initBuf.Length, SocketFlags.None, new AsyncCallback(this.OnReceiveInit), asyncState);
        }

        private void OnReceiveInit(IAsyncResult ar)
        {
            StateObject asyncState = (StateObject) ar.AsyncState;
            int num = this.clientSocket.EndReceive(ar);
            if (num > 0)
            {
                int num2 = asyncState.initBuf[0];
                asyncState.messageBuf = new byte[num2];
                if (num2 > num)
                {
                    Array.Copy(asyncState.initBuf, asyncState.messageBuf, asyncState.initBuf.Length);
                    this.clientSocket.BeginReceive(asyncState.messageBuf, asyncState.initBuf.Length, asyncState.messageBuf.Length - asyncState.initBuf.Length, SocketFlags.None, new AsyncCallback(this.OnReceive), asyncState);
                }
                else
                {
                    if (this.MessageReceived != null)
                    {
                        this.MessageReceived(asyncState.initBuf);
                    }
                    this.clientSocket.BeginReceive(asyncState.initBuf, 0, asyncState.initBuf.Length, SocketFlags.None, new AsyncCallback(this.OnReceiveInit), asyncState);
                }
            }
        }

        private void OnSend(IAsyncResult ar)
        {
            this.clientSocket.EndSend(ar);
            if (this.MessageSent != null)
            {
                this.MessageSent((byte[]) ar.AsyncState);
            }
        }

        public void Send(object anyObject)
        {
            this.Send(RawSerialize.Serialize(anyObject));
        }

        private void Send(byte[] sendBuffer)
        {
            if ((this.clientSocket != null) && this.clientSocket.Connected)
            {
                this.clientSocket.BeginSend(sendBuffer, 0, sendBuffer.Length, SocketFlags.None, new AsyncCallback(this.OnSend), sendBuffer);
            }
        }

        private void StructSocket_IS_TINYReceived(IS_TINY isTiny)
        {
            if (isTiny.SubT == IS_TINYTypeEnum.TINY_NONE)
            {
                this.Send(RawSerialize.Serialize(isTiny));
            }
        }

        private void StructSocket_MessageReceived(byte[] msg)
        {
            Header header = (Header) RawSerialize.Deserialize(msg, typeof(Header));
            switch (header.Type)
            {
                case PacketTypeEnum.ISP_ISI:
                    if (this.IS_ISIReceived != null)
                    {
                        this.IS_ISIReceived((IS_ISI) RawSerialize.Deserialize(msg, typeof(IS_ISI)));
                    }
                    return;

                case PacketTypeEnum.ISP_VER:
                    if (this.IS_VERReceived != null)
                    {
                        this.IS_VERReceived((IS_VER) RawSerialize.Deserialize(msg, typeof(IS_VER)));
                    }
                    return;

                case PacketTypeEnum.ISP_TINY:
                    if (this.IS_TINYReceived != null)
                    {
                        this.IS_TINYReceived((IS_TINY) RawSerialize.Deserialize(msg, typeof(IS_TINY)));
                    }
                    return;

                case PacketTypeEnum.ISP_SMALL:
                    if (this.IS_SMALLReceived != null)
                    {
                        this.IS_SMALLReceived((IS_SMALL) RawSerialize.Deserialize(msg, typeof(IS_SMALL)));
                    }
                    return;

                case PacketTypeEnum.ISP_STA:
                    if (this.IS_STAReceived != null)
                    {
                        this.IS_STAReceived((IS_STA) RawSerialize.Deserialize(msg, typeof(IS_STA)));
                    }
                    return;

                case PacketTypeEnum.ISP_SCH:
                    if (this.IS_SCHReceived != null)
                    {
                        this.IS_SCHReceived((IS_SCH) RawSerialize.Deserialize(msg, typeof(IS_SCH)));
                    }
                    return;

                case PacketTypeEnum.ISP_SFP:
                    if (this.IS_SFPReceived != null)
                    {
                        this.IS_SFPReceived((IS_SFP) RawSerialize.Deserialize(msg, typeof(IS_SFP)));
                    }
                    return;

                case PacketTypeEnum.ISP_SCC:
                    if (this.IS_SCCReceived != null)
                    {
                        this.IS_SCCReceived((IS_SCC) RawSerialize.Deserialize(msg, typeof(IS_SCC)));
                    }
                    return;

                case PacketTypeEnum.ISP_CPP:
                    if (this.IS_CPPReceived != null)
                    {
                        this.IS_CPPReceived((IS_CPP) RawSerialize.Deserialize(msg, typeof(IS_CPP)));
                    }
                    return;

                case PacketTypeEnum.ISP_ISM:
                    if (this.IS_ISMReceived != null)
                    {
                        this.IS_ISMReceived((IS_ISM) RawSerialize.Deserialize(msg, typeof(IS_ISM)));
                    }
                    return;

                case PacketTypeEnum.ISP_MSO:
                    if (this.IS_MSOReceived != null)
                    {
                        this.IS_MSOReceived((IS_MSO) RawSerialize.Deserialize(msg, typeof(IS_MSO)));
                    }
                    return;

                case PacketTypeEnum.ISP_III:
                    if (this.IS_IIIReceived != null)
                    {
                        this.IS_IIIReceived((IS_III) RawSerialize.Deserialize(msg, typeof(IS_III)));
                    }
                    return;

                case PacketTypeEnum.ISP_MST:
                    if (this.IS_MSTReceived != null)
                    {
                        this.IS_MSTReceived((IS_MST) RawSerialize.Deserialize(msg, typeof(IS_MST)));
                    }
                    return;

                case PacketTypeEnum.ISP_MTC:
                    if (this.IS_MTCReceived != null)
                    {
                        this.IS_MTCReceived((IS_MTC) RawSerialize.Deserialize(msg, typeof(IS_MTC)));
                    }
                    return;

                case PacketTypeEnum.ISP_MOD:
                    if (this.IS_MODReceived != null)
                    {
                        this.IS_MODReceived((IS_MOD) RawSerialize.Deserialize(msg, typeof(IS_MOD)));
                    }
                    return;

                case PacketTypeEnum.ISP_VTN:
                    if (this.IS_VTNReceived != null)
                    {
                        this.IS_VTNReceived((IS_VTN) RawSerialize.Deserialize(msg, typeof(IS_VTN)));
                    }
                    return;

                case PacketTypeEnum.ISP_RST:
                    if (this.IS_RSTReceived != null)
                    {
                        this.IS_RSTReceived((IS_RST) RawSerialize.Deserialize(msg, typeof(IS_RST)));
                    }
                    return;

                case PacketTypeEnum.ISP_NCN:
                    if (this.IS_NCNReceived != null)
                    {
                        this.IS_NCNReceived((IS_NCN) RawSerialize.Deserialize(msg, typeof(IS_NCN)));
                    }
                    return;

                case PacketTypeEnum.ISP_CNL:
                    if (this.IS_CNLReceived != null)
                    {
                        this.IS_CNLReceived((IS_CNL) RawSerialize.Deserialize(msg, typeof(IS_CNL)));
                    }
                    return;

                case PacketTypeEnum.ISP_CPR:
                    if (this.IS_CPRReceived != null)
                    {
                        this.IS_CPRReceived((IS_CPR) RawSerialize.Deserialize(msg, typeof(IS_CPR)));
                    }
                    return;

                case PacketTypeEnum.ISP_NPL:
                    if (this.IS_NPLReceived != null)
                    {
                        this.IS_NPLReceived((IS_NPL) RawSerialize.Deserialize(msg, typeof(IS_NPL)));
                    }
                    return;

                case PacketTypeEnum.ISP_PLP:
                    if (this.IS_PLPReceived != null)
                    {
                        this.IS_PLPReceived((IS_PLP) RawSerialize.Deserialize(msg, typeof(IS_PLP)));
                    }
                    return;

                case PacketTypeEnum.ISP_PLL:
                    if (this.IS_PLLReceived != null)
                    {
                        this.IS_PLLReceived((IS_PLL) RawSerialize.Deserialize(msg, typeof(IS_PLL)));
                    }
                    return;

                case PacketTypeEnum.ISP_LAP:
                    if (this.IS_LAPReceived != null)
                    {
                        this.IS_LAPReceived((IS_LAP) RawSerialize.Deserialize(msg, typeof(IS_LAP)));
                    }
                    return;

                case PacketTypeEnum.ISP_SPX:
                    if (this.IS_SPXReceived != null)
                    {
                        this.IS_SPXReceived((IS_SPX) RawSerialize.Deserialize(msg, typeof(IS_SPX)));
                    }
                    return;

                case PacketTypeEnum.ISP_PIT:
                    if (this.IS_PITReceived != null)
                    {
                        this.IS_PITReceived((IS_PIT) RawSerialize.Deserialize(msg, typeof(IS_PIT)));
                    }
                    return;

                case PacketTypeEnum.ISP_PSF:
                    if (this.IS_PSFReceived != null)
                    {
                        this.IS_PSFReceived((IS_PSF) RawSerialize.Deserialize(msg, typeof(IS_PSF)));
                    }
                    return;

                case PacketTypeEnum.ISP_PLA:
                    if (this.IS_PLAReceived != null)
                    {
                        this.IS_PLAReceived((IS_PLA) RawSerialize.Deserialize(msg, typeof(IS_PLA)));
                    }
                    return;

                case PacketTypeEnum.ISP_CCH:
                    if (this.IS_CCHReceived != null)
                    {
                        this.IS_CCHReceived((IS_CCH) RawSerialize.Deserialize(msg, typeof(IS_CCH)));
                    }
                    return;

                case PacketTypeEnum.ISP_PEN:
                    if (this.IS_PENReceived != null)
                    {
                        this.IS_PENReceived((IS_PEN) RawSerialize.Deserialize(msg, typeof(IS_PEN)));
                    }
                    return;

                case PacketTypeEnum.ISP_TOC:
                    if (this.IS_TOCReceived != null)
                    {
                        this.IS_TOCReceived((IS_TOC) RawSerialize.Deserialize(msg, typeof(IS_TOC)));
                    }
                    return;

                case PacketTypeEnum.ISP_FLG:
                    if (this.IS_FLGReceived != null)
                    {
                        this.IS_FLGReceived((IS_FLG) RawSerialize.Deserialize(msg, typeof(IS_FLG)));
                    }
                    return;

                case PacketTypeEnum.ISP_PFL:
                    if (this.IS_PFLReceived != null)
                    {
                        this.IS_PFLReceived((IS_PFL) RawSerialize.Deserialize(msg, typeof(IS_PFL)));
                    }
                    return;

                case PacketTypeEnum.ISP_FIN:
                    if (this.IS_FINReceived != null)
                    {
                        this.IS_FINReceived((IS_FIN) RawSerialize.Deserialize(msg, typeof(IS_FIN)));
                    }
                    return;

                case PacketTypeEnum.ISP_RES:
                    if (this.IS_RESReceived != null)
                    {
                        this.IS_RESReceived((IS_RES) RawSerialize.Deserialize(msg, typeof(IS_RES)));
                    }
                    return;

                case PacketTypeEnum.ISP_REO:
                    if (this.IS_REOReceived != null)
                    {
                        this.IS_REOReceived((IS_REO) RawSerialize.Deserialize(msg, typeof(IS_REO)));
                    }
                    return;

                case PacketTypeEnum.ISP_NLP:
                    if (this.IS_NLPReceived != null)
                    {
                        this.IS_NLPReceived((IS_NLP) RawSerialize.Deserialize(msg, typeof(IS_NLP)));
                    }
                    return;

                case PacketTypeEnum.ISP_MCI:
                    if (this.IS_MCIReceived != null)
                    {
                        this.IS_MCIReceived((IS_MCI) RawSerialize.Deserialize(msg, typeof(IS_MCI)));
                    }
                    return;

                case PacketTypeEnum.ISP_MSX:
                    if (this.IS_MSXReceived != null)
                    {
                        this.IS_MSXReceived((IS_MSX) RawSerialize.Deserialize(msg, typeof(IS_MSX)));
                    }
                    return;

                case PacketTypeEnum.ISP_MSL:
                    if (this.IS_MSLReceived != null)
                    {
                        this.IS_MSLReceived((IS_MSL) RawSerialize.Deserialize(msg, typeof(IS_MSL)));
                    }
                    return;

                case PacketTypeEnum.ISP_CRS:
                    if (this.IS_CRSReceived != null)
                    {
                        this.IS_CRSReceived((IS_CRS) RawSerialize.Deserialize(msg, typeof(IS_CRS)));
                    }
                    return;

                case PacketTypeEnum.ISP_BFN:
                    if (this.IS_BFNReceived != null)
                    {
                        this.IS_BFNReceived((IS_BFN) RawSerialize.Deserialize(msg, typeof(IS_BFN)));
                    }
                    return;

                case PacketTypeEnum.ISP_BTN:
                    if (this.IS_BTNReceived != null)
                    {
                        this.IS_BTNReceived((IS_BTN) RawSerialize.Deserialize(msg, typeof(IS_BTN)));
                    }
                    return;

                case PacketTypeEnum.ISP_BTC:
                    if (this.IS_BTCReceived != null)
                    {
                        this.IS_BTCReceived((IS_BTC) RawSerialize.Deserialize(msg, typeof(IS_BTC)));
                    }
                    return;

                case PacketTypeEnum.ISP_BTT:
                    if (this.IS_BTTReceived != null)
                    {
                        this.IS_BTTReceived((IS_BTT) RawSerialize.Deserialize(msg, typeof(IS_BTT)));
                    }
                    return;
            }
            throw new ApplicationException("unknown message received");
        }

        private void StructSocket_MessageSent(byte[] msg)
        {
            Header header = (Header) RawSerialize.Deserialize(msg, typeof(Header));
            switch (header.Type)
            {
                case PacketTypeEnum.ISP_ISI:
                    if (this.IS_ISISent != null)
                    {
                        this.IS_ISISent((IS_ISI) RawSerialize.Deserialize(msg, typeof(IS_ISI)));
                    }
                    return;

                case PacketTypeEnum.ISP_VER:
                    if (this.IS_VERSent != null)
                    {
                        this.IS_VERSent((IS_VER) RawSerialize.Deserialize(msg, typeof(IS_VER)));
                    }
                    return;

                case PacketTypeEnum.ISP_TINY:
                    if (this.IS_TINYSent != null)
                    {
                        this.IS_TINYSent((IS_TINY) RawSerialize.Deserialize(msg, typeof(IS_TINY)));
                    }
                    return;

                case PacketTypeEnum.ISP_SMALL:
                    if (this.IS_SMALLSent != null)
                    {
                        this.IS_SMALLSent((IS_SMALL) RawSerialize.Deserialize(msg, typeof(IS_SMALL)));
                    }
                    return;

                case PacketTypeEnum.ISP_STA:
                    if (this.IS_STASent != null)
                    {
                        this.IS_STASent((IS_STA) RawSerialize.Deserialize(msg, typeof(IS_STA)));
                    }
                    return;

                case PacketTypeEnum.ISP_SCH:
                    if (this.IS_SCHSent != null)
                    {
                        this.IS_SCHSent((IS_SCH) RawSerialize.Deserialize(msg, typeof(IS_SCH)));
                    }
                    return;

                case PacketTypeEnum.ISP_SFP:
                    if (this.IS_SFPSent != null)
                    {
                        this.IS_SFPSent((IS_SFP) RawSerialize.Deserialize(msg, typeof(IS_SFP)));
                    }
                    return;

                case PacketTypeEnum.ISP_SCC:
                    if (this.IS_SCCSent != null)
                    {
                        this.IS_SCCSent((IS_SCC) RawSerialize.Deserialize(msg, typeof(IS_SCC)));
                    }
                    return;

                case PacketTypeEnum.ISP_CPP:
                    if (this.IS_CPPSent != null)
                    {
                        this.IS_CPPSent((IS_CPP) RawSerialize.Deserialize(msg, typeof(IS_CPP)));
                    }
                    return;

                case PacketTypeEnum.ISP_ISM:
                    if (this.IS_ISMSent != null)
                    {
                        this.IS_ISMSent((IS_ISM) RawSerialize.Deserialize(msg, typeof(IS_ISM)));
                    }
                    return;

                case PacketTypeEnum.ISP_MSO:
                    if (this.IS_MSOSent != null)
                    {
                        this.IS_MSOSent((IS_MSO) RawSerialize.Deserialize(msg, typeof(IS_MSO)));
                    }
                    return;

                case PacketTypeEnum.ISP_III:
                    if (this.IS_IIISent != null)
                    {
                        this.IS_IIISent((IS_III) RawSerialize.Deserialize(msg, typeof(IS_III)));
                    }
                    return;

                case PacketTypeEnum.ISP_MST:
                    if (this.IS_MSTSent != null)
                    {
                        this.IS_MSTSent((IS_MST) RawSerialize.Deserialize(msg, typeof(IS_MST)));
                    }
                    return;

                case PacketTypeEnum.ISP_MTC:
                    if (this.IS_MTCSent != null)
                    {
                        this.IS_MTCSent((IS_MTC) RawSerialize.Deserialize(msg, typeof(IS_MTC)));
                    }
                    return;

                case PacketTypeEnum.ISP_MOD:
                    if (this.IS_MODSent != null)
                    {
                        this.IS_MODSent((IS_MOD) RawSerialize.Deserialize(msg, typeof(IS_MOD)));
                    }
                    return;

                case PacketTypeEnum.ISP_VTN:
                    if (this.IS_VTNSent != null)
                    {
                        this.IS_VTNSent((IS_VTN) RawSerialize.Deserialize(msg, typeof(IS_VTN)));
                    }
                    return;

                case PacketTypeEnum.ISP_RST:
                    if (this.IS_RSTSent != null)
                    {
                        this.IS_RSTSent((IS_RST) RawSerialize.Deserialize(msg, typeof(IS_RST)));
                    }
                    return;

                case PacketTypeEnum.ISP_NCN:
                    if (this.IS_NCNSent != null)
                    {
                        this.IS_NCNSent((IS_NCN) RawSerialize.Deserialize(msg, typeof(IS_NCN)));
                    }
                    return;

                case PacketTypeEnum.ISP_CNL:
                    if (this.IS_CNLSent != null)
                    {
                        this.IS_CNLSent((IS_CNL) RawSerialize.Deserialize(msg, typeof(IS_CNL)));
                    }
                    return;

                case PacketTypeEnum.ISP_CPR:
                    if (this.IS_CPRSent != null)
                    {
                        this.IS_CPRSent((IS_CPR) RawSerialize.Deserialize(msg, typeof(IS_CPR)));
                    }
                    return;

                case PacketTypeEnum.ISP_NPL:
                    if (this.IS_NPLSent != null)
                    {
                        this.IS_NPLSent((IS_NPL) RawSerialize.Deserialize(msg, typeof(IS_NPL)));
                    }
                    return;

                case PacketTypeEnum.ISP_PLP:
                    if (this.IS_PLPSent != null)
                    {
                        this.IS_PLPSent((IS_PLP) RawSerialize.Deserialize(msg, typeof(IS_PLP)));
                    }
                    return;

                case PacketTypeEnum.ISP_PLL:
                    if (this.IS_PLLSent != null)
                    {
                        this.IS_PLLSent((IS_PLL) RawSerialize.Deserialize(msg, typeof(IS_PLL)));
                    }
                    return;

                case PacketTypeEnum.ISP_LAP:
                    if (this.IS_LAPSent != null)
                    {
                        this.IS_LAPSent((IS_LAP) RawSerialize.Deserialize(msg, typeof(IS_LAP)));
                    }
                    return;

                case PacketTypeEnum.ISP_SPX:
                    if (this.IS_SPXSent != null)
                    {
                        this.IS_SPXSent((IS_SPX) RawSerialize.Deserialize(msg, typeof(IS_SPX)));
                    }
                    return;

                case PacketTypeEnum.ISP_PIT:
                    if (this.IS_PITSent != null)
                    {
                        this.IS_PITSent((IS_PIT) RawSerialize.Deserialize(msg, typeof(IS_PIT)));
                    }
                    return;

                case PacketTypeEnum.ISP_PSF:
                    if (this.IS_PSFSent != null)
                    {
                        this.IS_PSFSent((IS_PSF) RawSerialize.Deserialize(msg, typeof(IS_PSF)));
                    }
                    return;

                case PacketTypeEnum.ISP_PLA:
                    if (this.IS_PLASent != null)
                    {
                        this.IS_PLASent((IS_PLA) RawSerialize.Deserialize(msg, typeof(IS_PLA)));
                    }
                    return;

                case PacketTypeEnum.ISP_CCH:
                    if (this.IS_CCHSent != null)
                    {
                        this.IS_CCHSent((IS_CCH) RawSerialize.Deserialize(msg, typeof(IS_CCH)));
                    }
                    return;

                case PacketTypeEnum.ISP_PEN:
                    if (this.IS_PENSent != null)
                    {
                        this.IS_PENSent((IS_PEN) RawSerialize.Deserialize(msg, typeof(IS_PEN)));
                    }
                    return;

                case PacketTypeEnum.ISP_TOC:
                    if (this.IS_TOCSent != null)
                    {
                        this.IS_TOCSent((IS_TOC) RawSerialize.Deserialize(msg, typeof(IS_TOC)));
                    }
                    return;

                case PacketTypeEnum.ISP_FLG:
                    if (this.IS_FLGSent != null)
                    {
                        this.IS_FLGSent((IS_FLG) RawSerialize.Deserialize(msg, typeof(IS_FLG)));
                    }
                    return;

                case PacketTypeEnum.ISP_PFL:
                    if (this.IS_PFLSent != null)
                    {
                        this.IS_PFLSent((IS_PFL) RawSerialize.Deserialize(msg, typeof(IS_PFL)));
                    }
                    return;

                case PacketTypeEnum.ISP_FIN:
                    if (this.IS_FINSent != null)
                    {
                        this.IS_FINSent((IS_FIN) RawSerialize.Deserialize(msg, typeof(IS_FIN)));
                    }
                    return;

                case PacketTypeEnum.ISP_RES:
                    if (this.IS_RESSent != null)
                    {
                        this.IS_RESSent((IS_RES) RawSerialize.Deserialize(msg, typeof(IS_RES)));
                    }
                    return;

                case PacketTypeEnum.ISP_REO:
                    if (this.IS_REOSent != null)
                    {
                        this.IS_REOSent((IS_REO) RawSerialize.Deserialize(msg, typeof(IS_REO)));
                    }
                    return;

                case PacketTypeEnum.ISP_NLP:
                    if (this.IS_NLPSent != null)
                    {
                        this.IS_NLPSent((IS_NLP) RawSerialize.Deserialize(msg, typeof(IS_NLP)));
                    }
                    return;

                case PacketTypeEnum.ISP_MCI:
                    if (this.IS_MCISent != null)
                    {
                        this.IS_MCISent((IS_MCI) RawSerialize.Deserialize(msg, typeof(IS_MCI)));
                    }
                    return;

                case PacketTypeEnum.ISP_MSX:
                    if (this.IS_MSXSent != null)
                    {
                        this.IS_MSXSent((IS_MSX) RawSerialize.Deserialize(msg, typeof(IS_MSX)));
                    }
                    return;

                case PacketTypeEnum.ISP_MSL:
                    if (this.IS_MSLSent != null)
                    {
                        this.IS_MSLSent((IS_MSL) RawSerialize.Deserialize(msg, typeof(IS_MSL)));
                    }
                    return;

                case PacketTypeEnum.ISP_CRS:
                    if (this.IS_CRSSent != null)
                    {
                        this.IS_CRSSent((IS_CRS) RawSerialize.Deserialize(msg, typeof(IS_CRS)));
                    }
                    return;

                case PacketTypeEnum.ISP_BFN:
                    if (this.IS_BFNSent != null)
                    {
                        this.IS_BFNSent((IS_BFN) RawSerialize.Deserialize(msg, typeof(IS_BFN)));
                    }
                    return;

                case PacketTypeEnum.ISP_BTN:
                    if (this.IS_BTNSent != null)
                    {
                        this.IS_BTNSent((IS_BTN) RawSerialize.Deserialize(msg, typeof(IS_BTN)));
                    }
                    return;

                case PacketTypeEnum.ISP_BTC:
                    if (this.IS_BTCSent != null)
                    {
                        this.IS_BTCSent((IS_BTC) RawSerialize.Deserialize(msg, typeof(IS_BTC)));
                    }
                    return;

                case PacketTypeEnum.ISP_BTT:
                    if (this.IS_BTTSent != null)
                    {
                        this.IS_BTTSent((IS_BTT) RawSerialize.Deserialize(msg, typeof(IS_BTT)));
                    }
                    return;
            }
            throw new ApplicationException("unknown message received");
        }

        public bool Connected
        {
            get
            {
                return ((this.clientSocket != null) && this.clientSocket.Connected);
            }
        }

        protected abstract System.Net.Sockets.ProtocolType ProtocolType { get; }

        protected abstract System.Net.Sockets.SocketType SocketType { get; }

        public delegate void IS_BFNReceivedDelegate(IS_BFN is_bfn);

        public delegate void IS_BFNSentDelegate(IS_BFN is_bfn);

        public delegate void IS_BTCReceivedDelegate(IS_BTC is_btc);

        public delegate void IS_BTCSentDelegate(IS_BTC is_btc);

        public delegate void IS_BTNReceivedDelegate(IS_BTN is_btn);

        public delegate void IS_BTNSentDelegate(IS_BTN is_btn);

        public delegate void IS_BTTReceivedDelegate(IS_BTT is_btt);

        public delegate void IS_BTTSentDelegate(IS_BTT is_btt);

        public delegate void IS_CCHReceivedDelegate(IS_CCH is_cch);

        public delegate void IS_CCHSentDelegate(IS_CCH is_cch);

        public delegate void IS_CNLReceivedDelegate(IS_CNL is_cnl);

        public delegate void IS_CNLSentDelegate(IS_CNL is_cnl);

        public delegate void IS_CPPReceivedDelegate(IS_CPP is_cpp);

        public delegate void IS_CPPSentDelegate(IS_CPP is_cpp);

        public delegate void IS_CPRReceivedDelegate(IS_CPR is_cpr);

        public delegate void IS_CPRSentDelegate(IS_CPR is_cpr);

        public delegate void IS_CRSReceivedDelegate(IS_CRS is_crs);

        public delegate void IS_CRSSentDelegate(IS_CRS is_crs);

        public delegate void IS_FINReceivedDelegate(IS_FIN is_fin);

        public delegate void IS_FINSentDelegate(IS_FIN is_fin);

        public delegate void IS_FLGReceivedDelegate(IS_FLG is_flg);

        public delegate void IS_FLGSentDelegate(IS_FLG is_flg);

        public delegate void IS_IIIReceivedDelegate(IS_III is_iii);

        public delegate void IS_IIISentDelegate(IS_III is_iii);

        public delegate void IS_ISIReceivedDelegate(IS_ISI is_isi);

        public delegate void IS_ISISentDelegate(IS_ISI is_isi);

        public delegate void IS_ISMReceivedDelegate(IS_ISM is_ism);

        public delegate void IS_ISMSentDelegate(IS_ISM is_ism);

        public delegate void IS_LAPReceivedDelegate(IS_LAP is_lap);

        public delegate void IS_LAPSentDelegate(IS_LAP is_lap);

        public delegate void IS_MCIReceivedDelegate(IS_MCI is_mci);

        public delegate void IS_MCISentDelegate(IS_MCI is_mci);

        public delegate void IS_MODReceivedDelegate(IS_MOD is_mod);

        public delegate void IS_MODSentDelegate(IS_MOD is_mod);

        public delegate void IS_MSLReceivedDelegate(IS_MSL is_msl);

        public delegate void IS_MSLSentDelegate(IS_MSL is_msl);

        public delegate void IS_MSOReceivedDelegate(IS_MSO is_mso);

        public delegate void IS_MSOSentDelegate(IS_MSO is_mso);

        public delegate void IS_MSTReceivedDelegate(IS_MST is_mst);

        public delegate void IS_MSTSentDelegate(IS_MST is_mst);

        public delegate void IS_MSXReceivedDelegate(IS_MSX is_msx);

        public delegate void IS_MSXSentDelegate(IS_MSX is_msx);

        public delegate void IS_MTCReceivedDelegate(IS_MTC is_mtc);

        public delegate void IS_MTCSentDelegate(IS_MTC is_mtc);

        public delegate void IS_NCNReceivedDelegate(IS_NCN is_ncn);

        public delegate void IS_NCNSentDelegate(IS_NCN is_ncn);

        public delegate void IS_NLPReceivedDelegate(IS_NLP is_nlp);

        public delegate void IS_NLPSentDelegate(IS_NLP is_nlp);

        public delegate void IS_NPLReceivedDelegate(IS_NPL is_npl);

        public delegate void IS_NPLSentDelegate(IS_NPL is_npl);

        public delegate void IS_PENReceivedDelegate(IS_PEN is_pen);

        public delegate void IS_PENSentDelegate(IS_PEN is_pen);

        public delegate void IS_PFLReceivedDelegate(IS_PFL is_pfl);

        public delegate void IS_PFLSentDelegate(IS_PFL is_pfl);

        public delegate void IS_PITReceivedDelegate(IS_PIT is_pit);

        public delegate void IS_PITSentDelegate(IS_PIT is_pit);

        public delegate void IS_PLAReceivedDelegate(IS_PLA is_pla);

        public delegate void IS_PLASentDelegate(IS_PLA is_pla);

        public delegate void IS_PLLReceivedDelegate(IS_PLL is_pll);

        public delegate void IS_PLLSentDelegate(IS_PLL is_pll);

        public delegate void IS_PLPReceivedDelegate(IS_PLP is_plp);

        public delegate void IS_PLPSentDelegate(IS_PLP is_plp);

        public delegate void IS_PSFReceivedDelegate(IS_PSF is_psf);

        public delegate void IS_PSFSentDelegate(IS_PSF is_psf);

        public delegate void IS_REOReceivedDelegate(IS_REO is_reo);

        public delegate void IS_REOSentDelegate(IS_REO is_reo);

        public delegate void IS_RESReceivedDelegate(IS_RES is_res);

        public delegate void IS_RESSentDelegate(IS_RES is_res);

        public delegate void IS_RSTReceivedDelegate(IS_RST is_rst);

        public delegate void IS_RSTSentDelegate(IS_RST is_rst);

        public delegate void IS_SCCReceivedDelegate(IS_SCC is_scc);

        public delegate void IS_SCCSentDelegate(IS_SCC is_scc);

        public delegate void IS_SCHReceivedDelegate(IS_SCH is_sch);

        public delegate void IS_SCHSentDelegate(IS_SCH is_sch);

        public delegate void IS_SFPReceivedDelegate(IS_SFP is_sfp);

        public delegate void IS_SFPSentDelegate(IS_SFP is_sfp);

        public delegate void IS_SMALLReceivedDelegate(IS_SMALL is_small);

        public delegate void IS_SMALLSentDelegate(IS_SMALL is_small);

        public delegate void IS_SPXReceivedDelegate(IS_SPX is_spx);

        public delegate void IS_SPXSentDelegate(IS_SPX is_spx);

        public delegate void IS_STAReceivedDelegate(IS_STA is_sta);

        public delegate void IS_STASentDelegate(IS_STA is_sta);

        public delegate void IS_TINYReceivedDelegate(IS_TINY is_tiny);

        public delegate void IS_TINYSentDelegate(IS_TINY is_tiny);

        public delegate void IS_TOCReceivedDelegate(IS_TOC is_toc);

        public delegate void IS_TOCSentDelegate(IS_TOC is_toc);

        public delegate void IS_VERReceivedDelegate(IS_VER is_ver);

        public delegate void IS_VERSentDelegate(IS_VER is_ver);

        public delegate void IS_VTNReceivedDelegate(IS_VTN is_vtn);

        public delegate void IS_VTNSentDelegate(IS_VTN is_vtn);

        private delegate void MessageReceivedDelegate(byte[] msg);

        private delegate void MessageSentDelegate(byte[] msg);
    }
}

