﻿namespace LfsInSimLib.IS_SubPackets
{
    using System;
    using System.Runtime.InteropServices;

    [StructLayout(LayoutKind.Sequential, Pack=1)]
    public class RaceLaps
    {
        private byte raceLaps;
        public bool IsQualifying
        {
            get
            {
                return (this.raceLaps == 0);
            }
            set
            {
                this.raceLaps = 0;
            }
        }
        public ushort? Laps
        {
            get
            {
                ushort? nullable = null;
                if ((this.raceLaps >= 1) && (this.raceLaps <= 0x63))
                {
                    nullable = new ushort?(this.raceLaps);
                }
                if ((this.raceLaps >= 100) && (this.raceLaps <= 190))
                {
                    nullable = new ushort?((ushort) (((this.raceLaps - 100) * 10) + 100));
                }
                return nullable;
            }
            set
            {
                if ((value >= 1) && (value <= 0x63))
                {
                    this.raceLaps = (byte) value.Value;
                }
                if ((value >= 100) && (value <= 0x3e8))
                {
                    int? nullable11 = ((value - 100) / 10) + 100;
                    this.raceLaps = (byte) nullable11.Value;
                }
            }
        }
        public byte? Hours
        {
            get
            {
                byte? nullable = null;
                if ((this.raceLaps >= 0xbf) && (this.raceLaps <= 0xee))
                {
                    nullable = new byte?((byte) (this.raceLaps - 190));
                }
                return nullable;
            }
            set
            {
                if ((value >= 1) && (value <= 0x30))
                {
                    int? nullable5 = value + 190;
                    this.raceLaps = (byte) nullable5.Value;
                }
            }
        }
        public override string ToString()
        {
            string str = string.Empty;
            if (this.Laps.HasValue)
            {
                str = this.Laps.ToString() + " Laps";
            }
            if (this.Hours.HasValue)
            {
                str = this.Hours.ToString() + " Hours";
            }
            return str;
        }
    }
}

