﻿namespace LfsInSimLib.IS_Packets
{
    using LfsInSimLib.IS_Enums;
    using System;
    using System.Runtime.InteropServices;

    [StructLayout(LayoutKind.Sequential, Pack=1)]
    public class IS_VER
    {
        private byte Size = 20;
        private PacketTypeEnum Type = PacketTypeEnum.ISP_VER;
        public byte ReqI;
        private byte Zero = 0;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst=8)]
        public string Version;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst=6)]
        public string Product;
        public ushort InSimVer;
        public static IS_TINY CreateRequestPacket(byte reqI)
        {
            return new IS_TINY(reqI, IS_TINYTypeEnum.TINY_VER);
        }
    }
}

