﻿namespace LfsInSimLib.IS_Packets
{
    using LfsInSimLib.IS_Enums;
    using System;
    using System.Runtime.InteropServices;

    [StructLayout(LayoutKind.Sequential, Pack=1)]
    public class IS_RES
    {
        private byte Size = 0x54;
        private PacketTypeEnum Type = PacketTypeEnum.ISP_RES;
        public byte ReqI;
        public byte PLID;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst=0x18)]
        public string UName;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst=0x18)]
        public string PName;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst=8)]
        private char[] plate;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst=4)]
        public string CName;
        public uint TTime;
        public uint BTime;
        private byte SpA = 0;
        public byte NumStops;
        public byte Confirm;
        private byte SpB = 0;
        public ushort LapsDone;
        public ushort Flags;
        public byte ResultNum;
        public byte NumRes;
        private byte Sp2 = 0;
        private byte Sp3 = 0;
        public string Plate
        {
            get
            {
                return new string(this.plate);
            }
            set
            {
                this.plate = value.ToCharArray(0, 8);
            }
        }
    }
}

