﻿namespace LfsInSimLib.IS_Packets
{
    using LfsInSimLib.IS_Enums;
    using LfsInSimLib.IS_SubPackets;
    using System;
    using System.Runtime.InteropServices;

    [StructLayout(LayoutKind.Sequential, Pack=1)]
    public class IS_NPL
    {
        private byte Size = 0x4c;
        private PacketTypeEnum Type = PacketTypeEnum.ISP_NPL;
        public byte ReqI;
        public byte PLID;
        public byte UCID;
        public PlayerTypeEnum PType;
        public PlayerFlagsEnum Flags;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst=0x18)]
        public string PName;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst=8)]
        private char[] plate;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst=4)]
        public string CName;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst=0x10)]
        public string SName;
        public LfsInSimLib.IS_SubPackets.Tyres Tyres;
        public byte H_Mass;
        public byte H_TRes;
        private byte SpB = 0;
        public PassengersFlagsEnum Pass;
        private int Spare = 0;
        private byte Sp0 = 0;
        public byte NumP;
        private byte Sp2 = 0;
        private byte Sp3 = 0;
        public string Plate
        {
            get
            {
                return new string(this.plate);
            }
            set
            {
                this.plate = value.ToCharArray(0, 8);
            }
        }
    }
}

