﻿namespace LfsInSimLib.IS_Packets
{
    using LfsInSimLib.IS_Enums;
    using System;
    using System.Runtime.InteropServices;

    [StructLayout(LayoutKind.Sequential, Pack=1)]
    public class IS_CPR
    {
        private byte Size = 0x24;
        private PacketTypeEnum Type = PacketTypeEnum.ISP_CPR;
        private byte ReqI = 0;
        public byte UCID;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst=0x18)]
        public string PName;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst=8)]
        private char[] plate;
        public string Plate
        {
            get
            {
                return new string(this.plate);
            }
            set
            {
                this.plate = value.ToCharArray(0, 8);
            }
        }
    }
}

