﻿namespace ISRM
{
    using LfsInSimLib.IS_Packets;
    using System;
    using System.IO;

    public class mod_nascar : module
    {
        private int CautionLap;
        public RaceFlag Flag;
        public byte IDadmin;
        public byte IDflag;
        public byte IDfollow;
        public float Pace = 100f;
        public PosList PosStart = new PosList();

        private void AutoLog(string s)
        {
            this.Log(string.Format("#A [{0:hh:mm:ss}] {1}", DateTime.Now, s));
        }

        private double dist(double X1, double Y1, double X2, double Y2)
        {
            return Math.Sqrt(Math.Pow(X1 - X2, 2.0) + Math.Pow(Y1 - Y2, 2.0));
        }

        private double distance(Player p1, Player p2)
        {
            return (Math.Sqrt((double) ((((p1.X - p2.X) ^ (2 + (p1.Y - p2.Y))) ^ (2 + (p1.Z - p2.Z))) ^ 2)) / 65536.0);
        }

        private double eval(double X, double Y, double X1, double Y1, double X2, double Y2)
        {
            double num = this.dist(X, Y, X1, Y1);
            double num2 = this.dist(X, Y, X2, Y2);
            double num3 = this.dist(X1, Y1, X2, Y2);
            double num4 = ((num + num2) + num3) / 2.0;
            double num5 = Math.Sqrt(((num4 * (num4 - num)) * (num4 - num2)) * (num4 - num3));
            Console.WriteLine(X);
            Console.WriteLine(Y);
            Console.WriteLine(X1);
            Console.WriteLine(Y1);
            Console.WriteLine(num3);
            Console.WriteLine(num5);
            return ((2.0 * num5) / num3);
        }

        public override void In(object message)
        {
            if ((message is IS_RST) && (base.x.Session == SessionType.Race))
            {
                this.UpdateFlag(RaceFlag.Warmup);
            }
            if (message is IS_REO)
            {
                IS_REO is_reo = (IS_REO) message;
                this.PosStart = new PosList();
                for (int i = 0; i < 0x20; i++)
                {
                    if (is_reo.PLID.PLID[i] != 0)
                    {
                        this.PosStart.Add(is_reo.PLID.PLID[i]);
                    }
                }
            }
            if (((message is IS_PLL) || (message is IS_PLP)) && ((base.x.Players.Count == 0) && (base.x.Session == SessionType.Race)))
            {
                this.UpdateFlag(RaceFlag.Warmup);
            }
            if (message is IS_LAP)
            {
                IS_LAP is_lap = (IS_LAP) message;
                if ((base.x.Positions.PLID(is_lap.PLID) == 1) && (base.x.Session == SessionType.Race))
                {
                    if (base.x.LapsDone == 1)
                    {
                        this.UpdateFlag(RaceFlag.Green);
                    }
                    if ((base.x.LapsDone == this.CautionLap) && (this.Flag == RaceFlag.Yellow))
                    {
                        this.UpdateFlag(RaceFlag.Green);
                    }
                    if (base.x.LapsDone == (base.x.Laps - 1))
                    {
                        this.UpdateFlag(RaceFlag.White);
                    }
                    if (base.x.LapsDone == base.x.Laps)
                    {
                        this.UpdateFlag(RaceFlag.Chequered);
                    }
                }
            }
            if (message is IS_III)
            {
            }
        }

        public override void Init()
        {
            this.IDadmin = base.x.GetID();
            this.IDflag = base.x.GetID();
            this.IDfollow = base.x.GetID();
        }

        private void Log(string s)
        {
            StreamWriter writer = new StreamWriter(new FileStream(@"c:\current.txt", FileMode.Append, FileAccess.Write));
            writer.WriteLine(s);
            writer.Close();
        }

        private void Report(string s, Connection c)
        {
            string pName;
            if (c.Players.Count > 0)
            {
                pName = c.Plyr.PName;
            }
            else
            {
                pName = "spec: " + c.UName;
            }
            this.Log(string.Format("#R [{0:hh:mm:ss}] [{1}] {2}", DateTime.Now, pName, s));
        }

        public override void Update()
        {
            int num;
            for (num = 1; num < this.PosStart.Count; num++)
            {
                if (base.x.Positions.PLID((byte) this.PosStart[num]) == 0)
                {
                    this.PosStart.RemoveAt(num);
                }
            }
            for (num = 1; num < base.x.Positions.Count; num++)
            {
                if (this.PosStart.PLID((byte) base.x.Positions[num]) == 0)
                {
                    this.PosStart.Add(base.x.Positions[num]);
                }
            }
            foreach (Player player in base.x.Players)
            {
                if ((this.Flag == RaceFlag.Warmup) || (this.Flag == RaceFlag.Yellow))
                {
                    if (base.x.Positions.PLID(player.PLID) == 1)
                    {
                        player.Messages.Replace(new Message("fl_leader", this.IDfollow));
                        player.Messages.Add(new Message("fl_speed", this.IDfollow, this.Pace));
                    }
                    int num2 = this.PosStart.PLID(player.PLID);
                    if (num2 != 1)
                    {
                        string pName = base.x.Players.ID((byte) this.PosStart[num2 - 1]).PName;
                        player.Messages.Replace(new Message("fl_behind", this.IDfollow, pName));
                    }
                }
            }
        }

        private void UpdateFlag(RaceFlag flag)
        {
            bool flag2 = false;
            if (flag == RaceFlag.Yellow)
            {
                if ((this.Flag == RaceFlag.Green) && ((base.x.LapsDone + 2) < base.x.Laps))
                {
                    this.CautionLap = base.x.LapsDone + 2;
                    this.Flag = RaceFlag.Yellow;
                    this.PosStart = new PosList(base.x.Positions);
                    flag2 = true;
                }
            }
            else
            {
                this.Flag = flag;
                flag2 = true;
            }
            if (flag2)
            {
                if (this.Flag == RaceFlag.Warmup)
                {
                    base.x.Broadcast(new Message("fl_warmup", this.IDflag));
                }
                if (this.Flag == RaceFlag.Red)
                {
                    base.x.Broadcast(new Message("fl_red", this.IDflag));
                }
                if (this.Flag == RaceFlag.Green)
                {
                    base.x.Broadcast(new Message("fl_green", this.IDflag, 5));
                    base.x.Broadcast(new Message("", this.IDflag));
                }
                if (this.Flag == RaceFlag.Yellow)
                {
                    base.x.Broadcast(new Message("fl_yellow", this.IDflag, this.CautionLap));
                }
                if (this.Flag == RaceFlag.White)
                {
                    base.x.Broadcast(new Message("fl_white", this.IDflag));
                }
                if (this.Flag == RaceFlag.Chequered)
                {
                    base.x.Broadcast(new Message("fl_checkers", this.IDflag));
                }
            }
            this.AutoLog(this.Flag.ToString());
        }

        private void YellowCheck()
        {
        }
    }
}

