﻿namespace ISRM
{
    using LfsInSimLib.IS_Enums;
    using LfsInSimLib.IS_Packets;
    using System;
    using System.Collections;
    using System.Collections.Generic;
    using System.Configuration;
    using System.IO;

    public class mod_drag : module
    {
        private int AutoRestartTime;
        private SBool AutoSpec = new SBool(false);
        private double Distance = 402.33598712524844;
        private S<Enum> DistanceEnum = new S<Enum>(DistanceType.Quarter);
        private const double FTinM = 3.28084;
        private pList FullGroup = new pList();
        private pList Group = new pList();
        private S<Enum> Light = new S<Enum>(LightType.Sportsman);
        private double Light1;
        private double Light2;
        private double Light3;
        private double Light4;
        private SL Lights;
        private int MinPlayers;
        private const double MPHinMS = 2.2369362;
        private pList NextParts = new pList();
        private pList Parts = new pList();
        private List<string[]> PersonalBest = new List<string[]>();
        private SBool PitDQ = new SBool(false);
        private bool Practice = false;
        private SBool PracticeFlag = new SBool(false);
        private Stopwatch S = new Stopwatch();
        private Stopwatch S2 = new Stopwatch();
        private Stopwatch S3 = new Stopwatch();
        private int Seconds;
        private byte Status;
        private List<Ticket> Ti = new List<Ticket>();
        private TL Tickets;
        private Label Top;
        private Label TopRight;
        private Hashtable Tracks = new Hashtable();
        private const double UinM = 65536.0;
        private const double UinMS = 327.68;
        private int WaitTime;

        private void Clear()
        {
            this.Ti.Clear();
            this.Parts.Clear();
            this.FullGroup.Clear();
            this.Group.Clear();
            this.NextParts.Clear();
        }

        private void ClickDistance(Control control, Connection connection)
        {
            base.x.Broadcast(new Message("dr_distance", 0, this.DistanceEnum.Value));
            switch (((DistanceType) this.DistanceEnum.Value))
            {
                case DistanceType.Eighth:
                    this.Distance = 201.16799356262422;
                    break;

                case DistanceType.Quarter:
                    this.Distance = 402.33598712524844;
                    break;

                case DistanceType.Half:
                    this.Distance = 804.67197425049687;
                    break;
            }
        }

        private void ClickLight(Control control, Connection connection)
        {
            this.UpdateLight();
            base.x.Broadcast(new Message("dr_light", 0, this.Light.Value));
        }

        private void Continue()
        {
            this.Ti.Clear();
            this.Group.Clear();
            if (this.Practice)
            {
                this.PreparePractice();
            }
            else if (this.Parts.Count == 3)
            {
                this.Group.AddRange(this.Parts);
                this.Parts.Clear();
                this.PrepareDrag();
            }
            else if (this.Parts.Count > 1)
            {
                Random random = new Random();
                int index = random.Next(0, this.Parts.Count);
                this.Group.Add(this.Parts[index]);
                this.Parts.RemoveAt(index);
                index = random.Next(0, this.Parts.Count);
                this.Group.Add(this.Parts[index]);
                this.Parts.RemoveAt(index);
                this.PrepareDrag();
            }
            else if (this.Parts.Count == 1)
            {
                if (this.NextParts.Count > 0)
                {
                    this.Parts.AddRange(this.NextParts);
                    this.NextParts.Clear();
                    this.Continue();
                }
                else
                {
                    this.Top.Hidden = ((Player) this.Parts[0]).PName;
                    this.StopDragThenRestart("dr_winner");
                }
            }
            else if (this.Parts.Count == 0)
            {
                if (this.NextParts.Count > 0)
                {
                    this.Parts.AddRange(this.NextParts);
                    this.NextParts.Clear();
                    this.Continue();
                }
                else
                {
                    this.StopDragThenRestart("dr_end");
                }
            }
        }

        private double dist(double X1, double Y1, double X2, double Y2)
        {
            return Math.Sqrt(Math.Pow(X1 - X2, 2.0) + Math.Pow(Y1 - Y2, 2.0));
        }

        private double eval(double X, double Y)
        {
            if ((base.x.Track != null) && this.Tracks.ContainsKey(base.x.Track))
            {
                double[] numArray = (double[]) this.Tracks[base.x.Track];
                double num = numArray[0];
                double num2 = numArray[1];
                double num3 = numArray[2];
                double num4 = numArray[3];
                double x = (num4 - num2) / (num3 - num);
                return ((numArray[4] * (((-x * X) + Y) + ((x * num) - num2))) / Math.Sqrt(Math.Pow(x, 2.0) + 1.0));
            }
            return double.MaxValue;
        }

        private void FinishDrag(Player Winner)
        {
            base.x.Broadcast(new Message("dr_win", 0, Winner.PName));
            this.Top.Hidden = Winner.PName;
            this.Top.Name = "dr_win";
            this.NextParts.Add(Winner);
            this.Status = 4;
            this.S2.Start();
            this.Tickets.Update(this.Ti, Winner, this.Distance);
            base.x.Screen.Add(this.Tickets);
        }

        private void FinishPractice(Player Winner)
        {
            if (this.Group.Count > 1)
            {
                base.x.Broadcast(new Message("dr_win", 0, Winner.PName));
                this.Top.Hidden = Winner.PName;
                this.Top.Name = "dr_win";
            }
            this.Status = 14;
            this.S2.Start();
            this.Tickets.Update(this.Ti, Winner, this.Distance);
            base.x.Screen.Add(this.Tickets);
        }

        private void FormDrag()
        {
            base.x.Broadcast(new Message("dr_getready", 0));
            this.TopRight.Name = "";
            this.Status = 2;
            this.S.Start();
            this.S3.Start();
            this.UpdateLight();
            base.x.Screen.Remove(this.Tickets);
            ArrayList list = new ArrayList();
            foreach (Player player in this.Group)
            {
                int index = this.FullGroup.IndexOf(player);
                Ticket ticket = this.Ti[index];
                if (!ticket.Staged)
                {
                    list.Add(player);
                }
            }
            foreach (Player player in list)
            {
                this.Kick(player, new Message("dr_nostart", 0));
            }
        }

        private void FormPractice()
        {
            base.x.Broadcast(new Message("dr_getready", 0));
            this.TopRight.Name = "";
            this.Status = 12;
            this.S.Start();
            this.S3.Start();
            this.UpdateLight();
            base.x.Screen.Remove(this.Tickets);
            ArrayList list = new ArrayList();
            foreach (Player player in this.Group)
            {
                int index = this.FullGroup.IndexOf(player);
                Ticket ticket = this.Ti[index];
                if (!ticket.Staged)
                {
                    list.Add(player);
                }
            }
            foreach (Player player in list)
            {
                this.Kick(player, null);
            }
        }

        private string GetLight(Control control, Connection connection)
        {
            return this.Light.ToString();
        }

        public override void In(object message)
        {
            if (message is IS_NPL)
            {
                IS_NPL is_npl = (IS_NPL) message;
                base.x.Send_RCM(Convert.ToChar(160).ToString(), base.x.Players.ID(is_npl.PLID));
                if (base.x.Players.Count == 1)
                {
                    this.Clear();
                    this.Practice = true;
                    this.Continue();
                }
            }
            if (message is IS_PLL)
            {
                IS_PLL is_pll = (IS_PLL) message;
                this.Kick(is_pll.PLID, null);
                if (((this.Status > 0) && (this.Status < 5)) && (base.x.Players.Count == 0))
                {
                    this.StopDrag("");
                }
            }
            if (message is IS_PLP)
            {
                IS_PLP is_plp = (IS_PLP) message;
                if (this.PitDQ.isTrue)
                {
                    if ((this.Status > 0) && (this.Status < 5))
                    {
                        this.Kick(is_plp.PLID, new Message("dr_dq", 0));
                        if (base.x.Players.Count == 0)
                        {
                            this.StopDrag("");
                        }
                    }
                    if ((this.Status > 10) && (this.Status < 15))
                    {
                        this.Kick(is_plp.PLID, null);
                    }
                }
            }
            if (message is IS_RST)
            {
                base.x.Send_RCM(Convert.ToChar(160).ToString());
                if (base.x.Players.Count > 0)
                {
                    this.Clear();
                    this.NextParts.AddRange(base.x.Players);
                    this.Practice = this.PracticeFlag.isTrue || (base.x.Players.Count < this.MinPlayers);
                    this.Continue();
                }
            }
        }

        public override void Init()
        {
            string str;
            this.WaitTime = Convert.ToInt32(ConfigurationManager.AppSettings["wait_time"]);
            this.PracticeFlag.isTrue = SConvert.ToBoolean(ConfigurationManager.AppSettings["practice"]);
            this.AutoSpec.isTrue = SConvert.ToBoolean(ConfigurationManager.AppSettings["autospec"]);
            this.PitDQ.isTrue = SConvert.ToBoolean(ConfigurationManager.AppSettings["dq_teleport"]);
            this.Light.Value = (LightType) Enum.Parse(typeof(LightType), ConfigurationManager.AppSettings["lights"]);
            this.DistanceEnum.Value = (DistanceType) Enum.Parse(typeof(DistanceType), ConfigurationManager.AppSettings["distance"]);
            this.MinPlayers = Convert.ToInt32(ConfigurationManager.AppSettings["min_players"]);
            if (this.MinPlayers < 2)
            {
                this.MinPlayers = 2;
            }
            this.AutoRestartTime = Convert.ToInt32(ConfigurationManager.AppSettings["auto_restart_time"]);
            StreamReader reader = new StreamReader(new FileStream("Tracks.txt", FileMode.OpenOrCreate, FileAccess.Read));
            while ((str = reader.ReadLine()) != null)
            {
                string[] strArray = str.Split("'".ToCharArray());
                if (strArray.Length >= 6)
                {
                    this.Tracks.Add(strArray[0], new double[] { Convert.ToDouble(strArray[1]), Convert.ToDouble(strArray[2]), Convert.ToDouble(strArray[3]), Convert.ToDouble(strArray[4]), Convert.ToDouble(strArray[5]) });
                }
            }
            reader.Close();
            this.Top = new Label("", "", new NameDelegate(this.TopHidden), 0, 0, 20, 180);
            this.TopRight = new Label("", 0, 180, 20, 20);
            base.x.Admin_MS("laps 0");
            this.Lights = new SL(40, 160, new NameDelegate(this.PracticeOverride));
            this.Tickets = new TL(20, 0);
            base.x.Screen.Add(this.Top);
            base.x.Screen.Add(this.TopRight);
            base.x.Screen.Add(this.Lights);
            Menu m = new Menu("dr_top");
            m.Add(new ListBox(this.PersonalBest, new string[] { "mn_name", "dr_et", "dr_rt", "dr_mph" }, new int[] { 30, 12, 12, 12 }, true, 10, 10, 10, 0, 0));
            base.x.MainMenu.Add(m);
            base.moduleMenu = new Menu("dr_settings");
            base.moduleMenu.Draw = new DrawDecider(Control.IsAdmin);
            base.moduleMenu.Add(new EnumBox(this.DistanceEnum, "^3", new ControlDelegate(this.ClickDistance)));
            base.moduleMenu.Add(new EnumBox(this.Light, "^3", new ControlDelegate(this.ClickLight)));
            base.moduleMenu.Add(new CheckBox(this.PracticeFlag, "dr_practice"));
            base.moduleMenu.Add(new CheckBox(this.AutoSpec, "dr_autospec"));
            base.moduleMenu.Add(new CheckBox(this.PitDQ, "dr_pitdq"));
            ISRM.FileRead(this.PersonalBest, "PB.txt");
            this.PersonalBest.Sort(new StringArrayComparer(1, true));
            this.StopDrag("");
        }

        private bool IsFinished(Player p)
        {
            return ((this.SDist(p) >= this.Distance) && this.IsInside(p));
        }

        private bool IsInside(Player p)
        {
            if ((base.x.Track != null) && this.Tracks.ContainsKey(base.x.Track))
            {
                double[] numArray = (double[]) this.Tracks[base.x.Track];
                double num = this.dist(numArray[0], numArray[1], (numArray[0] + numArray[2]) / 2.0, (numArray[1] + numArray[3]) / 2.0) / 65536.0;
                double x = this.dist((double) p.X, (double) p.Y, (numArray[0] + numArray[2]) / 2.0, (numArray[1] + numArray[3]) / 2.0) / 65536.0;
                double num3 = this.SDist(p);
                return (Math.Sqrt(Math.Pow(x, 2.0) - Math.Pow(num3, 2.0)) < (num + 3.0));
            }
            return false;
        }

        private bool IsPreStaged(Player p)
        {
            return (((this.SDist(p) > -0.9) && (this.SDist(p) < -0.3)) && this.IsInside(p));
        }

        private bool IsSafelyPreStaged(Player p)
        {
            return (((this.SDist(p) > -0.85) && (this.SDist(p) < -0.35)) && this.IsInside(p));
        }

        private bool IsSafelyStaged(Player p)
        {
            return (((this.SDist(p) > -0.55) && (this.SDist(p) < -0.05)) && this.IsInside(p));
        }

        private bool IsStaged(Player p)
        {
            return (((this.SDist(p) > -0.6) && (this.SDist(p) < 0.0)) && this.IsInside(p));
        }

        private void Kick(Player p, Message m)
        {
            this.Kick(p.PLID, m);
        }

        private void Kick(byte ID, Message m)
        {
            Player player = null;
            if (this.Group.ID(ID) != null)
            {
                player = this.Group.ID(ID);
            }
            if (this.Parts.ID(ID) != null)
            {
                player = this.Parts.ID(ID);
            }
            if (this.NextParts.ID(ID) != null)
            {
                player = this.NextParts.ID(ID);
            }
            this.Group.RemoveID(ID);
            this.Parts.RemoveID(ID);
            this.NextParts.RemoveID(ID);
            if (((player != null) && (m != null)) && (m.Text.Length > 0))
            {
                m.Thing = player.PName;
                base.x.Broadcast(m);
            }
            foreach (Ticket ticket in this.Ti)
            {
                if ((ticket.P != null) && (ticket.P.PLID == ID))
                {
                    ticket.P = null;
                }
            }
        }

        private string PracticeOverride(Control control, Connection connection)
        {
            SimpleControl control2 = (SimpleControl) control;
            if (((this.Status > 10) && (this.Status < 15)) && (connection.Players.Count > 0))
            {
                if (this.Group.Contains(connection.Plyr))
                {
                    int index = this.Group.IndexOf(connection.Plyr);
                    Ticket ticket = this.Ti[index];
                    if (ticket.PreStaged && (control2.Hidden == "P"))
                    {
                        return "^3";
                    }
                    if (ticket.Staged && (control2.Hidden == "S"))
                    {
                        return "^3";
                    }
                }
                else if (control2.Hidden == "R")
                {
                    return "^1";
                }
            }
            return "";
        }

        private void PrepareDrag()
        {
            this.FullGroup.Clear();
            this.FullGroup.AddRange(this.Group);
            this.Ti.Clear();
            foreach (Player player in this.FullGroup)
            {
                this.Ti.Add(new Ticket(player));
            }
            this.Lights.TurnOff();
            this.Status = 1;
            string str = ((Player) this.Group[0]).PName + "^: vs " + ((Player) this.Group[1]).PName;
            if (this.Group.Count == 3)
            {
                str = str + "^: vs " + ((Player) this.Group[2]).PName;
            }
            this.Top.Name = str;
            this.Seconds = this.WaitTime;
            this.S.Start();
        }

        private void PreparePractice()
        {
            this.Status = 11;
            this.Clear();
            this.Lights.TurnOff();
            this.Top.Name = "dr_practice";
        }

        private double SDist(Player p)
        {
            return (this.eval((double) p.X, (double) p.Y) / 65536.0);
        }

        public static void SetColor(ref Label C, AdvCol Color)
        {
            C.Name = C.Name.Replace("^0", "");
            C.Name = C.Name.Replace("^1", "");
            C.Name = C.Name.Replace("^2", "");
            C.Name = C.Name.Replace("^3", "");
            C.Name = C.Name.Replace("^4", "");
            C.Name = C.Name.Replace("^5", "");
            C.Name = C.Name.Replace("^6", "");
            C.Name = C.Name.Replace("^7", "");
            if (((byte) (C.Style & ButtonStyleFlagsEnum.ISB_C1)) == 1)
            {
                C.Style = (ButtonStyleFlagsEnum) ((byte) (C.Style ^ ButtonStyleFlagsEnum.ISB_C1));
            }
            if (((byte) (C.Style & ButtonStyleFlagsEnum.ISB_C2)) == 2)
            {
                C.Style = (ButtonStyleFlagsEnum) ((byte) (C.Style ^ ButtonStyleFlagsEnum.ISB_C2));
            }
            if (((byte) (C.Style & ButtonStyleFlagsEnum.ISB_C4)) == 4)
            {
                C.Style = (ButtonStyleFlagsEnum) ((byte) (C.Style ^ ButtonStyleFlagsEnum.ISB_C4));
            }
            switch (Color)
            {
                case AdvCol.Black:
                    C.Name = "^0" + C.Name;
                    break;

                case AdvCol.Red:
                    C.Name = "^1" + C.Name;
                    break;

                case AdvCol.Green:
                    C.Name = "^2" + C.Name;
                    break;

                case AdvCol.Yellow:
                    C.Name = "^3" + C.Name;
                    break;

                case AdvCol.Blue:
                    C.Name = "^4" + C.Name;
                    break;

                case AdvCol.Pink:
                    C.Name = "^5" + C.Name;
                    break;

                case AdvCol.LightBlue:
                    C.Name = "^6" + C.Name;
                    break;

                case AdvCol.White:
                    C.Name = "^7" + C.Name;
                    break;

                case AdvCol.PaleYellow:
                    C.Style = (ButtonStyleFlagsEnum) ((byte) (C.Style | ButtonStyleFlagsEnum.ISB_C1));
                    break;

                case AdvCol.PaleGreen:
                    C.Style = (ButtonStyleFlagsEnum) ((byte) (C.Style | ButtonStyleFlagsEnum.ISB_C4));
                    break;

                case AdvCol.PaleRed:
                    C.Style = (ButtonStyleFlagsEnum) ((byte) (C.Style | ButtonStyleFlagsEnum.ISB_C1 | ButtonStyleFlagsEnum.ISB_C4));
                    break;

                case AdvCol.PaleBlue:
                    C.Style = (ButtonStyleFlagsEnum) ((byte) (C.Style | ButtonStyleFlagsEnum.ISB_C2 | ButtonStyleFlagsEnum.ISB_C4));
                    break;

                case AdvCol.Gray:
                    C.Style = (ButtonStyleFlagsEnum) ((byte) (C.Style | ButtonStyleFlagsEnum.ISB_C1 | ButtonStyleFlagsEnum.ISB_C2 | ButtonStyleFlagsEnum.ISB_C4));
                    break;
            }
        }

        private void StartDrag()
        {
            this.Status = 3;
            this.S.Start();
        }

        private void StartPractice()
        {
            this.Status = 13;
            this.S.Start();
        }

        private void StopDrag(string s)
        {
            this.Clear();
            this.Status = 0;
            this.Top.Name = s;
            this.TopRight.Name = "";
            this.Lights.TurnOff();
            base.x.ScreenDraw();
            this.S3.Start();
        }

        private void StopDragThenRestart(string s)
        {
            this.Clear();
            this.Status = 5;
            this.Top.Name = s;
            this.TopRight.Name = "";
            this.Lights.TurnOff();
            base.x.ScreenDraw();
            this.S3.Start();
            this.Seconds = this.AutoRestartTime;
        }

        private double TimeOffset(Player p, double distance)
        {
            return (((this.SDist(p) - distance) / (((double) p.Speed) / 327.68)) * 1000.0);
        }

        private string TopHidden(Control control, Connection connection)
        {
            return this.Top.Hidden;
        }

        public override void Update()
        {
            int index;
            Ticket current;
            pList list;
            string[] strArray;
            double maxValue;
            int num3;
            Ticket ticket2;
            ArrayList list2;
            Player player3;
            double num4;
            if ((this.Status > 0) && (this.Status < 4))
            {
                foreach (Player player in this.Group)
                {
                    index = this.FullGroup.IndexOf(player);
                    current = this.Ti[index];
                    if (!(current.Staged || !this.IsSafelyStaged(player)))
                    {
                        current.Staged = true;
                    }
                    if (!(!current.Staged || this.IsStaged(player)))
                    {
                        current.Staged = false;
                    }
                    if (!(current.PreStaged || !this.IsSafelyPreStaged(player)))
                    {
                        current.PreStaged = true;
                    }
                    if (!(!current.PreStaged || this.IsPreStaged(player)))
                    {
                        current.PreStaged = false;
                    }
                }
                foreach (Player player in this.FullGroup)
                {
                    if (!this.Group.Contains(player))
                    {
                        index = this.FullGroup.IndexOf(player);
                        this.Lights.red[index] = true;
                        this.Lights.Refresh();
                        base.x.ScreenDraw();
                    }
                }
                if (this.FullGroup.Count < 3)
                {
                    this.Lights.red[2] = true;
                    this.Lights.Refresh();
                    base.x.ScreenDraw();
                }
                if (this.Group.Count == 0)
                {
                    this.Continue();
                }
                if (this.Group.Count == 1)
                {
                }
            }
            if (this.Status == 1)
            {
                if (this.S.Interval > ((this.WaitTime - this.Seconds) * 0x3e8))
                {
                    this.TopRight.Name = this.Seconds.ToString();
                    this.Seconds--;
                }
                if (this.S.Interval > (this.WaitTime * 0x3e8))
                {
                    this.FormDrag();
                }
                else
                {
                    bool flag = true;
                    foreach (Player player in this.Group)
                    {
                        index = this.FullGroup.IndexOf(player);
                        current = this.Ti[index];
                        if (current.Staged)
                        {
                            this.Lights.stage[index] = true;
                            this.Lights.Refresh();
                        }
                        else
                        {
                            this.Lights.stage[index] = false;
                            this.Lights.Refresh();
                            flag = false;
                        }
                        if (current.PreStaged)
                        {
                            this.Lights.prestage[index] = true;
                            this.Lights.Refresh();
                        }
                        else
                        {
                            this.Lights.prestage[index] = false;
                            this.Lights.Refresh();
                        }
                        base.x.ScreenDraw();
                    }
                    if (flag)
                    {
                        if (!this.S2.Started)
                        {
                            this.S2.Start();
                        }
                        if (this.S2.Interval > 5000.0)
                        {
                            this.FormDrag();
                        }
                    }
                    else if (this.S2.Started)
                    {
                        this.S2.Reset();
                    }
                }
            }
            if (this.Status == 2)
            {
                list = new pList();
                foreach (Player player in this.Group)
                {
                    index = this.FullGroup.IndexOf(player);
                    current = this.Ti[index];
                    if (!current.Staged)
                    {
                        list.Add(player);
                    }
                }
                foreach (Player player in list)
                {
                    this.Kick(player, new Message("dr_jumpstart", 0));
                }
                if (this.S.Interval > (5000.0 + this.Light1))
                {
                    this.Lights.Sequence = 1;
                    this.Lights.Refresh();
                }
                if (this.S.Interval > (5000.0 + this.Light2))
                {
                    this.Lights.Sequence = 2;
                    this.Lights.Refresh();
                }
                if (this.S.Interval > (5000.0 + this.Light3))
                {
                    this.Lights.Sequence = 3;
                    this.Lights.Refresh();
                }
                if (this.S.Interval > (5000.0 + this.Light4))
                {
                    this.Lights.Sequence = 4;
                    this.Lights.Refresh();
                    this.StartDrag();
                }
                base.x.ScreenDraw();
                foreach (Player player in this.Group)
                {
                    base.x.Connections.HighPriority(player.Conn);
                }
            }
            if ((this.Status == 2) || (this.Status == 3))
            {
                foreach (Player player in this.Group)
                {
                    index = this.FullGroup.IndexOf(player);
                    current = this.Ti[index];
                    if (((((double) player.Speed) / 327.68) >= 0.1) && (current.Lag < 0.0))
                    {
                        current.Lag = this.S3.Interval;
                    }
                }
            }
            if ((this.Status == 3) || (this.Status == 4))
            {
                foreach (Player player in this.Group)
                {
                    index = this.FullGroup.IndexOf(player);
                    current = this.Ti[index];
                    if (!(current.Staged || (current.RT >= 0.0)))
                    {
                        current.RT = this.S.Interval;
                    }
                    if ((((((double) player.Speed) / 327.68) * 2.2369362) >= 60.0) && (current.x0to60 < 0.0))
                    {
                        current.x0to60 = this.S3.Interval - current.Lag;
                    }
                    if ((this.SDist(player) > 18.287999414784018) && (current.x60 < 0.0))
                    {
                        current.x60 = this.S.Interval - this.TimeOffset(player, 18.287999414784018);
                    }
                    if ((this.SDist(player) > 100.58399678131211) && (current.x330 < 0.0))
                    {
                        current.x330 = this.S.Interval - this.TimeOffset(player, 100.58399678131211);
                    }
                    if ((this.SDist(player) > 201.16799356262422) && (current.x660 < 0.0))
                    {
                        current.x660 = this.S.Interval - this.TimeOffset(player, 201.16799356262422);
                    }
                    if ((this.SDist(player) > 304.79999024640034) && (current.x1000 < 0.0))
                    {
                        current.x1000 = this.S.Interval - this.TimeOffset(player, 304.79999024640034);
                    }
                    if ((this.SDist(player) > 402.33598712524844) && (current.x1320 < 0.0))
                    {
                        current.x1320 = this.S.Interval - this.TimeOffset(player, 402.33598712524844);
                    }
                    if ((this.SDist(player) > 609.59998049280068) && (current.x2000 < 0.0))
                    {
                        current.x2000 = this.S.Interval - this.TimeOffset(player, 609.59998049280068);
                    }
                    if (this.IsFinished(player) && (current.Time < 0.0))
                    {
                        current.Time = this.S.Interval - this.TimeOffset(player, this.Distance);
                        current.MPH = (((double) player.Speed) / 327.68) * 2.2369362;
                        base.x.Send_MTC(new Message("dr_finish", 0), player.Conn);
                        strArray = new string[] { current.P.PName, string.Format("{0:0.000}", current.Time / 1000.0), string.Format("{0:0.000}", current.RT / 1000.0), string.Format("{0:0.0}", current.MPH) };
                        this.PersonalBest.Add(strArray);
                        this.PersonalBest.Sort(new StringArrayComparer(1, true));
                        ISRM.FileAdd(strArray, "PB.txt");
                    }
                    if ((current.Time > 0.0) && (current.Margin == -10241024.0))
                    {
                        maxValue = double.MaxValue;
                        foreach (Player player2 in this.Group)
                        {
                            if (player != player2)
                            {
                                num3 = this.Group.IndexOf(player2);
                                ticket2 = this.Ti[num3];
                                if ((ticket2.Time > 0.0) && (ticket2.Time < maxValue))
                                {
                                    maxValue = ticket2.Time;
                                }
                            }
                        }
                        if (!(maxValue == double.MaxValue))
                        {
                            current.Margin = maxValue - current.Time;
                        }
                    }
                }
            }
            if (this.Status == 3)
            {
                if (this.AutoSpec.isTrue)
                {
                    foreach (Player player in base.x.Players)
                    {
                        if (((!this.FullGroup.Contains(player) && (this.SDist(player) > 0.0)) && (this.SDist(player) < this.Distance)) && this.IsInside(player))
                        {
                            base.x.Admin_MS("spec " + player.PName);
                        }
                    }
                }
                if (this.S.Interval > ((10.0 + (this.Distance / 20.0)) * 1000.0))
                {
                    list2 = new ArrayList();
                    foreach (Player player in this.Group)
                    {
                        list2.Add(player);
                    }
                    foreach (Player player in list2)
                    {
                        this.Kick(player, new Message("dr_nofinish", 0));
                    }
                }
                player3 = null;
                num4 = -1.0;
                foreach (Player player in this.Group)
                {
                    if ((this.IsFinished(player) && (this.SDist(player) > num4)) && this.IsInside(player))
                    {
                        num4 = this.SDist(player);
                        player3 = player;
                    }
                }
                if ((player3 != null) && (this.FullGroup.Count > 1))
                {
                    this.FinishDrag(player3);
                }
            }
            if ((this.Status == 4) && (this.S2.Interval > 5000.0))
            {
                this.Continue();
            }
            if (this.Status == 5)
            {
                if ((this.S3.Interval > ((this.AutoRestartTime - this.Seconds) * 0x3e8)) && (this.AutoRestartTime < 0x3e8))
                {
                    this.TopRight.Name = this.Seconds.ToString();
                    this.Seconds--;
                }
                if (this.S3.Interval > (this.AutoRestartTime * 0x3e8))
                {
                    this.StopDrag("");
                    if (base.x.Players.Count >= this.MinPlayers)
                    {
                        base.x.Admin_MS("restart");
                    }
                }
            }
            if (this.Status == 11)
            {
                foreach (Player player in base.x.Players)
                {
                    if (!((!this.IsPreStaged(player) && !this.IsStaged(player)) || this.Group.Contains(player)))
                    {
                        this.Group.Add(player);
                        this.Ti.Add(new Ticket(player));
                        this.S.Start();
                    }
                    if ((!this.IsPreStaged(player) && !this.IsStaged(player)) && this.Group.Contains(player))
                    {
                        this.Group.Remove(player);
                        list2 = new ArrayList();
                        using (List<Ticket>.Enumerator enumerator3 = this.Ti.GetEnumerator())
                        {
                            while (enumerator3.MoveNext())
                            {
                                current = enumerator3.Current;
                                if (current.P == player)
                                {
                                    list2.Add(current);
                                }
                            }
                        }
                        /*
                        using (IEnumerator enumerator2 = list2.GetEnumerator())
                        {
                            while (enumerator2.MoveNext())
                            {
                                current = (Ticket) enumerator2.Current;
                                this.Ti.Remove(current);
                            }
                        }
                        */
                    }
                }
                if (this.Group.Count == 0)
                {
                    this.S.Reset();
                }
                if (this.S.Interval > 10000.0)
                {
                    this.FullGroup.AddRange(this.Group);
                    this.FormPractice();
                }
            }
            if ((this.Status > 10) && (this.Status < 14))
            {
                foreach (Player player in this.Group)
                {
                    index = this.Group.IndexOf(player);
                    current = this.Ti[index];
                    if (!(current.Staged || !this.IsSafelyStaged(player)))
                    {
                        current.Staged = true;
                    }
                    if (!(!current.Staged || this.IsStaged(player)))
                    {
                        current.Staged = false;
                    }
                    if (!(current.PreStaged || !this.IsSafelyPreStaged(player)))
                    {
                        current.PreStaged = true;
                    }
                    if (!(!current.PreStaged || this.IsPreStaged(player)))
                    {
                        current.PreStaged = false;
                    }
                }
                if ((this.Group.Count == 0) && (this.Status != 11))
                {
                    this.Continue();
                }
            }
            if (this.Status == 12)
            {
                list = new pList();
                foreach (Player player in this.Group)
                {
                    index = this.FullGroup.IndexOf(player);
                    current = this.Ti[index];
                    if (!current.Staged)
                    {
                        list.Add(player);
                    }
                }
                foreach (Player player in list)
                {
                    this.Kick(player, new Message("dr_jumpstart", 0));
                }
                if (this.S.Interval > (5000.0 + this.Light1))
                {
                    this.Lights.Sequence = 1;
                    this.Lights.Refresh();
                }
                if (this.S.Interval > (5000.0 + this.Light2))
                {
                    this.Lights.Sequence = 2;
                    this.Lights.Refresh();
                }
                if (this.S.Interval > (5000.0 + this.Light3))
                {
                    this.Lights.Sequence = 3;
                    this.Lights.Refresh();
                }
                if (this.S.Interval > (5000.0 + this.Light4))
                {
                    this.Lights.Sequence = 4;
                    this.Lights.Refresh();
                    this.StartPractice();
                }
                base.x.ScreenDraw();
                foreach (Player player in this.Group)
                {
                    base.x.Connections.HighPriority(player.Conn);
                }
            }
            if ((this.Status == 12) || (this.Status == 13))
            {
                foreach (Player player in this.Group)
                {
                    index = this.FullGroup.IndexOf(player);
                    current = this.Ti[index];
                    if (((((double) player.Speed) / 327.68) >= 0.5) && (current.Lag < 0.0))
                    {
                        current.Lag = this.S3.Interval;
                    }
                }
            }
            if ((this.Status == 13) || (this.Status == 14))
            {
                foreach (Player player in this.Group)
                {
                    index = this.FullGroup.IndexOf(player);
                    current = this.Ti[index];
                    if (!(current.Staged || (current.RT >= 0.0)))
                    {
                        current.RT = this.S.Interval;
                    }
                    if ((((((double) player.Speed) / 327.68) * 2.2369362) >= 60.0) && (current.x0to60 < 0.0))
                    {
                        current.x0to60 = this.S3.Interval - current.Lag;
                    }
                    if ((this.SDist(player) > 18.287999414784018) && (current.x60 < 0.0))
                    {
                        current.x60 = this.S.Interval - this.TimeOffset(player, 18.287999414784018);
                    }
                    if ((this.SDist(player) > 100.58399678131211) && (current.x330 < 0.0))
                    {
                        current.x330 = this.S.Interval - this.TimeOffset(player, 100.58399678131211);
                    }
                    if ((this.SDist(player) > 201.16799356262422) && (current.x660 < 0.0))
                    {
                        current.x660 = this.S.Interval - this.TimeOffset(player, 201.16799356262422);
                    }
                    if ((this.SDist(player) > 304.79999024640034) && (current.x1000 < 0.0))
                    {
                        current.x1000 = this.S.Interval - this.TimeOffset(player, 304.79999024640034);
                    }
                    if ((this.SDist(player) > 402.33598712524844) && (current.x1320 < 0.0))
                    {
                        current.x1320 = this.S.Interval - this.TimeOffset(player, 402.33598712524844);
                    }
                    if ((this.SDist(player) > 609.59998049280068) && (current.x2000 < 0.0))
                    {
                        current.x2000 = this.S.Interval - this.TimeOffset(player, 609.59998049280068);
                    }
                    if (this.IsFinished(player) && (current.Time < 0.0))
                    {
                        current.Time = this.S.Interval - this.TimeOffset(player, this.Distance);
                        current.MPH = (((double) player.Speed) / 327.68) * 2.2369362;
                        base.x.Send_MTC(new Message("dr_finish", 0), player.Conn);
                        strArray = new string[] { current.P.PName, string.Format("{0:0.000}", current.Time / 1000.0), string.Format("{0:0.000}", current.RT / 1000.0), string.Format("{0:0.0}", current.MPH) };
                        this.PersonalBest.Add(strArray);
                        this.PersonalBest.Sort(new StringArrayComparer(1, true));
                        ISRM.FileAdd(strArray, "PB.txt");
                    }
                    if ((current.Time > 0.0) && (current.Margin == -10241024.0))
                    {
                        maxValue = double.MaxValue;
                        foreach (Player player2 in this.FullGroup)
                        {
                            if (player != player2)
                            {
                                num3 = this.FullGroup.IndexOf(player2);
                                ticket2 = this.Ti[num3];
                                if ((ticket2.Time > 0.0) && (ticket2.Time < maxValue))
                                {
                                    maxValue = ticket2.Time;
                                }
                            }
                        }
                        if (!(maxValue == double.MaxValue))
                        {
                            current.Margin = maxValue - current.Time;
                        }
                    }
                }
            }
            if (this.Status == 13)
            {
                if (this.S.Interval > ((10.0 + (this.Distance / 20.0)) * 1000.0))
                {
                    list2 = new ArrayList();
                    foreach (Player player in this.Group)
                    {
                        list2.Add(player);
                    }
                    foreach (Player player in list2)
                    {
                        this.Kick(player, null);
                    }
                }
                player3 = null;
                num4 = -1.0;
                foreach (Player player in this.Group)
                {
                    if (this.IsFinished(player) && (this.SDist(player) > num4))
                    {
                        num4 = this.SDist(player);
                        player3 = player;
                    }
                }
                if (player3 != null)
                {
                    this.FinishPractice(player3);
                }
            }
            if ((this.Status == 14) && (this.S2.Interval > 5000.0))
            {
                this.Continue();
            }
        }

        private void UpdateLight()
        {
            switch (((LightType) this.Light.Value))
            {
                case LightType.Sportsman:
                    this.Light1 = 0.0;
                    this.Light2 = 500.0;
                    this.Light3 = 1000.0;
                    this.Light4 = 1500.0;
                    break;

                case LightType.Pro:
                    this.Light1 = 0.0;
                    this.Light2 = 0.0;
                    this.Light3 = 0.0;
                    this.Light4 = 400.0;
                    break;

                case LightType.LFS:
                {
                    Random random = new Random();
                    this.Light1 = 0.0;
                    this.Light2 = 1000.0;
                    this.Light3 = 2000.0;
                    this.Light4 = random.Next(0xfa0, 0x1770);
                    break;
                }
            }
        }
    }
}

