﻿namespace ISRM
{
    using LfsInSimLib.IS_Enums;
    using System;
    using System.Collections;

    public class TabControl : Control
    {
        public ArrayList Items;
        public int TabW;

        public TabControl(ArrayList items, int t, int l, int h, int w, int tw) : base(t, l, h, w)
        {
            base.DefaultSettings["tab"] = 0;
            this.TabW = tw;
            this.Items = items;
        }

        private void Click(Control c, Connection d)
        {
            foreach (Tab tab in this.Items)
            {
                if (tab.C == c)
                {
                    base.GetSettings(d)["tab"] = this.Items.IndexOf(tab);
                }
            }
        }

        public override ArrayList GetElements(Connection c)
        {
            int num = (int) base.GetSettings(c)["tab"];
            ArrayList list = new ArrayList();
            foreach (Tab tab in this.Items)
            {
                int index = this.Items.IndexOf(tab);
                if (index == num)
                {
                    list.Add(new Element(c, "^8" + tab.Name, ButtonStyleFlagsEnum.ISB_CLICK | ButtonStyleFlagsEnum.ISB_LIGHT, base.T, base.L + (this.TabW * index), base.H, this.TabW, tab.C, tab.C, new ControlDelegate(this.Click)));
                }
                else
                {
                    list.Add(new Element(c, tab.Name, ButtonStyleFlagsEnum.ISB_CLICK | ButtonStyleFlagsEnum.ISB_DARK, base.T, base.L + (this.TabW * index), base.H, this.TabW, tab.C, tab.C, new ControlDelegate(this.Click)));
                }
            }
            ArrayList elements = ((Tab) this.Items[num]).C.GetElements(c);
            foreach (Element element in elements)
            {
                element.D = this;
                list.Add(element);
            }
            return list;
        }

        public void LineDown(Control control, Connection connection)
        {
            int num = (int) base.GetSettings(connection)["line"];
            base.GetSettings(connection)["line"] = num + 1;
        }

        public void LineUp(Control control, Connection connection)
        {
            int num = (int) base.GetSettings(connection)["line"];
            if (num > 0)
            {
                base.GetSettings(connection)["line"] = num - 1;
            }
        }
    }
}

