﻿namespace ISRM
{
    using LfsInSimLib.IS_Enums;
    using System;
    using System.Collections.Generic;

    public class TL : Bunch
    {
        private double Distance;
        private List<Ticket> Ti;
        private Player Winner;

        public TL(int T, int L)
        {
            TimeSpan span = TimeSpan.FromSeconds(15.0);
            base.Expire = span;
            ButtonStyleFlagsEnum enum2 = ButtonStyleFlagsEnum.ISB_LIGHT | ButtonStyleFlagsEnum.ISB_RIGHT;
            Label label = new Label("{0}", "dr_et", new NameDelegate(this.Display), T, L, 10, 0x20) {
                Style = enum2
            };
            base.List.Add(label);
            label = new Label("{0}", "dr_rt", new NameDelegate(this.Display), T + 10, L, 10, 0x20) {
                Style = enum2
            };
            base.List.Add(label);
            label = new Label("{0}", "dr_margin", new NameDelegate(this.Display), T + 20, L, 10, 0x20) {
                Style = enum2
            };
            base.List.Add(label);
            label = new Label("{0}", "dr_060", new NameDelegate(this.Display), new DrawDecider(this.Self), T + 30, L, 10, 0x20) {
                Style = enum2
            };
            base.List.Add(label);
            label = new Label("{0}", "dr_mph", new NameDelegate(this.Display), new DrawDecider(this.Self), T + 40, L, 10, 0x20) {
                Style = enum2
            };
            base.List.Add(label);
            label = new Label("{0}", "60'", new NameDelegate(this.Display), new DrawDecider(this.Self), T, L + 0x20, 10, 0x20) {
                Style = enum2
            };
            base.List.Add(label);
            label = new Label("{0}", "330'", new NameDelegate(this.Display), new DrawDecider(this.Self), T + 10, L + 0x20, 10, 0x20) {
                Style = enum2
            };
            base.List.Add(label);
            label = new Label("{0}", "660'", new NameDelegate(this.Display), new DrawDecider(this.Draw4), T + 20, L + 0x20, 10, 0x20) {
                Style = enum2
            };
            base.List.Add(label);
            label = new Label("{0}", "1000'", new NameDelegate(this.Display), new DrawDecider(this.Draw4), T + 30, L + 0x20, 10, 0x20) {
                Style = enum2
            };
            base.List.Add(label);
            label = new Label("{0}", "1320'", new NameDelegate(this.Display), new DrawDecider(this.Draw2), T + 40, L + 0x20, 10, 0x20) {
                Style = enum2
            };
            base.List.Add(label);
            label = new Label("{0}", "2000'", new NameDelegate(this.Display), new DrawDecider(this.Draw2), T + 50, L + 0x20, 10, 0x20) {
                Style = enum2
            };
            base.List.Add(label);
        }

        private string Display(SimpleControl control, Connection connection)
        {
            Ticket ticket = null;
            string str;
            if (connection.Players.Count > 0)
            {
                foreach (Ticket ticket2 in this.Ti)
                {
                    if (connection.Plyr == ticket2.P)
                    {
                        ticket = ticket2;
                    }
                }
            }
            if (ticket == null)
            {
                foreach (Ticket ticket2 in this.Ti)
                {
                    if (ticket2.P == this.Winner)
                    {
                        ticket = ticket2;
                    }
                }
            }
            double mPH = -1.0;
            if (ticket != null)
            {
                if (control.Hidden == "dr_et")
                {
                    mPH = ticket.Time / 1000.0;
                }
                if (control.Hidden == "dr_margin")
                {
                    mPH = ticket.Margin / 1000.0;
                }
                if (control.Hidden == "dr_rt")
                {
                    mPH = ticket.RT / 1000.0;
                }
                if (control.Hidden == "dr_mph")
                {
                    mPH = ticket.MPH;
                }
                if (control.Hidden == "dr_060")
                {
                    mPH = ticket.x0to60 / 1000.0;
                }
                if (control.Hidden == "60'")
                {
                    mPH = ticket.x60 / 1000.0;
                }
                if (control.Hidden == "330'")
                {
                    mPH = ticket.x330 / 1000.0;
                }
                if (control.Hidden == "660'")
                {
                    mPH = ticket.x660 / 1000.0;
                }
                if (control.Hidden == "1000'")
                {
                    mPH = ticket.x1000 / 1000.0;
                }
                if (control.Hidden == "1320'")
                {
                    mPH = ticket.x1320 / 1000.0;
                }
                if (control.Hidden == "2000'")
                {
                    mPH = ticket.x2000 / 1000.0;
                }
            }
            if ((mPH > -1000.0) && (control.Hidden == "dr_margin"))
            {
                str = string.Format("{0:0.000}", Math.Abs(mPH));
            }
            else if ((mPH > 0.0) && (control.Hidden == "dr_mph"))
            {
                str = string.Format("{0:0.0}", mPH);
            }
            else if (mPH >= 0.0)
            {
                str = string.Format("{0:0.00}", mPH);
            }
            else
            {
                str = "?";
            }
            return string.Format("^0{0} - {1}", ISRM.Parse(control.Hidden, null, connection.Lingo), str);
        }

        private bool Draw2(Connection connection)
        {
            if ((this.Distance >= 800.0) && (connection.Players.Count > 0))
            {
                foreach (Ticket ticket in this.Ti)
                {
                    if (connection.Plyr == ticket.P)
                    {
                        return true;
                    }
                }
            }
            return false;
        }

        private bool Draw4(Connection connection)
        {
            if ((this.Distance >= 400.0) && (connection.Players.Count > 0))
            {
                foreach (Ticket ticket in this.Ti)
                {
                    if (connection.Plyr == ticket.P)
                    {
                        return true;
                    }
                }
            }
            return false;
        }

        private bool Self(Connection connection)
        {
            if (connection.Players.Count > 0)
            {
                foreach (Ticket ticket in this.Ti)
                {
                    if (connection.Plyr == ticket.P)
                    {
                        return true;
                    }
                }
            }
            return false;
        }

        public void Update(List<Ticket> ti, Player winner, double distance)
        {
            this.Distance = distance;
            this.Winner = winner;
            this.Ti = new List<Ticket>(ti);
        }
    }
}

