﻿namespace ISRM
{
    using System;
    using System.Collections.Generic;

    internal class StringArrayComparer : IComparer<string[]>
    {
        public int Index;
        public bool Numeric;

        public StringArrayComparer(int i, bool num)
        {
            this.Index = i;
            this.Numeric = num;
        }

        public int Compare(string[] s1, string[] s2)
        {
            if ((s1.Length < this.Index) || (s2.Length < this.Index))
            {
                return 0;
            }
            if (this.Numeric)
            {
                double num = Convert.ToDouble(s1[this.Index]);
                double num2 = Convert.ToDouble(s2[this.Index]);
                if (num > num2)
                {
                    return 1;
                }
                if (num < num2)
                {
                    return -1;
                }
                return 0;
            }
            return string.Compare(s1[this.Index], s2[this.Index]);
        }
    }
}

