﻿namespace ISRM
{
    using System;

    public class Stopwatch
    {
        public bool Started = false;
        private DateTime StartTime;

        public void Reset()
        {
            this.Started = false;
        }

        public void Start()
        {
            this.StartTime = DateTime.Now;
            this.Started = true;
        }

        public double Interval
        {
            get
            {
                if (this.Started)
                {
                    TimeSpan span = (TimeSpan) (DateTime.Now - this.StartTime);
                    return span.TotalMilliseconds;
                }
                return -1.0;
            }
        }
    }
}

