﻿namespace ISRM
{
    using LfsInSimLib.IS_Enums;
    using LfsInSimLib.IS_Packets;
    using System;
    using System.Collections;

    public abstract class SimpleControl : Control
    {
        public ControlDelegate Event;
        public string Hidden;
        public string Name;
        public ButtonStyleFlagsEnum Style;
        public NameDelegate Thing;
        public byte TypeIn;

        public SimpleControl(string str)
        {
            this.Name = str;
            this.Thing = (NameDelegate) Delegate.Combine(this.Thing, new NameDelegate(this.Dummy));
            base.L = 0;
            base.T = 10;
            base.W = 50;
            base.H = 10;
        }

        public SimpleControl(string str, int t, int l, int h, int w) : base(t, l, h, w)
        {
            this.Name = str;
            this.Thing = (NameDelegate) Delegate.Combine(this.Thing, new NameDelegate(this.Dummy));
        }

        public SimpleControl(string str, string hidden, NameDelegate thing, int t, int l, int h, int w) : this(str, t, l, h, w)
        {
            this.Thing = thing;
            this.Hidden = hidden;
        }

        private object Dummy(Control control, Connection c)
        {
            return "";
        }

        public Element GetElement(Connection c)
        {
            if (base.Draw(c))
            {
                return new Element(new IS_BTN { ReqI = 1, UCID = c.UCID, Inst = 0, BStyle = this.Style, TypeIn = this.TypeIn, ClickID = 0xff, Text = ISRM.Parse(this.Name, this.Thing(this, c), c.Lingo), L = (byte) base.L, T = (byte) base.T, H = (byte) base.H, W = (byte) base.W }, this, this, this.Event);
            }
            return null;
        }

        public override ArrayList GetElements(Connection c)
        {
            ArrayList list = new ArrayList();
            if (this.GetElement(c) != null)
            {
                list.Add(this.GetElement(c));
            }
            return list;
        }
    }
}

