﻿namespace ISRM
{
    using LfsInSimLib.IS_Enums;
    using System;

    public class SL : Bunch
    {
        private Label Green;
        public bool[] prestage = new bool[3];
        private Label[] PreStage = new Label[3];
        public bool[] red = new bool[3];
        private Label[] Red = new Label[3];
        public byte Sequence = 0;
        public bool[] stage = new bool[3];
        private Label[] Stage = new Label[3];
        private Label Yellow1;
        private Label Yellow2;
        private Label Yellow3;

        public SL(short T, short L, NameDelegate PracticeOverride)
        {
            string str = Convert.ToChar(0x2022).ToString();
            base.List.Add(this.Yellow1 = new Label(str + "   " + str + "   " + str, T + 0x10, L - 0x22, 20, 100));
            base.List.Add(this.Yellow2 = new Label(str + "   " + str + "   " + str, T + 0x18, L - 0x22, 20, 100));
            base.List.Add(this.Yellow3 = new Label(str + "   " + str + "   " + str, T + 0x20, L - 0x22, 20, 100));
            base.List.Add(this.Green = new Label(str + "   " + str + "   " + str, T + 40, L - 0x22, 20, 100));
            short l = (short) (L + 1);
            short t = T;
            for (int i = 0; i < 3; i++)
            {
                Label label2;
                this.red[i] = false;
                this.stage[i] = false;
                this.prestage[i] = false;
                this.PreStage[i] = label2 = new Label("{0}" + str + str, "P", PracticeOverride, t, l - 4, 0x10, 0x10);
                base.List.Add(label2);
                this.Stage[i] = label2 = new Label("{0}" + str + str, "S", PracticeOverride, t + 8, l - 4, 0x10, 0x10);
                base.List.Add(label2);
                this.Red[i] = label2 = new Label("{0}" + str, "R", PracticeOverride, t + 0x30, l - 6, 20, 20);
                base.List.Add(label2);
                base.List.Add(new Label("", t, l, 0x40, 8));
                l = (short) (l + 11);
            }
            foreach (Label label in base.List)
            {
                if (label.Name != "")
                {
                    label.Style = (ButtonStyleFlagsEnum) ((byte) (label.Style ^ ButtonStyleFlagsEnum.ISB_DARK));
                }
            }
            this.Refresh();
        }

        public void Refresh()
        {
            mod_drag.SetColor(ref this.Yellow1, AdvCol.Black);
            mod_drag.SetColor(ref this.Yellow2, AdvCol.Black);
            mod_drag.SetColor(ref this.Yellow3, AdvCol.Black);
            mod_drag.SetColor(ref this.Green, AdvCol.PaleGreen);
            if (this.Sequence > 0)
            {
                mod_drag.SetColor(ref this.Yellow1, AdvCol.Yellow);
            }
            if (this.Sequence > 1)
            {
                mod_drag.SetColor(ref this.Yellow2, AdvCol.Yellow);
            }
            if (this.Sequence > 2)
            {
                mod_drag.SetColor(ref this.Yellow3, AdvCol.Yellow);
            }
            if (this.Sequence > 3)
            {
                mod_drag.SetColor(ref this.Green, AdvCol.Green);
            }
            for (int i = 0; i < 3; i++)
            {
                if (this.red[i])
                {
                    mod_drag.SetColor(ref this.Red[i], AdvCol.Red);
                }
                else
                {
                    mod_drag.SetColor(ref this.Red[i], AdvCol.PaleRed);
                }
                if (this.stage[i])
                {
                    mod_drag.SetColor(ref this.Stage[i], AdvCol.Yellow);
                }
                else
                {
                    mod_drag.SetColor(ref this.Stage[i], AdvCol.Black);
                }
                if (this.prestage[i])
                {
                    mod_drag.SetColor(ref this.PreStage[i], AdvCol.Yellow);
                }
                else
                {
                    mod_drag.SetColor(ref this.PreStage[i], AdvCol.Black);
                }
            }
        }

        public void TurnOff()
        {
            for (int i = 0; i < 3; i++)
            {
                this.red[i] = false;
                this.stage[i] = false;
                this.prestage[i] = false;
            }
            this.Sequence = 0;
            this.Refresh();
        }
    }
}

