﻿namespace ISRM
{
    using LfsInSimLib.IS_SubPackets;
    using System;

    public class Player
    {
        public short AngVel;
        public Connection Conn;
        public ushort Direction;
        public ushort Heading;
        public int Lap;
        public MessageSystem Messages;
        public int Node;
        public ISRM Parent;
        public byte Penalty;
        public byte PLID;
        public string PName;
        public byte Position;
        public ushort Speed;
        public int X;
        public int Y;
        public int Z;

        public Player(Connection conn, byte plid, string pname, ISRM parent)
        {
            this.Messages = new MessageSystem(new MessageDelegate(this.Display));
            this.Parent = parent;
            this.Conn = conn;
            this.PLID = plid;
            this.PName = pname;
            this.Lap = 0;
            this.Init();
        }

        protected void Display(Message m)
        {
            this.Parent.Send_RCM(m, this);
        }

        private void Fill(int a, int b, DateTime at, DateTime bt)
        {
            if (a > b)
            {
                int num = a;
                a = b;
                b = num;
                DateTime time = at;
                at = bt;
                bt = time;
            }
            int num2 = (b - a) + 1;
            if (num2 > 1)
            {
                TimeSpan span3 = (TimeSpan) (bt - at);
                TimeSpan span = new TimeSpan(span3.Ticks / ((long) (num2 - 1)));
                for (int i = 0; i < num2; i++)
                {
                    TimeSpan span2 = new TimeSpan(span.Ticks * i);
                }
            }
        }

        public void Init()
        {
        }

        public void Update(CompCar c)
        {
            if (Math.Abs((int) (c.Node - this.Node)) >= (this.Parent.NumNodes / 2))
            {
                if (c.Node < this.Node)
                {
                    this.Lap++;
                }
                else
                {
                    this.Lap--;
                }
            }
            this.Node = c.Node;
            this.AngVel = c.AngVel;
            this.Direction = c.Direction;
            this.Heading = c.Heading;
            this.Speed = c.Speed;
            this.X = c.X;
            this.Y = c.Y;
            this.Z = c.Z;
            this.Position = c.Position;
        }

        public int BigNode
        {
            get
            {
                return (this.Node + (this.Parent.NumNodes * this.Lap));
            }
        }

        public string CaplessPName
        {
            get
            {
                string pName = this.PName;
                for (int i = 0; i < this.PName.Length; i++)
                {
                    if (pName[i] == '^')
                    {
                        pName.Remove(i, 2);
                        i--;
                    }
                }
                return pName;
            }
        }
    }
}

